/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.driver.oui.RemoteInventoryInfo;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.MachineInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.sysman.oii.oiix.OiixFileOps;

public class WizardHelper {
    private static WizardHelper instance;
    private static Logger logger;

    private WizardHelper() {
    }

    public static WizardHelper getInstance() {
        if (instance == null) {
            instance = new WizardHelper();
        }
        return instance;
    }

    public void moveRACONDll(String home, List<String> nodes, boolean localNode) {
        File directory = new File(home, "bin");
        try {
            ClusterCmd cmd = new ClusterCmd();
            String racOnDllDblFile = "orarac12.dll.dbl";
            String racOnDllFile = "orarac12.dll";
            File sourceDllFile = new File(directory, racOnDllDblFile);
            File destinationDllFile = new File(directory, racOnDllFile);
            if (!localNode) {
                if (nodes != null && nodes.size() > 0) {
                    for (String node : nodes) {
                        if (!cmd.fileExists(node, sourceDllFile.getAbsolutePath())) continue;
                        cmd.moveFilesOnNode(node, sourceDllFile.getAbsolutePath(), destinationDllFile.getAbsolutePath());
                    }
                }
            } else if (sourceDllFile.exists()) {
                cmd.moveFilesOnNode(sourceDllFile.getAbsolutePath(), destinationDllFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception occurred while moving orarac12.dll.dbl files on remote nodes", e);
        }
    }

    public void updateSilentFlagInRootScript(String home) {
        HashMap<String, String> map = new HashMap<String, String>();
        File rootMacroFile = new File(home, InstallConstants.ROOT_MACROS_LOCATION);
        if (Boolean.getBoolean("oracle.installer.silent")) {
            map.put("OUI_SILENT", "true");
        } else {
            map.put("OUI_SILENT", "false");
        }
        File destinationBakFile = new File(rootMacroFile.getAbsolutePath() + FunctionsUtil.getTimeStamp() + ".bak");
        try {
            OiixFileOps.copyFile((String)rootMacroFile.getAbsolutePath(), (String)destinationBakFile.getAbsolutePath(), (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while backing the root macro file", e);
        }
        FileInfo.getInstance().updateValuesToFile(destinationBakFile, rootMacroFile, map);
    }

    public List<String> getNodesWithRegisteredHome(String oracleHome, List<String> nodes) {
        ArrayList<String> nodesWithRegisteredHome = new ArrayList<String>();
        if (oracleHome != null && !oracleHome.isEmpty() && nodes != null && !nodes.isEmpty()) {
            MachineInfo machineInfo = MachineInfo.getInstance();
            for (String node : nodes) {
                boolean isHomeRegistered = RemoteInventoryInfo.getInstance((String)node).isHomeWithLocationExist(oracleHome);
                if (!isHomeRegistered) continue;
                nodesWithRegisteredHome.add(node);
            }
        }
        return nodesWithRegisteredHome;
    }

    public void updateRootConfigScript(String home) {
        HashMap<String, String> map = new HashMap<String, String>();
        File rootConfigFile = new File(home, InstallConstants.ROOT_CONFIG_LOCATION);
        map.put("ADDNODE", "true");
        map.put("SW_ONLY", "false");
        map.put("HA_CONFIG", "false");
        File destinationBakFile = new File(rootConfigFile.getAbsolutePath() + FunctionsUtil.getTimeStamp() + ".bak");
        try {
            OiixFileOps.copyFile((String)rootConfigFile.getAbsolutePath(), (String)destinationBakFile.getAbsolutePath(), (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while backing the root config file", e);
        }
        FileInfo.getInstance().updateValuesToFile(destinationBakFile, rootConfigFile, map);
    }

    static {
        logger = Logger.getLogger(WizardHelper.class.getName());
    }
}

