/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver.job;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.InstallerPatchBean;
import oracle.install.ivw.common.driver.InstallerPatchDriver;
import oracle.install.ivw.common.resource.StringResourceBundle;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.crs.WinCRSInfo;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;

public class InstallerPatchJob {
    private InstallerPatchBean installerPatchBean;
    private static Logger logger = Logger.getLogger(InstallerPatchJob.class.getName());
    private final boolean isWindows = PlatformInfo.getInstance().isWindows();
    private Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private final String WIN_HKLM_KEY = "HKEY_LOCAL_MACHINE";
    private final String WIN_SOFTWARE_ORACLE_KEY = "SOFTWARE\\ORACLE";
    private final String WIN_INST_LOC_VALUE = "inst_loc";

    public InstallerPatchJob(InstallerPatchBean installerPatchBean) {
        this.installerPatchBean = installerPatchBean;
    }

    public void call() {
        if (this.installerPatchBean.isCheckStatus()) {
            this.checkStatus();
        }
        if (this.installerPatchBean.isRevert()) {
            this.revert();
        }
        if (this.installerPatchBean.isApplyingInstallerUpdates()) {
            this.applyInstallerUpdates();
        }
        if (this.installerPatchBean.isUpdatingOpatch()) {
            this.updateOpatch();
        }
        if (this.installerPatchBean.isApplyingPSU() || this.installerPatchBean.isApplyingOneOffs()) {
            this.applyPatch();
        }
    }

    private void checkStatus() {
        String oracleHome = this.installerPatchBean.getOracleHome();
        String patchLockPath = oracleHome + File.separator + "install" + File.separator + "patch";
        File patchLockFile = new File(patchLockPath);
        if (patchLockFile.exists()) {
            String[] tokens;
            String firstLine;
            ArrayList<String> lines = FileInfo.getFileContentLines(patchLockPath);
            if (lines != null && !lines.isEmpty() && (firstLine = (String)lines.get(0)) != null && !firstLine.isEmpty() && (tokens = firstLine.split(":")).length == 2) {
                String backupLoc = tokens[0];
                String installerUpdate = tokens[1];
                this.logAndPrint(Level.SEVERE, this.resource.getString("InstallerPatchJob.checkStatus.failedInstallerUpdate", "ERROR: The home is not clean. This home cannot be used since ({0}) action failed for installer update ({1}). Use ({2}) flag alone to remove the failed installer update.", new Object[]{"-applyInstallerUpdates", installerUpdate, "-revert"}));
                System.exit(Application.CommonExitStatus.FAILURE.getIntValue());
            }
            this.logAndPrint(Level.SEVERE, this.resource.getString("InstallerPatchJob.checkStatus.failedOpatch", "ERROR: The home is not clean. This home cannot be used since there was a failed OPatch execution in this home. Use a different home to proceed.", new Object[0]));
            System.exit(Application.CommonExitStatus.FAILURE.getIntValue());
        } else {
            logger.log(Level.INFO, "The home patch status is clean.");
        }
    }

    private void revert() {
        String oracleHome = this.installerPatchBean.getOracleHome();
        String patchLockPath = oracleHome + File.separator + InstallConstants.INSTALLER_PATCH_LOCK_FILE;
        File patchLockFile = new File(patchLockPath);
        if (patchLockFile.exists()) {
            String firstLine;
            ArrayList<String> lines = FileInfo.getFileContentLines(patchLockPath);
            if (lines != null && !lines.isEmpty() && (firstLine = (String)lines.get(0)) != null && !firstLine.isEmpty()) {
                String[] tokens = firstLine.split(":");
                if (tokens.length == 2) {
                    String backupLoc = tokens[0];
                    String installerUpdate = tokens[1];
                    File backupLocFile = new File(backupLoc);
                    File[] subFiles = backupLocFile.listFiles();
                    if (subFiles != null && subFiles.length > 0) {
                        for (File subFile : subFiles) {
                            this.copyFilesRecursively(subFile, backupLoc, oracleHome, null);
                        }
                    }
                    this.removeFilesRecursively(backupLocFile);
                    patchLockFile.delete();
                    this.logAndPrint(this.resource.getString("InstallerPatchJob.revert.noActionRequired", "Successfully reverted failed installer update ({0}).", new Object[]{installerUpdate}));
                } else {
                    this.logAndPrint(Level.SEVERE, this.resource.getString("InstallerPatchJob.revert.noActionRequired", "ERROR: Nothing to revert.", new Object[0]));
                }
            }
        } else {
            this.logAndPrint(Level.SEVERE, this.resource.getString("InstallerPatchJob.revert.noActionRequired", "ERROR: Nothing to revert.", new Object[0]));
        }
    }

    private void removeFilesRecursively(File file) {
        File[] subFiles;
        if (file.isDirectory() && (subFiles = file.listFiles()) != null && subFiles.length > 0) {
            for (File subFile : subFiles) {
                this.removeFilesRecursively(subFile);
            }
        }
        file.delete();
    }

    private void applyPatch() {
        String oracleHome = this.installerPatchBean.getOracleHome();
        String tempLocation = this.installerPatchBean.getTempLocation();
        String patchActionsPrefix = "PatchActions";
        String oraInventoryDirName = "oraInventory";
        String oraBaseDirName = "oraBase";
        String ouiToolName = this.isWindows ? "setup.exe" : "runInstaller";
        String ouiToolPath = oracleHome + File.separator + "oui" + File.separator + "bin" + File.separator + ouiToolName;
        String debugFlag = this.installerPatchBean.isDebug() ? "-debug" : "";
        String patchActionsPath = tempLocation + File.separator + patchActionsPrefix;
        File patchActionsFile = new File(patchActionsPath);
        patchActionsFile.mkdirs();
        InventoryInfo invInfo = InventoryInfo.getInstance();
        boolean inventoryExists = invInfo.isInventoryExist();
        boolean oracleRegKeyExists = true;
        String invLoc = null;
        if (inventoryExists) {
            invLoc = invInfo.getDefaultInventoryLoc();
        } else {
            invLoc = patchActionsPath + File.separator + oraInventoryDirName;
            File invLocFile = new File(invLoc);
            if (!invLocFile.exists()) {
                invLocFile.mkdirs();
            }
            if (this.isWindows) {
                try {
                    oracleRegKeyExists = WinCRSInfo.regKeyExistsOnLocalNode("HKEY_LOCAL_MACHINE" + File.separator + "SOFTWARE\\ORACLE");
                }
                catch (InstallException e) {
                    logger.log(Level.SEVERE, "Could not determine if the Oracle registry key exists.", (Throwable)((Object)e));
                }
            }
        }
        String inventoryArg = this.isWindows && inventoryExists ? "" : "INVENTORY_LOCATION=" + invLoc;
        String oraBasePath = patchActionsPath + File.separator + oraBaseDirName;
        File oraBaseFile = new File(oraBasePath);
        oraBaseFile.mkdirs();
        this.logAndPrint(this.resource.getString("InstallerPatchJob.attachHome.start", "Preparing the home to patch...", new Object[0]));
        String[] attachHomeCmd = new String[]{ouiToolPath, "-attachHome", "-silent", "-waitforcompletion", "ORACLE_HOME=" + oracleHome, "ORACLE_HOME_NAME=tempGIName", "ORACLE_BASE=" + oraBasePath, inventoryArg, debugFlag};
        boolean attachSucceeded = this.runCommand(attachHomeCmd);
        if (attachSucceeded) {
            File ohInvFile;
            String[] detachHomeCmd;
            boolean detachHomeSucceeded;
            boolean isPSUFirst;
            HashMap<String, String> envVars = new HashMap<String, String>();
            envVars.put("ORACLE_BASE", oraBasePath);
            boolean patchSucceeded = true;
            boolean bl = isPSUFirst = this.installerPatchBean.getApplyPSUFirst() == null ? false : this.installerPatchBean.getApplyPSUFirst();
            if (isPSUFirst) {
                if (this.installerPatchBean.isApplyingPSU()) {
                    patchSucceeded = this.applyPSU(envVars);
                }
                if (patchSucceeded && this.installerPatchBean.isApplyingOneOffs()) {
                    patchSucceeded = this.applyOneOffs(envVars);
                }
            } else {
                if (this.installerPatchBean.isApplyingOneOffs()) {
                    patchSucceeded = this.applyOneOffs(envVars);
                }
                if (patchSucceeded && this.installerPatchBean.isApplyingPSU()) {
                    patchSucceeded = this.applyPSU(envVars);
                }
            }
            if (!(detachHomeSucceeded = this.runCommand(detachHomeCmd = new String[]{ouiToolPath, "-detachHome", "-silent", "-waitforcompletion", "ORACLE_HOME=" + oracleHome, inventoryArg, debugFlag}))) {
                logger.log(Level.WARNING, "Could not detach the home from the temporal inventory.");
            }
            if (this.isWindows && !inventoryExists) {
                if (oracleRegKeyExists) {
                    try {
                        WinCRSInfo.deleteRegValueOnLocalNode("HKEY_LOCAL_MACHINE" + File.separator + "SOFTWARE\\ORACLE", "inst_loc");
                    }
                    catch (InstallException e) {
                        logger.log(Level.WARNING, "Could not remove the registry key pointing to the temporary inventory.", (Throwable)((Object)e));
                    }
                } else {
                    try {
                        WinCRSInfo.deleteRegKeyOnLocalNode("HKEY_LOCAL_MACHINE", "SOFTWARE\\ORACLE");
                    }
                    catch (InstallException e) {
                        logger.log(Level.WARNING, "Could not remove the Oracle registry key.", (Throwable)((Object)e));
                    }
                }
            }
            String ohInvPath = oracleHome + File.separator + "oraInst.loc";
            if (this.isWindows) {
                ohInvPath = oracleHome + File.separator + "bin" + File.separator + "oracle.key";
            }
            if ((ohInvFile = new File(ohInvPath)).exists()) {
                ohInvFile.delete();
            }
            if (!patchSucceeded) {
                System.exit(Application.CommonExitStatus.FAILURE.getIntValue());
            } else if (patchActionsFile.exists()) {
                this.removeFilesRecursively(patchActionsFile);
            }
        } else {
            String tempLogs = invLoc + File.separator + "logs";
            this.logAndPrint(this.resource.getString("InstallerPatchJob.attachHome.failed", "Preparing the home to apply the patch failed. For details look at the logs from {0}.", new Object[]{tempLogs}));
        }
        this.logAndPrint(this.resource.getString("InstallerPatchJob.logLocation", "The log can be found at: {0}", new Object[]{InstallerPatchDriver.getLogFile()}));
    }

    private boolean applyPSU(Map<String, String> envVars) {
        String psuPath = this.installerPatchBean.getPsuPath();
        File psuPathFile = new File(psuPath);
        File[] subFiles = psuPathFile.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            this.logAndPrint(this.resource.getString("InstallerPatchJob.applyPatch.start", "Applying the patch {0}...", new Object[]{psuPath}));
            for (File subFile : subFiles) {
                String patchPath;
                boolean succeeded;
                if (subFile == null || !subFile.getName().matches("^[0-9]+$") || (succeeded = this.runOpatch(patchPath = subFile.getAbsolutePath(), envVars))) continue;
                return false;
            }
            this.logAndPrint(this.resource.getString("InstallerPatchJob.applyPatch.end", "Successfully applied the patch.", new Object[0]));
        }
        return true;
    }

    private boolean applyOneOffs(Map<String, String> envVars) {
        String[] oneOffsPaths;
        for (String patchPath : oneOffsPaths = this.installerPatchBean.getOneOffsPaths()) {
            this.logAndPrint(this.resource.getString("InstallerPatchJob.applyPatch.start", "Applying the patch {0}...", new Object[]{patchPath}));
            boolean succeeded = this.runOpatch(patchPath, envVars);
            if (!succeeded) {
                return false;
            }
            this.logAndPrint(this.resource.getString("InstallerPatchJob.applyPatch.end", "Successfully applied the patch.", new Object[0]));
        }
        return true;
    }

    private boolean runOpatch(String patchPath, Map<String, String> envVars) {
        String verboseArg = this.installerPatchBean.isDebug() ? "-verbose" : "";
        String opatchBinary = this.isWindows ? "opatch.bat" : "opatch";
        String oracleHome = this.installerPatchBean.getOracleHome();
        String opatchPath = oracleHome + File.separator + "OPatch" + File.separator + opatchBinary;
        String patchLockPath = oracleHome + File.separator + InstallConstants.INSTALLER_PATCH_LOCK_FILE;
        File patchLockFile = new File(patchLockPath);
        boolean patchLockCreated = false;
        if (!patchLockFile.exists()) {
            try {
                patchLockCreated = patchLockFile.createNewFile();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not create the patch lock file.", e);
            }
        }
        String local = "";
        try {
            if (CRSInfo.getInstance().isCRSConfigured() || CRSInfo.getInstance().isHAConfigured()) {
                local = "-local";
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not determine if there is a CRS or HA configured in this environment.", e);
        }
        String[] cmd = new String[]{opatchPath, "apply", "-oh", oracleHome, patchPath, verboseArg, "-silent", "-no_relink", local};
        boolean cmdSucceeded = this.runCommand(cmd, envVars);
        if (!cmdSucceeded) {
            String opatchLogs = oracleHome + File.separator + "cfgtoollogs" + File.separator + "opatch" + File.separator;
            this.logAndPrint(Level.SEVERE, this.resource.getString("InstallerPatchJob.applyPatch.failed", "OPatch command failed while applying the patch. For details look at the logs from {0}", new Object[]{opatchLogs}));
        } else if (patchLockCreated) {
            patchLockFile.delete();
        }
        return cmdSucceeded;
    }

    private boolean runCommand(String[] args) {
        return this.runCommand(args, null);
    }

    private boolean runCommand(String[] args, Map<String, String> envVars) {
        List stderrLines;
        ProcessBuilder pb = new ProcessBuilder(args);
        if (envVars != null) {
            pb.environment().putAll(envVars);
        }
        AbstractLineProcessor stdoutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
            }
        };
        AbstractLineProcessor stderrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
            }
        };
        ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, (OutputProcessor)stdoutProcessor, (OutputProcessor)stderrProcessor);
        int exitCode = 0;
        ProcessLauncher pl = ProcessLauncher.getInstance();
        try {
            exitCode = pl.launchProcess(pli);
        }
        catch (Exception e) {
            exitCode = Application.CommonExitStatus.FAILURE.getIntValue();
        }
        List stdoutLines = stdoutProcessor.getLines();
        if (stdoutLines != null && !stdoutLines.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String stdoutLine : stdoutLines) {
                sb.append(stdoutLine + "\n");
            }
            logger.log(Level.INFO, sb.toString());
        }
        if ((stderrLines = stderrProcessor.getLines()) != null && !stderrLines.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String stderrLine : stderrLines) {
                sb.append(stderrLine + "\n");
            }
            logger.log(Level.WARNING, sb.toString());
        }
        return exitCode == 0;
    }

    private void applyInstallerUpdates() {
        String oracleHome = this.installerPatchBean.getOracleHome();
        String installerUpdates = oracleHome + File.separator + "install" + File.separator + "installerUpdates";
        File installerUpdatesFile = new File(installerUpdates);
        if (!installerUpdatesFile.exists()) {
            installerUpdatesFile.mkdirs();
        }
        String timestamp = this.installerPatchBean.getTimestamp();
        String backupLoc = installerUpdates + File.separator + "backup_" + timestamp;
        String[] installerUpdatesPaths = this.installerPatchBean.getInstallerUpdatesPaths();
        for (int i = 0; i < installerUpdatesPaths.length; ++i) {
            File backupLocFile;
            String backupColonUpdate;
            backupLoc = installerUpdatesPaths.length > 1 ? backupLoc + "_" + i : backupLoc;
            String installerUpdate = installerUpdatesPaths[i];
            while ((!this.isWindows && installerUpdate.length() > 1 || this.isWindows && installerUpdate.length() > 3) && installerUpdate.endsWith(File.separator)) {
                installerUpdate = installerUpdate.substring(0, installerUpdate.length() - 1);
            }
            String patchLockPath = oracleHome + File.separator + InstallConstants.INSTALLER_PATCH_LOCK_FILE;
            File patchLockFile = new File(patchLockPath);
            boolean patchLockCreated = false;
            if (!patchLockFile.exists()) {
                try {
                    patchLockCreated = patchLockFile.createNewFile();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not create the patch lock file.", e);
                }
            }
            if (patchLockCreated && !FileInfo.appendTextToFile(patchLockPath, backupColonUpdate = backupLoc + ":" + installerUpdate)) {
                logger.log(Level.WARNING, "Could not append the backup location to the patch lock file.");
            }
            if (!(backupLocFile = new File(backupLoc)).exists()) {
                backupLocFile.mkdirs();
            }
            String filesDirPath = installerUpdate + File.separator + "files";
            File filesDir = new File(filesDirPath);
            this.logAndPrint(this.resource.getString("InstallerPatchJob.applyInstallerUpdates.start", "Applying installer update from: {0}", new Object[]{installerUpdate}));
            File[] subFiles = filesDir.listFiles();
            if (subFiles != null && subFiles.length > 0) {
                int filesCopied = 0;
                for (File subFile : subFiles) {
                    filesCopied += this.copyFilesRecursively(subFile, filesDirPath, oracleHome, backupLoc);
                }
                this.logAndPrint(this.resource.getString("InstallerPatchJob.applyInstallerUpdates.filesCopied", "Number of files copied: {0}", new Object[]{filesCopied}));
            }
            if (!patchLockCreated || !patchLockFile.exists()) continue;
            patchLockFile.delete();
        }
        this.logAndPrint(this.resource.getString("InstallerPatchJob.logLocation", "The log can be found at: {0}", new Object[]{InstallerPatchDriver.getLogFile()}));
    }

    private int copyFilesRecursively(File file, String filesLoc, String destLoc, String backupLoc) {
        int filesCopied;
        block13: {
            File destFile;
            block14: {
                String destTemplate;
                File destTemplateFile;
                filesCopied = 0;
                if (file == null) break block13;
                String fileName = file.getName();
                String parentPath = file.getParent();
                String relPath = filesLoc.length() == parentPath.length() ? "" : parentPath.substring(filesLoc.length() + 1);
                String destPath = destLoc + File.separator + relPath + File.separator + fileName;
                destFile = new File(destPath);
                String templatesPath = destLoc + File.separator + "inventory" + File.separator + "Templates";
                if (!Files.isSymbolicLink(file.toPath()) && file.isDirectory()) break block14;
                if (backupLoc != null && destFile.exists()) {
                    File backupParentPath = new File(backupLoc + File.separator + relPath);
                    if (!backupParentPath.exists()) {
                        backupParentPath.mkdirs();
                    }
                    File backupDestFile = new File(backupParentPath, fileName);
                    Path backupDestFilePath = null;
                    try {
                        backupDestFilePath = Files.copy(destFile.toPath(), backupDestFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not copy the file " + destFile.getAbsolutePath() + " to " + backupDestFile.getAbsolutePath());
                    }
                    if (backupDestFilePath != null) {
                        logger.log(Level.INFO, "File backed up: " + backupDestFile.getAbsolutePath());
                    }
                }
                Path destFilePath = null;
                try {
                    destFilePath = Files.copy(file.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not copy the file " + file.getAbsolutePath() + " to " + destFile.getAbsolutePath());
                }
                if (destFilePath != null) {
                    logger.log(Level.INFO, "File copied: " + destPath);
                    ++filesCopied;
                }
                if (!(destTemplateFile = new File(destTemplate = templatesPath + File.separator + relPath + File.separator + fileName)).exists()) break block13;
                Path destTemplatePath = null;
                try {
                    destTemplatePath = Files.copy(file.toPath(), destTemplateFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not copy the file " + file.getAbsolutePath() + " to " + destTemplateFile.getAbsolutePath());
                }
                if (destTemplatePath == null) break block13;
                logger.log(Level.INFO, "Template file copied: " + destTemplate);
                break block13;
            }
            File[] subFiles = file.listFiles();
            if (subFiles != null && subFiles.length > 0) {
                if (!destFile.exists()) {
                    destFile.mkdirs();
                }
                for (File subFile : subFiles) {
                    filesCopied += this.copyFilesRecursively(subFile, filesLoc, destLoc, backupLoc);
                }
            }
        }
        return filesCopied;
    }

    private void updateOpatch() {
        String oracleHome = this.installerPatchBean.getOracleHome();
        String currentOpatch = oracleHome + File.separator + "OPatch";
        File currentOpatchFile = new File(currentOpatch);
        String newOpatch = this.installerPatchBean.getOpatchLoc();
        File newOpatchFile = new File(newOpatch);
        String timestamp = this.installerPatchBean.getTimestamp();
        String backupLoc = oracleHome + File.separator + "OPatch" + "_" + timestamp + ".bkp";
        File backupLocFile = new File(backupLoc);
        Path backupPath = null;
        try {
            backupPath = Files.move(currentOpatchFile.toPath(), backupLocFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not move the current opatch to the backup location.", e);
        }
        if (backupPath != null) {
            this.logAndPrint(this.resource.getString("InstallerPatchJob.updateOpatch.moved", "Moved the existent OPatch software to ({0}).", new Object[]{backupLoc}));
        }
        int filesCopied = -1;
        filesCopied = this.copyFilesRecursively(newOpatchFile, newOpatchFile.getParent(), oracleHome, null);
        if (filesCopied > -1) {
            this.logAndPrint(this.resource.getString("InstallerPatchJob.updateOpatch.updated", "Successfully copied the provided OPatch software from ({0}) into the Oracle home ({1}).", new Object[]{newOpatch, oracleHome}));
        }
    }

    private void logAndPrint(String str) {
        this.logAndPrint(Level.INFO, str);
    }

    private void logAndPrint(Level level, String str) {
        if (level == null) {
            level = Level.INFO;
        }
        logger.log(level, str);
        System.out.println(str);
    }
}

