/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver.job;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.resource.StringResourceBundle;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FunctionsUtil;
import oracle.install.library.util.PlatformInfo;

public class CreateGoldImageJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(CreateGoldImageJob.class.getName());
    private String sourceHome;
    private String destinationLocation;
    protected static final String sep = File.separator;
    protected List<String> excludedFiles;
    private static final String timestamp = FunctionsUtil.getTimeStamp();
    protected String goldImageName = "home";
    protected String cmdLineExclFiles;
    private ProgressUI<Void> progressUI;

    public CreateGoldImageJob(String sourceHome, String destinationLocation, String cmdLineExclFiles, ProgressUI<Void> progressUI) {
        super((Object)"creategoldimage", null, 0.1f);
        this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)CommonDialogLabelResID.class.getName(), (String)"createGoldImageJob.description"), "Create Gold Image", new Object[0]));
        this.setRetryEnabled(true);
        this.setRequired(true);
        this.setRetriable(this);
        this.sourceHome = sourceHome;
        this.destinationLocation = destinationLocation;
        this.cmdLineExclFiles = cmdLineExclFiles;
        this.progressUI = progressUI;
    }

    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        Application.removeExitStatus((ExitStatus)Application.CommonExitStatus.FAILURE);
        Resource stringResource = Application.getInstance().getResource(StringResourceBundle.class.getName());
        this.log(Level.INFO, stringResource.getString("CreateGoldImageJob.progress.createGoldImage", "Creating the Gold Image", new Object[0]), new Object[0]);
        boolean succeeded = false;
        Set<File> filesSet = this.getAllFilesRecursively(new File(this.sourceHome));
        if (filesSet != null) {
            this.setProgress(0.1f);
            filesSet = this.removeExcludedFiles(filesSet);
            this.setProgress(0.15f);
            List<File> sortedFiles = this.sortFilesByPathLength(filesSet);
            this.setProgress(0.2f);
            succeeded = this.addToGoldImage(sortedFiles, this.sourceHome, this.getProgress(), 0.78f);
            this.setProgress(0.98f);
        }
        this.setProgress(1.0f);
        if (succeeded) {
            this.setStatus(Status.SUCCEEDED);
        } else {
            String logLocation = OUILogHandler.getLogLocation();
            Advice advice = ExceptionManager.advise((ErrorMessage)new DefaultErrorMessage((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_CREATOR_JOB_FAILED, new Object[]{logLocation}));
            if (advice == Advice.CONTINUE) {
                this.setStatus(Status.SUCCEEDED);
            } else {
                this.setStatus(Status.FAILED);
                Application.addExitStatus((ExitStatus)Application.CommonExitStatus.FAILURE);
            }
        }
    }

    private List<File> sortFilesByPathLength(Set<File> filesSet) {
        ArrayList<File> sortedFiles = new ArrayList<File>();
        sortedFiles.addAll(filesSet);
        Collections.sort(sortedFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int dist1 = f1.getAbsolutePath().length();
                int dist2 = f2.getAbsolutePath().length();
                return dist1 - dist2;
            }
        });
        return sortedFiles;
    }

    protected Set<File> getAllFilesRecursively(File file) {
        HashSet<File> files = new HashSet<File>();
        if (file != null) {
            files.add(file);
            if (file.isDirectory()) {
                File[] subFiles = null;
                try {
                    subFiles = file.listFiles();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get subfiles from: " + file.getPath(), e);
                }
                if (subFiles != null && subFiles.length > 0) {
                    for (File subFile : subFiles) {
                        files.addAll(this.getAllFilesRecursively(subFile));
                    }
                }
            }
        }
        return files;
    }

    private Set<File> removeExcludedFiles(Set<File> listOfFiles) {
        HashSet<File> files = new HashSet<File>();
        if (listOfFiles != null && !listOfFiles.isEmpty()) {
            files.addAll(listOfFiles);
            if (this.excludedFiles != null && !this.excludedFiles.isEmpty()) {
                for (String excludedFile : this.excludedFiles) {
                    File excluded = null;
                    try {
                        excluded = new File(this.sourceHome + sep + excludedFile);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Could not create file object from: " + excludedFile, e);
                    }
                    if (excluded == null || !excluded.exists()) continue;
                    files.remove(excluded);
                }
            }
        }
        files.remove(new File(this.sourceHome));
        return files;
    }

    private boolean addToGoldImage(List<File> sortedFiles, String workingDir, float currentProgress, float progressWeight) {
        boolean isDestDirCreated;
        File destinationDir;
        boolean succeed = true;
        String goldImageName = this.goldImageName + "_" + timestamp + ".zip";
        if (workingDir.endsWith(File.separator)) {
            workingDir = workingDir.substring(0, workingDir.length() - 1);
        }
        if (!(destinationDir = new File(this.destinationLocation)).exists() && !(isDestDirCreated = destinationDir.mkdirs())) {
            logger.log(Level.SEVERE, "Failed to create destination location:" + this.destinationLocation);
            return false;
        }
        if (sortedFiles != null && !sortedFiles.isEmpty()) {
            int buffer = 100;
            float progressIncrement = 0.0f;
            if (currentProgress != -1.0f) {
                progressIncrement = progressWeight / (float)(sortedFiles.size() / buffer);
            }
            for (int i = 0; i < sortedFiles.size(); i += buffer) {
                int batchSize = buffer;
                if (i + buffer > sortedFiles.size()) {
                    batchSize = sortedFiles.size() - i;
                }
                List<File> filesBatch = sortedFiles.subList(i, i + batchSize);
                ArrayList<String> args = new ArrayList<String>();
                args.add(System.getProperty("ORACLE_HOME") + sep + "bin" + sep + "zip");
                args.add("-q");
                if (!PlatformInfo.getInstance().isWindows()) {
                    args.add("-y");
                }
                if (new File(this.destinationLocation + sep + goldImageName).exists()) {
                    args.add("-g");
                }
                args.add(this.destinationLocation + sep + goldImageName);
                for (File file : filesBatch) {
                    args.add(file.getAbsolutePath().substring(workingDir.length() + 1));
                }
                succeed = this.runCmd(args.toArray(new String[0]), workingDir);
                if (!succeed) {
                    new File(this.destinationLocation + sep + goldImageName).delete();
                    break;
                }
                if (currentProgress == -1.0f) continue;
                this.setProgress(this.getProgress() + progressIncrement);
            }
        }
        return succeed;
    }

    private boolean runCmd(String[] args, String currentWorkingDir) {
        boolean succeed = true;
        AbstractLineProcessor stdOutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                logger.info(line);
            }
        };
        AbstractLineProcessor stdErrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                logger.warning(line);
            }
        };
        ProcessBuilder pb = new ProcessBuilder(args);
        if (currentWorkingDir != null) {
            pb.directory(new File(currentWorkingDir));
        }
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, (OutputProcessor)stdOutProcessor, (OutputProcessor)stdErrProcessor);
        int exitCode = 0;
        try {
            exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
        }
        catch (Exception e) {
            succeed = false;
            logger.log(Level.INFO, "Gold image creation failed", e);
            logger.log(Level.INFO, e.getMessage());
        }
        if (exitCode != 0) {
            succeed = false;
        }
        return succeed;
    }

    protected List<String> getExcludedFiles(String sourceHome) {
        String[] exclFiles;
        ArrayList<String> files = new ArrayList<String>();
        if (this.cmdLineExclFiles != null && !this.cmdLineExclFiles.isEmpty() && (exclFiles = this.cmdLineExclFiles.split(",")) != null && exclFiles.length > 0) {
            for (String exclFile : exclFiles) {
                if (exclFile == null || !exclFile.startsWith(sourceHome)) continue;
                File excl = null;
                try {
                    excl = new File(exclFile);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not get file object from: " + exclFile, e);
                }
                if (excl == null || !excl.exists()) continue;
                files.add(exclFile.substring(sourceHome.length() + 1));
                Set<File> subFiles = this.getAllFilesRecursively(excl);
                if (subFiles == null || subFiles.isEmpty()) continue;
                for (File subFile : subFiles) {
                    files.add(subFile.getAbsolutePath().substring(sourceHome.length() + 1));
                }
            }
        }
        List<String> nonReadableFiles = null;
        try {
            nonReadableFiles = FileInfo.getNonReadableFiles(new File(sourceHome));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not get the non readable files from the source home " + sourceHome, e);
        }
        if (nonReadableFiles != null && !nonReadableFiles.isEmpty()) {
            logger.warning("Following files are not readable: " + nonReadableFiles.toString());
            for (String file : nonReadableFiles) {
                files.add(file.substring(sourceHome.length() + 1));
            }
        }
        return files;
    }

    protected List<String> getExistentFilesFromRegexListFile(String topDir, String regexListFile) {
        ArrayList<String> files = new ArrayList<String>();
        if (regexListFile != null) {
            File file = null;
            try {
                file = new File(topDir + sep + regexListFile);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not create file object from: " + regexListFile, e);
            }
            if (file != null) {
                if (file.exists()) {
                    ArrayList<String> regexLines = FileInfo.getFileContentLines(regexListFile);
                    if (regexLines != null && !regexLines.isEmpty()) {
                        for (String line : regexLines) {
                            Set<File> innerFiles;
                            if (line == null) continue;
                            if (PlatformInfo.getInstance().isWindows()) {
                                line = line.replace('/', '\\');
                            }
                            if (line.contains("*")) {
                                if (line.indexOf(42) != line.lastIndexOf(42)) continue;
                                String wildcard = "*";
                                if (line.contains(".*")) {
                                    wildcard = ".*";
                                }
                                String firstHalf = line.substring(0, line.indexOf(wildcard));
                                String secondHalf = null;
                                if (line.length() > firstHalf.length() + wildcard.length()) {
                                    secondHalf = line.substring(line.indexOf(wildcard) + wildcard.length(), line.length());
                                }
                                String lastDirPath = firstHalf.substring(0, firstHalf.lastIndexOf(sep) + 1);
                                File lastDir = null;
                                try {
                                    lastDir = new File(topDir + sep + lastDirPath);
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Could not create file object from: " + topDir + sep + lastDirPath, e);
                                }
                                if (lastDir == null || !lastDir.exists()) continue;
                                String fileNamePrefix = "";
                                if (firstHalf.length() > lastDirPath.length()) {
                                    fileNamePrefix = firstHalf.substring(lastDirPath.length());
                                }
                                String fileNameSuffix = "";
                                if (secondHalf != null) {
                                    fileNameSuffix = secondHalf;
                                }
                                File[] subFiles = null;
                                try {
                                    final String namePrefix = fileNamePrefix;
                                    final String nameSuffix = fileNameSuffix;
                                    subFiles = lastDir.listFiles(new FilenameFilter(){

                                        @Override
                                        public boolean accept(File file, String name) {
                                            return name.startsWith(namePrefix) && name.endsWith(nameSuffix);
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    logger.log(Level.SEVERE, "Could not expand the files from: " + line, e);
                                }
                                if (subFiles == null || subFiles.length <= 0) continue;
                                for (File subFile : subFiles) {
                                    Set<File> innerFiles2;
                                    files.add(subFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                                    if (!subFile.isDirectory() || (innerFiles2 = this.getAllFilesRecursively(subFile)) == null || innerFiles2.isEmpty()) continue;
                                    for (File innerFile : innerFiles2) {
                                        files.add(innerFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                                    }
                                }
                                continue;
                            }
                            File lineFile = null;
                            try {
                                lineFile = new File(topDir + sep + line);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Could not create file object from: " + topDir + sep + line, e);
                            }
                            if (lineFile == null || !lineFile.exists()) continue;
                            files.add(lineFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                            if (!lineFile.isDirectory() || (innerFiles = this.getAllFilesRecursively(lineFile)) == null || innerFiles.isEmpty()) continue;
                            for (File innerFile : innerFiles) {
                                files.add(innerFile.getAbsolutePath().substring(this.sourceHome.length() + 1));
                            }
                        }
                    }
                } else {
                    logger.log(Level.INFO, "File " + regexListFile + "does not exist.");
                }
            }
        }
        return files;
    }

    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add((Job)this);
            }
        }
        return retriableJobs;
    }

    public void retry() throws Exception {
        this.call(true);
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public Callable<?> getWork() {
        return this;
    }

    protected void log(Level level, String message, Object ... args) {
        if (this.progressUI != null) {
            this.progressUI.log(level, message, args);
        } else {
            logger.log(level, message, args);
        }
    }
}

