/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import oracle.install.commons.flow.ConditionContext;
import oracle.install.commons.flow.ConditionResult;
import oracle.install.commons.flow.ConditionRoutine;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.ivw.common.bean.Language;
import oracle.install.ivw.common.bean.OracleSetupBean;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.common.validator.ProductLanguageValidator;
import oracle.install.library.util.ProductInfo;
import oracle.sysman.oii.oiix.OiixLanguage;

@UIRef(value="ProductLanguageUI")
@ValidatorRef(value=ProductLanguageValidator.class)
public class ProductLanguageAction
extends DefaultAction
implements ConditionRoutine {
    public static final Route ROUTE_DEFAULT = new Route("productlanguage_yes");

    public final void execute(FlowContext flowContext) {
        OracleSetupBean setupBean = (OracleSetupBean)((Object)flowContext.getBeanLike(OracleSetupBean.class));
        ArrayList<String> languages = new ArrayList<String>();
        languages.addAll(Arrays.asList(setupBean.getLanguages()));
        if (languages.size() > 0 && languages.contains("all_langs")) {
            Set<Language> supportedLanguages = ProductInfo.getInstance().getSupportedLanguages();
            languages.clear();
            for (Language language : supportedLanguages) {
                languages.add(language.getCode());
            }
            setupBean.setLanguages(languages.toArray(new String[0]));
        }
    }

    public Route transition(FlowContext flowContext) {
        OracleSetupBean setupBean = (OracleSetupBean)((Object)flowContext.getBeanLike(OracleSetupBean.class));
        ArrayList<String> languages = new ArrayList<String>();
        languages.addAll(Arrays.asList(OiixLanguage.getUpdatedLangs23((String[])setupBean.getLanguages())));
        setupBean.setLanguages(languages.toArray(new String[0]));
        return ROUTE_DEFAULT;
    }

    public ConditionResult check(ConditionContext context) {
        OracleSetupBean setupBean = (OracleSetupBean)((Object)context.getFlowContext().getBeanLike(OracleSetupBean.class));
        String propertyCheck = PreferenceHelper.getProperty("oracle.install.allowProductLanguageSelection");
        if (propertyCheck != null && !Boolean.parseBoolean(propertyCheck)) {
            setupBean.setLanguages(ProductLanguageAction.getAllLanguages());
            return ConditionResult.MATCHED;
        }
        return ConditionResult.MISMATCHED;
    }

    private static String[] getAllLanguages() {
        Set<Language> supportedLanguages = ProductInfo.getInstance().getSupportedLanguages();
        ArrayList<String> languages = new ArrayList<String>();
        for (Language language : supportedLanguages) {
            languages.add(language.getCode());
        }
        String[] allUpdatedLanguages = OiixLanguage.getUpdatedLangs23((String[])languages.toArray(new String[0]));
        return allUpdatedLanguages;
    }
}

