/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMInstanceType;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.util.Version;

class VersionOpOutputParser
extends KFODOpOutputParser {
    private ASMInstance instance;

    public VersionOpOutputParser(ASMInstance instance) {
        this.instance = instance;
    }

    public VersionOpOutputParser() {
    }

    public ASMInstance getInstance() {
        return this.instance;
    }

    public void setInstance(ASMInstance instance) {
        this.instance = instance;
    }

    @Override
    public void parseLine(String line) {
        String[] tokens = Helper.tokenize(line);
        if (tokens.length == 3) {
            try {
                String sid = tokens[0];
                String rac = tokens[1];
                ASMInstanceType instanceType = ASMInstanceType.UNKNOWN;
                if ("NO".equals(rac)) {
                    instanceType = ASMInstanceType.NON_RAC;
                } else if ("YES".equals(rac)) {
                    instanceType = ASMInstanceType.RAC;
                }
                if (instanceType != ASMInstanceType.UNKNOWN) {
                    Version version = Version.parseVersion((String)tokens[2]);
                    if (this.instance != null) {
                        this.instance.setVersion(version);
                        this.instance.setInstanceType(instanceType);
                    } else {
                        OracleServiceRegistry registry = OracleServiceRegistry.getInstance();
                        OracleService oracleService = registry.findServiceById(sid);
                        if (oracleService != null) {
                            oracleService.setVersion(version);
                            this.instance = new ASMInstance(oracleService, instanceType);
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

