/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.install.asm.bean.ASMInputValidationHelper;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.Advice;

public class DiskDiscoveryPathDialog
extends JDialog {
    private Logger logger = Logger.getLogger(DiskDiscoveryPathDialog.class.getName());
    private MultiLineLabel lblDescription;
    private JLabel lblDiskPath;
    private JTextField txtDiscoveryPath;
    private JButton btnOk;
    private JButton btnCancel;
    private String diskDiscoveryString;
    private String[] diskDiscoveryPath;
    private Frame owner;

    public DiskDiscoveryPathDialog(Frame owner, String diskDiscoveryString) {
        super(owner);
        this.setName(DiskDiscoveryPathDialog.class.getName());
        this.diskDiscoveryPath = null;
        this.diskDiscoveryString = diskDiscoveryString;
        if (this.diskDiscoveryString == null || this.diskDiscoveryString.length() == 0) {
            try {
                ASMUtility asmUtil = ASMUtility.getInstance();
                this.diskDiscoveryString = asmUtil.getDefaultDiscoveryString();
            }
            catch (ASMUtilityException e) {
                e.printStackTrace();
                StandardDialog.showError((Component)this, (Throwable)((Object)e));
            }
        }
        this.owner = owner;
        this.buildUI();
    }

    protected void acceptInput() {
        this.processDiscoveryString(this.txtDiscoveryPath.getText().trim());
        this.dispose();
    }

    protected void discardInput() {
        this.dispose();
    }

    protected void buildUI() {
        this.btnOk = new JButton();
        this.btnOk.setName("DiskDiscoveryPathDialog.btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskDiscoveryPathDialog.this.acceptInput();
            }
        });
        this.btnCancel = new JButton();
        this.btnCancel.setName("DiskDiscoveryPathDialog.btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiskDiscoveryPathDialog.this.discardInput();
            }
        });
        this.txtDiscoveryPath = new JTextField();
        this.txtDiscoveryPath.setName("DiskDiscoveryPathDialog.txtDiscoveryPath");
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (DiskDiscoveryPathDialog.this.btnCancel.isShowing() || DiskDiscoveryPathDialog.this.txtDiscoveryPath.isShowing()) {
                    int keyCode = e.getKeyCode();
                    if (e.getKeyCode() == 10) {
                        DiskDiscoveryPathDialog.this.acceptInput();
                    }
                    if (keyCode == 27) {
                        DiskDiscoveryPathDialog.this.discardInput();
                    }
                }
                return false;
            }
        });
        this.lblDiskPath = new JLabel();
        this.lblDescription = new MultiLineLabel();
        JPanel jContentPane = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblDescription, (Container)jContentPane, (int)0, (int)0, (int)3, (int)1, (int)1, (int)21, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.lblDiskPath, (Container)jContentPane, (int)0, (int)1, (int)1, (int)1, (int)0, (int)21, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.txtDiscoveryPath, (Container)jContentPane, (int)1, (int)1, (int)2, (int)1, (int)2, (int)21, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)jContentPane, (int)1, (int)2, (int)1, (int)1, (int)2, (int)21, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnOk, (Container)jContentPane, (int)1, (int)2, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnCancel, (Container)jContentPane, (int)2, (int)2, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        JPanel pnlContent = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)jContentPane, (Container)pnlContent, (int)0, (int)0, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (Insets)new Insets(10, 10, 10, 10));
        this.getContentPane().add(pnlContent);
        this.lblDiskPath.setLabelFor(this.txtDiscoveryPath);
        this.setLocalizedTexts();
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.txtDiscoveryPath.setText(this.diskDiscoveryString);
    }

    private void processDiscoveryString(String discoveryString) {
        discoveryString = discoveryString.replaceAll("'", "").replaceAll("\"", "");
        this.logger.info("... discoveryString = " + discoveryString);
        String[] paths = discoveryString.trim().split(",");
        ArrayList<String> pathList = new ArrayList<String>();
        StatusMessages<ValidationStatusMessage> errorMessages = new StatusMessages<ValidationStatusMessage>();
        errorMessages = ASMInputValidationHelper.validateDiskDiscoveryString(discoveryString);
        if (errorMessages.size() > 0) {
            Advice advice = StandardDialog.showErrors((Component)this, errorMessages);
            if (advice == Advice.ABORT) {
                StandardDialog.promptInput((Component)this.owner, (String)this.getTitle(), (Component)this);
            }
        } else {
            for (String path : paths) {
                if ((path = path.trim()).length() <= 0) continue;
                pathList.add(path);
            }
            if (!pathList.isEmpty()) {
                this.diskDiscoveryString = discoveryString;
                this.diskDiscoveryPath = pathList.toArray(new String[0]);
            }
        }
    }

    private void setLocalizedTexts() {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.asm.resource.StringResourceBundle");
        this.setTitle(resource.getString("DiskDiscoveryPathDialog.title", "Change Disk Discovery Path", new Object[0]));
        String text = resource.getString("DiskDiscoveryPathDialog.ok", "&OK*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnOk, (String)text);
        text = resource.getString("DiskDiscoveryPathDialog.cancel", "Cancel*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnCancel, (String)text);
        text = resource.getString("DiskDiscoveryPathDialog.lblDiskPath.text", "&Disk Discovery Path*:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblDiskPath, (String)text);
        this.lblDescription.setText(resource.getString("DiskDiscoveryPathDialog.lblDescription.text", "Changing the Disk Discovery Path will affect all Disk Groups", new Object[0]));
    }

    public String[] getDiskDiscoveryPath() {
        return this.diskDiscoveryPath;
    }

    public String getDiskDiscoveryString() {
        return this.diskDiscoveryString;
    }
}

