/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.asm.bean.ASMInputValidationErrorCode;
import oracle.install.asm.bean.ASMSettings;
import oracle.install.asm.bean.DiskGroupSettings;
import oracle.install.asm.resource.ASMInstallConstants;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.DiskGroupInitPurpose;
import oracle.install.asm.util.DiskHeaderStatus;
import oracle.install.asm.util.FailureGroup;
import oracle.install.asm.util.Redundancy;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.util.PreferenceHelper;
import oracle.install.ivw.crs.bean.CRSInstallSettings;
import oracle.install.ivw.crs.validator.MgmtDBValidationHelper;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.ivw.db.validator.RecoveryBackupValidator;
import oracle.install.ivw.db.validator.StorageOptionsValidator;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.CRSConstants;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cluster.ClusterNode;

public class ASMInputValidationHelper {
    private static final int ASM_DISKGROUP_NAME_SIZE = 30;
    private static Logger logger = Logger.getLogger(ASMInputValidationHelper.class.getName());

    private static int getMinimumDiskCount(DiskGroupInitPurpose purpose, Redundancy redundancy) {
        int diskCount = 0;
        if (redundancy != null) {
            if (purpose == DiskGroupInitPurpose.METADATA) {
                switch (redundancy) {
                    case EXTERNAL: {
                        diskCount = 1;
                        break;
                    }
                    case NORMAL: {
                        diskCount = 3;
                        break;
                    }
                    case HIGH: {
                        diskCount = 5;
                        break;
                    }
                    case FLEX: {
                        diskCount = 3;
                        break;
                    }
                    case EXTENDED: {
                        diskCount = 5;
                    }
                }
            } else {
                switch (redundancy) {
                    case EXTERNAL: {
                        diskCount = 1;
                        break;
                    }
                    case NORMAL: {
                        diskCount = 2;
                        break;
                    }
                    case HIGH: {
                        diskCount = 3;
                        break;
                    }
                    case FLEX: {
                        diskCount = 3;
                        break;
                    }
                    case EXTENDED: {
                        diskCount = 3;
                    }
                }
            }
        }
        return diskCount;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskGroup(String diskGroupName, boolean isOradataOnASM, boolean isBackupRecoveryOnASM, boolean isContainerDB) {
        StatusMessages errorMessages = new StatusMessages();
        try {
            ASMUtility asmUtility = ASMUtility.getInstance();
            ASMInstance asmInstance = asmUtility.getASMInstance();
            if (asmInstance == null) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_INSTANCE_NOT_FOUND, new Object[0]));
            }
            if (diskGroupName == null || diskGroupName.trim().length() == 0) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.NO_ASM_DISKGROUP_SELECTED, new Object[0]));
            }
            if (asmInstance != null) {
                List<DiskGroup> diskGroups = asmUtility.getDiskGroups(asmInstance);
                if (diskGroups == null || diskGroups.isEmpty()) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.NO_ASM_DISKGROUP_FOUND, new Object[]{asmInstance.getSid()}));
                } else {
                    DiskGroup selectedDiskGroup = null;
                    for (DiskGroup diskGroup : diskGroups) {
                        if (!diskGroupName.equalsIgnoreCase(diskGroup.getName())) continue;
                        selectedDiskGroup = diskGroup;
                        break;
                    }
                    if (selectedDiskGroup == null) {
                        errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.UNKNOWN_ASM_DISKGROUP, new Object[]{diskGroupName}));
                    } else {
                        ValidationStatusMessage errMessage;
                        int value = selectedDiskGroup.getAsmCompatibilityVersion().compareTo(InstallConstants.VERSION_12_1, 2);
                        if (value < 0) {
                            String selectedAsmVersion = selectedDiskGroup.getAsmCompatibilityVersion().getMajor() + "." + selectedDiskGroup.getAsmCompatibilityVersion().getMinor() + "." + "0.0.0";
                            String requiredAsmVersion = InstallConstants.VERSION.getMajor() + "." + InstallConstants.VERSION.getMinor() + "." + "0.0.0";
                            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INCORRECT_ASM_COMPATIBLITY_VERSION, new Object[]{selectedAsmVersion, selectedDiskGroup.getName(), requiredAsmVersion}));
                        }
                        if ((errMessage = ASMInputValidationHelper.validateFreeSpace(selectedDiskGroup, isOradataOnASM, isBackupRecoveryOnASM, isContainerDB)) != null) {
                            errorMessages.add((StatusMessage)errMessage);
                        }
                    }
                }
            }
        }
        catch (ASMUtilityException e) {
            ExceptionManager.handle((Throwable)((Object)e));
        }
        return errorMessages;
    }

    public static ValidationStatusMessage validateFreeSpace(DiskGroup diskGroup, boolean oradataOnASM, boolean backupRecoveryOnASM) {
        return ASMInputValidationHelper.validateFreeSpace(diskGroup, oradataOnASM, backupRecoveryOnASM, false);
    }

    public static ValidationStatusMessage validateFreeSpace(DiskGroup diskGroup, boolean oradataOnASM, boolean backupRecoveryOnASM, boolean isContainerDB) {
        ValidationStatusMessage errorMessage = null;
        if (diskGroup != null) {
            Redundancy redundancy = diskGroup.getRedundancy();
            long freeSpaceRequired = ASMInputValidationHelper.getFreeSpaceRequired(oradataOnASM, backupRecoveryOnASM, isContainerDB, redundancy);
            logger.log(Level.FINEST, "The required space in MB is : " + freeSpaceRequired + " and the diskgroup " + diskGroup.getName() + " has " + diskGroup.getFreeSpace() + " space");
            if (diskGroup.getFreeSpace() < freeSpaceRequired) {
                errorMessage = new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKGROUP, new Object[]{String.valueOf(freeSpaceRequired)});
            }
        }
        return errorMessage;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
        return ASMInputValidationHelper.validateDiskGroupSettings(diskGroupSettings, DiskGroupInitPurpose.USERDATA, 1);
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskGroupSettings(DiskGroupSettings diskGroupSettings, DiskGroupInitPurpose purpose, int nodeCount) {
        StatusMessages errorMessageList = null;
        ArrayList<Disk> cachedDisksList = new ArrayList();
        try {
            ASMUtility asmUtility = ASMUtility.getInstance();
            if (diskGroupSettings.getDiskPaths() != null) {
                cachedDisksList = asmUtility.findDisks(diskGroupSettings.getDiskPaths().toArray(new String[0]));
            }
        }
        catch (ASMUtilityException aue) {
            ExceptionManager.handle((Throwable)((Object)aue));
        }
        if (diskGroupSettings != null) {
            errorMessageList = new StatusMessages();
            errorMessageList.addAll(ASMInputValidationHelper.validateDiskDiscoveryString(diskGroupSettings.getDiskDiscoveryString()));
            StatusMessages<ValidationStatusMessage> errorMessages = ASMInputValidationHelper.validateGroupName(diskGroupSettings.getGroupName(), diskGroupSettings.getDiskDiscoveryString());
            if (errorMessages != null) {
                errorMessageList.addAll(errorMessages);
            }
            if ((errorMessages = ASMInputValidationHelper.validateHeader(cachedDisksList)) != null) {
                errorMessageList.addAll(errorMessages);
            }
            if ((errorMessages = ASMInputValidationHelper.validateRedundancy(diskGroupSettings.getRedundancy())) != null) {
                errorMessageList.addAll(errorMessages);
            }
            if ((errorMessages = ASMInputValidationHelper.validateDiskSizes(cachedDisksList, diskGroupSettings)) != null) {
                errorMessageList.addAll(errorMessages);
            }
            if ((errorMessages = ASMInputValidationHelper.validateAUSize(diskGroupSettings.getAUSize())) != null) {
                errorMessageList.addAll(errorMessages);
            }
            errorMessageList.addAll(ASMInputValidationHelper.validateDiskPaths(diskGroupSettings.getDiskPaths(), diskGroupSettings.getRedundancy(), purpose, nodeCount, cachedDisksList));
        }
        return errorMessageList;
    }

    public static StatusMessages<ValidationStatusMessage> validateAUSize(int AUSize) {
        StatusMessages errorMessages = new StatusMessages();
        if (!Arrays.asList(CRSConstants.AUSizes).contains(AUSize)) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_DISKGROUP_AUSIZE_NOT_VALID, new Object[]{Arrays.toString((Object[])CRSConstants.AUSizes)}));
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskSizes(List<Disk> disks, DiskGroupSettings diskGroupSettings) {
        StatusMessages errorMessages = new StatusMessages();
        Redundancy redundancy = diskGroupSettings.getRedundancy();
        int auSize = diskGroupSettings.getAUSize();
        ArrayList<String> disksPassingSizeLimit = new ArrayList<String>();
        if (disks != null && !disks.isEmpty()) {
            long sizeLimit = 0x200000L;
            for (Disk disk : disks) {
                long size;
                if (disk == null || (size = disk.getSize()) < sizeLimit) continue;
                disksPassingSizeLimit.add(disk.getPath());
            }
        }
        if (!disksPassingSizeLimit.isEmpty()) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_DISK_SIZE_PASSES_RDBMS_COMPATIBILITY_LIMIT, new Object[]{2, diskGroupSettings.getGroupName(), "12.1", ((Object)disksPassingSizeLimit).toString()}));
        }
        ArrayList<Disk> disksCopy = new ArrayList<Disk>();
        disksCopy.addAll(disks);
        if (redundancy != Redundancy.EXTERNAL) {
            Map<String, String> diskFGMap = diskGroupSettings.getDiskFailureGroupMap();
            List<String> quorumFGList = diskGroupSettings.getQuorumFailureGroupNames();
            if (diskFGMap != null && quorumFGList != null && quorumFGList.size() > 0) {
                String fgName = null;
                for (String quorumFG : quorumFGList) {
                    for (String diskPath : diskFGMap.keySet()) {
                        Disk diskToBeRemoved;
                        fgName = diskFGMap.get(diskPath);
                        if (fgName == null || !fgName.equalsIgnoreCase(quorumFG) || (diskToBeRemoved = ASMInputValidationHelper.getDiskToBeRemoved(disksCopy, diskPath)) == null) continue;
                        disksCopy.remove(diskToBeRemoved);
                    }
                }
            }
            if (disksCopy.size() > 1) {
                Disk previousDisk = (Disk)disksCopy.get(0);
                long sizeOfPreviousDisk = previousDisk.getSize();
                int auBlocksInPreviousDisk = (int)Math.floor(sizeOfPreviousDisk / (long)auSize);
                for (int i = 1; i < disksCopy.size(); ++i) {
                    Disk currentDisk = (Disk)disksCopy.get(i);
                    long sizeOfCurrentDisk = currentDisk.getSize();
                    int auBlocksInCurrentDisk = (int)Math.floor(sizeOfCurrentDisk / (long)auSize);
                    if (auBlocksInPreviousDisk != auBlocksInCurrentDisk) {
                        errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.DIFFERENT_ASM_MEMBER_DISK_SIZE, new Object[]{String.valueOf(auSize)}));
                        break;
                    }
                    auBlocksInPreviousDisk = auBlocksInCurrentDisk;
                }
            }
        }
        return errorMessages;
    }

    private static Disk getDiskToBeRemoved(List<Disk> disks, String diskPath) {
        for (Disk disk : disks) {
            if (!disk.getPath().equals(diskPath)) continue;
            return disk;
        }
        return null;
    }

    public static StatusMessages<ValidationStatusMessage> validateGroupName(String groupName, String diskDiscoveryString) {
        StatusMessages errorMessages;
        block8: {
            errorMessages = new StatusMessages();
            if (groupName == null || groupName.trim().length() == 0) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_DISKGROUP_NAME_EXPECTED, new Object[0]));
            } else {
                Set<String> sql_reserved_words;
                String badChars = ASMInputValidationHelper.getBadCharsForDiskGroupName();
                String strFoundBadChar = GenericValidation.validateBadCharGetString(badChars, groupName);
                Pattern pattern = Pattern.compile("[a-zA-Z]");
                Matcher matcher = pattern.matcher(Character.toString(groupName.charAt(0)));
                if (strFoundBadChar != null && strFoundBadChar.length() > 0 || !matcher.matches()) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_ASM_DISKGROUP_NAME, new Object[0]));
                }
                if (groupName.length() > 30) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.DISKGROUP_NAME_SIZE_EXCEEDED, new Object[]{30}));
                }
                if ((sql_reserved_words = ASMInputValidationHelper.getReservedWordsForSQL()).contains(groupName)) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INCORRECT_ASM_DISKGROUP_NAME, new Object[0]));
                }
                try {
                    ASMUtility asmUtility = ASMUtility.getInstance();
                    List<String> discoveredGroups = asmUtility.findDiskgroupsFromHeader(diskDiscoveryString);
                    if (discoveredGroups == null || discoveredGroups.size() <= 0) break block8;
                    for (String diskgroup : discoveredGroups) {
                        if (!diskgroup.equalsIgnoreCase(groupName)) continue;
                        errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.NON_UNIQUE_ASM_DISKS, new Object[0]));
                        break;
                    }
                }
                catch (ASMUtilityException e) {
                    ExceptionManager.handle((Throwable)((Object)e));
                }
            }
        }
        return errorMessages.size() > 0 ? errorMessages : null;
    }

    private static String getBadCharsForDiskGroupName() {
        String badChars = null;
        badChars = PlatformInfo.getInstance().isWindows() ? "!@%^&*-()+=|/`~[{]};'\",<>?.$#" : "!@%^&*()+=-|`~[{]};:'\",<>?\\.$#";
        return badChars;
    }

    private static Set<String> getReservedWordsForSQL() {
        String[] sql_reserved_Words = CRSConstants.sql_reserved_words;
        TreeSet<String> sql_reserved_words_set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < sql_reserved_Words.length; ++i) {
            sql_reserved_words_set.add(sql_reserved_Words[i]);
        }
        return sql_reserved_words_set;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskDiscoveryString(String diskDiscoveryString) {
        StatusMessages errorMessages = new StatusMessages();
        if (!PlatformInfo.getInstance().isWindows()) {
            if (diskDiscoveryString == null || diskDiscoveryString.isEmpty()) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.EMPTY_DISK_DISCOVERY_STRING, new Object[0]));
            } else {
                String badChars = null;
                String[] pathList = diskDiscoveryString.split(",");
                badChars = "\\?$ ;";
                if (pathList.length > 0) {
                    for (String path : pathList) {
                        String strFoundBadChar = GenericValidation.validateBadCharGetString(badChars, path);
                        if (strFoundBadChar == null || strFoundBadChar.length() <= 0) continue;
                        errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_DISK_DISCOVERY_STRING, new Object[]{badChars}));
                        break;
                    }
                }
            }
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskPaths(List<String> diskPaths, Redundancy redundancy) {
        List<Disk> disks = new ArrayList<Disk>();
        try {
            ASMUtility asmUtility = ASMUtility.getInstance();
            disks = asmUtility.findDisks(diskPaths.toArray(new String[0]));
        }
        catch (ASMUtilityException aue) {
            ExceptionManager.handle((Throwable)((Object)aue));
        }
        return ASMInputValidationHelper.validateDiskPaths(diskPaths, redundancy, DiskGroupInitPurpose.USERDATA, 1, disks);
    }

    public static StatusMessages<ValidationStatusMessage> validateDiskPaths(List<String> diskPaths, Redundancy redundancy, DiskGroupInitPurpose purpose, int nodeCount, List<Disk> disks) {
        int minimumDiskCount;
        StatusMessages errorMessages = new StatusMessages();
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        int validDiskCount = 0;
        if (diskPaths == null || diskPaths.isEmpty()) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.EMPTY_ASM_DISKGROUP, new Object[0]));
        } else {
            String invalidDisks = null;
            if (disks == null) {
                invalidDisks = diskPaths.toString();
            } else {
                ArrayList<String> diskPathsCopy = new ArrayList<String>();
                if (platformInfo.isWindows()) {
                    for (String diskPath : diskPaths) {
                        diskPathsCopy.add(diskPath.toUpperCase());
                    }
                } else {
                    diskPathsCopy.addAll(diskPaths);
                }
                for (Disk disk : disks) {
                    diskPathsCopy.remove(platformInfo.isWindows() ? disk.getPath().toUpperCase() : disk.getPath());
                }
                invalidDisks = diskPathsCopy.isEmpty() ? null : diskPathsCopy.toString();
                validDiskCount = diskPaths.size() - diskPathsCopy.size();
            }
            if (invalidDisks != null) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_ASM_DISKS, new Object[]{invalidDisks}));
            }
        }
        if (validDiskCount > 0 && redundancy != null && validDiskCount < (minimumDiskCount = ASMInputValidationHelper.getMinimumDiskCount(purpose, redundancy))) {
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            String redundancyString = resource.getString(redundancy.name(), redundancy.name(), new Object[0]);
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_MEMBER_DISKS, new Object[]{redundancyString, String.valueOf(minimumDiskCount)}));
        }
        return errorMessages;
    }

    public static long getDiskSize(List<String> diskPaths) {
        long size = 0L;
        if (diskPaths != null && diskPaths.size() > 0) {
            try {
                ASMUtility asmUtility = ASMUtility.getInstance();
                List<Disk> disks = asmUtility.findDisks(diskPaths.toArray(new String[0]));
                if (disks != null && disks.size() > 0) {
                    for (Disk disk : disks) {
                        size += disk.getSize();
                    }
                }
            }
            catch (ASMUtilityException e) {
                ExceptionManager.handle((Throwable)((Object)e));
            }
        }
        return size;
    }

    public static StatusMessages<ValidationStatusMessage> checkASMFreeSpaceRequired(List<String> diskPaths, Redundancy redundancy, DiskGroupInitPurpose purpose, int nodeCount, int additionRequiredSpace, int AUSize, int ACFSMountSize) {
        StatusMessages errorMessages = new StatusMessages();
        long size = 0L;
        if (diskPaths != null) {
            long requiredSize = 0L;
            size = ASMInputValidationHelper.getDiskSize(diskPaths);
            if (purpose == DiskGroupInitPurpose.METADATA) {
                requiredSize = ASMInputValidationHelper.getRequiredSizeCRS(redundancy, diskPaths, nodeCount, AUSize);
                logger.log(Level.FINEST, "Required CRS Size=" + requiredSize);
                logger.log(Level.FINEST, "Addition size=" + additionRequiredSpace);
                long requiredSizeModAUSize = (requiredSize += (long)additionRequiredSpace) % (long)AUSize;
                if (requiredSizeModAUSize > 0L) {
                    requiredSize += (long)AUSize - requiredSizeModAUSize;
                }
                requiredSize += (long)(8 * AUSize);
                logger.log(Level.FINEST, "Required CRS Size after (multiple of AU + 8xAU)=" + (requiredSize += (long)(1024 * ACFSMountSize)));
                if (size < requiredSize) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKS, new Object[]{requiredSize}));
                }
            } else {
                long requiredSizeModAUSize = (requiredSize += (long)additionRequiredSpace) % (long)AUSize;
                if (requiredSizeModAUSize > 0L) {
                    requiredSize += (long)AUSize - requiredSizeModAUSize;
                }
                logger.log(Level.FINEST, "Required Size after (multiple of AU + 8xAU)=" + (requiredSize += (long)(8 * AUSize)));
                if (size < requiredSize) {
                    errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKS, new Object[]{requiredSize}));
                }
            }
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> checkASMFreeSpaceRequired(List<String> diskPaths, long requiredSize) {
        StatusMessages errorMessages = new StatusMessages();
        long size = 0L;
        logger.log(Level.FINEST, "Required CRS Size=" + requiredSize);
        if (diskPaths != null && (size = ASMInputValidationHelper.getDiskSize(diskPaths)) < requiredSize) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_ASM_DISKS, new Object[]{requiredSize}));
        }
        return errorMessages;
    }

    private static long getRequiredSizeCRS(Redundancy redundancy, List<String> diskPaths, int nodeCount, int AUSize) {
        int diskCount = diskPaths.size();
        int vdMult = 1;
        int ocrMult = 1;
        switch (redundancy) {
            case EXTERNAL: {
                vdMult = 1;
                ocrMult = 1;
                break;
            }
            case NORMAL: {
                vdMult = 3;
                ocrMult = 2;
                break;
            }
            case HIGH: {
                vdMult = 5;
                ocrMult = 3;
                break;
            }
            case FLEX: {
                vdMult = 3;
                ocrMult = 2;
                break;
            }
            case EXTENDED: {
                vdMult = 5;
                ocrMult = 3;
            }
        }
        long dataSize = 300 * vdMult + 500 * ocrMult;
        long metaSize = 15 * AUSize + 2 * AUSize * diskCount + 132 * nodeCount;
        return dataSize + metaSize;
    }

    public static StatusMessages<ValidationStatusMessage> validateHeader(List<Disk> disks) {
        StatusMessages errorMessages = new StatusMessages();
        if (disks != null && !disks.isEmpty()) {
            ArrayList<String> invalidDisksPath = new ArrayList<String>();
            block3: for (Disk disk : disks) {
                DiskHeaderStatus dhs = disk.getHeaderStatus();
                switch (dhs) {
                    case CANDIDATE: 
                    case PROVISIONED: {
                        continue block3;
                    }
                }
                invalidDisksPath.add(disk.getPath());
            }
            if (!invalidDisksPath.isEmpty()) {
                errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.ASM_DISKS_INVALID_HEADER_STATUS, new Object[]{((Object)invalidDisksPath).toString()}));
            }
        }
        return errorMessages;
    }

    public static StatusMessages<ValidationStatusMessage> validateRedundancy(Redundancy redundancy) {
        StatusMessages errorMessages = new StatusMessages();
        if (redundancy == null) {
            errorMessages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)ASMInputValidationErrorCode.INVALID_ASM_DISKGROUP_REDUNDANCY, new Object[0]));
        }
        return errorMessages;
    }

    public static long getFreeSpaceRequired(boolean isOradataOnASM, boolean isBackupRecoveryOnASM, boolean isContainerDB, Redundancy redundancy) {
        long freeSpace = 0L;
        if (isOradataOnASM) {
            freeSpace += StorageOptionsValidator.getOradataFreeSpaceRequired((boolean)isContainerDB);
        }
        if (isBackupRecoveryOnASM) {
            freeSpace += RecoveryBackupValidator.getRecoveryFreeSpaceRequired((boolean)isContainerDB);
        }
        return freeSpace;
    }

    public static void validateASMStorage() throws ValidationException {
        try {
            ASMUtility utility = ASMUtility.getInstance();
            ASMInstance asmInstance = utility.getASMInstance();
            if (asmInstance == null || !asmInstance.getOracleHome().exists() || asmInstance.getOracleHome().list() == null || asmInstance.getOracleHome().list().length == 0) {
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_NOT_COMPATIBLE, new Object[0]);
            }
        }
        catch (ASMUtilityException e) {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_NOT_COMPATIBLE, new Object[0]);
        }
    }

    public static void checkClientASMFreeSpaceRequired(DiskGroup diskGroup, CRSInstallSettings crsBean) throws ValidationException {
        int requiredSize = 800;
        long freeSpaceAvailable = diskGroup.getFreeSpace();
        logger.log(Level.FINEST, "The required space in MB is : " + requiredSize + " and the diskgroup " + diskGroup.getName() + " has " + freeSpaceAvailable + " space");
        if (freeSpaceAvailable < (long)requiredSize) {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_SPACE_IN_SERVER_CLUSTER_ASM_DISKGROUP, new Object[]{requiredSize});
        }
    }

    public static void validateFailureGroups(DiskGroupSettings diskGroupSettings, DiskGroupInitPurpose purpose, boolean isExtendedCluster) throws ValidationException {
        Map<String, String> diskFailureGroupMap = diskGroupSettings.getDiskFailureGroupMap();
        Redundancy redundancy = diskGroupSettings.getRedundancy();
        List<String> quorumFailureGroups = diskGroupSettings.getQuorumFailureGroupNames();
        if (!diskFailureGroupMap.isEmpty()) {
            ArrayList<String> diskPathsList = new ArrayList<String>(diskFailureGroupMap.keySet());
            ArrayList<String> failureGroupList = new ArrayList<String>(diskFailureGroupMap.values());
            logger.info("Disks and Failure Groups :" + diskFailureGroupMap);
            failureGroupList.removeAll(Arrays.asList(null, ""));
            boolean bFGSpecified = false;
            for (String fgname : failureGroupList) {
                if (fgname.trim().length() == 0) continue;
                bFGSpecified = true;
                break;
            }
            if (bFGSpecified) {
                int minimumUniqueFGs;
                logger.info("FG List :" + failureGroupList);
                if (diskPathsList.size() != failureGroupList.size()) {
                    logger.info("None or All disks need to have a FG assigned");
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_FAILURE_GROUPS_SPECIFIED, new Object[0]);
                }
                HashSet<String> uniqueFGSet = new HashSet<String>(failureGroupList);
                int noOfUniqueFGs = uniqueFGSet.size();
                if (noOfUniqueFGs < (minimumUniqueFGs = ASMInputValidationHelper.getMinimumDiskCount(purpose, redundancy)) && redundancy != Redundancy.EXTERNAL) {
                    Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
                    String redundancyString = resource.getString(redundancy.name(), redundancy.name(), new Object[0]);
                    logger.info(" " + redundancyString + " Redundancy should have atleast" + minimumUniqueFGs + " unique FGs assigned.");
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_FAILURE_GROUPS_FOR_SELECTED_REDUNDANCY, new Object[]{redundancyString, minimumUniqueFGs});
                }
                if (isExtendedCluster) {
                    List<FailureGroup> FGList = diskGroupSettings.getFailureGroupsList();
                    HashSet<Object> uniqueFGsExtendedSet = new HashSet<Object>();
                    for (FailureGroup FG : FGList) {
                        String fgName = FG.getFailureGroupName();
                        if (fgName == null || fgName.length() <= 0) continue;
                        uniqueFGsExtendedSet.add(fgName);
                    }
                    logger.info("FG List specified for Extended Cluster Sites :" + uniqueFGsExtendedSet);
                    int noOfuniqueFGsExtended = uniqueFGsExtendedSet.size();
                    if (noOfUniqueFGs != noOfuniqueFGsExtended) {
                        logger.info("Not all FGs specified with Extended Cluster sites have been selected/specified for Disk-FG Mapping");
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_ALL_SPECIFIED_FAILURE_GROUPS_NOT_SELECTED_FOR_DISKS, new Object[]{uniqueFGsExtendedSet, uniqueFGSet});
                    }
                }
                if (noOfUniqueFGs > 0) {
                    Iterator iter = uniqueFGSet.iterator();
                    HashMap<String, List<String>> reverseFGMap = new HashMap<String, List<String>>();
                    HashMap<String, List<String>> reverseQuorumFGMap = new HashMap<String, List<String>>();
                    while (iter.hasNext()) {
                        String fgname = (String)iter.next();
                        if (StringUtils.containsIgnoreCase(quorumFailureGroups, (String)fgname)) {
                            reverseQuorumFGMap.put(fgname, ASMInputValidationHelper.getDisksList(diskFailureGroupMap, fgname));
                            continue;
                        }
                        reverseFGMap.put(fgname, ASMInputValidationHelper.getDisksList(diskFailureGroupMap, fgname));
                    }
                    int tmp = 0;
                    if (reverseQuorumFGMap.size() > 0) {
                        for (Map.Entry entry : reverseQuorumFGMap.entrySet()) {
                            tmp = ((List)entry.getValue()).size();
                            String fgname = (String)entry.getKey();
                            if (tmp >= 1) continue;
                            logger.info("At least 1 disk need to be assigned to a QUORUM failure group");
                            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_DISKS_IN_QUORUM_FAILURE_GROUPS, new Object[]{fgname});
                        }
                    }
                    if (reverseFGMap.size() > 0) {
                        List referenceList = (List)reverseFGMap.entrySet().iterator().next().getValue();
                        int n = referenceList.size();
                        for (Map.Entry entry : reverseFGMap.entrySet()) {
                            tmp = ((List)entry.getValue()).size();
                            if (n == tmp) continue;
                            logger.info("No. of disks in each FG should be equal");
                            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_DISKS_IN_FAILURE_GROUPS, new Object[0]);
                        }
                    }
                    String eligibleList = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                    for (String fgName : uniqueFGSet) {
                        if (GenericValidation.validateStartCharacter(eligibleList, fgName)) continue;
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INVALID_FAILURE_GROUP_NAME, new Object[]{fgName});
                    }
                }
            } else if (isExtendedCluster) {
                logger.info(" For Extended Cluster, no Failure groups are specified.");
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_NO_FAILURE_GROUPS_SELECTED_FOR_DISKS, new Object[0]);
            }
        }
    }

    private static List<String> getDisksList(Map<String, String> hm, String fgname) {
        ArrayList<String> disksList = new ArrayList<String>();
        for (String diskPath : hm.keySet()) {
            if (hm.get(diskPath) == null || !hm.get(diskPath).equals(fgname)) continue;
            disksList.add(diskPath);
        }
        return disksList;
    }

    public static void validateGIMRDGdiskPaths(ASMSettings asmSettings) throws ValidationException {
        List<String> primaryDGDisksList = asmSettings.getDiskGroupSettings().getDiskPaths();
        List<String> gimrDGDisksList = asmSettings.getGIMRDiskGroupSettings().getDiskPaths();
        for (String diskPath : gimrDGDisksList) {
            if (!primaryDGDisksList.contains(diskPath)) continue;
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.SELECTED_ASM_DISKS_OVERLAP, new Object[]{diskPath});
        }
    }

    public static void validateASMAndGIMRDiskGroupName(ASMSettings asmSettings) throws ValidationException {
        String asmDiskGroupName = asmSettings.getDiskGroupSettings().getGroupName();
        String gimrDiskGroupName = asmSettings.getGIMRDiskGroupSettings().getGroupName();
        if (asmDiskGroupName != null && gimrDiskGroupName != null && asmDiskGroupName.equalsIgnoreCase(gimrDiskGroupName)) {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_GIMR_DISK_GROUP_NAME_MATCH, new Object[]{gimrDiskGroupName, asmDiskGroupName});
        }
    }

    public static void validateSites(DiskGroupSettings diskGroupSettings, List<ClusterNode> nodelist, ASMInstallConstants.DiskgroupType dgType) throws ValidationException {
        boolean extendedRedundancyOptionEnabled = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.crs.enableExtendedRedundancy"));
        List<FailureGroup> failureGroups = diskGroupSettings.getFailureGroupsList();
        if (failureGroups != null && !failureGroups.isEmpty()) {
            Object referenceList;
            HashSet allSites = new HashSet();
            HashSet<String> dataSites = new HashSet<String>();
            HashSet<String> quorumSites = new HashSet<String>();
            for (FailureGroup failureGroup : failureGroups) {
                String siteName = failureGroup.getSite();
                if (siteName == null || siteName.length() <= 0) continue;
                if (failureGroup.isQuorum()) {
                    quorumSites.add(siteName);
                } else {
                    dataSites.add(siteName);
                }
                if (!StringUtils.containsIgnoreCase(quorumSites, (String)siteName) || !StringUtils.containsIgnoreCase(dataSites, (String)siteName)) continue;
                quorumSites.remove(siteName);
            }
            allSites.addAll(dataSites);
            allSites.addAll(quorumSites);
            logger.info("Data Sites: " + dataSites);
            logger.info("Quorum Sites: " + quorumSites);
            Redundancy redundancy = diskGroupSettings.getRedundancy();
            if (allSites.isEmpty()) {
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_NO_SITES_PROVIDED, new Object[0]);
            }
            if (dgType == ASMInstallConstants.DiskgroupType.PRIMARY_DG || dgType == ASMInstallConstants.DiskgroupType.GIMR_DG && redundancy == Redundancy.EXTENDED) {
                if (quorumSites.isEmpty()) {
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_NO_QUORUM_SITE_PROVIDED, new Object[0]);
                }
                if (dataSites.size() != 2) {
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_INSUFFICIENT_NUMBER_OF_DATA_SITES, new Object[]{2});
                }
            }
            if ((dgType != ASMInstallConstants.DiskgroupType.GIMR_DG || redundancy != Redundancy.NORMAL) && allSites.size() != 3) {
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_INSUFFICIENT_NUMBER_OF_SITES, new Object[]{3});
            }
            if (dataSites.size() < 2) {
                throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_INSUFFICIENT_NUMBER_OF_DATA_SITES, new Object[]{2});
            }
            HashMap quorumSitesFGMap = new HashMap();
            if (!quorumSites.isEmpty()) {
                for (String siteName : quorumSites) {
                    ArrayList<String> quorumFGList = new ArrayList<String>();
                    for (FailureGroup failureGroup : failureGroups) {
                        String site = failureGroup.getSite();
                        if (site == null || !site.equals(siteName)) continue;
                        String string = failureGroup.getFailureGroupName();
                        if (!failureGroup.isQuorum()) continue;
                        quorumFGList.add(string);
                    }
                    quorumSitesFGMap.put(siteName, quorumFGList);
                }
            }
            HashMap dataSitesFGMap = new HashMap();
            if (!dataSites.isEmpty()) {
                for (String string : dataSites) {
                    ArrayList<String> dataFGList = new ArrayList<String>();
                    for (FailureGroup fg : failureGroups) {
                        String string2 = fg.getSite();
                        if (string2 == null || !string2.equals(string)) continue;
                        String fgName = fg.getFailureGroupName();
                        dataFGList.add(fgName);
                    }
                    dataSitesFGMap.put(string, dataFGList);
                }
            }
            logger.info("Data Sites and Failure Groups: " + dataSitesFGMap);
            logger.info("Quorum Sites and Failure Groups: " + quorumSitesFGMap);
            if (extendedRedundancyOptionEnabled && redundancy == Redundancy.EXTENDED) {
                int n;
                int size = 0;
                for (Map.Entry entry : quorumSitesFGMap.entrySet()) {
                    size = ((List)entry.getValue()).size();
                    if (size >= 1) continue;
                    logger.info("Atleast 1 FG is to be specified in a Quorum site");
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_FAILURE_GROUPS_IN_SITES_QUORUM, new Object[]{1});
                }
                referenceList = (List)dataSitesFGMap.entrySet().iterator().next().getValue();
                int n2 = referenceList.size();
                if (n2 < 3) {
                    n = 3;
                }
                boolean bl = false;
                for (Map.Entry entry : dataSitesFGMap.entrySet()) {
                    int n3 = ((List)entry.getValue()).size();
                    if (n == n3) continue;
                    logger.info("No. of FGs in each Site should be equal and min.3");
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_FAILURE_GROUPS_IN_SITES, new Object[]{3});
                }
            }
            if (dgType == ASMInstallConstants.DiskgroupType.PRIMARY_DG) {
                if (redundancy == Redundancy.NORMAL || redundancy == Redundancy.FLEX) {
                    int n;
                    int size = 0;
                    for (Map.Entry entry : quorumSitesFGMap.entrySet()) {
                        size = ((List)entry.getValue()).size();
                        if (size >= 1) continue;
                        logger.info("Atleast 1 FG is to be specified in a Quorum site");
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_FAILURE_GROUPS_IN_SITES_QUORUM, new Object[]{1});
                    }
                    referenceList = (List)dataSitesFGMap.entrySet().iterator().next().getValue();
                    int n4 = referenceList.size();
                    if (n4 != 1) {
                        n = 1;
                    }
                    boolean bl = false;
                    for (Map.Entry entry : dataSitesFGMap.entrySet()) {
                        int n5 = ((List)entry.getValue()).size();
                        if (n == n5) continue;
                        logger.info("No. of FGs in each Site should be equal and min.1");
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_FAILURE_GROUPS_IN_SITES, new Object[]{1});
                    }
                }
                if (nodelist != null) {
                    HashMap sitesNodesMap = new HashMap();
                    for (String string : dataSites) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (ClusterNode clusterNode : nodelist) {
                            if (!string.equalsIgnoreCase(clusterNode.getSite())) continue;
                            arrayList.add(clusterNode.getName());
                        }
                        sitesNodesMap.put(string, arrayList);
                    }
                    for (String string : dataSites) {
                        if (((List)sitesNodesMap.get(string)).size() >= 1) continue;
                        throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_NODES_PER_SITE, new Object[]{string});
                    }
                }
            } else if (dgType == ASMInstallConstants.DiskgroupType.GIMR_DG && redundancy != Redundancy.EXTENDED) {
                int n;
                HashMap allSitesFGMap = new HashMap();
                allSitesFGMap.putAll(dataSitesFGMap);
                allSitesFGMap.putAll(quorumSitesFGMap);
                referenceList = (List)allSitesFGMap.entrySet().iterator().next().getValue();
                int n6 = referenceList.size();
                if (n6 != 1) {
                    n = 1;
                }
                boolean bl = false;
                for (Map.Entry entry : allSitesFGMap.entrySet()) {
                    int n7 = ((List)entry.getValue()).size();
                    if (n == n7) continue;
                    logger.info("No. of FGs in each Site should be equal and min.1");
                    throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.INSUFFICIENT_NUMBER_OF_FAILURE_GROUPS_IN_SITES, new Object[]{1});
                }
            }
        } else {
            throw new ValidationException((ErrorCode)ASMInputValidationErrorCode.ASM_EXTENDED_CLUSTER_NO_SITES_PROVIDED, new Object[0]);
        }
    }

    public static long calculateFreeSpaceRequiredForASMOnNAS(boolean isPrimaryDG, boolean isGIMRDGConfigured, CRSInstallSettings crsBean) {
        long freeSpaceRequired = 0L;
        int gimrSize = MgmtDBValidationHelper.calculateMgmtSpaceRequired((CRSInstallSettings)crsBean);
        int ocrBackupSize = CRSInfo.getInstance().getBackupDGSize();
        if (isPrimaryDG) {
            int nodeCount = crsBean.getClusterConfig().getPublicNodeNames(false).size();
            int AUSize = 4;
            long dataSize = 800L;
            long metaSize = 15 * AUSize + 2 * AUSize + 132 * nodeCount;
            long ocrSize = dataSize + metaSize;
            freeSpaceRequired += ocrSize;
            if (!isGIMRDGConfigured) {
                freeSpaceRequired += (long)(gimrSize + ocrBackupSize);
            }
        } else {
            freeSpaceRequired += (long)(gimrSize + ocrBackupSize);
        }
        return freeSpaceRequired;
    }

    public static int getRedundancyMultiple(DiskGroupInitPurpose purpose, Redundancy redundancy) {
        int redundancyMultiple = 0;
        if (redundancy != null) {
            if (purpose == DiskGroupInitPurpose.METADATA) {
                switch (redundancy) {
                    case EXTERNAL: {
                        redundancyMultiple = 1;
                        break;
                    }
                    case NORMAL: {
                        redundancyMultiple = 3;
                        break;
                    }
                    case HIGH: {
                        redundancyMultiple = 5;
                        break;
                    }
                    case FLEX: {
                        redundancyMultiple = 3;
                        break;
                    }
                    case EXTENDED: {
                        redundancyMultiple = 5;
                    }
                }
            } else {
                switch (redundancy) {
                    case EXTERNAL: {
                        redundancyMultiple = 1;
                        break;
                    }
                    case NORMAL: {
                        redundancyMultiple = 2;
                        break;
                    }
                    case HIGH: {
                        redundancyMultiple = 3;
                        break;
                    }
                    case FLEX: {
                        redundancyMultiple = 2;
                        break;
                    }
                    case EXTENDED: {
                        redundancyMultiple = 4;
                    }
                }
            }
        }
        return redundancyMultiple;
    }
}

