/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicSessionContextBuilder;
import oracle.sysman.oii.oiic.OiicSessionProvider;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oip.oipc.oipcc.OipccPrereqSessionContext;
import oracle.sysman.oip.oipc.oipck.OipckIBuilder;

public class OipccPrereqContextBuilder
extends OiicSessionContextBuilder
implements OipckIBuilder {
    private OipccPrereqSessionContext m_oPrereqContext;
    private String m_sContextFile;
    private static final String PREREQ_PACKAGE_JAR_NAME = "OraPrereq.jar";
    private static final String PREREQ_CONTEXT_FILE_NAME = "prereq_context.xml";

    private OipccPrereqContextBuilder(String sContextFile) {
        if (sContextFile != null) {
            this.m_sContextFile = sContextFile;
        }
    }

    private OipccPrereqContextBuilder() {
        this.m_sContextFile = null;
    }

    public static OipccPrereqContextBuilder getBuilder(String sFileName) {
        OipccPrereqContextBuilder oContextBuilder = null;
        oContextBuilder = sFileName != null ? new OipccPrereqContextBuilder(sFileName) : new OipccPrereqContextBuilder();
        return oContextBuilder;
    }

    public static OipccPrereqContextBuilder getBuilder() {
        return new OipccPrereqContextBuilder();
    }

    public OipccPrereqSessionContext buildContext(String sInputFile) throws OiixException {
        try {
            FileInputStream oInputStream = new FileInputStream(sInputFile);
            return this.buildContext(oInputStream);
        }
        catch (IOException ioe) {
            throw new OiixException((Throwable)ioe);
        }
    }

    public OipccPrereqSessionContext buildContext(InputStream oInputStream) throws OiixException, IOException {
        OipccPrereqSessionContext oContext = new OipccPrereqSessionContext();
        Map oVariablesMap = this.buildVariablesMap(oContext, oInputStream);
        oContext.setVariablesMap(oVariablesMap);
        return oContext;
    }

    protected String getSessionVarsJarLoc() {
        String sSessionVarsJarLoc = System.getProperty("oracle.installer.oui_loc");
        sSessionVarsJarLoc = OiixPathOps.concatPath((String)sSessionVarsJarLoc.trim(), (String)"/jlib/OraPrereq.jar");
        sSessionVarsJarLoc = OiixPathOps.getNativeForm((String)sSessionVarsJarLoc);
        return sSessionVarsJarLoc;
    }

    @Override
    public Object build() {
        OiicISession oSession;
        OiisVariableOwner oContext = null;
        if (!this.isContextFileSpecified() && (oSession = OiicSessionProvider.getCurrentSession()) != null) {
            oContext = oSession.getContext();
        }
        if (oContext == null) {
            oContext = this.createContext();
        }
        return oContext;
    }

    private OiisVariableOwner createContext() {
        OipccPrereqSessionContext oContext = null;
        try {
            if (this.isContextFileSpecified()) {
                oContext = this.buildContext(this.m_sContextFile);
            } else {
                String sJarLoc = this.getSessionVarsJarLoc();
                String sSessionVarsFileName = PREREQ_CONTEXT_FILE_NAME;
                OiixJarClassLoader oPrereqJarLoader = OiixJarClassLoader.createLoader((String)sJarLoc);
                InputStream oInputStream = oPrereqJarLoader.getLocalResourceAsStream(PREREQ_CONTEXT_FILE_NAME);
                oContext = this.buildContext(oInputStream);
            }
        }
        catch (OiixException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return oContext;
    }

    private boolean isContextFileSpecified() {
        return this.m_sContextFile != null;
    }
}

