/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.opatchsdk.FAExecutionContext;
import oracle.opatch.opatchsdk.OPatchAutomationAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchInterviewAction;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchSDKStringConstants;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.patchverbs.AutomationElement;

public class OPatchFAAutomationAction
extends OPatchAutomationAction
implements Cloneable {
    protected static String execLog = "";
    protected static String configLog = "";
    protected AutomationElement ael = null;
    private String commonHome = "";
    private boolean isBound = false;
    private boolean isOK = true;
    private boolean isDryRun = false;
    private String oracleHomePath = "";
    private String logFile = "";
    private OPatchPatch wrapperPatch = null;
    private FAExecutionContext faContext = null;
    private OPatchStepOperation failedPrereqStep = null;
    private OPatchStepOperation failedClosingStep = null;
    protected OPatchInterviewAction[] interviewElements = new OPatchInterviewAction[0];
    private OPatchFAOperation prereqOperation = null;
    private String execLogFile = "";
    private String configLogFile = "";
    private boolean displayLogFile = true;

    protected OPatchFAAutomationAction() {
    }

    protected OPatchFAAutomationAction(AutomationElement auto_el) {
        this.ael = auto_el;
    }

    protected void setCommonComponentsHome(String commonHome) {
        this.commonHome = commonHome;
    }

    protected String getCommonComponentsHome() {
        return this.commonHome;
    }

    protected String getOracleHome() {
        return this.oracleHomePath;
    }

    protected void setExecLogFile(String logFile) {
        this.execLogFile = logFile;
    }

    protected void setConfigLogFile(String logFile) {
        this.configLogFile = logFile;
    }

    protected void setPrereqOperation(OPatchFAOperation operation) {
        this.prereqOperation = operation;
    }

    protected OPatchFAOperation getLastSetPrereqOperation() {
        return this.prereqOperation;
    }

    protected void setDisplayLogFile(boolean display) {
        this.displayLogFile = display;
    }

    protected boolean getDisplayLogFile() {
        return this.displayLogFile;
    }

    public void setInterviewList(OPatchInterviewAction[] interviewElements) {
        this.interviewElements = interviewElements;
    }

    public OPatchInterviewAction[] getInterviewElements() {
        return this.interviewElements;
    }

    protected Properties getInterviewProperties() {
        Properties p = new Properties();
        for (int i = 0; i < this.interviewElements.length; ++i) {
            String key = this.interviewElements[i].getKey();
            String value = this.interviewElements[i].getDefaultValue();
            p.setProperty(key, value);
        }
        return p;
    }

    public void setInterviewValue(OPatchInterviewAction interAction, String value) throws OPatchException {
        for (int i = 0; i < this.interviewElements.length; ++i) {
            if (interAction != this.interviewElements[i]) continue;
            this.interviewElements[i].setDefaultValue(value);
            return;
        }
        throw new OPatchException("The input interview object is not part of the interview elements set in the artifact list by OPatch.");
    }

    public String getExecLogFile() {
        return this.execLogFile;
    }

    public String getConfigLogFile() {
        return this.configLogFile;
    }

    public String getLastOperatedLogFile() {
        return this.logFile;
    }

    protected OPatchPatch getWrapperPatch() {
        return this.wrapperPatch;
    }

    protected void setOracleHomePath(String oh) {
        if (oh == null) {
            oh = "";
        }
        this.oracleHomePath = oh;
    }

    protected void setFailedPrereqStep(OPatchStepOperation step) {
        this.failedPrereqStep = step;
    }

    protected void setFailedClosingStep(OPatchStepOperation step) {
        this.failedClosingStep = step;
    }

    public OPatchStepOperation getFailedPrereqStep() {
        return this.failedPrereqStep;
    }

    public OPatchStepOperation getFailedClosingStep() {
        return this.failedClosingStep;
    }

    protected boolean isDryRun() {
        return this.isDryRun;
    }

    protected void setDryRun(boolean in) {
        this.isDryRun = in;
    }

    public boolean isOK() {
        return this.isOK;
    }

    protected void setOK(boolean in) {
        this.isOK = in;
    }

    public void setLogFile(String logFile) {
        if (logFile == null) {
            logFile = "";
        }
        this.logFile = logFile;
    }

    protected void setWrapperPatch(OPatchPatch wrapperPatch) {
        this.wrapperPatch = wrapperPatch;
    }

    protected void setOperatingFAContext(FAExecutionContext faContext) {
        this.faContext = faContext;
    }

    protected FAExecutionContext getOperatingFAContext() {
        return this.faContext;
    }

    protected Map constructMap() {
        OPatchPatch patch = null;
        if (this instanceof OPatchDeployAction) {
            OPatchDeployAction oda = (OPatchDeployAction)this;
            if (oda.inputPatchLoc != null && !oda.inputPatchLoc.equals("")) {
                try {
                    patch = new OPatchPatch(oda.inputPatchLoc);
                }
                catch (OPatchException oPatchException) {}
            } else {
                patch = this.getWrapperPatch();
            }
        } else {
            patch = this.getWrapperPatch();
        }
        return this.constructMap(patch);
    }

    private Map constructMap(OPatchPatch patch) {
        File f;
        HashMap<String, String> env = new HashMap<String, String>();
        String tempLoc = FMWClientFactory.getTempLocation((String)this.oracleHomePath, (String)this.wrapperPatch.getCookedPatchID());
        if (tempLoc != null && !(f = new File(tempLoc)).exists()) {
            f.mkdirs();
        }
        env.put(OPatchSDKStringConstants.TEMP_WORK_LOCATION, tempLoc);
        env.put(OPatchSDKStringConstants.PATCH_ID, this.wrapperPatch.getPatchLanguageId());
        env.put("OPatch.ORACLE_HOME", this.getOracleHome());
        String patchOH = patch.getOracleHome();
        if (patchOH == null || patchOH.equals("")) {
            env.put("OPatch.RELATIVE_DEPLOY_PATH", patch.getPatchLocation() + File.separator + "files");
        } else if (this.isDryRun()) {
            env.put("OPatch.RELATIVE_DEPLOY_PATH", patch.getPatchLocation() + File.separator + "files");
        } else {
            env.put("OPatch.RELATIVE_DEPLOY_PATH", this.getOracleHome());
        }
        return env;
    }

    public boolean isArtifactBoundtoConfigInstance() {
        return this.isBound;
    }

    protected void setBoundToConfigInstance(boolean isBound) {
        this.isBound = isBound;
    }

    public boolean isPreAction() {
        return this.ael.isPreAction();
    }

    public String toString() {
        return "";
    }

    public Object clone() {
        OPatchFAAutomationAction faAction = (OPatchFAAutomationAction)super.clone();
        faAction.oracleHomePath = OPatchUtils.norm(this.oracleHomePath);
        faAction.commonHome = OPatchUtils.norm(this.commonHome);
        faAction.wrapperPatch = this.wrapperPatch;
        faAction.isDryRun = this.isDryRun;
        faAction.faContext = this.faContext;
        OPatchInterviewAction[] myElements = new OPatchInterviewAction[this.interviewElements.length];
        for (int i = 0; i < myElements.length; ++i) {
            myElements[i] = (OPatchInterviewAction)this.interviewElements[i].clone();
        }
        faAction.setInterviewList(myElements);
        return faAction;
    }
}

