/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchAnalysisReport
implements IAnalysisReport {
    private List<OPatchPatch> napplyPatches = new ArrayList<OPatchPatch>();
    private List<OPatchPatch> nrollbackPatches = new ArrayList<OPatchPatch>();
    private HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> prereqResults = new HashMap();
    private OPatchNApplyOptions options = null;
    private OPatchNRollbackOptions nrollbackOptions = null;
    private OPatchPatch[] patches;
    private OPatchTarget target;
    private OPatchPatch[] installedPatches;

    public OPatchAnalysisReport() {
    }

    public OPatchAnalysisReport(OPatchPatch[] patches, OPatchTarget target) throws OPatchException {
        this.patches = patches;
        this.target = target;
        this.installedPatches = target.getContext().getInstalledActivePatches();
    }

    public OPatchAnalysisReport(OPatchPatch[] patches, OPatchTarget target, OPatchNApplyOptions options) throws OPatchException {
        this.patches = patches;
        this.target = target;
        this.options = options;
        this.installedPatches = target.getContext().getInstalledActivePatches();
    }

    public OPatchAnalysisReport(OPatchPatch[] patches, OPatchTarget target, OPatchNRollbackOptions options) throws OPatchException {
        this.patches = patches;
        this.target = target;
        this.nrollbackOptions = options;
        this.installedPatches = target.getContext().getInstalledActivePatches();
    }

    public void addOPatchPatchPrereqResult(OPatchPatchPrereq prereq, PrereqResult result) {
        OPatchTarget.StatusCheck sc;
        if (this.prereqResults.containsKey(prereq)) {
            sc = this.prereqResults.get(prereq);
            StringBuffer buff = new StringBuffer(sc.getResult());
            buff.append("\n");
            buff.append(result.toString());
            sc.setResult(buff.toString());
            buff = null;
        } else {
            sc = new OPatchTarget.StatusCheck(0, result.toString());
            this.prereqResults.put(prereq, sc);
        }
        if (result.getResult() == null) {
            sc.setStatusCode(2);
        } else {
            this.setOPatchPatchPrereqResult(prereq, result.getResult());
        }
    }

    public void setOPatchPatchPrereqResult(OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status, String message) {
        if (this.prereqResults.containsKey(prereq)) {
            this.setOPatchPatchPrereqResult(prereq, status);
            OPatchTarget.StatusCheck sc = this.prereqResults.get(prereq);
            StringBuffer buff = new StringBuffer(sc.getResult());
            buff.append("\n");
            buff.append(message);
            sc.setResult(buff.toString());
            buff = null;
        }
    }

    public void setOPatchPatchPrereqResult(OPatchPatchPrereq prereq, PrereqResult.ExecuteStatus status) {
        if (this.prereqResults.containsKey(prereq)) {
            if (status == PrereqResult.ExecuteStatus.FAILED) {
                this.prereqResults.get(prereq).setStatusCode(1);
            } else if (status == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                this.prereqResults.get(prereq).setStatusCode(2);
            } else {
                this.prereqResults.get(prereq).setStatusCode(0);
            }
        }
    }

    public void addNApplyPatch(String patchId) {
        for (OPatchPatch patch : this.patches) {
            if (!patch.getPatchId().equals(patchId)) continue;
            this.napplyPatches.add(patch);
            break;
        }
    }

    public void addNRollbackPatch(String patchId, boolean autoRollback) {
        if (!autoRollback) {
            for (OPatchPatch patch : this.patches) {
                if (!patchId.equals(patch.getPatchId())) continue;
                this.nrollbackPatches.add(patch);
                break;
            }
        } else {
            for (OPatchPatch patch : this.installedPatches) {
                if (!patchId.equals(patch.getPatchId())) continue;
                this.nrollbackPatches.add(patch);
                break;
            }
        }
    }

    @Override
    public List<OPatchPatch> getNApplyPatches() {
        return new ArrayList<OPatchPatch>(this.napplyPatches);
    }

    @Override
    public List<OPatchPatch> getNRollbackPatches() {
        return new ArrayList<OPatchPatch>(this.nrollbackPatches);
    }

    @Override
    public HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> getPrereqResults() {
        return new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>(this.prereqResults);
    }

    @Override
    public OPatchNApplyOptions getOptions() {
        return this.options;
    }

    @Override
    public OPatchNRollbackOptions getNRollbackOptions() {
        return this.nrollbackOptions;
    }
}

