/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class GetNodeVipMapData
implements OiilQuery {
    private static final String NoPerm = "permission denied";
    private static final String NoHost = "unknown host";
    private static final String NoConn = "Connection refused";
    private static final String OpenFailMsg = "NODENOTAVAIL";
    private static final String PermFailMsg = "ACCESSDENIED";
    private static final String ConnRefused = "CONNREFUSED";
    private static final String EnvErrMsg = "ENVIRNMTERR";
    private static final String SuccMsg = "SUCCESS";

    public Object performQuery(Vector inputs) throws OiilQueryException {
        try {
            String crsHome = (String)this.retItem(inputs, "oracleHome");
            Version v = new Version();
            ClusterInfo clusterObj = new ClusterInfo(crsHome, v);
            HashMap mapObj = clusterObj.getNodeVIPMap();
            if (mapObj.isEmpty()) {
                String[] output = new String[]{"ERROR", null};
                return output;
            }
            Set s = mapObj.keySet();
            Iterator iteratorObj = s.iterator();
            String[] result = new String[s.size() + 1];
            result[0] = SuccMsg;
            int idx = 1;
            while (iteratorObj.hasNext()) {
                String curKey = (String)iteratorObj.next();
                String curVal = (String)mapObj.get(curKey);
                result[idx++] = curKey + "=" + curVal;
            }
            return result;
        }
        catch (ClusterInfoException ciexcep) {
            String errMsg = ciexcep.getMessage();
            String[] RetMsg = new String[]{"ERROR", errMsg};
            return RetMsg;
        }
    }

    Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public String ProcErrMsg(String MsgToProcess) {
        String RetErrMsg = EnvErrMsg;
        StringTokenizer st = new StringTokenizer(MsgToProcess, "\n");
        String val = st.nextToken();
        if (st.hasMoreTokens()) {
            val = st.nextToken();
        }
        StringTokenizer st1 = new StringTokenizer(val, ":");
        String val1 = st1.nextToken();
        if (st1.hasMoreTokens()) {
            val1 = st1.nextToken();
        }
        StringTokenizer st2 = new StringTokenizer(val1, ".");
        String val2 = st2.nextToken();
        if (st2.hasMoreTokens()) {
            val2 = st2.nextToken();
        }
        System.out.println("val2 is " + val2);
        if (val2.trim().equalsIgnoreCase(NoPerm)) {
            RetErrMsg = PermFailMsg;
        }
        if (val1.trim().equalsIgnoreCase(NoHost)) {
            RetErrMsg = OpenFailMsg;
        }
        if (val1.trim().equalsIgnoreCase(NoConn)) {
            RetErrMsg = ConnRefused;
        }
        return RetErrMsg;
    }

    public static void main(String[] args) {
        GetNodeVipMapData obj = new GetNodeVipMapData();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        String[] retval = null;
        try {
            inputs.addElement(new OiilActionInputElement("oracleHome", (Object)args[0]));
            retval = (String[])obj.performQuery(inputs);
            if (retval != null) {
                for (int i = 0; i < retval.length; ++i) {
                    System.out.println("retval[" + i + "]:" + retval[i]);
                }
            } else {
                System.out.println("Return Value is null: " + retval);
            }
        }
        catch (OiilQueryException oiilQueryException) {
            // empty catch block
        }
    }
}

