/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.GroupConfig;
import oracle.ias.cache.group.GroupException;
import oracle.ias.cache.group.HttpHandler;
import oracle.ias.cache.group.HttpPacket;
import oracle.ias.cache.group.Packet;

public class StreamHandler {
    Socket m_s;
    int m_mode = GroupCommunication.getMode();
    ObjectInputStream m_ois;
    ObjectOutputStream m_oos;
    BufferedOutputStream m_bos;
    BufferedInputStream m_bis;
    HttpHandler m_http_handler;

    public StreamHandler(Socket socket) throws GroupException, IOException {
        if (socket == null) {
            throw new GroupException(GroupCommunication.EXP_GRP_SOCKETINITFAIL);
        }
        this.m_s = socket;
        if (this.m_mode == 1) {
            this.m_oos = new ObjectOutputStream(this.m_s.getOutputStream());
            this.m_ois = new ObjectInputStream(this.m_s.getInputStream());
        } else if (this.m_mode == 2) {
            GroupConfig groupConfig = GroupCommunication.getGroupConfig();
            int n = groupConfig.getReceiveBufferSize();
            int n2 = groupConfig.getSendBufferSize();
            this.m_bis = new BufferedInputStream(this.m_s.getInputStream(), n);
            this.m_bos = new BufferedOutputStream(this.m_s.getOutputStream(), n2);
            this.m_http_handler = new HttpHandler(this.m_bis, this.m_bos);
        }
    }

    public void write(Packet packet) throws IOException, GroupException {
        if (this.m_mode == 1) {
            this.m_oos.writeObject(packet);
            this.m_oos.flush();
        } else if (this.m_mode == 2) {
            HttpPacket httpPacket = new HttpPacket(packet);
            this.m_http_handler.write(httpPacket);
        }
    }

    public Packet read() throws IOException, GroupException {
        Packet packet = null;
        try {
            if (this.m_mode == 1) {
                packet = (Packet)this.m_ois.readObject();
            } else if (this.m_mode == 2) {
                packet = this.m_http_handler.read();
            }
        }
        catch (Exception exception) {
            throw new GroupException(exception.getMessage(), exception);
        }
        return packet;
    }

    public void reset() throws IOException {
        if (this.m_mode == 1) {
            this.m_oos.reset();
        } else if (this.m_mode == 2) {
            // empty if block
        }
    }

    public void close() throws IOException {
        if (this.m_mode == 1) {
            this.m_oos.close();
            this.m_ois.close();
        } else {
            this.m_bos.close();
            this.m_bis.close();
        }
    }
}

