/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ias.cache.group.GroupCommunication;

public class Address
implements Serializable,
Comparable {
    static final long serialVersionUID = 7259713205257648185L;
    InetAddress ip;
    int port;
    int position;
    long uid;
    long timeStamp;
    Serializable tag;
    boolean isOriginal_;
    String cacheName;
    static long g_uid = 0L;
    static byte[] guid_lock = new byte[0];
    transient int code;
    String fullyQualifiedHostname;
    String userDefinedID;
    int priorityOrder;

    public Address(InetAddress inetAddress, int n, boolean bl, int n2) {
        this.timeStamp = 0L;
        this.tag = null;
        this.cacheName = "";
        this.code = 0;
        this.userDefinedID = null;
        this.priorityOrder = 0;
        this.ip = inetAddress;
        this.port = n;
        this.position = -1;
        this.isOriginal_ = bl;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
        this.priorityOrder = n2;
    }

    public Address(InetAddress inetAddress, int n, int n2) {
        this.timeStamp = 0L;
        this.tag = null;
        this.cacheName = "";
        this.code = 0;
        this.userDefinedID = null;
        this.priorityOrder = 0;
        this.ip = inetAddress;
        this.port = n;
        this.position = n2;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
    }

    public Address(InetAddress inetAddress, int n) {
        this.timeStamp = 0L;
        this.tag = null;
        this.cacheName = "";
        this.code = 0;
        this.userDefinedID = null;
        this.priorityOrder = 0;
        this.ip = inetAddress;
        this.port = n;
        this.position = -1;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
    }

    public Address(InetAddress inetAddress, int n, Serializable serializable) {
        this.timeStamp = 0L;
        this.tag = null;
        this.cacheName = "";
        this.code = 0;
        this.userDefinedID = null;
        this.priorityOrder = 0;
        this.ip = inetAddress;
        this.port = n;
        this.tag = serializable;
        this.position = -1;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
    }

    public Address(int n) {
        block2: {
            this.timeStamp = 0L;
            this.tag = null;
            this.cacheName = "";
            this.code = 0;
            this.userDefinedID = null;
            this.priorityOrder = 0;
            try {
                this.ip = InetAddress.getLocalHost();
                this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(this.ip.getHostAddress());
                this.port = n;
                this.position = -1;
            }
            catch (UnknownHostException unknownHostException) {
                if (!GroupCommunication.shouldLog(0)) break block2;
                GroupCommunication.log("Can't get local host ", unknownHostException);
            }
        }
    }

    void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    void setUid(long l) {
        this.uid = l;
    }

    public long getUid() {
        return this.uid;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public Serializable getTag() {
        return this.tag;
    }

    public boolean isOriginal() {
        return this.isOriginal_;
    }

    public int getPort() {
        return this.port;
    }

    public void setCacheName(String string) {
        this.cacheName = string;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setGUid(long l) {
        byte[] byArray = guid_lock;
        synchronized (guid_lock) {
            g_uid = l;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getGUid() {
        byte[] byArray = guid_lock;
        synchronized (guid_lock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return g_uid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incGUid() {
        byte[] byArray = guid_lock;
        synchronized (guid_lock) {
            ++g_uid;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.ip.getHostAddress());
        stringBuffer.append(":");
        stringBuffer.append(this.port);
        stringBuffer.append(", pos=");
        stringBuffer.append(this.position);
        if (!bl) {
            stringBuffer.append(", uid=");
            stringBuffer.append(this.uid);
            if (this.tag != null) {
                stringBuffer.append(", tag=");
                stringBuffer.append(this.tag.hashCode());
            }
            if (this.isOriginal_) {
                stringBuffer.append(", orig");
            }
            if (this.cacheName != null) {
                stringBuffer.append(", name=");
                stringBuffer.append(this.cacheName);
            }
            stringBuffer.append(", pri=");
            stringBuffer.append(this.priorityOrder);
        }
        if (this.userDefinedID != null && !this.userDefinedID.equals("")) {
            stringBuffer.append(", def=");
            stringBuffer.append(this.userDefinedID);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getString() {
        return new String(this.getFullyQualifiedHostName() + ":" + this.port);
    }

    public String getIPString() {
        return new String(this.ip.getHostAddress());
    }

    public String getHostName() {
        return new String(this.ip.getHostName());
    }

    public String getFullyQualifiedHostName() {
        return this.fullyQualifiedHostname;
    }

    private static String getFullyQualifiedHostName(String string) {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string2;
    }

    public void setUserDefinedId(String string) {
        this.userDefinedID = string;
    }

    public String getUserDefinedId() {
        return this.userDefinedID;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Address address = (Address)object;
        return this.ip.equals(address.ip) && address.port == this.port;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (!this.equals(object)) {
            Address address = (Address)object;
            String string = address.getIPString();
            int n2 = address.port;
            n = this.getIPString().compareTo(string);
            if (n == 0) {
                n = this.port - n2;
            }
        }
        return n;
    }

    public int hashCode() {
        if (this.code == 0) {
            this.code = this.ip.hashCode() + this.port;
        }
        return this.code;
    }
}

