/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Vector;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.Task;
import oracle.ias.cache.ThreadPool;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.MessageQueue;
import oracle.ias.cache.group.Packet;

class TaskQ
implements MessageQueue {
    private static TaskQ tq = null;
    private static long seqId = 0L;
    Task head = null;
    Task tail = null;
    int count = 0;
    Vector dMap;
    boolean dViewChange = false;
    boolean iamworking = true;
    private byte[] t_lock = new byte[0];

    private TaskQ() {
        this.dMap = new Vector();
    }

    static TaskQ getInstance() {
        if (tq == null) {
            tq = new TaskQ();
        }
        return tq;
    }

    synchronized Task getTask() {
        Task task = null;
        while (this.iamworking) {
            int n = ThreadPool.getAcceptPriority();
            do {
                if ((task = task == null ? this.head : task.next) != null && this.isDeliverable(task, n)) {
                    this.startDeliver(task);
                    this.dequeue(task);
                    break;
                }
                if (!CacheInternal.shouldLog(15) || task == null) continue;
                CacheInternal.logger.log("[Mem]  Task ID: " + task.id + " is not " + "deliverable. Priority=" + n);
            } while (task != null);
            if (task != null) {
                return task;
            }
            this.waitForWork(0);
            if (!CacheInternal.logger.shouldLog(15)) continue;
            long l = 0L;
            if (this.head != null) {
                l = this.head.id;
            }
            CacheInternal.logger.log("[CMg] " + Thread.currentThread().getName() + " is notified by TASK ID: " + l);
        }
        return null;
    }

    synchronized Task dequeue() {
        if (this.head == null) {
            return null;
        }
        Task task = this.head;
        this.head = this.head.next;
        if (this.head != null) {
            this.head.prev = null;
        }
        --this.count;
        return task;
    }

    synchronized void dequeue(Task task) {
        if (task == null) {
            return;
        }
        if (task.prev == null) {
            this.dequeue();
        } else if (task.next == null) {
            this.tail = task.prev;
            this.tail.next = null;
            --this.count;
        } else {
            task.prev.next = task.next;
            task.next.prev = task.prev;
            --this.count;
        }
    }

    synchronized void putTask(Task task) {
        this.enqueue(task);
    }

    public synchronized void enqueue(Object object) {
        Task task = null;
        if (object instanceof GroupMessage) {
            task = new Task(41, object);
        } else if (object instanceof Task) {
            task = (Task)object;
        }
        if (this.head == null) {
            this.head = task;
            this.head.prev = null;
        } else {
            this.tail.next = task;
            task.prev = this.tail;
        }
        task.next = null;
        this.tail = task;
        ++this.count;
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log("[CMg] Enqueued: " + task);
        }
        this.wakeup();
    }

    synchronized void waitForWork(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void wakeup() {
        this.notify();
    }

    synchronized void wakeupAll() {
        this.notifyAll();
    }

    synchronized void flush() {
        this.head = null;
        this.tail = null;
        this.count = 0;
    }

    synchronized void startDeliver(Task task) {
        if (task.taskType != 41) {
            return;
        }
        GroupMessage groupMessage = (GroupMessage)task.info;
        if (groupMessage.type == 1) {
            this.dViewChange = true;
        } else if (groupMessage.type == 0) {
            Packet packet = (Packet)groupMessage.messageInfo;
            this.dMap.addElement(packet.getSourceAddress());
        }
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log("[CMg] " + Thread.currentThread().getName() + " DeliverId=" + ++seqId + " start delivery " + " TASK: " + task + ", dMap: " + this.dMap);
        }
    }

    synchronized void endDeliver(Task task) {
        if (task.taskType != 41) {
            return;
        }
        GroupMessage groupMessage = (GroupMessage)task.info;
        if (groupMessage.type == 1) {
            this.dViewChange = false;
        } else if (groupMessage.type == 0) {
            Packet packet = (Packet)groupMessage.messageInfo;
            this.dMap.removeElement(packet.getSourceAddress());
        }
        if (this.count > 0) {
            this.wakeup();
        }
        if (CacheInternal.logger.shouldLog(15)) {
            CacheInternal.logger.log("[CMg] " + Thread.currentThread().getName() + " DeliverId=" + seqId + " End delivery " + " TASK: " + task + ", dMap:" + this.dMap);
        }
    }

    synchronized boolean isDeliverable(Task task, int n) {
        if (task.taskType != 41) {
            if (task.taskType == 16 || task.taskType == 1 || task.taskType == 8 || task.taskType == 12 || task.taskType == 10) {
                return true;
            }
            return n == 0;
        }
        GroupMessage groupMessage = (GroupMessage)task.info;
        if (groupMessage.type == 2) {
            return true;
        }
        if (groupMessage.type == 1 && this.dViewChange) {
            return false;
        }
        if (groupMessage.type == 1) {
            return true;
        }
        Packet packet = (Packet)groupMessage.messageInfo;
        if (!this.isResponse(packet) && (this.dMap.contains(packet.getSourceAddress()) || n > 1)) {
            if (CacheInternal.logger.shouldLog(15)) {
                CacheInternal.logger.log("[CMg] " + Thread.currentThread().getName() + " not deliverable, priority=" + n + ", TASK: " + task + ", dMap=" + this.dMap);
            }
            return false;
        }
        return true;
    }

    private boolean isResponse(Packet packet) {
        if (packet.getMessage() instanceof Task) {
            Task task = (Task)packet.getMessage();
            if (task.taskType == 8 || task.taskType == 1 || task.taskType == 10 || task.taskType == 7 || task.taskType == 22 || task.taskType == 21 || task.taskType == 12) {
                return true;
            }
        }
        return false;
    }

    synchronized void rest() {
        this.iamworking = false;
        tq = null;
    }
}

