/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

class RegionCount {
    long objid;
    int count;
    int max;
    long maxSize;
    long size;

    RegionCount(long l, int n, long l2) {
        this.objid = l;
        this.count = 0;
        this.size = 0L;
        this.max = n;
        this.maxSize = l2;
    }

    synchronized boolean incNcheck(long l) {
        ++this.count;
        this.size += l;
        return this.max > 0 && this.count > this.max || this.maxSize > 0L && this.size > this.maxSize;
    }

    synchronized boolean check() {
        return this.max > 0 && this.count > this.max || this.maxSize > 0L && this.size > this.maxSize;
    }

    synchronized void dec(long l) {
        --this.count;
        this.size -= l;
    }

    long getId() {
        return this.objid;
    }

    int getCount() {
        return this.count;
    }

    int getMax() {
        return this.max;
    }

    long getMaxSize() {
        return this.maxSize;
    }

    long getsize() {
        return this.size;
    }

    synchronized void resetMax(int n) {
        this.max = n;
    }

    synchronized void resetSize(long l) {
        this.maxSize = l;
    }
}

