/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;

class ObjectExaminer {
    private static PrintStream out_ = null;
    private static int INC_INDENT = 3;
    private static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final int[] PRIMITIVE_SIZE = new int[]{1, 1, 2, 2, 4, 8, 4, 8};
    private static final int PRIMITIVE_BOOLEAN_TYPE = 0;
    private static final int PRIMITIVE_BYTE_TYPE = 1;
    private static final int PRIMITIVE_CHAR_TYPE = 2;
    private static final int PRIMITIVE_SHORT_TYPE = 3;
    private static final int PRIMITIVE_INT_TYPE = 4;
    private static final int PRIMITIVE_LONG_TYPE = 5;
    private static final int PRIMITIVE_FLOAT_TYPE = 6;
    private static final int PRIMITIVE_DOUBLE_TYPE = 7;
    private long size_;
    private HashSet objRefMap_;

    public ObjectExaminer() {
        this.resetShareObjectRefs();
    }

    public HashSet getShareObjectRefs() {
        return this.objRefMap_;
    }

    public void resetShareObjectRefs() {
        this.objRefMap_ = new HashSet(100, 0.5f);
    }

    public long getSize(Object object, boolean bl) throws IllegalAccessException {
        return ObjectExaminer.walkObjectMap(object, 0, this.objRefMap_, bl);
    }

    public static long getEntireObjectSize(Object object) {
        return ObjectExaminer.getEntireObjectSize(object, false);
    }

    public static long getEntireObjectSize(Object object, boolean bl) {
        long l = 0L;
        if (object == null) {
            return l;
        }
        try {
            ObjectExaminer objectExaminer = new ObjectExaminer();
            l = objectExaminer.getSize(object, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace(out_);
        }
        return l;
    }

    public static void setVerboseOutput(PrintStream printStream) {
        out_ = printStream;
    }

    public static void main(String[] stringArray) {
        System.out.println("Usage: java ObjectExaminer [verbose]");
        try {
            if (stringArray.length > 0) {
                ObjectExaminer.setVerboseOutput(System.out);
            }
            long l = System.currentTimeMillis();
            long l2 = ObjectExaminer.getEntireObjectSize(System.getProperties(), true);
            long l3 = System.currentTimeMillis();
            System.out.println("Size: " + l2 + " bytes. Elasped: " + (l3 - l) + " msec.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static long walkObjectMap(Object object, int n, HashSet hashSet, boolean bl) throws IllegalAccessException {
        long l = 0L;
        long l2 = 0L;
        Class<?> clazz = object.getClass();
        if (out_ != null) {
            out_.println(ObjectExaminer.indent(n) + clazz + " at 0x" + Integer.toHexString(object.hashCode()).toUpperCase());
        }
        Field[] fieldArray = ObjectExaminer.getAllFields(clazz);
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object2;
            Class<?> clazz2;
            Field field = fieldArray[i];
            field.setAccessible(true);
            if (bl && Modifier.isStatic(field.getModifiers())) continue;
            if (out_ != null) {
                out_.print(ObjectExaminer.indent(n + INC_INDENT) + field);
            }
            if (field.getType().isPrimitive()) {
                l2 = ObjectExaminer.getPrimitiveLength(field.getType().toString());
                if (out_ != null) {
                    out_.println(" (" + l2 + ")");
                }
                l += l2;
                continue;
            }
            if (field.getType().isArray()) {
                Integer n2;
                clazz2 = field.getType().getComponentType();
                if (clazz2.isPrimitive()) {
                    l2 = ObjectExaminer.getPrimitiveArrayLength(clazz2, field, object);
                    if (out_ != null) {
                        out_.println(" (" + l2 + ")");
                    }
                    l += l2;
                    continue;
                }
                if (out_ != null) {
                    out_.println("");
                }
                if (!hashSet.add(n2 = new Integer((object2 = field.get(object)).hashCode()))) continue;
                int n3 = Array.getLength(object2);
                for (int j = 0; j < n3; ++j) {
                    Object object3 = Array.get(object2, j);
                    if (object3 == null) continue;
                    l += ObjectExaminer.walkObjectMap(object3, n + INC_INDENT, hashSet, bl);
                }
                continue;
            }
            if (out_ != null) {
                out_.println("");
            }
            if ((clazz2 = field.get(object)) == null || clazz2 == object || !hashSet.add(object2 = new Integer(clazz2.hashCode()))) continue;
            l += ObjectExaminer.walkObjectMap(clazz2, n + INC_INDENT, hashSet, bl);
        }
        return l;
    }

    private static Field[] getAllFields(Class clazz) {
        Field[] fieldArray = null;
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Field[] fieldArray2 = ObjectExaminer.getAllFields(clazz2);
            Field[] fieldArray3 = clazz.getDeclaredFields();
            fieldArray = new Field[fieldArray3.length + fieldArray2.length];
            System.arraycopy(fieldArray3, 0, fieldArray, 0, fieldArray3.length);
            System.arraycopy(fieldArray2, 0, fieldArray, fieldArray3.length, fieldArray2.length);
        } else {
            fieldArray = clazz.getDeclaredFields();
        }
        return fieldArray;
    }

    private static int getPrimitiveLength(String string) {
        for (int i = 0; i < PRIMITIVE_NAMES.length; ++i) {
            if (!string.equals(PRIMITIVE_NAMES[i])) continue;
            return PRIMITIVE_SIZE[i];
        }
        return 0;
    }

    private static long getPrimitiveArrayLength(Class clazz, Field field, Object object) throws IllegalAccessException {
        long l = 0L;
        for (int i = 0; i < PRIMITIVE_NAMES.length; ++i) {
            if (!clazz.toString().equals(PRIMITIVE_NAMES[i])) continue;
            switch (i) {
                case 0: {
                    l = ((boolean[])field.get(object)).length * PRIMITIVE_SIZE[0];
                    break;
                }
                case 1: {
                    l = ((byte[])field.get(object)).length * PRIMITIVE_SIZE[1];
                    break;
                }
                case 2: {
                    l = ((char[])field.get(object)).length * PRIMITIVE_SIZE[2];
                    break;
                }
                case 7: {
                    l = ((double[])field.get(object)).length * PRIMITIVE_SIZE[7];
                    break;
                }
                case 6: {
                    l = ((float[])field.get(object)).length * PRIMITIVE_SIZE[6];
                    break;
                }
                case 4: {
                    l = ((int[])field.get(object)).length * PRIMITIVE_SIZE[4];
                    break;
                }
                case 5: {
                    l = ((long[])field.get(object)).length * PRIMITIVE_SIZE[5];
                    break;
                }
                case 3: {
                    l = ((short[])field.get(object)).length * PRIMITIVE_SIZE[3];
                }
            }
            break;
        }
        return l;
    }

    private static String indent(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }
}

