/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.Net;

class FileLock {
    static final String LOCK_NAME = "_lock_";
    private static final int WAIT_TIME = 50;
    private static final int DEFAULT_RETRY = 1000;
    private static final int READ_RETRY = 100;
    private static final char SEPARATOR = '_';
    private boolean locked = false;
    private File lock;
    private File owner;
    private boolean local;

    FileLock(String string, boolean bl) {
        this.local = bl;
        this.lock = new File(string, LOCK_NAME);
    }

    static void cleanLock(String string) {
        boolean bl;
        long l = -1L;
        long l2 = -1L;
        int n = 0;
        String[] stringArray = null;
        File file = new File(string, LOCK_NAME);
        if (CacheInternal.shouldLog(15)) {
            CacheInternal.logger.log("[Dsk] FileLock cleaning " + file);
        }
        while ((bl = file.exists()) && n < 100) {
            try {
                stringArray = file.list();
                if (stringArray != null && stringArray.length != 0) {
                    break;
                }
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        if (n != 100) {
            int n2 = stringArray[0].indexOf(95);
            l = Long.parseLong(stringArray[0].substring(0, n2));
            if (Net.isAlive(l, l2 = Long.parseLong(stringArray[0].substring(n2 + 1, stringArray[0].length())))) {
                if (CacheInternal.logger.shouldLog(15)) {
                    CacheInternal.logger.log("[Dsk] FileLock found live process " + l + " holds " + file);
                }
            } else {
                if (CacheInternal.logger.shouldLog(7)) {
                    CacheInternal.logger.log("[Dsk] FileLock found dead " + file + " uid=" + l);
                }
                FileLock.deleteLock(file, new File(file, stringArray[0]));
            }
        } else {
            if (CacheInternal.logger.shouldLog(7)) {
                CacheInternal.logger.log("[Dsk] FileLock found an uncompleted dead " + file);
            }
            FileLock.deleteLock(file, null);
        }
    }

    private boolean createLockFile(String string) {
        boolean bl;
        block8: {
            try {
                this.owner = new File(this.lock, String.valueOf(Net.getUid()) + '_' + String.valueOf(Net.getTimeStamp()));
                bl = this.lock.mkdir();
                if (!bl) break block8;
                try {
                    bl = this.owner.mkdir();
                    if (!bl && CacheInternal.logger.shouldLog(7)) {
                        CacheInternal.logger.log("[Dsk] FileLock fail to create " + this.owner);
                    }
                }
                catch (Exception exception) {
                    if (CacheInternal.logger.shouldLog(7)) {
                        CacheInternal.logger.log("[Dsk] FileLock creating " + this.owner, exception);
                    }
                    bl = false;
                }
                if (!bl && !this.lock.delete() && CacheInternal.logger.shouldLog(7)) {
                    CacheInternal.logger.log("[Dsk] FileLock fail to delete failed " + this.lock);
                }
                return bl;
            }
            catch (Exception exception) {
                if (CacheInternal.logger.shouldLog(7)) {
                    CacheInternal.logger.log("[Dsk] FileLock creating " + this.lock, exception);
                }
                bl = false;
            }
        }
        return bl;
    }

    boolean getLock(String string, int n) {
        if (this.local) {
            return true;
        }
        if (n <= 0) {
            n = 1000;
        }
        int n2 = 0;
        while (!this.locked) {
            if (CacheInternal.shouldLog(15)) {
                CacheInternal.logger.log("[Dsk] FileLock getting " + string + " " + this.lock + " retry=" + n2);
            }
            this.locked = this.createLockFile(string);
            if (this.locked) break;
            if (++n2 == n) {
                return false;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (CacheInternal.shouldLog(15)) {
            CacheInternal.logger.log("[Dsk] FileLock got lock " + this.lock);
        }
        return true;
    }

    void releaseLock() {
        if (this.local) {
            return;
        }
        FileLock.deleteLock(this.lock, this.owner);
        this.locked = false;
        if (CacheInternal.shouldLog(15)) {
            CacheInternal.logger.log("[Dsk] FileLock released " + this.lock);
        }
    }

    private static void deleteLock(File file, File file2) {
        if (file2 != null && file2.exists() && !file2.delete() && CacheInternal.logger.shouldLog(7)) {
            CacheInternal.logger.log("[Dsk] FileLock can not delete owner " + file2);
        }
        if (!file.delete() && CacheInternal.logger.shouldLog(7)) {
            CacheInternal.logger.log("[Dsk] FileLock can not delete lock " + file);
        }
    }

    boolean exists() {
        return this.lock.exists();
    }
}

