/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import oracle.ias.cache.CacheInternal;

public class CacheObjectInputStream
extends ObjectInputStream {
    String m_key;

    public CacheObjectInputStream(String string) throws IOException {
        this.m_key = string;
    }

    public CacheObjectInputStream(InputStream inputStream, String string) throws IOException {
        super(inputStream);
        this.m_key = string;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (this.m_key == null) {
            return super.resolveClass(objectStreamClass);
        }
        ClassLoader classLoader = CacheInternal.getUserClassLoader(this.m_key);
        if (classLoader == null) {
            return super.resolveClass(objectStreamClass);
        }
        String string = objectStreamClass.getName();
        return classLoader.loadClass(string);
    }
}

