/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Random;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;

class CacheHandleQ {
    private static final int ALLOC_SIZE = 2;
    private static final int QCOUNT = 8;
    private static CacheHandle[] freelist;
    private static Object[] lock;
    private static Random getRand;
    private static Random putRand;

    CacheHandleQ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheHandle getHandle() {
        CacheHandle cacheHandle;
        int n = CacheHandleQ.getQue(getRand);
        Object object = lock[n];
        synchronized (object) {
            if (freelist[n] == null) {
                CacheHandleQ.growCacheHandleList(n);
            }
            cacheHandle = freelist[n];
            CacheHandleQ.freelist[n] = cacheHandle.next;
        }
        cacheHandle.free = false;
        return cacheHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseHandle(CacheHandle cacheHandle) throws CacheException {
        if (cacheHandle.free) {
            return;
        }
        cacheHandle.releaseHandle();
        cacheHandle.free = true;
        int n = CacheHandleQ.getQue(putRand);
        Object object = lock[n];
        synchronized (object) {
            cacheHandle.next = freelist[n];
            CacheHandleQ.freelist[n] = cacheHandle;
        }
    }

    private static void growCacheHandleList(int n) {
        CacheHandle cacheHandle = new CacheHandle();
        cacheHandle.free = true;
        CacheHandleQ.freelist[n] = cacheHandle;
        for (int i = 1; i < 2; ++i) {
            CacheHandle cacheHandle2 = new CacheHandle();
            cacheHandle2.free = true;
            cacheHandle.next = cacheHandle2;
            cacheHandle = cacheHandle2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        for (int i = 0; i < 8; ++i) {
            Object object = lock[i];
            synchronized (object) {
                CacheHandle cacheHandle = freelist[i];
                while (cacheHandle != null) {
                    CacheHandle cacheHandle2 = cacheHandle.next;
                    cacheHandle.next = null;
                    cacheHandle = cacheHandle2;
                }
                CacheHandleQ.freelist[i] = null;
                continue;
            }
        }
    }

    private static int getQue(Random random) {
        int n = (random.nextInt() & Integer.MAX_VALUE) % 8;
        return n;
    }

    public static synchronized void dump() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            n = 0;
            CacheHandle cacheHandle = freelist[i];
            while (cacheHandle != null) {
                ++n;
                cacheHandle = cacheHandle.next;
            }
            System.out.println("Queue " + i + " size = " + n);
        }
    }

    static {
        long l = System.currentTimeMillis();
        getRand = new Random(l);
        putRand = new Random(l);
        freelist = new CacheHandle[8];
        lock = new Object[8];
        for (int i = 0; i < 8; ++i) {
            CacheHandleQ.freelist[i] = null;
            CacheHandleQ.lock[i] = new Object();
        }
    }
}

