/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Version;
import oracle.install.driver.util.engine.SQLEngine;
import oracle.install.driver.util.engine.SQLErrorHandler;
import oracle.install.driver.util.engine.SQLFatalErrorException;

public class SQLPlusEngine
extends SQLEngine {
    private static final String DEFAULT_SQL_PROMPT = "SQL>";
    private static final int DEFAULT_SQL_PROMPT_LEN = "SQL>".length();
    private static final String BEGIN_OF_QUERY_RESULT_MARKER = "BEGIN_OF_RESULT";
    private static final String[] BEGIN_OF_QUERY_RESULT_SETTINGS = new String[]{"set sqlprompt 'BEGIN_OF_RESULT'", "show sqlprompt", "set sqlprompt 'SQL>'"};
    private static final Logger logger = Logger.getLogger(SQLPlusEngine.class.getName());
    private static final String[] SILENT_DEFAULT_SETTINGS = new String[]{"set heading off", "set timing off", "set pagesize 0", "set feedback off", "set linesize 4000", "set sqlprompt 'SQL_ENGINE_END_OF_SQL'", "show sqlprompt", "set sqlprompt 'SQL>'"};
    private static final String[] NON_SILENT_DEFAULT_SETTINGS = new String[]{"set heading on", "set timing off", "set pagesize 0", "set feedback on", "set linesize 4000", "set sqlprompt 'SQL_ENGINE_END_OF_SQL'", "show sqlprompt", "set sqlprompt 'SQL>'"};
    private static boolean m_silentMode = true;

    public SQLPlusEngine(String oracleHome, String connStrOrSID) throws IOException {
        this(oracleHome, connStrOrSID, connStrOrSID != null && connStrOrSID.contains(":"));
    }

    public SQLPlusEngine(String oracleHome, String host, String port, String service) throws IOException {
        this(oracleHome, host + ":" + port + "/" + service, true);
    }

    public SQLPlusEngine(String oracleHome, String sidOrconnStr, boolean remoteConnect) throws IOException {
        super(oracleHome, sidOrconnStr, remoteConnect);
    }

    @Override
    protected String[] getBeginQuerySettings() {
        return BEGIN_OF_QUERY_RESULT_SETTINGS;
    }

    @Override
    protected String[] getDefaultSettings() {
        if (m_silentMode) {
            return SILENT_DEFAULT_SETTINGS;
        }
        return NON_SILENT_DEFAULT_SETTINGS;
    }

    @Override
    protected Vector removeHeaderFeedback(Vector stripHeader) {
        while (this.inQuery() && stripHeader.size() > 0) {
            String line = (String)stripHeader.elementAt(0);
            stripHeader.removeElementAt(0);
            if (line.length() <= 0 || line.indexOf(BEGIN_OF_QUERY_RESULT_MARKER) <= 0) continue;
            break;
        }
        return stripHeader;
    }

    @Override
    protected String[] getCmmdParams() {
        String[] cmmdLocation = null;
        boolean isVersionGreaterThan112 = false;
        Version oracleHomeVersion = Version.parseVersion("12.2.0.1.0");
        boolean bl = isVersionGreaterThan112 = oracleHomeVersion.compareTo(Version.parseVersion("11.2.0.0.0")) >= 0;
        if (m_silentMode) {
            logger.log(Level.INFO, "m_home: " + this.getOracleHome() + " version:" + oracleHomeVersion);
            logger.log(Level.INFO, "version > 112 " + isVersionGreaterThan112);
            cmmdLocation = isVersionGreaterThan112 ? new String[]{this.getSQLPlus(), "-S", "-N", "/NOLOG"} : new String[]{this.getSQLPlus(), "-S", "/NOLOG"};
        } else {
            cmmdLocation = isVersionGreaterThan112 ? new String[]{this.getSQLPlus(), "-N", "/NOLOG"} : new String[]{this.getSQLPlus(), "/NOLOG"};
        }
        return cmmdLocation;
    }

    public String getSQLPlus() {
        if (PlatformInfo.getInstance().isWindows()) {
            return this.getOracleHome() + File.separator + "bin" + File.separator + "sqlplus.exe";
        }
        return this.getOracleHome() + File.separator + "bin" + File.separator + "sqlplus";
    }

    @Override
    protected String removePrompt(String parseString, String stripPrompt) {
        int lastOccurence;
        if (stripPrompt != null && (lastOccurence = parseString.lastIndexOf(stripPrompt)) != -1) {
            int begin;
            if (stripPrompt.endsWith(DEFAULT_SQL_PROMPT) && (begin = parseString.indexOf(stripPrompt)) == 0) {
                String newParseString = parseString.substring(begin + stripPrompt.length()).trim();
                return newParseString;
            }
            String newParseString = parseString.substring(lastOccurence + stripPrompt.length()).trim();
            return newParseString;
        }
        return parseString;
    }

    @Override
    protected String catchPrompt(String parseString) {
        if (parseString.indexOf(DEFAULT_SQL_PROMPT) != -1) {
            return DEFAULT_SQL_PROMPT;
        }
        return null;
    }

    @Override
    public void executeScript(String script) throws SQLFatalErrorException, InterruptedException {
        try {
            String spool;
            if (System.getProperty("DETAILED_SCRIPT_LOG") != null) {
                spool = this.getSpoolFileName();
                logger.log(Level.INFO, "Spool before script run = " + spool);
                this.done();
                if (spool != null) {
                    this.setSpool(spool, true);
                }
                m_silentMode = false;
            }
            super.executeScript(script);
            if (System.getProperty("DETAILED_SCRIPT_LOG") != null) {
                spool = this.getSpoolFileName();
                logger.log(Level.INFO, "Spool after script run = " + spool);
                this.done();
                if (spool != null) {
                    this.setSpool(spool, true);
                }
                m_silentMode = true;
                this.setDefaultEngineSettings();
            }
        }
        catch (IOException e) {
            throw new SQLFatalErrorException(e.getMessage());
        }
        finally {
            m_silentMode = true;
        }
    }

    @Override
    public void executeScript(String script, String spoolFile) throws SQLFatalErrorException, IOException, InterruptedException {
        this.setSpool(spoolFile);
        this.executeScript(script);
    }

    @Override
    public String[][] getResultFromQuery(String sql, int numcols) throws SQLFatalErrorException, InterruptedException {
        this.executeQuery("set colsep '|||'");
        this.executeQuery("set wrap OFF");
        this.executeQuery("set linesize 4000");
        String[] result = this.executeQuery(sql);
        String[][] rowsColResult = new String[result.length][];
        for (int i = 0; i < result.length; ++i) {
            int j;
            StringTokenizer entries = new StringTokenizer(result[i], "|||");
            int nColumns = entries.countTokens();
            rowsColResult[i] = new String[numcols];
            for (j = 0; j < nColumns; ++j) {
                rowsColResult[i][j] = entries.nextToken().trim();
            }
            if (nColumns >= numcols) continue;
            for (j = nColumns; j < numcols; ++j) {
                rowsColResult[i][j] = "";
            }
        }
        Vector<String[]> rvec = new Vector<String[]>();
        for (int i = 0; i < result.length; ++i) {
            if (rowsColResult[i] == null) continue;
            rvec.addElement(rowsColResult[i]);
        }
        String[][] ret = new String[rvec.size()][];
        rvec.copyInto((Object[])ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SQLPlusEngine engine = null;
        if (args.length < 2) {
            System.out.println("Args: <oracle home> <sid> <new oracle home>");
            System.exit(0);
        }
        try {
            int i;
            engine = new SQLPlusEngine(args[1], args[0]);
            engine.setSQLErrorHandler(new SQLErrorHandler(){

                @Override
                public boolean handleError(String errorStr) {
                    String[] err = new String[]{errorStr};
                    return this.handleError(err);
                }

                @Override
                public boolean handleError(String[] errorStr) {
                    System.out.println("Ignoring following errors:");
                    for (int i = 0; i < errorStr.length; ++i) {
                        System.out.println(errorStr[i]);
                    }
                    System.out.println();
                    return true;
                }

                public Hashtable getIgnorableErrors() {
                    return null;
                }

                public Hashtable getFatalErrors() {
                    return null;
                }

                @Override
                public void handleSubStep(boolean skippedStatus) {
                }

                @Override
                public void handleSubStep(String progressItem, String Status2) {
                }
            });
            engine.setSpool("sql.log", true);
            engine.connect("sys", "oracle", "sysdba");
            engine.done();
            String DB_RUNNING = "RUNNING";
            boolean bDBRunning = false;
            try {
                String[] value = engine.executeQuery("select  'DB_RUNNING' from dual;");
                if (value != null && value.length > 0 && value[0].equals("DB_RUNNING")) {
                    bDBRunning = true;
                }
            }
            catch (SQLFatalErrorException value) {
                // empty catch block
            }
            if (!bDBRunning) {
                engine.startup();
            }
            engine.setEchoOn();
            if (args.length > 2) {
                engine.setSpool("rdbmsup.log");
                ((SQLEngine)engine).executeScript(args[2] + File.separator + "rdbms" + File.separator + "admin" + File.separator + "rdbmsup.sql");
                engine.setSpool("sql.log", true);
            }
            String[] res = engine.executeQuery("select name from v$datafile;");
            for (i = 0; i < res.length; ++i) {
                System.out.println("Datafile [" + i + "] = " + res[i]);
            }
            res = engine.executeQuery("select * from v$version");
            for (i = 0; i < res.length; ++i) {
                System.out.println("Version [" + i + "] = " + res[i]);
            }
            res = engine.executeQuery("select name from v$controlfile;");
            for (i = 0; i < res.length; ++i) {
                System.out.println("Controlfile [" + i + "] = " + res[i]);
            }
            res = engine.executeQuery("select value from v$parameter where name='control_files1';");
            for (i = 0; i < res.length; ++i) {
                System.out.println("control_files [" + i + "] = " + res[i]);
            }
            engine.spoolOff();
        }
        catch (Exception e) {
            System.out.println("ERROR :" + e);
            e.printStackTrace();
        }
        finally {
            try {
                System.out.println("Executing done");
                if (engine != null) {
                    engine.done();
                }
            }
            catch (Exception e) {
                System.out.println("ERROR in finally:" + e);
                e.printStackTrace();
            }
            System.exit(0);
        }
    }
}

