/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.util.engine.SQLErrorHandler;
import oracle.install.driver.util.engine.SQLFatalErrorException;
import oracle.install.driver.util.engine.SQLInterface;
import oracle.install.driver.util.engine.SQLPlusEngine;

public abstract class SQLEngine
implements Runnable,
SQLInterface {
    private SQLErrorHandler m_errHdlr;
    private Process m_sqlEngineProcess;
    private BufferedReader m_sqlEngineReader;
    private InputStream m_errStream;
    private Thread m_readerThread;
    private ErrorStreamReader m_errorReader;
    private PrintWriter m_sqlEngineWriter;
    private PrintWriter m_sqlLogWriter;
    private String m_home;
    private String m_sid;
    private String m_twoTask;
    private String m_scriptsWorkDirectory;
    private boolean m_bPasswordSpool = false;
    private static final String USER_PSWD_SEPARATOR = "/";
    private static final String PASSWORD_MASK = "******";
    private static final String ALTER = "ALTER";
    private static final int ALTER_LEN = "ALTER".length();
    private static final String CONNECT = "CONNECT";
    private static final int CONNECT_LEN = "CONNECT".length();
    private static final String CREATE_PDB = "CREATE PLUGGABLE DATABASE";
    private static final int CREATE_PDB_LEN = "CREATE PLUGGABLE DATABASE".length();
    private static final String CREATE_USER = "CREATE USER";
    private static final int CREATE_USER_LEN = "CREATE USER".length();
    private static final String SCRIPT_EXECUTION_SYMBOL = "@";
    private final int FLUSH_LINE_THRESHOLD = 20;
    private boolean m_bInConnect = false;
    private boolean m_bDoneCalled = false;
    private boolean m_bReaderDone = false;
    private boolean m_bInterrupted = false;
    private volatile boolean m_bReaderStarted = false;
    private volatile boolean m_bReadDone = false;
    private volatile boolean m_bWriteDone = false;
    private boolean m_bFatalErrorOccured = false;
    private String m_sErrorString = "";
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String fileSeparator = System.getProperty("file.separator");
    private Vector m_lastQueryResult = new Vector(0);
    private boolean m_bExecQuery = false;
    private String m_bsubStepSkippedStatus = "";
    private String m_bsubStepComponent = "";
    protected String m_userName;
    protected String m_password;
    protected String m_role;
    protected boolean m_bEchoOn = false;
    private PrintWriter m_spoolWriter;
    private String m_spoolFile = null;
    private String m_connString = null;
    private Object CancelMonitor = new Object();
    private boolean m_bInitialized = false;
    private volatile boolean m_bReaderSuspended = false;
    private boolean isCollectingErrorDetails = false;
    private ArrayList<String> errorCodesArrayList = new ArrayList();
    protected static final String END_OF_SQL = "SQL_ENGINE_END_OF_SQL";
    private final String ENV_PROPERTY_FILE = "oracle/sysman/assistants/util/sqlEngine/sqlEngine.env";
    private boolean m_tagging;
    private String m_applicationName;
    private boolean m_bUTF8 = false;
    private boolean showLogName;
    private static final Logger logger = Logger.getLogger(SQLEngine.class.getName());
    private Resource resource;
    private InventoryInfo inventoryInfo;
    private PlatformInfo platformInfo;

    protected SQLEngine(String oracleHome, String sidOrconnStr) throws IOException {
        this(oracleHome, sidOrconnStr, sidOrconnStr != null && sidOrconnStr.contains(":"));
    }

    protected SQLEngine(String oracleHome, String sidOrconnStr, boolean remoteConnect) throws IOException {
        this.m_home = oracleHome;
        if (remoteConnect) {
            this.m_connString = sidOrconnStr;
            this.m_sid = "";
        } else {
            this.m_sid = sidOrconnStr;
        }
        this.inventoryInfo = InventoryInfo.getInstance();
        this.platformInfo = PlatformInfo.getInstance();
        this.resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
        this.initialize();
    }

    public void setTWOTask(String setTwoTask) {
        this.m_twoTask = setTwoTask;
    }

    @Override
    public void setRemoteConnectString(String connStr) {
        this.m_connString = connStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException {
        this.m_bReaderDone = false;
        this.m_bDoneCalled = false;
        this.m_bInitialized = false;
        String[] _command = this.getCmmdParams();
        String[] _env = this.getEnvParams();
        try {
            logger.log(Level.INFO, "Execing SQLPLUS/SVRMGR process...");
            this.m_sqlEngineProcess = Runtime.getRuntime().exec(_command, _env);
        }
        catch (Exception e) {
            String[] args = new String[2];
            StringBuffer cmdBuf = new StringBuffer();
            for (int i = 0; i < _command.length; ++i) {
                cmdBuf.append(_command[i] + " ");
            }
            args[0] = cmdBuf.toString();
            args[1] = e.getMessage() == null ? "NULL" : e.getMessage();
            throw new IOException(this.resource.getString("EXEC_ERROR", "There is an error in creating the following process:\n{0}\nThe error is:\n{1}", args[0], args[1]));
        }
        this.m_sqlEngineReader = null;
        this.m_sqlEngineReader = this.m_bUTF8 ? new BufferedReader(new InputStreamReader(this.m_sqlEngineProcess.getInputStream(), "UTF8")) : new BufferedReader(new InputStreamReader(this.m_sqlEngineProcess.getInputStream()));
        logger.log(Level.INFO, "m_bReaderStarted: " + this.m_bReaderStarted);
        if (!this.m_bReaderStarted) {
            logger.log(Level.INFO, "Starting Reader Thread... ");
            this.m_readerThread = new Thread(this);
            this.m_readerThread.start();
        }
        this.m_errStream = this.m_sqlEngineProcess.getErrorStream();
        this.m_errorReader = new ErrorStreamReader(this.m_errStream);
        new Thread(this.m_errorReader).start();
        OutputStream child_out = this.m_sqlEngineProcess.getOutputStream();
        this.m_sqlEngineWriter = new PrintWriter(child_out);
        String logFile = System.getProperty("SQL_LOG_FILE");
        if (logFile != null) {
            try {
                this.m_sqlLogWriter = new PrintWriter(new FileOutputStream(logFile, true));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                logger.log(Level.INFO, "****Could not create the sql log writer for file: " + logFile);
                this.m_sqlLogWriter = null;
            }
            if (this.m_sqlLogWriter != null) {
                Calendar calndr = Calendar.getInstance();
                this.m_sqlLogWriter.println(lineSeparator + lineSeparator + "New SqlEngine ----- " + calndr.getTime().toString() + lineSeparator);
                this.m_sqlLogWriter.flush();
            }
        }
        SQLEngine sQLEngine = this;
        synchronized (sQLEngine) {
            while (!this.m_bReaderStarted) {
                logger.log(Level.INFO, "Waiting for m_bReaderStarted to be true ");
                try {
                    this.wait(10L);
                }
                catch (InterruptedException e) {
                    this.m_bInterrupted = true;
                }
            }
        }
        this.setDefaultEngineSettings();
        this.m_bInitialized = true;
        this.errorCodesArrayList.add("ORA-15056");
    }

    protected String getOracleHome() {
        return this.m_home;
    }

    public static SQLEngine getSQLEngine(String oracleHome, String host, String port, String service) throws IOException {
        SQLPlusEngine engine = null;
        String connString = host + ":" + port + USER_PSWD_SEPARATOR + service;
        engine = new SQLPlusEngine(oracleHome, connString, true);
        return engine;
    }

    public static SQLEngine getSQLEngine(String oracleHome, String connStr) throws IOException {
        SQLPlusEngine engine = null;
        engine = new SQLPlusEngine(oracleHome, connStr);
        return engine;
    }

    protected abstract String catchPrompt(String var1);

    protected abstract String removePrompt(String var1, String var2);

    protected abstract String[] getCmmdParams();

    private String[] getEnvParams() {
        String nlsLangValue;
        Vector<String> envVec = new Vector<String>(7);
        String os = System.getProperty("os.name");
        String oracleBase = this.inventoryInfo.getBaseForLocation(this.m_home);
        ArrayList<String> addedProperties = new ArrayList<String>();
        envVec.addElement("ORACLE_SID=" + this.m_sid);
        addedProperties.add("ORACLE_SID");
        if (this.m_twoTask != null) {
            if (!this.platformInfo.isWindows()) {
                envVec.addElement("TWO_TASK=" + this.m_twoTask);
                addedProperties.add("TWO_TASK");
            } else {
                envVec.addElement("LOCAL=" + this.m_twoTask);
                addedProperties.add("LOCAL");
            }
        }
        envVec.addElement("ORACLE_HOME=" + this.m_home);
        addedProperties.add("ORACLE_HOME");
        if (oracleBase != null && !oracleBase.trim().equals("")) {
            envVec.addElement("ORACLE_BASE=" + oracleBase);
            addedProperties.add("ORACLE_BASE");
        }
        if ((nlsLangValue = System.getProperty("NLS_LANG")) == null || nlsLangValue.trim().equals("")) {
            nlsLangValue = this.platformInfo.getEnv("NLS_LANG");
        }
        if (nlsLangValue == null || nlsLangValue.trim().equals("")) {
            try {
                Class[] paramTypes = new Class[]{Locale.class};
                Object[] paramVals = new Object[]{Locale.getDefault()};
                Class<?> mapperClass = Class.forName("oracle.i18n.util.LocaleMapper");
                Method oraLocaleMethod = mapperClass.getMethod("getOraLocale", paramTypes);
                nlsLangValue = (String)oraLocaleMethod.invoke(null, paramVals) + ".AL32UTF8";
                logger.log(Level.INFO, "Default NLS_LANG: " + nlsLangValue);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Unable to get NLS_LANG from LocaleMapper: " + e.getMessage());
            }
        }
        if (nlsLangValue != null && !nlsLangValue.trim().equals("")) {
            logger.log(Level.INFO, "NLS_LANG: " + nlsLangValue);
            envVec.addElement("NLS_LANG=" + nlsLangValue);
            addedProperties.add("NLS_LANG");
            this.m_bUTF8 = nlsLangValue.endsWith("UTF8");
        }
        if (!this.platformInfo.isWindows()) {
            String tkum = System.getProperty("TKUM_VARIABLES_SET");
            String nlsPath = this.platformInfo.getEnv("TKUM_NLS");
            if (nlsPath != null && !nlsPath.trim().equals("") && (tkum == null || tkum.trim().equals(""))) {
                logger.log(Level.INFO, "Setting the ORA_NLS Env Variables...");
                envVec.addElement("ORA_NLS=" + nlsPath);
                envVec.addElement("ORA_NLS32=" + nlsPath);
                envVec.addElement("ORA_NLS33=" + nlsPath);
                addedProperties.add("ORA_NLS");
                addedProperties.add("ORA_NLS32");
                addedProperties.add("ORA_NLS33");
            }
            envVec.addElement("PATH=" + this.m_home + File.separator + "bin" + File.pathSeparator + this.platformInfo.getEnv("PATH"));
            addedProperties.add("PATH");
            if (os.equals("HP-UX")) {
                envVec.addElement("SHLIB_PATH=" + this.m_home + File.separator + "lib");
                addedProperties.add("SHLIB_PATH");
                String ldLibraryPath = this.m_home + File.separator + "lib";
                envVec.addElement("LD_LIBRARY_PATH=" + ldLibraryPath);
                addedProperties.add("LD_LIBRARY_PATH");
                envVec.addElement("LD_LIBRARY_PATH_64=" + ldLibraryPath);
                addedProperties.add("LD_LIBRARY_PATH_64");
            }
            if (os.equals("AIX") || os.equals("z/OS")) {
                envVec.addElement("LIBPATH=" + this.m_home + File.separator + "lib" + File.pathSeparator + this.platformInfo.getEnv("LIBPATH"));
                addedProperties.add("LIBPATH");
            }
            if (os.equals("Solaris") || os.equals("SunOS") || os.equals("Compaq's Digital UNIX") || os.equals("OSF1") || os.equals("SEQUENT") || os.equals("Linux")) {
                String ldLibraryPath;
                String newldPath = this.platformInfo.getEnv("TKUM_LIBRARY_PATH");
                if (newldPath != null && !newldPath.trim().equals("") && (tkum == null || tkum.trim().equals(""))) {
                    logger.log(Level.INFO, "Setting the OLD LD_LIBRARY_PATH Env Variables...");
                    ldLibraryPath = newldPath + File.pathSeparator + this.platformInfo.getEnv("LD_LIBRARY_PATH");
                    envVec.addElement("LD_LIBRARY_PATH=" + ldLibraryPath);
                    envVec.addElement("LD_LIBRARY_PATH_64=" + ldLibraryPath);
                } else {
                    ldLibraryPath = this.m_home + File.separator + "lib" + File.pathSeparator + this.platformInfo.getEnv("LD_LIBRARY_PATH");
                    envVec.addElement("LD_LIBRARY_PATH=" + ldLibraryPath);
                    envVec.addElement("LD_LIBRARY_PATH_64=" + ldLibraryPath);
                }
                addedProperties.add("LD_LIBRARY_PATH");
                addedProperties.add("LD_LIBRARY_PATH_64");
            }
        } else {
            envVec.addElement("PATH=" + this.m_home + File.separator + "bin" + File.pathSeparator + this.platformInfo.getEnv("PATH"));
            addedProperties.add("PATH");
            envVec.addElement("SystemRoot=" + this.platformInfo.getEnv("SystemRoot"));
            addedProperties.add("SystemRoot");
        }
        Map<String, String> envVars = System.getenv();
        for (String name : envVars.keySet()) {
            if (addedProperties.contains(name) || "SQLPATH".equalsIgnoreCase(name)) continue;
            String value = envVars.get(name);
            if (value == null || value.trim().equals("")) {
                value = this.platformInfo.getEnv(name);
            }
            if (value == null || value.trim().equals("")) continue;
            envVec.addElement(name + "=" + value);
        }
        Object[] _env = new String[envVec.size()];
        envVec.copyInto(_env);
        return _env;
    }

    protected String[] getBeginQuerySettings() {
        return new String[0];
    }

    protected abstract String[] getDefaultSettings();

    protected abstract Vector removeHeaderFeedback(Vector var1);

    private void reInitialize() throws IOException, InterruptedException, SQLFatalErrorException {
        logger.log(Level.INFO, "Reinitializing SQLEngine...");
        if (this.m_spoolWriter != null) {
            this.m_spoolWriter.flush();
            this.m_spoolWriter.close();
            this.m_spoolWriter = null;
        }
        this.closeResources();
        this.m_bInterrupted = false;
        this.m_bReadDone = false;
        this.m_bWriteDone = false;
        this.m_bFatalErrorOccured = false;
        this.m_sErrorString = "";
        this.m_bReaderSuspended = false;
        boolean bOldm_bExecQuery = this.m_bExecQuery;
        this.m_bExecQuery = false;
        this.initialize();
        if (this.m_spoolFile != null) {
            FileOutputStream spool_out = new FileOutputStream(this.m_spoolFile, true);
            try {
                this.m_spoolWriter = new PrintWriter(spool_out);
            }
            catch (Exception e) {
                logger.log(Level.INFO, e.getMessage(), e);
                logger.log(Level.INFO, "****Could not create the spool writer for Spool file: " + this.m_spoolFile);
                this.m_spoolWriter = null;
            }
        }
        this.m_bExecQuery = bOldm_bExecQuery;
    }

    public String getSID() {
        return this.m_sid;
    }

    protected boolean inQuery() {
        return this.m_bExecQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] executeQuery(String sql) throws InterruptedException, SQLFatalErrorException {
        this.m_bExecQuery = true;
        try {
            sql = this.getTaggedSQL(sql);
            this.executeImpl(sql);
            String[] res = new String[this.m_lastQueryResult.size()];
            for (int i = 0; i < this.m_lastQueryResult.size(); ++i) {
                res[i] = (String)this.m_lastQueryResult.elementAt(i);
                res[i] = res[i].trim();
            }
            String[] stringArray = res;
            return stringArray;
        }
        finally {
            this.m_lastQueryResult.removeAllElements();
            this.m_lastQueryResult.trimToSize();
            this.m_bExecQuery = false;
        }
    }

    @Override
    public String[][] getResultFromQuery(String sql, int numcols) throws SQLFatalErrorException, InterruptedException {
        return this.getResultFromQuery(sql);
    }

    @Override
    public String[][] getResultFromQuery(String sql) throws SQLFatalErrorException, InterruptedException {
        String[] result = this.executeQuery(sql);
        if (result.length == 0) {
            return null;
        }
        String[][] rowsColResult = new String[result.length][];
        for (int i = 0; i < result.length; ++i) {
            StringTokenizer entries = new StringTokenizer(result[i]);
            int nColumns = entries.countTokens();
            rowsColResult[i] = new String[nColumns];
            for (int j = 0; j < nColumns; ++j) {
                rowsColResult[i][j] = entries.nextToken().trim();
            }
        }
        return rowsColResult;
    }

    @Override
    public void connect(String user, String password) throws SQLFatalErrorException, InterruptedException {
        this.connect(user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String userName, String password, String role) throws SQLFatalErrorException, InterruptedException {
        try {
            this.m_bInConnect = true;
            this.executeImpl(this.getConnectCommand(userName, password, role));
            this.m_userName = userName;
            this.m_password = password;
            this.m_role = role;
        }
        finally {
            this.m_bInConnect = false;
        }
    }

    private String getConnectCommand(String userName, String password, String role) {
        String cmd = null;
        String user = userName;
        if ("SYS".equalsIgnoreCase(user) || "SYSTEM".equalsIgnoreCase(user)) {
            user = user.toUpperCase();
        }
        if (role != null) {
            if (user == null || password == null || user.equals("") || password.equals("")) {
                cmd = "connect / as " + role;
            } else if (this.m_connString == null || this.m_twoTask != null) {
                cmd = "connect \"" + user + "\"/\"" + password + "\" as " + role;
            } else {
                logger.log(Level.INFO, "Connecting using conn string: " + this.m_connString);
                cmd = "connect \"" + user + "\"/\"" + password + "\"@" + this.m_connString + " as " + role;
            }
        } else if (this.m_connString == null || this.m_twoTask != null) {
            cmd = "connect \"" + user + "\"/\"" + password + "\"";
        } else {
            logger.log(Level.INFO, "Connecting using conn string: " + this.m_connString);
            cmd = "connect \"" + user + "\"/\"" + password + "\"@" + this.m_connString;
        }
        return cmd;
    }

    @Override
    public void executeScript(String script) throws SQLFatalErrorException, InterruptedException {
        if (this.m_scriptsWorkDirectory != null) {
            script = this.transferScriptLocation(script);
        }
        this.executeImpl(SCRIPT_EXECUTION_SYMBOL + script + ";");
    }

    @Override
    public void executeScript(String script, String spoolFile) throws SQLFatalErrorException, IOException, InterruptedException {
        this.setSpool(spoolFile, false);
        if (this.m_scriptsWorkDirectory != null) {
            script = this.transferScriptLocation(script);
        }
        this.executeImpl(SCRIPT_EXECUTION_SYMBOL + script + ";");
    }

    private String transferScriptLocation(String script) {
        logger.log(Level.INFO, "Script at Original Install Location:=" + script);
        int index = 0;
        String params = null;
        index = script.indexOf(" ");
        if (index != -1) {
            params = script.substring(index);
            script = script.substring(0, index + 1);
        }
        File fileObj = new File(script);
        String scriptName = fileObj.getName();
        if (params != null) {
            scriptName = scriptName + params;
        }
        script = this.m_scriptsWorkDirectory + fileSeparator + scriptName;
        logger.log(Level.INFO, "Script linked from WorkDir Location:=" + script);
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SQLEngine sQLEngine = this;
        synchronized (sQLEngine) {
            this.m_bReaderStarted = true;
        }
        try {
            String parseString = null;
            do {
                parseString = this.readSqlOutput();
            } while (!this.m_bInterrupted && parseString != null && !this.m_bReaderDone);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            this.m_bInterrupted = true;
        }
    }

    public synchronized String readSqlOutput() throws IOException {
        Vector<String> errorTrace = new Vector<String>(5);
        String parseString = null;
        String prompt = null;
        try {
            while (!this.m_bWriteDone) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this.m_bInterrupted = true;
            return parseString;
        }
        this.checkReaderSuspended();
        this.m_bFatalErrorOccured = false;
        this.m_sErrorString = "";
        Vector spoolTextList = new Vector();
        boolean bNotify = false;
        boolean bHeaderRemoved = false;
        this.isCollectingErrorDetails = false;
        while (!this.m_bInterrupted && !this.m_bDoneCalled && (parseString = this.m_sqlEngineReader.readLine()) != null) {
            if (prompt == null) {
                prompt = this.catchPrompt(parseString);
            }
            parseString = this.removePrompt(parseString, prompt);
            if (this.m_readerThread.isInterrupted()) {
                this.m_bInterrupted = true;
                break;
            }
            this.checkReaderSuspended();
            if (this.m_spoolWriter != null) {
                spoolTextList.addElement(parseString);
            }
            if (parseString.trim().indexOf(END_OF_SQL) != -1) {
                bNotify = true;
                if (spoolTextList.size() > 0) {
                    spoolTextList.setSize(spoolTextList.size() - 1);
                }
            }
            if (!(!this.hasError(parseString) && !this.isCollectingErrorDetails || errorTrace.size() > 0 && parseString.equals((String)errorTrace.lastElement()))) {
                String spool;
                if (this.showLogName && errorTrace.size() == 0 && (spool = this.getSpoolFileName()) != null && !spool.isEmpty()) {
                    errorTrace.addElement("[" + new File(spool).getName() + "] ");
                }
                errorTrace.addElement(parseString);
                continue;
            }
            if (this.isStepComplete(parseString) && this.m_errHdlr != null) {
                this.m_errHdlr.handleSubStep(this.getSubstepComponent(), this.getSubstepSkippedStatus());
            }
            if (this.m_spoolWriter != null && (errorTrace.size() > 0 || spoolTextList.size() > 20)) {
                int i;
                if (!bHeaderRemoved) {
                    bHeaderRemoved = true;
                    spoolTextList = this.removeHeaderFeedback(spoolTextList);
                }
                int size = spoolTextList.size();
                for (i = 0; i < size; ++i) {
                    if (this.m_bPasswordSpool) {
                        this.m_spoolWriter.println(this.getLogCommand((String)spoolTextList.elementAt(i)));
                        continue;
                    }
                    this.m_spoolWriter.println(spoolTextList.elementAt(i));
                }
                this.m_spoolWriter.flush();
                for (i = 0; i < size; ++i) {
                    spoolTextList.removeElementAt(0);
                }
            }
            if (errorTrace.size() > 0) {
                boolean bFatalError = false;
                Object[] errors = new String[errorTrace.size()];
                errorTrace.copyInto(errors);
                errorTrace.removeAllElements();
                this.isCollectingErrorDetails = false;
                if (this.m_errHdlr != null) {
                    if (!this.m_errHdlr.handleError((String[])errors)) {
                        bFatalError = true;
                    } else {
                        this.m_lastQueryResult.removeAllElements();
                        this.m_bExecQuery = false;
                    }
                } else {
                    bFatalError = true;
                }
                if (bFatalError) {
                    this.m_bFatalErrorOccured = true;
                    parseString = null;
                    StringBuffer strBuf = new StringBuffer();
                    for (int j = 0; j < errors.length; ++j) {
                        strBuf.append((String)errors[j] + "\n");
                    }
                    this.m_sErrorString = strBuf.toString();
                    break;
                }
            }
            if (bNotify) break;
            if (!this.m_bExecQuery) continue;
            this.m_lastQueryResult.addElement(parseString.trim());
        }
        if (this.m_bExecQuery) {
            this.m_lastQueryResult = this.removeHeaderFeedback(this.m_lastQueryResult, true);
        }
        if (this.m_spoolWriter != null) {
            if (!bHeaderRemoved) {
                spoolTextList = this.removeHeaderFeedback(spoolTextList);
            }
            for (int i = 0; i < spoolTextList.size(); ++i) {
                if (this.m_bPasswordSpool) {
                    this.m_spoolWriter.println(this.getLogCommand((String)spoolTextList.elementAt(i)));
                    continue;
                }
                this.m_spoolWriter.println(spoolTextList.elementAt(i));
            }
            this.m_spoolWriter.flush();
        }
        if (parseString == null || this.m_bFatalErrorOccured) {
            this.m_bReaderDone = true;
            this.m_bReaderStarted = false;
        }
        if (this.m_bInterrupted || bNotify || this.m_bReaderDone || this.m_bFatalErrorOccured) {
            this.m_bReadDone = true;
            this.m_bWriteDone = false;
            this.notify();
        }
        return parseString;
    }

    protected void setReaderDone() {
        this.m_bReaderDone = true;
    }

    protected Vector removeHeaderFeedback(Vector stripHeader, boolean bOnQuery) {
        return this.removeHeaderFeedback(stripHeader);
    }

    private boolean hasError(String line) {
        for (String errorCode : this.errorCodesArrayList) {
            if (!line.startsWith(errorCode)) continue;
            this.isCollectingErrorDetails = true;
            return true;
        }
        if (line.startsWith("ORA-") || line.startsWith("MGR-") || line.startsWith("PLS-") || line.startsWith("PL/SQL:")) {
            this.isCollectingErrorDetails = false;
            return true;
        }
        return false;
    }

    private boolean isStepComplete(String line) {
        if (line.startsWith("DBUA_TIMESTAMP")) {
            this.m_bsubStepSkippedStatus = "";
            StringTokenizer strTok = new StringTokenizer(line);
            strTok.nextToken();
            String component = strTok.nextToken();
            String status = strTok.nextToken();
            if ("OPTION".equals(status.trim()) || "NO".equals(status.trim())) {
                status = status + " " + strTok.nextToken();
            }
            String date = strTok.nextToken();
            String time = strTok.nextToken();
            logger.log(Level.INFO, "..Status of Upgraded Component:" + component + " is: " + status + " at " + date + " " + time);
            this.setSubstepComponent(component);
            this.setSubstepSkippedStatus(status.trim());
            return true;
        }
        return false;
    }

    private void setSubstepSkippedStatus(String status) {
        this.m_bsubStepSkippedStatus = status;
    }

    private void setSubstepComponent(String component) {
        this.m_bsubStepComponent = component;
    }

    private String getSubstepSkippedStatus() {
        return this.m_bsubStepSkippedStatus;
    }

    private String getSubstepComponent() {
        return this.m_bsubStepComponent;
    }

    private synchronized void executeImpl(String[] commands) throws SQLFatalErrorException, InterruptedException {
        for (int i = 0; i < commands.length; ++i) {
            this.executeImpl(commands[i]);
        }
    }

    private synchronized void executeImpl(String commands) throws SQLFatalErrorException, InterruptedException {
        int i;
        if (commands == null) {
            return;
        }
        String[] DEFAULT_SETTINGS = this.getDefaultSettings();
        if (this.m_bInterrupted) {
            throw new InterruptedException();
        }
        Vector PRE_DEFAULT_SETTINGS = null;
        if (this.m_bReaderDone) {
            if (!this.m_bInitialized) {
                logger.log(Level.INFO, "Could not launch SQLPLUS. Failed during initialization");
                String[] args = new String[2];
                StringBuffer cmdBuf = new StringBuffer();
                String[] _command = this.getCmmdParams();
                for (int i2 = 0; i2 < _command.length; ++i2) {
                    cmdBuf.append(_command[i2] + " ");
                }
                args[0] = cmdBuf.toString();
                args[1] = this.m_errorReader.getError();
                throw new SQLFatalErrorException(this.resource.getString("EXEC_ERROR", "There is an error in creating the following process:\n{0}\nThe error is:\n{1}", args[0], args[1]));
            }
            try {
                this.reInitialize();
                PRE_DEFAULT_SETTINGS = this.getPreDefaultSettings();
            }
            catch (IOException e) {
                throw new SQLFatalErrorException(e.toString());
            }
        }
        if (PRE_DEFAULT_SETTINGS != null) {
            for (int i3 = 0; i3 < PRE_DEFAULT_SETTINGS.size(); ++i3) {
                this.m_sqlEngineWriter.println(PRE_DEFAULT_SETTINGS.elementAt(i3));
            }
        }
        if (this.m_bExecQuery) {
            String[] BEGIN_QUERY_SETTINGS = this.getBeginQuerySettings();
            for (i = 0; i < BEGIN_QUERY_SETTINGS.length; ++i) {
                this.m_sqlEngineWriter.println(BEGIN_QUERY_SETTINGS[i]);
            }
        }
        if (!(commands = commands.trim()).endsWith(USER_PSWD_SEPARATOR) && !commands.endsWith(";")) {
            commands = commands + ";";
        }
        this.m_sqlEngineWriter.println(commands);
        for (int i4 = 0; i4 < DEFAULT_SETTINGS.length; ++i4) {
            this.m_sqlEngineWriter.println(DEFAULT_SETTINGS[i4]);
        }
        this.m_sqlEngineWriter.flush();
        String logCommand = this.getLogCommand(commands);
        if (this.m_sqlLogWriter != null) {
            this.m_sqlLogWriter.println(logCommand);
            for (i = 0; i < DEFAULT_SETTINGS.length; ++i) {
                this.m_sqlLogWriter.println(DEFAULT_SETTINGS[i]);
            }
            this.m_sqlLogWriter.flush();
        }
        this.m_bReadDone = false;
        this.m_bWriteDone = true;
        this.notify();
        try {
            while (!this.m_bReadDone) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            this.m_bInterrupted = true;
        }
        this.m_bPasswordSpool = false;
        try {
            this.processPostExec();
        }
        catch (IOException e) {
            throw new SQLFatalErrorException(e.getMessage());
        }
        if (this.m_bInterrupted || this.m_bFatalErrorOccured) {
            try {
                String spool = this.m_spoolFile;
                this.done();
                if (spool != null) {
                    this.m_spoolFile = spool;
                }
            }
            catch (Exception e) {
                this.m_sErrorString = this.m_sErrorString + "\n" + e.getMessage();
            }
            if (this.m_bInterrupted) {
                throw new InterruptedException();
            }
            if (this.m_bFatalErrorOccured) {
                throw new SQLFatalErrorException(this.m_sErrorString);
            }
        }
    }

    private String getLogCommand(String commands) {
        if ((commands = commands.trim()).regionMatches(true, 0, CONNECT, 0, CONNECT_LEN)) {
            int index = commands.indexOf(USER_PSWD_SEPARATOR);
            if (index == -1) {
                return commands;
            }
            String userStr = commands.substring(0, index);
            if (userStr.trim().equalsIgnoreCase(CONNECT)) {
                return commands;
            }
            StringTokenizer entries = new StringTokenizer(commands, "\n\t /", true);
            int nTokens = entries.countTokens();
            StringBuffer logCommand = new StringBuffer();
            boolean bPasswordToken = false;
            for (int i = 0; i < nTokens; ++i) {
                String token = entries.nextToken();
                if (bPasswordToken) {
                    if (token.trim().length() > 0) {
                        bPasswordToken = false;
                        token = PASSWORD_MASK;
                        this.m_bPasswordSpool = true;
                    }
                } else if (token.equals(USER_PSWD_SEPARATOR)) {
                    bPasswordToken = true;
                }
                logCommand.append(token);
            }
            return logCommand.toString();
        }
        if (commands.regionMatches(true, 0, CREATE_PDB, 0, CREATE_PDB_LEN) || commands.regionMatches(true, 0, CREATE_USER, 0, CREATE_USER_LEN)) {
            StringBuffer logCommand = new StringBuffer();
            StringTokenizer entries = new StringTokenizer(commands);
            int nTokens = entries.countTokens();
            boolean bPasswordToken = false;
            boolean bIdentifiedToken = false;
            for (int i = 0; i < nTokens; ++i) {
                String token = entries.nextToken();
                if (bPasswordToken) {
                    bPasswordToken = false;
                    token = PASSWORD_MASK;
                    this.m_bPasswordSpool = true;
                } else if (token.equalsIgnoreCase("identified")) {
                    bIdentifiedToken = true;
                } else if (token.equalsIgnoreCase("by") && bIdentifiedToken) {
                    bPasswordToken = true;
                } else {
                    bIdentifiedToken = false;
                }
                logCommand.append(token + " ");
            }
            if (logCommand.length() == 0) {
                logCommand.append(commands);
            }
            return logCommand.toString().trim();
        }
        if (commands.regionMatches(true, 0, ALTER, 0, ALTER_LEN)) {
            StringBuffer logCommand = new StringBuffer();
            StringTokenizer entries = new StringTokenizer(commands);
            int nTokens = entries.countTokens();
            if (nTokens > 2) {
                String alter = entries.nextToken();
                logCommand.append(alter + " ");
                String user = entries.nextToken();
                logCommand.append(user + " ");
                if (user.equalsIgnoreCase("user")) {
                    boolean bPasswordToken = false;
                    boolean bIdentifiedToken = false;
                    for (int j = 2; j < nTokens; ++j) {
                        String token = entries.nextToken();
                        if (bPasswordToken) {
                            bPasswordToken = false;
                            token = PASSWORD_MASK;
                            this.m_bPasswordSpool = true;
                        } else if (token.equalsIgnoreCase("identified")) {
                            bIdentifiedToken = true;
                        } else if (token.equalsIgnoreCase("by") && bIdentifiedToken) {
                            bPasswordToken = true;
                        } else {
                            bIdentifiedToken = false;
                        }
                        logCommand.append(token + " ");
                    }
                } else {
                    logCommand.setLength(0);
                }
            }
            if (logCommand.length() == 0) {
                logCommand.append(commands);
            }
            return logCommand.toString().trim();
        }
        if (commands.startsWith(SCRIPT_EXECUTION_SYMBOL) && commands.indexOf(" ") > 0) {
            StringTokenizer entries = new StringTokenizer(commands);
            int nTokens = entries.countTokens();
            int arguments = nTokens - 1;
            StringBuffer logCommand = new StringBuffer();
            String ARGUMENT_REPLACEMENT = " << " + arguments + " arguments passed >>";
            String script = entries.nextToken();
            logCommand.append(script);
            logCommand.append(ARGUMENT_REPLACEMENT);
            return logCommand.toString().trim();
        }
        return commands;
    }

    protected Vector getPreDefaultSettings() {
        Vector<String> preDefs = new Vector<String>();
        Vector<String> logPreDefs = new Vector<String>();
        if (!this.m_bInConnect) {
            String cmd = this.getConnectCommand(this.m_userName, this.m_password, this.m_role) + "; ";
            preDefs.addElement(cmd);
            logPreDefs.addElement(this.getLogCommand(cmd));
        }
        if (this.m_bEchoOn) {
            preDefs.addElement("set echo on;");
            logPreDefs.addElement("set echo on;");
        } else {
            preDefs.addElement("set echo off;");
            logPreDefs.addElement("set echo off;");
        }
        if (this.m_sqlLogWriter != null) {
            for (int i = 0; i < logPreDefs.size(); ++i) {
                this.m_sqlLogWriter.println(logPreDefs.elementAt(i));
            }
        }
        return preDefs;
    }

    protected void processPostExec() throws IOException {
    }

    @Override
    public void executeSql(String sqlStmt) throws SQLFatalErrorException, InterruptedException {
        sqlStmt = this.getTaggedSQL(sqlStmt);
        this.executeImpl(sqlStmt);
    }

    @Override
    public void executeSql(String[] sqlStmt) throws SQLFatalErrorException, InterruptedException {
        int size = sqlStmt.length;
        for (int i = 0; i < size; ++i) {
            sqlStmt[i] = this.getTaggedSQL(sqlStmt[i]);
        }
        this.executeImpl(sqlStmt);
    }

    @Override
    public void setSpool(String spoolFile, boolean bAppend) throws IOException {
        this.spoolOff();
        if (spoolFile == null) {
            return;
        }
        logger.log(Level.INFO, "old Spool  = " + this.m_spoolFile);
        logger.log(Level.INFO, "Setting Spool  = " + spoolFile);
        logger.log(Level.INFO, "Is spool appendable? --> " + bAppend);
        if (this.m_sqlLogWriter != null) {
            this.m_sqlLogWriter.println("Old Spool to [" + this.m_spoolFile + "]");
            this.m_sqlLogWriter.println("New spool to [" + spoolFile + "] appendable? = " + bAppend);
            this.m_sqlLogWriter.flush();
        }
        this.m_spoolFile = spoolFile;
        FileOutputStream spool_out = new FileOutputStream(spoolFile, bAppend);
        try {
            this.m_spoolWriter = new PrintWriter(spool_out);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            logger.log(Level.WARNING, "****Could not create the spool writer for Spool file: " + this.m_spoolFile);
            this.m_spoolWriter = null;
        }
    }

    @Override
    public String getSpoolFileName() {
        return this.m_spoolFile;
    }

    @Override
    public void setSpool(String spoolFile) throws IOException {
        this.setSpool(spoolFile, true);
    }

    public void setReportErrorsWithLogName(boolean showLogName) {
        this.showLogName = showLogName;
    }

    @Override
    public void spoolOff() throws IOException {
        if (this.m_spoolWriter != null) {
            try {
                this.m_spoolWriter.flush();
                this.m_spoolWriter.close();
            }
            finally {
                logger.log(Level.INFO, "Setting spool off = " + this.m_spoolFile);
                if (this.m_sqlLogWriter != null) {
                    this.m_sqlLogWriter.println("Setting spool off = " + this.m_spoolFile);
                    this.m_sqlLogWriter.flush();
                }
                this.m_spoolWriter = null;
                this.m_spoolFile = null;
            }
        }
    }

    @Override
    public void setEchoOn() throws SQLFatalErrorException, InterruptedException {
        this.m_bEchoOn = true;
        this.executeImpl("set echo on;");
    }

    @Override
    public void startup() throws SQLFatalErrorException, InterruptedException {
        this.startup("");
    }

    @Override
    public void startup(String option) throws SQLFatalErrorException, InterruptedException {
        this.executeImpl("startup " + option + ";");
    }

    @Override
    public void shutdown() throws SQLFatalErrorException, InterruptedException {
        this.shutdown("");
    }

    @Override
    public void shutdown(int mode) throws SQLFatalErrorException, InterruptedException {
        try {
            switch (mode) {
                case 0: {
                    this.shutdown("immediate");
                    break;
                }
                case 1: {
                    this.shutdown("abort");
                    break;
                }
                case 2: {
                    this.shutdown("normal");
                    break;
                }
                default: {
                    this.shutdown();
                    break;
                }
            }
        }
        catch (SQLFatalErrorException e) {
            String message = e.getMessage();
            if (message != null && message.indexOf("ORA-03113") != -1) {
                logger.log(Level.WARNING, "Ignoring ORA-03113 during shutdown");
                logger.log(Level.WARNING, message);
            }
            throw e;
        }
    }

    @Override
    public void shutdown(String option) throws SQLFatalErrorException, InterruptedException {
        this.executeImpl("shutdown " + option + ";");
    }

    @Override
    public void setEchoOff() throws SQLFatalErrorException, InterruptedException {
        this.m_bEchoOn = false;
        this.executeImpl("set echo off;");
    }

    @Override
    public void setSQLErrorHandler(SQLErrorHandler errhdlr) {
        this.m_errHdlr = errhdlr;
    }

    @Override
    public void done() throws IOException {
        if (this.m_bDoneCalled) {
            return;
        }
        logger.log(Level.INFO, "Done called");
        try {
            this.spoolOff();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.m_bReaderDone) {
            try {
                this.m_bDoneCalled = true;
                this.executeImpl("exit;");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closeResources();
    }

    private void closeResources() {
        if (this.m_sqlEngineProcess != null) {
            this.m_sqlEngineProcess.destroy();
        }
        if (this.m_sqlEngineWriter != null) {
            this.m_sqlEngineWriter.close();
        }
        if (this.m_sqlLogWriter != null) {
            this.m_sqlLogWriter.close();
        }
        if (this.m_sqlEngineReader != null) {
            try {
                this.m_sqlEngineReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_errStream != null) {
            try {
                this.m_errStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReaderSuspended() {
        if (this.m_bReaderSuspended) {
            Object object = this.CancelMonitor;
            synchronized (object) {
                try {
                    while (this.m_bReaderSuspended) {
                        this.CancelMonitor.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.m_bInterrupted = true;
                }
            }
        }
    }

    public void interruptEngine() {
        this.m_readerThread.interrupt();
        try {
            this.m_sqlEngineProcess.getInputStream().close();
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage(), e);
        }
        this.m_bInterrupted = true;
    }

    public void suspendEngine() {
        this.m_bReaderSuspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeEngine() {
        Object object = this.CancelMonitor;
        synchronized (object) {
            this.m_bReaderSuspended = false;
            this.CancelMonitor.notify();
        }
    }

    public boolean isEngineInterrupted() {
        return this.m_bInterrupted;
    }

    protected void setDefaultEngineSettings() throws IOException {
        try {
            this.executeImpl(this.getDefaultSettings());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void setScriptsWorkDirectory(String location) {
        this.m_scriptsWorkDirectory = location;
    }

    public static String doSQLSubstitution(String sqlStatement, String[] bindings) {
        return SQLEngine.doSQLSubstitution(sqlStatement, bindings, true);
    }

    public static String doSQLSubstitution(String sqlStatement, String[] bindings, boolean logSQL) {
        if (bindings != null) {
            StringBuffer newStr = new StringBuffer();
            int startPos = 0;
            int subPos = sqlStatement.indexOf("%s", startPos);
            int whichSub = 0;
            while (subPos != -1) {
                newStr.append(sqlStatement.substring(startPos, subPos));
                if (whichSub < bindings.length) {
                    newStr.append(bindings[whichSub]);
                }
                startPos = subPos + 2;
                subPos = sqlStatement.indexOf("%s", startPos);
                ++whichSub;
            }
            newStr.append(sqlStatement.substring(startPos));
            sqlStatement = newStr.toString();
        }
        if (logSQL) {
            logger.log(Level.INFO, "The substituted sql statement:=" + sqlStatement);
        }
        return sqlStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SQLEngine engine = null;
        try {
            args = new String[]{"/private1/oracle/ora10i", "jdk1415"};
            engine = SQLEngine.getSQLEngine(args[1], args[0]);
            engine.setSQLErrorHandler(new SQLErrorHandler(){

                @Override
                public boolean handleError(String errorStr) {
                    String[] err = new String[]{errorStr};
                    return this.handleError(err);
                }

                @Override
                public boolean handleError(String[] errorStr) {
                    System.out.println("Ignoring following errors:");
                    for (int i = 0; i < errorStr.length; ++i) {
                        System.out.println(errorStr[i]);
                    }
                    System.out.println();
                    return true;
                }

                public Hashtable getIgnorableErrors() {
                    return null;
                }

                public Hashtable getFatalErrors() {
                    return null;
                }

                @Override
                public void handleSubStep(boolean skippedStatus) {
                }

                @Override
                public void handleSubStep(String progressItem, String Status2) {
                }
            });
            engine.setEchoOn();
            engine.setEchoOff();
            engine.connect("sys", "oracle", "sysdba");
            System.out.println("Spooling ot sql.log........");
            engine.setSpool("sqlCatalog.log");
            engine.executeScript("/private1/oracle/ora10i/rdbms/admin/rdbmsup.sql");
            engine.connect("sys", "oracle", "sysdba");
            String DB_RUNNING = "RUNNING";
            boolean bDBRunning = false;
            try {
                String[] value = engine.executeQuery("select  'DB_RUNNING' from dual;");
                if (value != null && value.length > 0 && value[0].equals("DB_RUNNING")) {
                    bDBRunning = true;
                    System.out.println("** DB is Running .....");
                }
            }
            catch (SQLFatalErrorException value) {
                // empty catch block
            }
            engine.setEchoOn();
            engine.executeSql("create or replace library dr$libx as 'd:\\oracle\\ora90\\bin\\oractxx9.dll';\n/");
            String[] cmds = new String[]{" alter user dhiraj identified by dhiraj", " ALTER USER oe IDENTIFIED BY lion DEFAULT TABLESPACE tbs_1; ", " ALTER USER hr IDENTIFIED GLOBALLY AS 'CN=tom,O=oracle,C=US';", " ALTER database hr by PASSWORD EXPIRE;"};
            engine.setEchoOn();
            for (int i = 0; i < cmds.length; ++i) {
                engine.executeSql(cmds[i]);
            }
            engine.executeSql("alter rollback segment RB16 online;");
            engine.executeQuery("select name from v$datafile;");
            System.out.println("** Running the Catalog Scipt ..");
            System.out.println("** Running the Catalog - Oracle Cryptographic toolkit ..");
            System.out.println("** Running the Catalog - Oracle Workspace Manager Toolkit ..");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (engine != null) {
                    engine.done();
                }
            }
            catch (Exception exception) {}
        }
        System.exit(0);
    }

    private String getTaggedSQL(String sql) {
        if (this.m_tagging && this.m_applicationName != null && this.m_applicationName.trim().length() > 0) {
            if ((sql = sql.trim()).endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            StringBuffer buffer = new StringBuffer(sql);
            buffer.append(" ");
            buffer.append("/* ");
            buffer.append(this.m_applicationName.trim());
            buffer.append(" */");
            buffer.append(";");
            sql = buffer.toString();
        }
        return sql;
    }

    public boolean isTagging() {
        return this.m_tagging;
    }

    public void setTagging(boolean tagging) {
        this.m_tagging = tagging;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    class ErrorStreamReader
    implements Runnable {
        private BufferedReader m_reader;
        private StringBuffer m_error;

        ErrorStreamReader(InputStream in) {
            this.m_reader = new BufferedReader(new InputStreamReader(in));
            this.m_error = new StringBuffer();
        }

        public String getError() {
            return this.m_error.toString();
        }

        @Override
        public void run() {
            try {
                String err;
                while ((err = this.m_reader.readLine()) != null) {
                    this.m_error.append(err + "\n");
                    if (SQLEngine.this.m_spoolWriter == null) continue;
                    SQLEngine.this.m_spoolWriter.println(err);
                }
                this.m_reader.close();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (this.m_reader != null) {
                        this.m_reader.close();
                    }
                }
                catch (IOException iOException) {}
                this.m_reader = null;
            }
        }
    }
}

