/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import oracle.install.commons.base.util.job.ExecutionResult;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.util.engine.Channel;
import oracle.install.driver.util.engine.ChannelException;
import oracle.install.driver.util.engine.ChannelHelper;
import oracle.install.driver.util.engine.ExecutionProcessHandler;
import oracle.install.driver.util.engine.JSchHelper;
import oracle.install.driver.util.resource.DriverErrorCode;

public class JSChChannel
extends Channel {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(JSChChannel.class.getName());
    private static final int MILLISECONDCONVERTER = 1000;

    JSChChannel(String node, String user, String password, Channel.ChannelMode cm, String sudoPbrunLocation, int timeout, boolean requireTty) {
        super(node, user, password, cm, sudoPbrunLocation, timeout, requireTty);
    }

    JSChChannel(String node, String user, String password, Channel.ChannelMode cm, String sudoPbrunLocation, int timeout, boolean requireTty, String asUser) {
        super(node, user, password, cm, sudoPbrunLocation, timeout, requireTty, asUser);
    }

    @Override
    protected ExecutionResult execCommandImpl(String command, List<String> args, Map<String, String> envVars, Map<String, String> stdin) {
        ExecutionResult result = new ExecutionResult();
        String Passphrase = "passphrase";
        try {
            logger.log(Level.INFO, "Entered execCommand");
            logger.log(Level.INFO, "Command is being run in " + (Object)((Object)this.getChannelMode()) + " mode.");
            JSch jsch = new JSch();
            String knownHostsPath = JSchHelper.getKnownHostsPath();
            try {
                logger.log(Level.INFO, "setting known hosts path to " + knownHostsPath);
                jsch.setKnownHosts(knownHostsPath);
            }
            catch (JSchException je) {
                logger.log(Level.INFO, "jsch exception while creating host key repository from file " + knownHostsPath + " message " + je.getMessage());
                throw new ChannelException((ErrorCode)DriverErrorCode.CHANNEL_FAILED_KNOWN_HOSTS_ERR, new Object[]{je, knownHostsPath, this.getNode()});
            }
            JSch.setLogger((Logger)new JschLogger());
            PrivUserInfo ui = new PrivUserInfo(this.getPwd(), Passphrase);
            String pubkeyPath = JSchHelper.getRSADSAPath();
            logger.log(Level.INFO, "pubkeypath is " + pubkeyPath);
            if (null != pubkeyPath && this.getChannelMode() != Channel.ChannelMode.ROOT) {
                jsch.addIdentity(pubkeyPath, Passphrase);
            }
            Session session = jsch.getSession(this.getUser(), this.getNode());
            Properties configProps = new Properties();
            configProps.put("PreferredAuthentications", "password,keyboard-interactive,publickey");
            session.setConfig(configProps);
            session.setPassword(this.getPwd());
            session.setUserInfo((UserInfo)ui);
            if (command.trim().equals(this.getSudoPbrunLocation() + " -k")) {
                this.setChannelMode(Channel.ChannelMode.SHELL);
            }
            if (this.getChannelMode() == Channel.ChannelMode.SUDO) {
                if (" -l".equalsIgnoreCase(command)) {
                    this.setRequireTty(true);
                }
                session.connect(this.getTimeout() * 1000);
            } else {
                session.connect(this.getTimeout() * 1000);
            }
            logger.log(Level.INFO, "command = " + command);
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            if (this.isRequireTty()) {
                channel.setPty(true);
            }
            List<String> commandList = ChannelHelper.constructCommand(command, args, envVars, this.getChannelMode(), this.getSudoPbrunLocation(), ChannelHelper.CommandContext.JSCH);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            channel.setOutputStream((OutputStream)os);
            ByteArrayOutputStream es = new ByteArrayOutputStream();
            channel.setErrStream((OutputStream)es);
            if (envVars != null && !envVars.isEmpty()) {
                for (String envVarName : envVars.keySet()) {
                    logger.log(Level.INFO, "setting env variable " + envVarName + "=" + envVars.get(envVarName));
                    channel.setEnv(envVarName, envVars.get(envVarName));
                }
            }
            logger.log(Level.INFO, "Command constructed is = " + commandList.get(0));
            result.setCommands(commandList);
            channel.setCommand(commandList.get(0));
            if (stdin == null || stdin.isEmpty()) {
                stdin = new HashMap<String, String>();
                stdin.put(ChannelHelper.getUserPasswordPrompt(), this.getPwd());
            } else if (stdin.get(ChannelHelper.getUserPasswordPrompt()) == null) {
                stdin.put(ChannelHelper.getUserPasswordPrompt(), this.getPwd());
            }
            channel.connect();
            try {
                new ExecutionProcessHandler().handleChannel(channel, result, stdin);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "IOE executing " + command + " on node " + this.getNode());
                throw new ChannelException((ErrorCode)DriverErrorCode.CHANNEL_FAILED_ERR, e, this.getNode(), command);
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "IOE executing " + command + " on node " + this.getNode());
                throw new ChannelException((ErrorCode)DriverErrorCode.CHANNEL_FAILED_ERR, e, this.getNode(), command);
            }
            finally {
                logger.log(Level.INFO, "end of command execution");
                channel.disconnect();
                session.disconnect();
                result.setSuccess(true);
            }
        }
        catch (JSchException e) {
            logger.log(Level.INFO, "jsch exception while executing command " + command + " on node " + this.getNode() + " message " + e.getMessage());
            ChannelException ce = new ChannelException((ErrorCode)DriverErrorCode.CHANNEL_FAILED_ERR, new Object[]{e, this.getNode(), command});
            result.addException(ce);
        }
        catch (ChannelException e) {
            logger.log(Level.INFO, "channel exception whie executing command " + command + " on node " + this.getNode() + " message " + e.getMessage());
            result.addException(e);
        }
        return result;
    }

    class PrivUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private volatile String m_Password = null;
        private volatile String m_Passphrase = null;
        boolean m_bConfirm = false;

        PrivUserInfo(String password, String passphrase) {
            this.m_Password = password;
            this.m_Passphrase = passphrase;
        }

        public String getPassword() {
            logger.log(Level.INFO, "returning password");
            return this.m_Password;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (prompt == null) {
                return null;
            }
            if (prompt.length > 0) {
                logger.log(Level.INFO, "prompting user in keyboard interactive interaction: " + instruction + " : prompt: " + prompt[0] + " : echo: " + echo[0] + " : destination: " + destination);
            } else {
                logger.log(Level.INFO, "prompting user in keyboard interactive interaction: " + instruction + " : destination: " + destination);
            }
            String[] response = new String[prompt.length];
            for (int i = 0; i < response.length; ++i) {
                response[i] = this.m_Password;
            }
            return response;
        }

        public boolean promptYesNo(String message) {
            logger.log(Level.INFO, "prompt user for yes/no answer: " + message);
            return true;
        }

        public String getPassphrase() {
            logger.log(Level.INFO, "return user passphrase");
            return this.m_Passphrase;
        }

        public boolean promptPassphrase(String message) {
            logger.log(Level.INFO, "prompting user for passphrase: " + message);
            return true;
        }

        public boolean promptPassword(String message) {
            logger.log(Level.INFO, "prompting user for password: " + message);
            return true;
        }

        public void showMessage(String message) {
            logger.log(Level.INFO, message);
        }
    }

    public static class JschLogger
    implements Logger {
        public boolean isEnabled(int level) {
            return false;
        }

        public void log(int level, String message) {
            logger.log(Level.INFO, message);
        }
    }
}

