/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.ExecutionResult;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.JobApplicationLogHandler;
import oracle.install.commons.base.util.job.JobVariableLoader;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.engine.CommandExecutor;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.util.engine.Channel;
import oracle.install.driver.util.engine.ChannelFactory;
import oracle.install.driver.util.resource.DriverErrorCode;

public class CommandExecutionEngine
implements CommandExecutor {
    private static final Logger logger = Logger.getLogger(CommandExecutionEngine.class.getName());
    private Process process;
    private JobSettings jobSettings;
    private List<String> nodes = new ArrayList<String>();
    private Channel.ChannelMode configMode;
    private String runAsUser = null;
    private String sudoPath = null;
    private String password = null;

    @Override
    public Map<String, ExecutionResult> execute(JobContext jobContext, JobSettings jobSettings) throws JobApplicationException {
        this.jobSettings = jobSettings;
        String command = jobSettings.getCommand();
        command = JobVariableLoader.getInstance().replaceVariables(command, jobContext.getJobIndependentVars(), jobSettings.getArgs());
        try {
            Map<String, ExecutionResult> resultMap = this.invoke(command, jobContext);
            return resultMap;
        }
        catch (Throwable e) {
            throw new JobApplicationException(e, (ErrorCode)DriverErrorCode.COMMAND_EXECUTION_ERR, command, JobApplicationLogHandler.getLogFile());
        }
    }

    public void abort() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ExecutionResult> invoke(final String executable, JobContext jobContext) throws Throwable {
        Map<String, VariableSettings> map;
        Object value;
        Map<String, VariableSettings> toolArgs;
        final ArrayList<String> args = new ArrayList<String>();
        final HashMap<String, String> envVarsMap = new HashMap<String, String>();
        Map<String, VariableSettings> envVars = this.jobSettings.getEnvVariables();
        if (envVars != null && !envVars.isEmpty()) {
            for (VariableSettings variableSettings : envVars.values()) {
                if (variableSettings == null || variableSettings.getValue() == null) continue;
                String string2 = variableSettings.getValue();
                string2 = JobVariableLoader.getInstance().replaceVariables(string2, jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                envVarsMap.put(variableSettings.getName(), string2);
            }
        }
        if ((toolArgs = this.jobSettings.getArgs()) != null && !toolArgs.isEmpty()) {
            for (VariableSettings variableSettings : toolArgs.values()) {
                String name = JobVariableLoader.getInstance().replaceVariables(variableSettings.getName(), jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                if (name.equalsIgnoreCase("remoteJobNodes")) {
                    String nodesValue = variableSettings.getValue();
                    if (nodesValue == null) continue;
                    nodesValue = JobVariableLoader.getInstance().replaceVariables(nodesValue, jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                    String[] nodesArray = nodesValue.split(",");
                    this.nodes.addAll(Arrays.asList(nodesArray));
                    continue;
                }
                if (name.equalsIgnoreCase("rootConfigMode")) {
                    if (variableSettings.getValue() == null) continue;
                    this.configMode = Channel.ChannelMode.valueOf(variableSettings.getValue());
                    continue;
                }
                if (name.equalsIgnoreCase("runAsUserName")) {
                    if (variableSettings.getValue() == null) continue;
                    this.runAsUser = variableSettings.getValue();
                    continue;
                }
                if (name.equalsIgnoreCase("sudoPath")) {
                    if (variableSettings.getValue() == null) continue;
                    this.sudoPath = JobVariableLoader.getInstance().replaceVariables(variableSettings.getValue(), jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                    continue;
                }
                if (name.equalsIgnoreCase("sudoUserName")) {
                    if (variableSettings.getValue() == null) continue;
                    this.runAsUser = JobVariableLoader.getInstance().replaceVariables(variableSettings.getValue(), jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                    continue;
                }
                if (!variableSettings.isValueExpected()) {
                    args.add(name);
                    continue;
                }
                if (variableSettings.getValue() == null || variableSettings.getValue().trim().isEmpty()) continue;
                args.add(name);
                value = variableSettings.getValue();
                value = JobVariableLoader.getInstance().replaceVariables((String)value, jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                args.add(this.getQuotedValue((String)value));
            }
        }
        if ((map = this.jobSettings.getCmdProperties()) != null && !map.isEmpty()) {
            for (VariableSettings arg : map.values()) {
                if (arg.getValue() == null || arg.getValue().trim().isEmpty()) continue;
                value = arg.getValue();
                value = JobVariableLoader.getInstance().replaceVariables((String)value, jobContext.getJobIndependentVars(), this.jobSettings.getArgs());
                args.add(arg.getName() + "=" + (String)value);
            }
        }
        Map<String, VariableSettings> map2 = this.jobSettings.getSecreteArgs();
        final HashMap<String, String> promptToPasswordMap = new HashMap<String, String>();
        if (map2 != null && !map2.isEmpty()) {
            for (VariableSettings arg : map2.values()) {
                if (arg.getName().equalsIgnoreCase("rootUserPassword")) {
                    if (arg.getValue() != null) {
                        this.password = arg.getValue();
                    }
                } else if (arg.getName().equalsIgnoreCase("runAsUserPassword")) {
                    if (arg.getValue() != null) {
                        this.password = arg.getValue();
                    }
                } else if (arg.getName().equalsIgnoreCase("sudoUserPassword")) {
                    if (arg.getValue() != null) {
                        this.password = arg.getValue();
                    }
                } else if (arg.getName().equalsIgnoreCase("currentUserPassword") && arg.getValue() != null) {
                    this.password = arg.getValue();
                }
                if (arg.getValue() == null || arg.getValue().isEmpty()) continue;
                if (arg.getPromptString() != null && !arg.getPromptString().isEmpty()) {
                    promptToPasswordMap.put(arg.getPromptString(), arg.getValue());
                    continue;
                }
                logger.log(Level.INFO, "Prompt string is not set for argument:" + arg.getName() + ". So checking the possibility of setting it as user password");
                if (this.password != null && !this.password.isEmpty()) continue;
                this.password = arg.getValue();
            }
        }
        ExecutorService service = null;
        boolean runParallel = Boolean.getBoolean(String.format(JobApplicationConstants.JOB_SUCCESSFUL_STATUS_EXIT_CODES_PROPERTY, this.jobSettings.getId()));
        if (!runParallel && envVars != null && envVars.containsKey(JobApplicationConstants.ENABLE_PARALLEL_EXECUTION_OF_NODES) && envVars.get(JobApplicationConstants.ENABLE_PARALLEL_EXECUTION_OF_NODES) != null) {
            runParallel = Boolean.valueOf(envVars.get(JobApplicationConstants.ENABLE_PARALLEL_EXECUTION_OF_NODES).getValue());
        }
        final ConcurrentHashMap<String, ExecutionResult> nodeStatusMap = new ConcurrentHashMap<String, ExecutionResult>();
        ConcurrentHashMap<String, Future<Integer>> nodeFutureMap = new ConcurrentHashMap<String, Future<Integer>>();
        try {
            service = runParallel ? Executors.newCachedThreadPool() : Executors.newSingleThreadExecutor();
            if (this.nodes.isEmpty()) {
                this.nodes.add("localnode");
            }
            for (final String node : this.nodes) {
                Future<Integer> future = service.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        Channel channel = ChannelFactory.getInstance().createChannel(node, CommandExecutionEngine.this.configMode, CommandExecutionEngine.this.sudoPath, CommandExecutionEngine.this.runAsUser, CommandExecutionEngine.this.password);
                        ExecutionResult result = channel.execCommand(executable, args, envVarsMap, promptToPasswordMap);
                        nodeStatusMap.put(node, result);
                        if (result != null) {
                            return result.getExitCode();
                        }
                        return -1;
                    }
                });
                nodeFutureMap.put(node, future);
            }
            for (final String node : nodeFutureMap.keySet()) {
                int exitCode = (Integer)((Future)nodeFutureMap.get(node)).get();
                if (nodeStatusMap.get(node) == null) {
                    nodeStatusMap.put(node, new ExecutionResult());
                }
                logger.log(Level.INFO, "Updating exit status for node:" + node + " old exit code is:", ((ExecutionResult)nodeStatusMap.get(node)).getExitCode());
                ((ExecutionResult)nodeStatusMap.get(node)).setExitCode(exitCode);
            }
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        return nodeStatusMap;
    }

    private String getQuotedValue(String value) {
        if (!(value == null || value.isEmpty() || value.startsWith("'") || value.startsWith("\""))) {
            return "'" + value + "'";
        }
        return value;
    }
}

