/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionHandler;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.resource.StringResourceBundle;
import oracle.install.driver.util.FileTransferProgressListener;
import oracle.install.driver.util.RemoteOperationException;
import oracle.install.driver.util.RemoteOperationHelper;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class RemoteCopyJob
extends Job
implements Callable<Void>,
Retriable<RemoteCopyJob> {
    private String oracleHome;
    private String[] allRemoteNodes;
    private String oracleBase;
    private String excludeFilePath;
    private boolean tolerantMode;
    private ProgressUI<?> progressUI;
    private String[] failedRemoteNodes;
    private Logger logger = Logger.getLogger(RemoteCopyJob.class.getName());
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());

    public RemoteCopyJob(Object id, String description, float weightage, String oracleHome, String oracleBase, String[] remoteNodesArr, String excludeFilePath, boolean tolerantMode) {
        super(id, description, weightage);
        this.oracleHome = oracleHome;
        this.oracleBase = oracleBase;
        this.allRemoteNodes = remoteNodesArr;
        this.excludeFilePath = excludeFilePath;
        this.tolerantMode = tolerantMode;
        this.setRequired(true);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        ClusterOperationExceptionHandler handler = new ClusterOperationExceptionHandler();
        ExceptionManager.getInstance().addExceptionHandler(RemoteOperationException.class, handler);
        ExceptionManager.getInstance().addExceptionHandler(ClusterException.class, handler);
        ExceptionManager.getInstance().addExceptionHandler(RuntimeException.class, handler);
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    @Override
    public List<RemoteCopyJob> getRetriableJobs() {
        ArrayList<RemoteCopyJob> retriableJobList = new ArrayList<RemoteCopyJob>();
        Status status = this.getStatus();
        if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
            retriableJobList.add(this);
        }
        return retriableJobList;
    }

    @Override
    public void retry() throws Exception {
        this.call(true);
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public void call(boolean retry) throws Exception {
        Object[] remoteNodes;
        if (this.progressUI != null) {
            this.progressUI.log(Level.INFO, resource.getString("RemoteCopy.message", "Copying {0} to remote nodes", this.oracleHome), new Object[0]);
        }
        if (retry) {
            remoteNodes = this.failedRemoteNodes != null && this.failedRemoteNodes.length > 0 ? this.failedRemoteNodes : this.allRemoteNodes;
            this.logger.log(Level.INFO, "Retrying remote copy on nodes : " + Arrays.toString(remoteNodes));
        } else {
            remoteNodes = this.allRemoteNodes;
        }
        if (this.oracleBase != null && this.oracleBase.length() > 0) {
            ArrayList<Object> nodeListOBCheckFailed = new ArrayList<Object>();
            ArrayList<Object> nodeListOBNotExist = new ArrayList<Object>();
            for (int i = 0; i < remoteNodes.length; ++i) {
                Object remoteNode = remoteNodes[i];
                boolean dirExists = false;
                try {
                    this.logger.log(Level.FINEST, "Checking existence of " + this.oracleBase + " on node " + (String)remoteNode);
                    dirExists = RemoteOperationHelper.getInstance().dirExists((String)remoteNode, this.oracleBase);
                    if (dirExists) continue;
                    nodeListOBNotExist.add(remoteNode);
                    continue;
                }
                catch (ClusterException cex) {
                    nodeListOBCheckFailed.add(remoteNode);
                    this.logger.log(Level.WARNING, "ClusterException occurred while checking " + this.oracleBase + " existence on node " + (String)remoteNode, cex);
                    continue;
                }
                catch (ClusterOperationException copex) {
                    nodeListOBCheckFailed.add(remoteNode);
                    this.logger.log(Level.WARNING, "ClusterOperationException occurred while checking " + this.oracleBase + " existence on node " + (String)remoteNode, copex);
                }
            }
            if (!nodeListOBNotExist.isEmpty()) {
                this.logger.log(Level.INFO, "Creating " + this.oracleBase + " on nodes " + nodeListOBNotExist);
                RemoteOperationHelper.getInstance().createDirWithPermissionsOnNodes(nodeListOBNotExist.toArray(new String[0]), this.oracleBase, "0755");
            }
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        String includeListFile = null;
        String remoteNodeCommonDestDir = this.oracleHome;
        try {
            this.setStatus(Status.INPROGRESS);
            this.logger.info("Job:" + this.getDescription() + " started. Status:" + (Object)((Object)this.getStatus()));
            this.logger.log(Level.INFO, "Copying {0} to remote nodes {1}", new Object[]{this.oracleHome, Arrays.toString(remoteNodes)});
            RemoteOperationHelper.getInstance().transferDirStructureToNodes(this.oracleHome, (String[])remoteNodes, this.oracleHome, includeListFile, true, this.excludeFilePath, true, tempDir, remoteNodeCommonDestDir, new FileTransferProgressListener(this));
            this.setStatus(Status.SUCCEEDED);
            if (retry && this.failedRemoteNodes != null && this.failedRemoteNodes.length > 0) {
                this.failedRemoteNodes = null;
            }
            this.logger.info("Job:" + this.getDescription() + " completed with the status:" + (Object)((Object)this.getStatus()));
        }
        catch (RemoteFileOperationException rfoex) {
            List<String> failedNodes = RemoteOperationHelper.getInstance().getFailedNodes();
            this.failedRemoteNodes = failedNodes.toArray(new String[0]);
            RemoteOperationException remoteOpEx = null;
            remoteOpEx = this.tolerantMode ? new RemoteOperationException(failedNodes, (ErrorCode)InstallerErrorCode.ACTIONABLE_REMOTE_COPY_OPERATION_FAILED, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile()) : new RemoteOperationException(failedNodes, (ErrorCode)InstallerErrorCode.REMOTE_COPY_OPERATION_FAILED, Severity.FATAL, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile());
            throw remoteOpEx;
        }
        catch (ClusterException cex) {
            ArrayList<String> failedNodes = new ArrayList<String>();
            failedNodes.addAll(Arrays.asList(remoteNodes));
            this.failedRemoteNodes = failedNodes.toArray(new String[0]);
            if (this.tolerantMode) {
                throw new RemoteOperationException(failedNodes, (Throwable)cex, (ErrorCode)InstallerErrorCode.ACTIONABLE_CLUSTER_OPERATION_FAILED, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile());
            }
            throw new RemoteOperationException(failedNodes, (Throwable)cex, (ErrorCode)InstallerErrorCode.CLUSTER_OPERATION_FAILED, Severity.FATAL, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile());
        }
        catch (RuntimeException rtex) {
            this.logger.log(Level.SEVERE, "Runtime exception occurred while copying " + this.oracleHome + " to remote nodes :" + rtex.getLocalizedMessage());
            this.logger.log(Level.SEVERE, ExceptionManager.getStackTrace(rtex));
            ArrayList<String> failedNodes = new ArrayList<String>();
            failedNodes.addAll(Arrays.asList(remoteNodes));
            this.failedRemoteNodes = failedNodes.toArray(new String[0]);
            throw new RemoteOperationException(failedNodes, (Throwable)rtex, (ErrorCode)InstallerErrorCode.REMOTE_COPY_UNEXPECTED_ERROR, Severity.FATAL, this.oracleHome);
        }
    }

    @Override
    public void handleException(Throwable jobException) {
        if (this.tolerantMode) {
            if (jobException instanceof RemoteOperationException) {
                RemoteOperationException rcex = (RemoteOperationException)jobException;
                Option advice = ExceptionManager.report(rcex);
                if (advice == Advice.CONTINUE) {
                    List<String> failedNodes = rcex.getFailedNodes();
                    Object setupDriver = SetupDriver.getInstance();
                    try {
                        ((SetupDriver)setupDriver).updateConfig(failedNodes);
                    }
                    catch (SetupDriverException e) {
                        this.logger.log(Level.WARNING, "SetupDriverException occurred while removing bad nodes.", e);
                    }
                    this.failedRemoteNodes = null;
                    this.setStatus(Status.SUCCEEDED);
                } else {
                    this.progressUI.log(Level.INFO, resource.getString("RemoteCopy.failed.message", "Copying {0} to remote nodes failed.", this.oracleHome), new Object[0]);
                    this.setStatus(Status.FAILED);
                }
            } else {
                this.progressUI.log(Level.INFO, resource.getString("RemoteCopy.failed.message", "Copying {0} to remote nodes failed.", this.oracleHome), new Object[0]);
                ExceptionManager.handle(jobException);
            }
        } else {
            this.progressUI.log(Level.INFO, resource.getString("RemoteCopy.failed.message", "Copying {0} to remote nodes failed.", this.oracleHome), new Object[0]);
            ExceptionManager.handle(jobException);
        }
    }

    public void setProgressBar(ProgressUI<?> progressUI) {
        this.progressUI = progressUI;
    }

    class ClusterOperationExceptionHandler
    implements ExceptionHandler<Throwable> {
        ClusterOperationExceptionHandler() {
        }

        @Override
        public void handleException(Throwable exception) {
            Option advise = ExceptionManager.report(exception);
            RemoteCopyJob.this.logger.log(Level.INFO, "User adivse {0}.", advise);
            if (advise != Advice.CONTINUE) {
                RemoteCopyJob.this.setStatus(Status.FAILED);
            } else {
                RemoteCopyJob.this.setStatus(Status.SUCCEEDED);
            }
        }
    }
}

