/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.util;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixWinOps;

public class VariableInitializer
extends OiisVariable {
    private String name;
    private OiisVariableOwner vo;
    private static boolean isWindows = VariableInitializer.isWindows();
    private static Map<String, Method> variableMethodMap = VariableInitializer.getVarMethodsMap();

    public VariableInitializer(OiisVariableOwner vo, String name) {
        super(vo, name);
        this.name = name;
        this.vo = vo;
    }

    public OiisAdvisedValue getCalculatedValue() throws OiisVarSettingException, OiifbCancelException {
        Method method;
        if (this.name != null && this.name.length() > 0 && (method = variableMethodMap.get(this.name.trim())) != null) {
            try {
                Object result = method.invoke((Object)this, new Object[0]);
                if (result != null) {
                    return new OiisAdvisedValue((Object)result.toString());
                }
            }
            catch (Exception e) {
                new OiisVarSettingException(this.vo, (OiisVariable)this, e.getMessage());
            }
        }
        if (this.getType() == BOOL) {
            return new OiisAdvisedValue((Object)Boolean.TRUE);
        }
        if (this.getType() == STRINGLIST) {
            return new OiisAdvisedValue((Object)STRINGLIST_DEFAULT);
        }
        if (this.getType() == NUMBER) {
            return new OiisAdvisedValue((Object)NUMBER_DEFAULT);
        }
        return new OiisAdvisedValue((Object)"");
    }

    @PropertyDef(value="oracle_install_UnixMakePath")
    public static String calculateUnixMakePath() {
        if (!isWindows) {
            if (OiixPlatform.getCurrentPlatform() == 46 || OiixPlatform.getCurrentPlatform() == 110 || OiixPlatform.getCurrentPlatform() == 227 || OiixPlatform.getCurrentPlatform() == 211) {
                return "/usr/bin/make";
            }
            return "/usr/ccs/bin/make";
        }
        return "";
    }

    @PropertyDef(value="s_windowsSystemDirectory")
    public static String calculateWindowsSystemDirectory() throws OiilNativeException {
        if (isWindows) {
            return OiixWinOps.getWindowsSystemDirectory();
        }
        return "";
    }

    @PropertyDef(value="oracle_install_windowsCommandLine")
    public static String calculateWindowsCommand() throws OiilNativeException {
        if (isWindows) {
            String dir = VariableInitializer.calculateWindowsSystemDirectory();
            return dir + "\\cmd /c call ";
        }
        return "";
    }

    @PropertyDef(value="oracle_install_netcaCmd")
    public static String calculateNetCACmd() {
        if (isWindows) {
            return "bin/netca.bat";
        }
        return "bin/netca";
    }

    @PropertyDef(value="oracle_install_netcaDeinstCmd")
    public static String calculateNetCADeinstCmd() {
        if (isWindows) {
            return "bin/netca_deinst.bat";
        }
        return "bin/netca_deinst";
    }

    @PropertyDef(value="oracle_install_db_dbcaCmd")
    public static String calculateDBCACmd() {
        if (isWindows) {
            return "bin/dbca.bat";
        }
        return "bin/dbca";
    }

    @PropertyDef(value="oracle_install_classpath_separator")
    public static String calculateClassPathSeparator() {
        if (isWindows) {
            return ";";
        }
        return ":";
    }

    @PropertyDef(value="oracle_install_db_dbuaCmd")
    public static String calculateDBUACmd() {
        if (isWindows) {
            return "bin/dbua.bat";
        }
        return "bin/dbua";
    }

    @PropertyDef(value="oracle_install_crs_emcaCmd")
    public static String calculateEMCACmd() {
        if (isWindows) {
            return "bin/emca.bat";
        }
        return "bin/emca";
    }

    @PropertyDef(value="oracle_install_crs_crsInstCmd")
    public static String calculateCRSInstCmd() {
        if (isWindows) {
            return "bin/crssetup.config.bat";
        }
        return "";
    }

    @PropertyDef(value="oracle_install_crs_crsDeinstCmd")
    public static String calculateCRSDeinstCmd() {
        if (isWindows) {
            return "bin/crssetup.exe";
        }
        return "";
    }

    @PropertyDef(value="oracle_install_crs_crsUpgrdCmd")
    public static String calculateCRSUpgrdCmd() {
        if (isWindows) {
            return "bin/crssetup.upgrade.bat";
        }
        return "";
    }

    @PropertyDef(value="oracle_install_crs_cluvfyCmd")
    public static String calculateCLUFYCmd() {
        if (isWindows) {
            return "bin/cluvfy.bat";
        }
        return "bin/cluvfy";
    }

    @PropertyDef(value="oracle_install_crs_asmcaCmd")
    public static String calculateASMCACmd() {
        if (isWindows) {
            return "asmca.bat";
        }
        return "asmca";
    }

    @PropertyDef(value="oracle_install_installerCmd")
    public static String calculateInstallerCmd() {
        if (isWindows) {
            return "setup.exe";
        }
        return "runInstaller";
    }

    @PropertyDef(value="oracle_install_crs_mgmtcaCmd")
    public static String calculateMGMTCmd() {
        if (isWindows) {
            return "bin/mgmtca.bat";
        }
        return "bin/mgmtca";
    }

    @PropertyDef(value="oracle_install_crs_RHPUpgradeCmd")
    public static String calculateRHPUpgradeCmd() {
        if (isWindows) {
            return "bin/rhprepos.bat";
        }
        return "bin/rhprepos";
    }

    @PropertyDef(value="oracle_install_crs_srvctlCmd")
    public static String calculateSRVCTLCmd() {
        if (isWindows) {
            return "bin/srvctl.bat";
        }
        return "bin/srvctl";
    }

    public static boolean isWindows() {
        int platform = OiixPlatform.getCurrentPlatform();
        return OiixPlatform.isPlatInGroup((int)-3, (int)platform);
    }

    private static Map<String, Method> getVarMethodsMap() {
        Method[] methods;
        HashMap<String, Method> variableMap = new HashMap<String, Method>();
        Class<VariableInitializer> clazz = VariableInitializer.class;
        for (Method method : methods = clazz.getMethods()) {
            PropertyDef propertyDef = method.getAnnotation(PropertyDef.class);
            if (propertyDef == null) continue;
            variableMap.put(propertyDef.value(), method);
        }
        return variableMap;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface PropertyDef {
        public String value();
    }
}

