/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui.action;

import java.io.File;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.ResourceURL;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.util.SetupSummary;

public abstract class AbstractFinishAction
implements Action {
    private Logger logger = Logger.getLogger(AbstractFinishAction.class.getName());

    @Override
    public void execute(FlowContext flowContext) {
        File oracleHome = new File(this.getOracleHome(flowContext));
        SetupSummary summary = SetupSummary.getInstance();
        summary.beginUpdate();
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        if ((cmdLineArgumentHandler == null || !cmdLineArgumentHandler.isArgumentPassed("executeConfigTools")) && this.showConfigToolExecutionMsg(flowContext)) {
            Application application = Application.getInstance();
            String configToolsCommand = this.getConfigToolsCommand(oracleHome.getAbsolutePath());
            String responseFilePath = null;
            boolean isSilent = ((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.SILENT;
            responseFilePath = isSilent ? cmdLineArgumentHandler.getArgumentValue("responseFile") : this.getResponseFile(oracleHome.getAbsolutePath());
            summary.append(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "configTools.message"), "\nAs install user, execute the following command to complete the configuration.\n\t{0} -executeConfigTools -responseFile {1} [-silent]", configToolsCommand, responseFilePath));
            if (!isSilent) {
                summary.append(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "configTools.message.note"), "\nNote: The required passwords need to be included in the response file.", new Object[0]));
            }
        }
        if (this.updateSummaryWithReadmeText(flowContext)) {
            String readmeText = this.getReadmeText(flowContext);
            if (readmeText != null) {
                summary.append(readmeText);
            } else {
                summary.append(DriverHelper.getReadmeFileContent(oracleHome));
            }
        }
        summary.endUpdate();
        this.printSummary();
    }

    protected String getResponseFile(String oracleHome) {
        this.logger.warning("This method should not be used");
        return "response_file_path";
    }

    protected String getConfigToolsCommand(String oracleHome) {
        String configToolsCommand = "runInstaller";
        if (PlatformInfo.getInstance().isWindows()) {
            configToolsCommand = "setup.exe";
        }
        String thisClassPath = null;
        try {
            thisClassPath = System.getProperty("oracle.installer.startup_location");
        }
        catch (Exception e) {
            this.logger.info("Could not get the path of the runInstaller/setup.exe for the config tools message.");
        }
        if (thisClassPath != null) {
            try {
                configToolsCommand = new File(thisClassPath + File.separator + ".." + File.separator + configToolsCommand).getCanonicalPath();
            }
            catch (Exception e) {
                this.logger.info("Could not get the canonical path of the runInstaller/setup.exe for the config tools message.");
            }
        }
        this.logger.info("Config tools command: " + configToolsCommand);
        return configToolsCommand;
    }

    public String getReadmeText(FlowContext flowContext) {
        return null;
    }

    protected void printSummary() {
        String msg = SetupSummary.getInstance().getText();
        if (msg != null && msg.length() > 0 && ((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.SILENT) {
            Console.println(msg + "\n");
        }
    }

    @Override
    public Route transition(FlowContext flowContext) {
        return null;
    }

    public abstract String getOracleHome(FlowContext var1);

    public boolean showConfigToolExecutionMsg(FlowContext flowContext) {
        return Application.getInstance().getArguments().contains("-noconfig");
    }

    public boolean updateSummaryWithReadmeText(FlowContext flowContext) {
        String home = this.getOracleHome(flowContext);
        return home != null && new File(home).exists() && ((SetupDriver)SetupDriver.getInstance()).getSetupMode() == SetupMode.INTERACTIVE && !Boolean.getBoolean("readme.exist");
    }
}

