/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class LicenseInfoDialog
extends JDialog {
    private Resource resource = Application.getInstance().getResource("oracle.install.driver.oui.resource.StringResourceBundle");
    private static final Logger logger = Logger.getLogger(LicenseInfoDialog.class.getName());
    private static boolean accepted = false;
    private static LicenseInfoDialog dialog;
    private File licenseFile;
    private FileType fileType;
    private JTextArea textArea;
    private JTextPane htmlPane;
    private MultilineLabel lblDescription;
    private JButton btnAccept;
    private JButton btnDecline;
    private JPanel mainPanel;
    private JPanel buttonPanel;

    public static boolean showDialog(Component frameComp, File licenseFile) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        if (licenseFile == null || !licenseFile.exists()) {
            logger.log(Level.WARNING, "License file either null or not exist");
        } else {
            dialog = new LicenseInfoDialog(frame, licenseFile);
            dialog.setVisible(true);
        }
        return accepted;
    }

    public LicenseInfoDialog(Frame owner, File licenseFile) {
        super(owner, "", true);
        this.licenseFile = licenseFile;
        this.setResizable(false);
        this.lblDescription = new MultilineLabel();
        this.textArea = new JTextArea();
        this.htmlPane = new HtmlPane();
        this.btnAccept = new JButton();
        this.btnDecline = new JButton();
        this.mainPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.btnAccept.setActionCommand("accept");
        this.btnAccept.setName("LicenseInfoDialog.btnAccept");
        this.btnDecline.setActionCommand("decline");
        this.btnDecline.setName("LicenseInfoDialog.btnDecline");
        String fileExt = this.getFileExtension(this.licenseFile);
        this.fileType = fileExt != null && (fileExt.equalsIgnoreCase("html") || fileExt.equalsIgnoreCase("htm")) ? FileType.HTML : FileType.TEXT;
        try {
            this.loadResource(licenseFile.toURL());
        }
        catch (MalformedURLException e1) {
            logger.log(Level.WARNING, "Exception occurred while loading license text from file", e1);
        }
        JScrollPane scrollPane = this.fileType == FileType.HTML ? new JScrollPane(this.htmlPane) : new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LayoutUtils.addComponent(this.lblDescription, this.mainPanel, 0, 0, 1, 1, 2, 17, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(scrollPane, this.mainPanel, 0, 1, 1, 1, 1, 18, 1.0, 1.0, new Insets(5, 5, 5, 5));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnAccept, this.buttonPanel, 0, 0, 1, 1, 0, 12, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnDecline, this.buttonPanel, 2, 0, 1, 1, 0, 12, 0.0, 0.0, new Insets(5, 5, 5, 5));
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPanel, "Center");
        contentPane.add((Component)this.buttonPanel, "Last");
        this.pack();
        this.setLocationRelativeTo(owner);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if (actionCommand.equalsIgnoreCase("accept")) {
                    accepted = true;
                } else {
                    accepted = false;
                }
                dialog.setVisible(false);
            }
        };
        this.btnAccept.addActionListener(listener);
        this.btnDecline.addActionListener(listener);
        this.pack();
        this.setSize(640, 480);
        this.localize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 480);
    }

    public void localize() {
        String sLicenseTitle = null;
        sLicenseTitle = OiixOraparam.getOraparamProfileString((String)"LICENSE_TITLE", null);
        if (sLicenseTitle == null || sLicenseTitle.length() == 0) {
            sLicenseTitle = OiixResourceBundle.getString((String)"S_LICENSE_TITLE");
        }
        this.setTitle(sLicenseTitle);
        String text = null;
        text = OiixResourceBundle.getString((String)"S_LICENSE_DESCRIPTION");
        this.lblDescription.setText(text);
        text = OiixResourceBundle.getString((String)"S_LICENSE_ACCEPT_BUTTON");
        SwingUtils.setText(this.btnAccept, text);
        text = OiixResourceBundle.getString((String)"S_LICENSE_CANCEL_BUTTON");
        SwingUtils.setText(this.btnDecline, text);
    }

    public void loadResource(URL url) {
        if (url != null) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    buffer.append(line).append('\n');
                }
                if (this.fileType == FileType.TEXT) {
                    this.textArea.setText(buffer.toString());
                } else {
                    this.htmlPane.setText(buffer.toString());
                }
                in.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load license content", e);
            }
        }
    }

    private String getFileExtension(File licenseFile) {
        String ext = null;
        String name = licenseFile.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            ext = name.substring(dotIndex + 1);
        }
        return ext;
    }

    static enum FileType {
        HTML,
        TEXT;

    }
}

