/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.cluster.install.InstallException;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverEvent;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.ScriptExecutionJob;
import oracle.install.commons.base.util.ScriptExecutor;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationHelper;
import oracle.install.commons.util.ApplicationListener;
import oracle.install.commons.util.Console;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.InstallProgressMonitor;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUICommandHelper;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUIMetadata;
import oracle.install.driver.oui.OUITimeLogHandler;
import oracle.install.driver.oui.PrepareConfigJob;
import oracle.install.driver.oui.PrepareConfigJobEx;
import oracle.install.driver.oui.RootScriptException;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SRVMInstallExceptionHandler;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SessionInitProgressMonitor;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.ui.DefaultAlertHandler;
import oracle.install.driver.oui.ui.DefaultInstallCancelHandler;
import oracle.install.driver.oui.ui.DefaultRetryHandler;
import oracle.install.driver.oui.ui.LicenseInfoDialog;
import oracle.install.driver.oui.util.SetupSummary;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiic.OiicSystemPropertyConstants;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OUISetupDriver<T>
extends SetupDriver<T> {
    public static final String PROPERTY_PROXY_MAPPINGS = "oracle.install.driver.oui.proxyMappings";
    public static final String SKIP_ROOT_SCRIPT_EXEC_CONFIRMATION = "oracle.install.rootAutomation.skipConfirmationMessages";
    public static final String ORAINST_ROOT_SCRIPT_FILE = "orainstRoot.sh";
    public static final String PRINT_TIME_OPTION = "-printtime";
    private static Logger logger = Logger.getLogger(OUISetupDriver.class.getName());
    private OiifmAlertHandler alertHandler;
    private OiicInstallCancelHandler installCancelHandler;
    private OiifbIRetry retryHandler;
    private ApplicationListener pauseListener;
    private static final String STARTUP_LOCATION = System.getProperty("oracle.installer.startup_location");
    private static boolean isSetupWizard = Boolean.getBoolean("oracle.installer.setupWizard");
    private Resource stringResource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);

    public abstract SessionDetails getSessionDetails(SetupJob.OUISetupMode var1) throws SetupDriverException;

    public OUISetupDriver() {
        this.pauseListener = new ApplicationListener(){

            @Override
            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.PAUSE) {
                    OUISetupDriver.this.pause();
                } else if (e.getType() == ApplicationEvent.Type.RESUME) {
                    OUISetupDriver.this.resume();
                }
            }
        };
    }

    protected void prepareConfig(PrepareConfigJob configJob) throws SetupDriverException, IOException {
    }

    protected void prepareConfig(PrepareConfigJobEx configJob, String oracleHome, String aggCfgID) throws SetupDriverException, IOException {
    }

    protected URL getProxyMappingsURL() {
        URL mappingsURL = null;
        String url = System.getProperty(PROPERTY_PROXY_MAPPINGS);
        if (url != null) {
            try {
                mappingsURL = new URL(url);
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "Failed while using proxy mapping URL set in System.properties. Reason: {0}", e.getMessage());
            }
        }
        if (mappingsURL == null) {
            mappingsURL = this.getClass().getResource("/oracle/install/driver/oui/proxy-mappings.properties");
            logger.log(Level.INFO, "Using default oui proxy mapping URL");
        }
        return mappingsURL;
    }

    @Override
    public void load() throws SetupDriverException {
        ExceptionManager.getInstance().addExceptionHandler(InstallException.class, new SRVMInstallExceptionHandler());
        URL mappingsURL = this.getProxyMappingsURL();
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        try {
            proxyFactory.registerProxies(mappingsURL);
        }
        catch (IOException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        Application application = Application.getInstance();
        if (application.getUIType() == UIType.NONE) {
            System.setProperty("oracle.installer.silentLogs", "true");
        }
        this.verifyLicenseAgreement();
        if (Application.isCommandLineSwitchEnabled(PRINT_TIME_OPTION)) {
            Application.getInstance().addApplicationProgressListener(OUITimeLogHandler.getInstanse());
        }
    }

    protected void loadHandlers(Component owner) {
        this.alertHandler = new DefaultAlertHandler(owner);
        this.installCancelHandler = new DefaultInstallCancelHandler(owner);
        this.retryHandler = new DefaultRetryHandler(owner);
    }

    public void setup(SetupJob setupJob) throws SetupDriverException {
        OiicIOUIAPISession session;
        logger.log(Level.INFO, "Starting to setup " + setupJob.getId().toString());
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        if (sessionDetails != null && (session = this.initSession(setupJob)) != null) {
            try {
                OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
                apiInstaller.doOperation();
                OiifmIRootShInfo[] rootScripts = session.getRootShInfo();
                logger.log(Level.INFO, "Number of root scripts to be executed = " + (rootScripts != null ? rootScripts.length : 0));
                setupJob.setRootScripts(rootScripts);
                this.updateSetupSummary(setupJob);
            }
            catch (OiicIllegalStateException e) {
                throw new SetupDriverException(e);
            }
            catch (OiicInstallAPIException e) {
                throw new SetupDriverException(e);
            }
            catch (Exception e) {
                throw new SetupDriverException(e);
            }
            finally {
                this.closeSession(sessionDetails, session);
            }
        }
        logger.log(Level.INFO, "Completed setting up " + setupJob.getId().toString());
    }

    protected void log(Level level, String message, Object ... args) {
        if (this.progressUI != null) {
            this.progressUI.log(level, message, args);
        } else {
            logger.log(level, message, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertCentralInventoryNotLocked() {
        if (OiiiInstallAreaControl.isCleanMachine()) {
            return;
        }
        boolean locked = false;
        String appId = "installActions";
        String appVer = "11.2";
        int retryStatus = 16;
        do {
            OiicStandardInventorySession session = new OiicStandardInventorySession(appId, appVer);
            try {
                String status = this.stringResource.getString("OUISetupDriver.centralInventoryLockCheck.text", "Verifying whether Central Inventory is locked by any other OUI session...", new Object[0]);
                this.log(Level.INFO, status, new Object[0]);
                locked = false;
                session.initSession(1);
                status = this.stringResource.getString("OUISetupDriver.centralInventoryLockCheck.success.text", "Central Inventory is not locked.", new Object[0]);
                this.log(Level.INFO, status, new Object[0]);
            }
            catch (OiitTargetLockNotAvailableException e) {
                locked = true;
                String errorMessage = e.getLocalizedMessage();
                logger.log(Level.SEVERE, errorMessage);
                SetupMode setupMode = this.getSetupMode();
                if (setupMode != SetupMode.INTERACTIVE) continue;
                retryStatus = this.retryHandler.doModal(errorMessage, 18, 0);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unexpected error while checking Central Inventory", t);
            }
            finally {
                session.endSession();
            }
        } while (locked && retryStatus == 2);
        if (locked) {
            Application.getInstance().shutdown(OUIExitStatus.STOP_INSTALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup() throws SetupDriverException {
        String msg;
        Status status = Status.FAILED;
        CompositeJob setupJob = this.prepareJob();
        setupJob.calibrate();
        this.properties = new Properties();
        if (this.progressUI != null) {
            Iterator<Job> progressModel;
            Object owner = this.progressUI.getOwner();
            if (owner instanceof Component) {
                this.loadHandlers((Component)owner);
            }
            if ((progressModel = this.progressUI.getProgressModel()) != null) {
                ((ProgressModel)((Object)progressModel)).setCompositeJobs(setupJob);
            }
        }
        this.assertCentralInventoryNotLocked();
        List<Job> jobs = setupJob.getJobs();
        logger.log(Level.INFO, "-----------Job Distribution------------");
        for (Job job : jobs) {
            logger.log(Level.INFO, "{0} : {1}", new Object[]{job.getDescription(), Float.valueOf(job.getActualWeightage())});
        }
        logger.log(Level.INFO, "---------------------------------------");
        for (Job job : jobs) {
            long startTime = 0L;
            Object jobID = job.getId();
            try {
                Callable<?> work = job.getWork();
                if (work != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        Date date = JobHelper.getDateTime();
                        logger.log(Level.INFO, "Job :" + jobID + "[ Start Time : " + JobHelper.dateFormat.format(date) + "]");
                        startTime = date.getTime();
                    }
                    job.setStatus(Status.INPROGRESS);
                    work.call();
                }
            }
            catch (Exception e) {
                job.handleException(e);
            }
            finally {
                if (logger.isLoggable(Level.FINEST)) {
                    Date date = JobHelper.getDateTime();
                    logger.log(Level.INFO, "Job : " + jobID + "[ End Time : " + JobHelper.dateFormat.format(date) + "]");
                    long endTime = date.getTime();
                    logger.log(Level.INFO, "Job : " + jobID + " - Time Elapsed : " + (endTime - startTime) / 1000L + "seconds.");
                }
            }
            Status s = job.getStatus();
            logger.finest("Job:" + job.getDescription() + " completed with the status:" + (Object)((Object)s));
            if (s == Status.SUCCEEDED || s == Status.SUCCEEDED_PARTIALLY || !job.isRequired()) continue;
            break;
        }
        if ((msg = SetupSummary.getInstance().getText()) != null && msg.length() > 0 && this.getSetupMode() == SetupMode.SILENT) {
            Console.println(msg + "\n");
        }
        Application application = Application.getInstance();
        String message = this.stringResource.getString("OUISetupDriver.cleanup.statusMessage", "Cleaning up, please wait...", new Object[0]);
        StatusControl statusControl = application.getStatusControl();
        Application.showStatus(message);
        Application.hideStatus();
        status = setupJob.getStatus();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(JobHelper.getJobTreeAsString(setupJob));
        }
        super.fireSetupDriverEvent(new SetupDriverEvent(this, status));
    }

    @Override
    public void pause() throws IllegalStateException {
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        apiInstaller.suspendOperation();
    }

    @Override
    public void resume() throws IllegalStateException {
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        apiInstaller.resumeOperation();
    }

    @Override
    public void unload() throws SetupDriverException {
        try {
            DriverHelper.doCleanup();
        }
        catch (Exception e) {
            throw new SetupDriverException(e);
        }
    }

    protected OiicIOUIAPISession initSession(SetupJob setupJob) throws SetupDriverException {
        logger.log(Level.INFO, "Initializing setup " + setupJob.getId().toString());
        SessionDetails sessionDetails = this.getSessionDetails(setupJob.getOUISetupMode());
        HashMap hashMap = sessionDetails.getVariableMap();
        Set<String> securePropertySet = sessionDetails.getSecurePropertySet();
        if (securePropertySet == null && BeanStoreUtils.isBean(this.setupBean)) {
            try {
                securePropertySet = BeanStoreUtils.getSecurePropertySet(this.setupBean);
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Failed to get secure property set from the SetupBean.", e);
            }
        }
        DriverHelper.logSessionDetails(hashMap, securePropertySet);
        this.constructAdditionalProperties(hashMap);
        OiicIOUIAPISession session = null;
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        Hashtable table = apiInstaller.getCommandLineArgsTable();
        if (table != null && !table.isEmpty()) {
            Enumeration keys = table.keys();
            ArrayList<String> keysList = new ArrayList<String>();
            for (Object key : hashMap.keySet()) {
                keysList.add(key.toString().toLowerCase());
            }
            while (keys.hasMoreElements()) {
                String value;
                Object key = keys.nextElement();
                if (key == null || keysList.contains(key.toString().toLowerCase()) || (value = (String)table.get(key)) == null || value.length() <= 0) continue;
                hashMap.put(key, value);
            }
        }
        String useSeparateRemoteNodeOps = ApplicationHelper.getProperty("oracle.installer.remotecopy.standalone");
        boolean isSeparateRemoteNodeOps = false;
        if (useSeparateRemoteNodeOps != null && useSeparateRemoteNodeOps.length() > 0) {
            isSeparateRemoteNodeOps = Boolean.valueOf(useSeparateRemoteNodeOps);
        }
        if (isSetupWizard || isSeparateRemoteNodeOps && setupJob.isMultinodeSetup()) {
            try {
                apiInstaller.initLogLoc(OUILogHandler.getLogLocation(), OUILogHandler.getLogFilePrefix(), OUILogHandler.getLogFileExtension(), false);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to set custom log location.", e);
            }
        }
        if (Boolean.getBoolean("oracle.installer.crs.standalone.addnode")) {
            try {
                apiInstaller.initLogLoc(OUILogHandler.getLogLocation(), "addNodeActions", OUILogHandler.getLogFileExtension(), false);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to set custom log location.", e);
            }
        }
        try {
            ArrayList<SessionDetails> sessions = new ArrayList<SessionDetails>();
            sessions.add(sessionDetails);
            apiInstaller.registerInstallAPISession(sessions);
        }
        catch (Exception e) {
            throw new SetupDriverException(e);
        }
        try {
            SessionInitProgressMonitor sessionInitMonitor;
            OUILogHandler.setDirectLoggingEnabled(false);
            session = apiInstaller.initOUIAPISession();
            if (this.alertHandler != null) {
                session.addAlertHandler(this.alertHandler);
            }
            if (this.installCancelHandler != null) {
                session.addInstallCancelHandler(this.installCancelHandler);
            }
            if (this.retryHandler != null) {
                session.addRetryHandler(this.retryHandler);
            }
            if ((sessionInitMonitor = setupJob.getSessionInitMonitor()) != null) {
                sessionInitMonitor.setProgressUI(this.progressUI);
                session.setInterviewProgressListener((OiixProgressListener)sessionInitMonitor);
            }
            apiInstaller.prepareForInstallOperations();
            InstallProgressMonitor installProgressMonitor = setupJob.getInstallProgressMonitor();
            if (installProgressMonitor != null) {
                installProgressMonitor.setProgressUI(this.progressUI);
                session.setInstallProgresListener((OiifrProgressActionListener)installProgressMonitor);
            }
            Application application = Application.getInstance();
            application.addApplicationListener(this.pauseListener);
        }
        catch (OiicInstallAPIException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.INSTALL_COMMON_SESSION_INIT_FAILED, new Object[0]);
        }
        catch (OiicIllegalStateException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.INSTALL_COMMON_SESSION_INIT_FAILED, new Object[0]);
        }
        return session;
    }

    protected HashMap constructAdditionalProperties(HashMap hashMap) throws SetupDriverException {
        String oracle_home = hashMap.get("ORACLE_HOME").toString();
        File readmeLoc = new File(oracle_home, "install/readme.txt");
        hashMap.put("readme.exist", readmeLoc.exists());
        System.setProperty("readme.exist", String.valueOf(readmeLoc.exists()));
        hashMap.put("oracle_install_user", System.getProperty("user.name"));
        return hashMap;
    }

    @Override
    public String getProperty(String key) {
        OUIMetadata metadata = null;
        if (this.properties.isEmpty()) {
            this.properties = new Properties();
            File metadataFile = new File(STARTUP_LOCATION, File.separator + ".." + File.separator + "stage" + File.separator + "shiphomeproperties.xml");
            try {
                metadata = OUIMetadata.newInstance(metadataFile);
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, "Error on retrieving the metadata of shiphomeproperties xml", e1);
            }
            if (metadata != null && metadata.getProperties() != null) {
                this.properties.putAll(metadata.getProperties());
            }
        }
        if (this.properties.get(key) != null) {
            return this.properties.get(key).toString();
        }
        return null;
    }

    protected void closeSession(SessionDetails sessionDetails, OiicIOUIAPISession session) throws SetupDriverException {
        boolean bool = session.getISession().getContext().getSession().isSuccessfullInstallation();
        logger.info("isSuccessfullInstallation: " + bool);
        Summary.getInstance().setSuccessfullInstall(bool);
        boolean rbool = session.getISession().getContext().getSession().isSuccessfullRemoteInstallation();
        logger.info("isSuccessfullRemoteInstallation: " + rbool);
        Summary.getInstance().setSuccessfullRemoteInstall(rbool);
        int exitCode = OiicExitCode.getExitCode();
        OUIExitStatus exitStatus = OUIExitStatus.valueOf(exitCode);
        if (exitStatus == null) {
            exitStatus = bool ? OUIExitStatus.SUCCESS : (rbool ? OUIExitStatus.LOCAL_SUCCESS_REMOTE_FAILURE : OUIExitStatus.FAILURE);
        }
        Application.addExitStatus(exitStatus);
        Application application = Application.getInstance();
        application.removeApplicationListener(this.pauseListener);
        session.setInstallProgresListener(null);
        Application.getInstance().addApplicationListener(new ApplicationListener(){

            @Override
            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.SHUTDOWN) {
                    OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
                    apiInstaller.disposeInstance();
                }
            }
        });
    }

    @Override
    public void processCommandLine(String ... args) {
        String[] argsWithSharedInvFlag = new String[args.length + 1];
        System.arraycopy(args, 0, argsWithSharedInvFlag, 0, args.length);
        argsWithSharedInvFlag[args.length] = "-ignoreSharedInventory";
        args = argsWithSharedInvFlag;
        OiicAPIInstaller oiicInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        try {
            Field[] fields;
            oiicInstaller.processCommandLine(args);
            Hashtable table = oiicInstaller.getCommandLineArgsTable();
            if (table != null && !table.isEmpty()) {
                this.commandLineArgs = new Properties();
                this.commandLineArgs.putAll((Map<?, ?>)table);
                this.commandLineArgs.putAll(OUICommandHelper.getSetupArguments(args));
            }
            Class<OiicSystemPropertyConstants> clazz = OiicSystemPropertyConstants.class;
            for (Field field : fields = clazz.getFields()) {
                if (!field.getType().equals(String.class)) continue;
                try {
                    String value;
                    String key = (String)field.get(null);
                    if (key == null || (value = System.getProperty(key)) == null) continue;
                    super.setProperty(key, value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        catch (OiicInvalidCmdLineException e) {
            throw new IllegalArgumentException(e.getErrorMessage());
        }
    }

    @Deprecated
    protected void config(ConfigJob configJob, boolean retry) throws SetupDriverException, IOException {
    }

    protected void config(ConfigJob configJob) throws SetupDriverException, IOException {
        this.config(configJob, false);
    }

    protected void config(ConfigJob configJob, String oracleHome, String aggCfgID) throws SetupDriverException, IOException {
        this.config(configJob, oracleHome, aggCfgID, false);
    }

    protected void config(ConfigJob configJob, String oracleHome, String aggCfgID, boolean retry) throws SetupDriverException, IOException {
    }

    @Override
    public void showUsage() {
        System.setProperty("application.commandline.hideMutuallyExclusiveArgsNotMatchingContextOrPlatform", "true");
        CommandLineArgumentHandler commandLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        commandLineArgumentHandler.setContextId(System.getProperty("application.commandline.currentContextId", null));
        commandLineArgumentHandler.showHelp(Application.getInstance().getArguments());
    }

    @Deprecated
    protected void updateSetupSummary(SetupJob setupJob) {
        if (!setupJob.isConfigurationRequired() && SetupSummary.getInstance().isUpdateSummaryInSetup()) {
            SessionDetails sessionDetails = setupJob.getSessionDetails();
            File oracleHome = new File(sessionDetails.getOHLoc());
            SetupSummary summary = SetupSummary.getInstance();
            if (oracleHome != null && oracleHome.exists() && this.getSetupMode() == SetupMode.INTERACTIVE && sessionDetails.getVariableMap().get("readme.exist") == Boolean.FALSE) {
                summary.append(DriverHelper.getReadmeFileContent(oracleHome));
            }
        }
    }

    @Deprecated
    protected void updateSetupSummary(ConfigJob configJob) {
        SetupJob setupJob = configJob.getSetupJob();
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        File oracleHome = new File(sessionDetails.getOHLoc());
        SetupSummary summary = SetupSummary.getInstance();
        if (oracleHome != null && oracleHome.exists() && this.getSetupMode() == SetupMode.INTERACTIVE) {
            summary.append(DriverHelper.getReadmeFileContent(oracleHome));
        }
    }

    @Deprecated
    protected void updateSetupSummary(PrepareConfigJob prepareConfigJob) {
        SetupJob setupJob = prepareConfigJob.getSetupJob();
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        File oracleHome = new File(sessionDetails.getOHLoc());
        SetupSummary summary = SetupSummary.getInstance();
        if (this.getSetupMode() == SetupMode.SILENT) {
            Application application = Application.getInstance();
            summary.append(application.getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "configTools.message"), "", new File(new File(oracleHome, "cfgtoollogs").getPath(), OiiolTextLogger.s_sConfigToolCommands).getPath()));
        }
        if (oracleHome != null && oracleHome.exists() && this.getSetupMode() == SetupMode.INTERACTIVE) {
            summary.append(DriverHelper.getReadmeFileContent(oracleHome));
        }
    }

    public StatusMessages<ErrorMessage> verifyInventoryUpdation(SetupJob setupJob) {
        StatusMessages<ErrorMessage> messages = new StatusMessages<ErrorMessage>();
        OiifmIRootShInfo[] rootScripts = setupJob.getRootScripts();
        String[] nodes = null;
        String oraInstRootLoc = null;
        if (rootScripts != null && rootScripts.length > 0) {
            for (OiifmIRootShInfo rootSH : rootScripts) {
                if (!rootSH.getRootShLocation().contains(ORAINST_ROOT_SCRIPT_FILE)) continue;
                oraInstRootLoc = rootSH.getRootShLocation();
                nodes = rootSH.getNodeList();
                if (!isSetupWizard || InventoryInfo.getInstance().isInventoryExist()) break;
                String localhostname = this.getLocalMachineName();
                if (nodes != null) {
                    ArrayList<String> nodesList = new ArrayList<String>(Arrays.asList(nodes));
                    if (StringUtils.containsIgnoreCase(nodesList, localhostname)) break;
                    nodesList.add(0, localhostname);
                    nodes = nodesList.toArray(new String[0]);
                    break;
                }
                nodes = new String[]{localhostname};
                break;
            }
        }
        try {
            String fileLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
            if (fileLoc != null && fileLoc.length() > 0) {
                File invLoc = new File(fileLoc);
                if (nodes == null || nodes.length == 0 || nodes.length == 1) {
                    if (invLoc == null || !invLoc.exists()) {
                        messages.add(new DefaultErrorMessage((ErrorCode)InstallEngineErrorCode.INVENTORY_NOT_UPDATED_WITH_HOME, oraInstRootLoc));
                    }
                } else {
                    void localNode = nodes[0];
                    ArrayList<Object> failedNodes = new ArrayList<Object>();
                    for (String nodeName : nodes) {
                        if (!nodeName.equalsIgnoreCase((String)localNode)) {
                            if (OiipgClusterOps.fileExistsOnNode((String)nodeName, (String)fileLoc)) continue;
                            failedNodes.add(nodeName);
                            continue;
                        }
                        if (invLoc != null && invLoc.exists()) continue;
                        failedNodes.add(localNode);
                    }
                    if (failedNodes != null && failedNodes.size() > 0) {
                        logger.log(Level.INFO, "orainstRoot.sh has not been executed on nodes: " + failedNodes);
                        messages.add(new DefaultErrorMessage((ErrorCode)InstallEngineErrorCode.INVENTORY_NOT_UPDATED_WITH_HOME_MULTINODE_WARN, oraInstRootLoc, failedNodes));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception occured while validating inventory updataion." + e.getMessage());
        }
        return messages;
    }

    public String getLocalMachineName() {
        String localMachineName = PlatformInfo.getInstance().getFullHostName();
        if (localMachineName.indexOf(".") >= 0) {
            localMachineName = localMachineName.substring(0, localMachineName.indexOf("."));
        }
        return localMachineName;
    }

    public void verifyLicenseAgreement() throws SetupDriverException {
        Application application = Application.getInstance();
        String licenseFile = this.getLicenseFileName();
        if (!Boolean.getBoolean("oracle.install.skipLicenseMessage") && licenseFile != null && licenseFile.length() > 0) {
            if (application.getUIType() == UIType.GRAPHICAL) {
                if (!LicenseInfoDialog.showDialog(null, new File(licenseFile))) {
                    logger.log(Level.SEVERE, "License agreement declined");
                    application.shutdown(OUIExitStatus.STOP_INSTALL);
                }
            } else {
                Object[] args = new Object[]{licenseFile};
                if (Boolean.valueOf(DriverHelper.getValue("ACCEPT_LICENSE_AGREEMENT")).booleanValue()) {
                    OiiolTextLogger.writeMessageToConsole((String)OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SILENT_LICENSE_TRUE", (Object[])args));
                } else {
                    String sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SILENT_LICENSE_FALSE", (Object[])args);
                    logger.log(Level.SEVERE, "License agreement declined");
                    OiiolTextLogger.writeMessageToConsole((String)sMsg);
                    application.shutdown(OUIExitStatus.STOP_INSTALL);
                }
            }
        }
    }

    public String getLicenseFileName() {
        String licenseFile = DriverHelper.getLicenseFileLocation();
        if (licenseFile == null) {
            licenseFile = Application.getInstance().getString("oracle.install.licenseFile.location", null, new Object[0]);
        }
        return licenseFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRootScripts(List<OiifmIRootShInfo> rootScriptsList, RootScriptJob rootScriptJob, boolean retry) throws Exception {
        OiifmIRootShInfo[] rootScripts = rootScriptsList.toArray(new OiifmIRootShInfo[0]);
        if (rootScripts.length > 0) {
            List<Job> jobs;
            if (!retry) {
                jobs = this.populateRootScriptJobs(rootScripts);
                if (jobs.size() > 0) {
                    for (Job job : jobs) {
                        rootScriptJob.add(job);
                    }
                } else {
                    logger.log(Level.INFO, "populated root script job list is empty");
                    rootScriptJob.setStatus(Status.FAILED);
                    return;
                }
                rootScriptJob.calibrate();
            }
            jobs = null;
            if (retry) {
                jobs = rootScriptJob.getRetriableJobs();
                if (jobs != null) {
                    JobHelper.reexecuteJobs(jobs);
                    if (rootScriptJob.getStatus() != Status.SUCCEEDED && rootScriptJob.getStatus() != Status.SUCCEEDED_PARTIALLY) {
                        rootScriptJob.doPostRootScriptAction();
                    }
                }
            } else {
                Advice advice = null;
                if (this.getSetupMode() != SetupMode.SILENT) {
                    if (!PlatformInfo.getInstance().isWindows() && !Boolean.getBoolean(SKIP_ROOT_SCRIPT_EXEC_CONFIRMATION)) {
                        String message = this.stringResource.getString("OUISetupDriver.configScriptExecution.startMessage", "Configuration scripts generated by the Installer needs to be run as a privileged user (root). Installer will run the these scripts using the privileged user credentials provided earlier.", new Object[0]);
                        advice = ExceptionManager.advise(new DefaultErrorMessage(message, Severity.WARNING));
                    } else {
                        if (System.getenv("WAIT_BEFORE_ROOT_EXECUTION") != null) {
                            advice = ExceptionManager.advise(new DefaultErrorMessage("Click Yes to proceed with the execution of the configuration scripts", Severity.WARNING));
                        }
                        advice = Advice.CONTINUE;
                    }
                } else {
                    advice = Advice.CONTINUE;
                }
                if (advice == Advice.CONTINUE) {
                    jobs = rootScriptJob.getJobs();
                    for (Job job : jobs) {
                        Status s;
                        Date date;
                        long startTime = 0L;
                        Object jobID = job.getId();
                        try {
                            if (logger.isLoggable(Level.FINEST)) {
                                date = JobHelper.getDateTime();
                                logger.log(Level.INFO, "Job :" + jobID + "[ Start Time : " + JobHelper.dateFormat.format(date) + "]");
                                startTime = date.getTime();
                            }
                            job.getWork().call();
                        }
                        catch (RootScriptException rsex) {
                            job.handleException(rsex);
                        }
                        catch (Exception ex) {
                            job.handleException(ex);
                        }
                        finally {
                            if (logger.isLoggable(Level.FINEST)) {
                                date = JobHelper.getDateTime();
                                logger.log(Level.INFO, "Job : " + jobID + "[ End Time : " + JobHelper.dateFormat.format(date) + "]");
                                long endTime = date.getTime();
                                logger.log(Level.INFO, "Job : " + jobID + " - Time Elapsed : " + (endTime - startTime) / 1000L + "seconds.");
                            }
                        }
                        if ((s = job.getStatus()) == Status.SUCCEEDED || s == Status.SUCCEEDED_PARTIALLY || s == Status.IGNORED || !job.isRequired()) continue;
                        break;
                    }
                    if (rootScriptJob.getStatus() != Status.SUCCEEDED && rootScriptJob.getStatus() != Status.SUCCEEDED_PARTIALLY) {
                        rootScriptJob.doPostRootScriptAction();
                    }
                } else {
                    logger.log(Level.WARNING, "User has not selected automatic config script execution.");
                    rootScriptJob.setStatus(Status.FAILED);
                }
            }
        }
    }

    protected List<Job> populateRootScriptJobs(OiifmIRootShInfo[] rootScripts) {
        ArrayList<Job> jobList = new ArrayList<Job>();
        if (rootScripts != null && rootScripts.length > 0) {
            ScriptExecutor<?> executor = this.getRootScriptExecutor();
            if (executor != null) {
                LinkedHashMap<File, List<String>> scriptNodesMap = new LinkedHashMap<File, List<String>>();
                HashMap<File, List<String>> scriptArgsMap = new HashMap<File, List<String>>();
                for (OiifmIRootShInfo script : rootScripts) {
                    String scriptName = script.getRootShLocation();
                    String[] nodes = script.getNodeList();
                    ArrayList<String> ouiNodeList = new ArrayList<String>();
                    if (nodes == null || nodes.length == 0) {
                        logger.log(Level.INFO, "Node list for the script:[" + scriptName + "] is empty. So considering local node");
                        String localNode = OiixNetOps.getMachineName((String)PlatformInfo.getInstance().getFullHostName());
                        ouiNodeList.add(localNode);
                    } else {
                        Object setupDriver = SetupDriver.getInstance();
                        List<String> currentNodeList = ((SetupDriver)setupDriver).getNodeList();
                        ouiNodeList.addAll(Arrays.asList(nodes));
                        if (currentNodeList != null && !currentNodeList.isEmpty() && ouiNodeList != null && !ouiNodeList.isEmpty()) {
                            ouiNodeList.retainAll(currentNodeList);
                        }
                        if (ouiNodeList.isEmpty()) {
                            logger.log(Level.INFO, "Node list for the script:[" + scriptName + "] is empty. So considering local node");
                            String localNode = OiixNetOps.getMachineName((String)PlatformInfo.getInstance().getFullHostName());
                            ouiNodeList.add(localNode);
                        }
                    }
                    File file = new File(scriptName);
                    if (!scriptName.contains(ORAINST_ROOT_SCRIPT_FILE) && !Boolean.getBoolean("oracle.install.rootautomation.skipSilentFlag")) {
                        scriptArgsMap.put(file, Arrays.asList("-silent"));
                    }
                    scriptNodesMap.put(file, ouiNodeList);
                }
                String description = Application.getInstance().getString(ResourceURL.resURL(DriverConstants.STRING_RESOURCE_BUNDLE_NAME, "RootScriptExecutionJob.txt"), "Running root scripts using specified configuration method", new Object[0]);
                logger.log(Level.FINE, "Creating script executor job for scriptNodesMap:" + scriptNodesMap);
                ScriptExecutionJob job = new ScriptExecutionJob("AutomaticRootScriptExec", description, 1.0f, executor, scriptNodesMap);
                job.setProgressUI(this.getProgressUI());
                job.setScriptArgsMap(scriptArgsMap);
                jobList.add(job);
            } else {
                logger.log(Level.INFO, "Script executor is null");
            }
        }
        return jobList;
    }

    public abstract ScriptExecutor<?> getRootScriptExecutor();

    protected void updateGlobalVars(String filePath, Map<String, String> newVars) {
        if (filePath == null) {
            return;
        }
        File globalVarsFile = new File(filePath);
        if (!globalVarsFile.exists()) {
            return;
        }
        if (newVars == null) {
            return;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not update globalvariables.xml file.", e);
        }
        if (docBuilder != null) {
            Document doc = null;
            try {
                doc = docBuilder.parse(globalVarsFile);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not open: " + filePath, e);
            }
            if (doc != null) {
                boolean updated = false;
                NodeList vars = doc.getElementsByTagName("VAR");
                if (vars != null) {
                    block8: for (String key : newVars.keySet()) {
                        for (int i = 0; i < vars.getLength(); ++i) {
                            String nameText;
                            Node name;
                            NamedNodeMap attrs;
                            Node var = vars.item(i);
                            if (var == null || (attrs = var.getAttributes()) == null || (name = attrs.getNamedItem("NAME")) == null || (nameText = name.getTextContent()) == null || !key.equals(nameText)) continue;
                            Node value = attrs.getNamedItem("VALUE");
                            if (value == null) continue block8;
                            String oldValue = value.getTextContent();
                            if (oldValue == null) {
                                oldValue = "NULL";
                            }
                            logger.log(Level.INFO, "Variable '" + key + "' old value: " + oldValue);
                            String newValue = newVars.get(key);
                            value.setTextContent(newValue);
                            logger.log(Level.INFO, "Variable '" + key + "' new value: " + newValue);
                            updated = true;
                            continue block8;
                        }
                    }
                }
                if (updated) {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = null;
                    try {
                        transformer = transformerFactory.newTransformer();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Could not complete the globalvariables.xml file update.", e);
                    }
                    if (transformer != null) {
                        DOMSource source = new DOMSource(doc);
                        StreamResult result = new StreamResult(globalVarsFile);
                        try {
                            transformer.transform(source, result);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Could not write the update changes for the globalvariables.xml", e);
                        }
                    }
                }
            }
        }
    }

    class RestartInstaller
    implements ApplicationListener {
        RestartInstaller() {
        }

        @Override
        public void update(ApplicationEvent e) {
            if (e.getType() == ApplicationEvent.Type.RESTART) {
                // empty if block
            }
        }
    }
}

