/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.net.NetworkUtility;
import oracle.install.commons.net.support.SSHConnectivityDetails;
import oracle.install.commons.net.support.SSHConnectivitySetupInfo;
import oracle.install.commons.net.support.SSHSetupPolicy;
import oracle.install.commons.net.support.SSHSupportErrorCode;
import oracle.install.commons.net.support.SSHSupportManager;
import oracle.install.commons.net.support.SSHSupportManagerException;
import oracle.install.commons.net.support.SSHSupportStatusCode;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.message.grid.FixedGridContent;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUILogHandler;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.util.RunCtlCommand;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.prov.ssh.FileLockException;
import oracle.sysman.prov.ssh.SSHSetup;
import oracle.sysman.prov.ssh.SSHSetupException;

public class OUISSHSupportManager
extends SSHSupportManager {
    private static final Logger logger = Logger.getLogger(OUISSHSupportManager.class.getName());
    private String logFile;
    private static int count = 1;
    private static final String LOG_FILE_FORMAT = "sshsetup%s_.log";
    private static final String UNKNOWN_CAUSE = "unknown";
    private static final String REMOTE_INTERFACES_LOG_LOC = "oracle.sysman.prov.riLogLoc";
    private Resource resource;

    public OUISSHSupportManager() {
        String pathLocProperty;
        String scratchPath = System.getProperty("oracle.installer.scratchPath");
        if (scratchPath == null) {
            scratchPath = System.getProperty("java.io.tmpdir");
        }
        if ((pathLocProperty = System.getProperty("oracle.sysman.prov.PathsPropertiesLoc")) == null) {
            System.setProperty("oracle.sysman.prov.PathsPropertiesLoc", scratchPath + File.separator + "oui" + File.separator + "prov" + File.separator + "resources");
        }
        File ouiLogFile = OUILogHandler.getLogFile();
        String ouiLogFileLoc = OUILogHandler.getLogLocation();
        this.logFile = ouiLogFile != null ? new File(ouiLogFile.getParent(), LOG_FILE_FORMAT).getPath() : (ouiLogFileLoc != null ? new File(ouiLogFileLoc, LOG_FILE_FORMAT).getPath() : new File(scratchPath, LOG_FILE_FORMAT).getPath());
        if (ouiLogFileLoc != null) {
            System.setProperty(REMOTE_INTERFACES_LOG_LOC, ouiLogFileLoc);
        }
        Application application = Application.getInstance();
        this.resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
    }

    @Override
    public SSHConnectivityDetails establishSSHConnectivity(SSHConnectivitySetupInfo setupInfo) throws SSHSupportManagerException {
        if (!super.isSetupEnabled()) {
            throw new SSHSupportManagerException((ErrorCode)SSHSupportErrorCode.SETUP_DISABLED, new Object[0]);
        }
        SSHConnectivityDetails details = new SSHConnectivityDetails();
        if (setupInfo != null) {
            String sharedUsername = setupInfo.getSharedUsername();
            details.setSharedUserName(sharedUsername);
            String[] nodes = setupInfo.getNodes();
            if (nodes != null && nodes.length > 0) {
                TreeSet<String> nodeSet = new TreeSet<String>();
                nodeSet.addAll(Arrays.asList(nodes));
                details.setUnconfiguredNodes(nodes);
                if (sharedUsername != null) {
                    try {
                        String logFile = String.format(this.logFile, count++);
                        logger.log(Level.INFO, "SSH Support Manager logs will be written to {0}", logFile.substring(0, logFile.lastIndexOf(46)) + OiiolLoggerUtil.getTimeStamp() + ".log");
                        SSHSetup sshSetup = new SSHSetup(setupInfo.getSharedPassword(), false, logFile);
                        sshSetup.setnoDelete();
                        String message = this.resource.getEnumString(SSHSupportStatusCode.ESTABLISHING_PASSWORDLESS_SSH_CONNECTIVITY, "Establishing SSH connectivity between the selected nodes. This may take several minutes. Please wait...", nodeSet);
                        Application.showStatus(message);
                        SSHSetupPolicy setupPolicy = super.getSetupPolicy();
                        boolean advanced = setupPolicy == SSHSetupPolicy.BIDIRECTIONAL;
                        logger.log(Level.INFO, "SSH Setup policy used: {0}", (Object)setupPolicy);
                        logger.log(Level.INFO, "SSH Setup isReuseKeys used: {0}", setupInfo.isReuseKeys());
                        logger.log(Level.INFO, "SSH Setup ExstingNodes used: {0}", Arrays.toString(setupInfo.getExstingNodes()));
                        logger.log(Level.INFO, "SSH Setup NewNodes used: {0}", Arrays.toString(setupInfo.getNodes()));
                        logger.log(Level.INFO, "SSH Setup SharedUsername used: {0}", setupInfo.getSharedUsername());
                        logger.log(Level.INFO, "SSH Setup isSharedHome used: {0}", setupInfo.isSharedHome());
                        logger.log(Level.INFO, "SSH Setup advanced used: {0}", advanced);
                        long startTime = System.currentTimeMillis();
                        sshSetup.setupConnectivity(setupInfo.isReuseKeys(), setupInfo.getExstingNodes(), setupInfo.getNodes(), setupInfo.getSharedUsername(), setupInfo.isSharedHome(), advanced, null, null, null);
                        long finishTime = System.currentTimeMillis();
                        logger.log(Level.INFO, "Total time taken to complete verification is {0} ms.", finishTime - startTime);
                        details.setConfiguredNodes(nodeSet);
                        message = this.resource.getEnumString(SSHSupportStatusCode.PASSWORDLESS_SSH_CONNECTIVITY_ESTABLISHED, "Successfully established passwordless SSH connectivity between the selected nodes.", nodeSet);
                        details.setOverallStatusMessage(new DefaultStatusMessage(Level.INFO, message));
                    }
                    catch (SSHSetupException e) {
                        logger.log(Level.WARNING, "Failed to establish SSH connectivity between the selected nodes");
                        String[] failedNodes = e.getFailedNodes();
                        if (failedNodes != null && failedNodes.length > 0) {
                            logger.log(Level.INFO, "Building failure details of failed nodes...");
                            details.setUnconfiguredNodes(failedNodes);
                            nodeSet.removeAll(details.getUnconfiguredNodes());
                            details.setConfiguredNodes(nodeSet);
                            HashSet<ErrorCode> errorCodeSet = new HashSet<ErrorCode>();
                            for (String failedNode : failedNodes) {
                                Throwable t = e.getExceptionOnNode(failedNode);
                                String cause = t == null ? UNKNOWN_CAUSE : t.getMessage();
                                ErrorCode errorCode = this.getErrorCode(cause);
                                errorCodeSet.add(errorCode);
                                DefaultErrorMessage errorMessage = new DefaultErrorMessage(t, errorCode, new Object[0]);
                                details.addStatusMessage(failedNode, errorMessage);
                                logger.log(Level.WARNING, "Failed to establish SSH connectivity with node {0}. Reason: {1}", new Object[]{failedNode, errorMessage.getMessage()});
                                String command = e.getFailedCommandForNode(failedNode);
                                String message = this.resource.getString("OUISSHSupportManager.commandExecution.failed", "Failed to execute the following command on node {0}: {1}", failedNode, command);
                                logger.log(Level.WARNING, message);
                                errorMessage = new DefaultErrorMessage(message);
                                details.addStatusMessage(failedNode, errorMessage);
                            }
                            DefaultErrorMessage overallMessage = null;
                            overallMessage = errorCodeSet.contains(SSHSupportErrorCode.AUTHENTICATION_FAILED) ? new DefaultErrorMessage((ErrorCode)SSHSupportErrorCode.AUTHENTICATION_FAILED, new Object[0]) : new DefaultErrorMessage((ErrorCode)SSHSupportErrorCode.FAILED_TO_ESTABLISH_SSH_CONNECTIVITY, details.getUnconfiguredNodes());
                            File logFile = LogManager.getInstance().getDefaultLogFile();
                            if (logFile != null) {
                                PlainContent extraDetails = new PlainContent(logFile.getAbsolutePath());
                                extraDetails.setTitle(this.resource.getString("ConfigProgressMonitor.logTitle", "Log File Location", new Object[0]));
                                overallMessage.getErrorInfo().setExtraDetails(extraDetails);
                            }
                            details.setOverallStatusMessage(overallMessage);
                        }
                        Throwable cause = e.getCause();
                        if (cause instanceof FileLockException) {
                            throw new SSHSupportManagerException((ErrorCode)SSHSupportErrorCode.FILE_OPERATION_PERMISSION_DENIED, new Object[0]);
                        }
                        throw new SSHSupportManagerException((Throwable)e, (ErrorCode)SSHSupportErrorCode.INTERNAL_DRIVER_ERROR, new Object[0]);
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "Failed to establish SSH connectivity between the selected nodes", e);
                        throw new SSHSupportManagerException(e, (ErrorCode)SSHSupportErrorCode.INTERNAL_DRIVER_ERROR, new Object[0]);
                    }
                    finally {
                        Application.showStatus(null);
                    }
                } else {
                    logger.log(Level.INFO, "sharedUsername not provided");
                }
            } else {
                logger.log(Level.INFO, "nodes not provided");
            }
        }
        return details;
    }

    private ErrorCode getErrorCode(String message) {
        SSHSupportErrorCode errorCode = null;
        if ("Auth fail".equals(message)) {
            errorCode = SSHSupportErrorCode.AUTHENTICATION_FAILED;
        } else if (UNKNOWN_CAUSE.equals(message)) {
            errorCode = SSHSupportErrorCode.INTERNAL_DRIVER_ERROR;
        }
        return errorCode;
    }

    @Override
    public SSHConnectivityDetails getSSHConnectivityDetails(String[] nodes, String sharedUserName, char[] passphrase) throws SSHSupportManagerException {
        if (!super.isSetupCheckEnabled() || !DriverHelper.isCVUEnabled()) {
            throw new SSHSupportManagerException((ErrorCode)SSHSupportErrorCode.SETUP_CHECK_DISABLED, new Object[0]);
        }
        SSHConnectivityDetails details = new SSHConnectivityDetails();
        details.setSharedUserName(sharedUserName);
        if (nodes != null && nodes.length > 0) {
            details.setUnconfiguredNodes(nodes);
            try {
                ClusterVerification cvu = ClusterVerification.getInstance();
                logger.log(Level.INFO, "Preparing to check passwordless SSH Connectivity between nodes: {0}", Arrays.asList(nodes).toString());
                String message = this.resource.getEnumString(SSHSupportStatusCode.CHECKING_PASSWORDLESS_SSH_CONNECTIVITY, "Testing passwordless SSH connectivity between the selected nodes. This may take several minutes, please wait...", new Object[0]);
                Application.showStatus(message);
                VerificationResultSet resultSet = cvu.checkUserEquiv(nodes, EnumSet.of(UserEquivCheckType.CV_EQUIV_SSH));
                if (resultSet != null) {
                    OverallStatus status = resultSet.getOverallStatus();
                    logger.log(Level.INFO, "OverallStatus of User Equivalence check using CVU is {0}", status);
                    NetworkUtility networkUtility = NetworkUtility.getInstance();
                    String localNode = null;
                    for (String node : nodes) {
                        logger.log(Level.FINEST, "Checking whether {0} is a local node or not. ", node);
                        if (!networkUtility.isLocalHost(node)) continue;
                        localNode = node;
                        logger.log(Level.FINEST, "Identified {0} as the local node.", node);
                        break;
                    }
                    Set<String> unconfiguredNodes = new TreeSet<String>();
                    TreeSet<String> configuredNodes = new TreeSet<String>();
                    switch (status) {
                        case OPERATION_FAILED: 
                        case VERIFICATION_FAILED: {
                            List errors = resultSet.getErrors();
                            for (VerificationError error : errors) {
                                logger.log(Level.INFO, "VerificationError: {0}", error.getCause());
                            }
                            if (resultSet.hasNodeResults()) {
                                try {
                                    List nodeResults = resultSet.getNodeResults();
                                    if (nodeResults != null) {
                                        for (VerificationResult nodeResult : nodeResults) {
                                            String node = nodeResult.getNode();
                                            StatusMessages<StatusMessage> messages = details.getStatusMessages(node);
                                            List nodeSpecificErrors = nodeResult.getErrors();
                                            for (VerificationError error : nodeSpecificErrors) {
                                                messages.add(new DefaultErrorMessage(error.getErrorMessage()));
                                            }
                                        }
                                    }
                                }
                                catch (NodeResultsUnavailableException e) {
                                    logger.log(Level.INFO, "Node specific results are not available.");
                                }
                            }
                            List failedNodes = resultSet.getFailedNodes();
                            if (nodes != null && failedNodes != null && !failedNodes.isEmpty()) {
                                for (String s : nodes) {
                                    int index = StringUtils.indexOfIgnoreCase(failedNodes, s);
                                    if (index < 0) continue;
                                    failedNodes.set(index, s);
                                }
                            }
                            if (failedNodes == null || failedNodes.isEmpty()) break;
                            unconfiguredNodes.addAll(failedNodes);
                            if (localNode == null || unconfiguredNodes.contains(localNode)) break;
                            unconfiguredNodes.add(localNode);
                        }
                    }
                    List successfulNodes = resultSet.getSuccessfulNodes();
                    if (nodes != null && successfulNodes != null && !successfulNodes.isEmpty()) {
                        for (String s : nodes) {
                            int index = StringUtils.indexOfIgnoreCase(successfulNodes, s);
                            if (index < 0) continue;
                            successfulNodes.set(index, s);
                        }
                    }
                    if (successfulNodes != null) {
                        configuredNodes.addAll(successfulNodes);
                        if (localNode != null && unconfiguredNodes.contains(localNode)) {
                            configuredNodes.remove(localNode);
                        }
                    }
                    details.setUnconfiguredNodes(unconfiguredNodes);
                    details.setConfiguredNodes(configuredNodes);
                    if (details.isConfigurationComplete() && localNode != null && nodes.length > 1 && super.getSetupCheckPolicy() == SSHSetupPolicy.BIDIRECTIONAL) {
                        unconfiguredNodes = this.getUnconfiguredRemoteNodes(localNode, details.getConfiguredNodes());
                        details.setUnconfiguredNodes(unconfiguredNodes);
                    }
                }
                StatusMessage overallStatusMessage = null;
                if (details.isConfigurationComplete()) {
                    message = this.resource.getEnumString(SSHSupportStatusCode.PASSWORDLESS_SSH_CONNECTIVITY_EXIST, "Passwordless SSH connectivity between the selected nodes already established.", new Object[0]);
                    overallStatusMessage = new DefaultStatusMessage(Level.INFO, message);
                } else {
                    overallStatusMessage = new DefaultErrorMessage((ErrorCode)SSHSupportErrorCode.PASSWORDLESS_SSH_CONNECTIVITY_NOT_SETUP, details.getUnconfiguredNodes());
                }
                details.setOverallStatusMessage(overallStatusMessage);
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Failed to check SSH Connectivity using CVU.", e);
                throw new SSHSupportManagerException(e, (ErrorCode)SSHSupportErrorCode.UNABLE_TO_GET_CONNECTIVITY_DETAILS, new Object[0]);
            }
        }
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getUnconfiguredRemoteNodes(String localNode, Set<String> nodes) {
        logger.log(Level.INFO, "Finding passwordless SSH connectivity setup on remote nodes");
        TreeSet<String> unconfiguredRemoteNodes = new TreeSet<String>();
        logger.log(Level.INFO, "Preparing remote commands to check passwordless SSH connectivity setup on remote nodes");
        Vector<SSHSetupVerificationCommand> tasks = new Vector<SSHSetupVerificationCommand>();
        SSHSupportManager supportManager = SSHSupportManager.getInstance();
        if (nodes.size() > supportManager.getSshdMaxStartups()) {
            supportManager.setSshdLockRequired(true);
        }
        for (String node : nodes) {
            if (node.equals(localNode)) continue;
            for (String remoteNode : nodes) {
                tasks.add(new SSHSetupVerificationCommand(node, remoteNode));
            }
        }
        logger.log(Level.INFO, "Total number of remote commands to be executed is {0}", tasks.size());
        boolean overallStatus = true;
        try {
            long startTime = System.currentTimeMillis();
            ClusterCmd clusterCmd = new ClusterCmd();
            overallStatus = clusterCmd.submit(tasks);
            long finishTime = System.currentTimeMillis();
            logger.log(Level.INFO, "Total time taken to complete verification is {0} ms.", finishTime - startTime);
        }
        catch (ClusterException e) {
            overallStatus = false;
            logger.log(Level.WARNING, "Failed while executing remote commands to check SSH connectivity to other nodes.", e);
        }
        finally {
            SSHSetupVerificationCommand.clearSemaphoreMaps();
        }
        if (!overallStatus) {
            TreeMap<String, TreeSet<String>> unconfiguredNodesMap = new TreeMap<String, TreeSet<String>>();
            for (SSHSetupVerificationCommand command : tasks) {
                boolean success = command.getStatus();
                if (success) continue;
                String sourceNode = command.getSourceNode();
                unconfiguredRemoteNodes.add(sourceNode);
                logger.log(Level.INFO, "Source Node: " + sourceNode + "  Target Node: " + command.getTargetNode());
                logger.log(Level.INFO, "Exception: " + command.getException());
                logger.log(Level.INFO, "Status log: " + command.getStatusLogger().getLog());
                TreeSet<String> unconfiguredNodes = (TreeSet<String>)unconfiguredNodesMap.get(sourceNode);
                if (unconfiguredNodes == null) {
                    unconfiguredNodes = new TreeSet<String>();
                    unconfiguredNodesMap.put(sourceNode, unconfiguredNodes);
                }
                unconfiguredNodes.add(command.getTargetNode());
            }
            logger.log(Level.INFO, "Remote node(s) not configured for passwordless SSH connectivity : {0}", unconfiguredRemoteNodes);
            FixedGridContent report = new FixedGridContent(unconfiguredNodesMap, "NODE", "REMOTE NODES");
            logger.log(Level.INFO, "Details about the list of remote node(s), not configured for passwordless SSH connectivity\n{0}", report.toString());
        } else {
            logger.log(Level.INFO, "All remote nodes are configured for passwordless SSH connectivity");
        }
        return unconfiguredRemoteNodes;
    }

    static class SSHSetupVerificationCommand
    extends RunCtlCommand {
        private static final String[] ENV = new String[0];
        private String sourceNode;
        private String targetNode;
        private static Map<String, Semaphore> targetNodeSemaphoreMap = new TreeMap<String, Semaphore>();
        private static Map<String, Semaphore> sourceNodeSemaphoreMap = new TreeMap<String, Semaphore>();

        public SSHSetupVerificationCommand(String sourceNode, String targetNode) {
            super("/usr/local/bin/ssh", new String[]{" -o FallBackToRsh=no ", " -o PasswordAuthentication=no ", " -o StrictHostKeyChecking=yes ", " -o NumberOfPasswordPrompts=0 ", targetNode, "/usr/bin/true"}, ENV, sourceNode);
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            SSHSupportManager supportManager = SSHSupportManager.getInstance();
            if (supportManager.isSshdLockRequired()) {
                if (!sourceNodeSemaphoreMap.containsKey(sourceNode)) {
                    sourceNodeSemaphoreMap.put(sourceNode, new Semaphore(supportManager.getAvailableSshdLocks(), true));
                }
                if (!targetNodeSemaphoreMap.containsKey(targetNode)) {
                    targetNodeSemaphoreMap.put(targetNode, new Semaphore(supportManager.getAvailableSshdLocks(), true));
                }
            }
        }

        public String getSourceNode() {
            return this.sourceNode;
        }

        public String getTargetNode() {
            return this.targetNode;
        }

        public static void clearSemaphoreMaps() {
            sourceNodeSemaphoreMap.clear();
            targetNodeSemaphoreMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean execute() {
            SSHSupportManager supportManager = SSHSupportManager.getInstance();
            if (supportManager.isSshdLockRequired()) {
                Semaphore sourceNodeSemaphore = sourceNodeSemaphoreMap.get(this.sourceNode);
                Semaphore targetNodeSemaphore = targetNodeSemaphoreMap.get(this.targetNode);
                boolean result = false;
                long timeout = supportManager.getSetupCheckTimeout();
                boolean sourceNodeLockAcquired = false;
                boolean targetNodeLockAcquired = false;
                try {
                    sourceNodeLockAcquired = sourceNodeSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "Interrupted Excepiton occured while waiting for Source node (" + this.sourceNode + ") lock.");
                }
                try {
                    targetNodeLockAcquired = targetNodeSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "Interrupted Excepiton occured while waiting for Target node (" + this.targetNode + ") lock.");
                }
                try {
                    result = super.execute();
                }
                finally {
                    if (sourceNodeLockAcquired) {
                        try {
                            sourceNodeSemaphore.release();
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Excepiton occured while releasing the Source node (" + this.sourceNode + ") lock.");
                        }
                    }
                    if (targetNodeLockAcquired) {
                        try {
                            targetNodeSemaphore.release();
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Excepiton occured while releasing the Target node (" + this.targetNode + ") lock.");
                        }
                    }
                }
                return result;
            }
            return super.execute();
        }
    }
}

