/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.StringResourceBundle;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicCmdLineProperty;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;

public class OUICommandHelper {
    private static SetupJob.OUISetupMode setupMode = SetupJob.OUISetupMode.INSTALL;
    private static OUIDelegate delegate = null;

    public static Map<String, String> getSetupArguments(String ... args) {
        HashMap<String, String> setupArgs = new HashMap<String, String>();
        if (args != null) {
            for (String arg : args) {
                int eqIndex;
                if (arg.startsWith("-") || (eqIndex = arg.indexOf(61)) == -1) continue;
                String key = arg.substring(0, eqIndex);
                String value = arg.substring(eqIndex + 1);
                setupArgs.put(key, value);
            }
        }
        return setupArgs;
    }

    public static void setMode(SetupJob.OUISetupMode mode) {
        setupMode = mode;
    }

    public static String[] validateArguments(String ... args) {
        return OUICommandHelper.getDelegate(setupMode).validate(args);
    }

    public static void showUsage() {
        OUICommandHelper.getDelegate(setupMode).displayHelp();
    }

    private static OUIDelegate getDelegate(SetupJob.OUISetupMode setupMode) {
        if (delegate == null) {
            delegate = setupMode == SetupJob.OUISetupMode.ADDNODE ? new OUINodeScalerDelegate() : (setupMode == SetupJob.OUISetupMode.CLONE ? new OUIClonerDelegate() : new OUIDelegate());
        }
        return delegate;
    }

    static class OUIClonerDelegate
    extends OUIDelegate {
        private static final List<String> AUXILIARY_OPTIONS = Arrays.asList(new String[0]);
        private static final List<String> CLONE_DEPRECATED_OPTIONS = Arrays.asList("clusterware", "crsLocation", "responseFile", "sourceLoc", "patchsetBugListFile", "globalvarxml", "attachHome", "detachHome", "enableRollingUpgrade", "local", "relink", "suppressPreCopyScript", "acceptUntrustedCertificates", "suppressPostCopyScript", "formCluster");

        protected String getAppExecutableName() {
            Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
            String executableName = resource.getString("CLONE_EXECUTABLE", "clone.pl", new Object[0]);
            return executableName;
        }

        @Override
        public List<String> getAuxiliaryOptions() {
            return AUXILIARY_OPTIONS;
        }

        @Override
        public List<String> getDeprecatedOptions() {
            ArrayList<String> deprectedOptions = new ArrayList<String>();
            deprectedOptions.addAll(CLONE_DEPRECATED_OPTIONS);
            deprectedOptions.addAll(super.getDeprecatedOptions());
            return deprectedOptions;
        }
    }

    static class OUINodeScalerDelegate
    extends OUIDelegate {
        private static final List<String> AUXILIARY_OPTIONS = Arrays.asList("executePrereqs", "ignorePrereq", "ignoreInternalDriverError", "noCopy");
        private static final List<String> ADDNODE_DEPRECATED_OPTIONS = Arrays.asList("clusterware", "crsLocation", "responseFile", "sourceLoc", "patchsetBugListFile", "globalvarxml", "attachHome", "clone", "detachHome", "enableRollingUpgrade", "local", "relink", "suppressPreCopyScript", "acceptUntrustedCertificates", "suppressPostCopyScript", "formCluster");

        protected String getAppExecutableName() {
            Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
            String executableName = resource.getString("ADDNODE_UNIX_EXECUTABLE", "addnode.sh", new Object[0]);
            if (PlatformInfo.getInstance().isWindows()) {
                executableName = resource.getString("ADDNODE_WINDOWS_EXECUTABLE", "addnode.bat", new Object[0]);
            }
            return executableName;
        }

        @Override
        public List<String> getAuxiliaryOptions() {
            return AUXILIARY_OPTIONS;
        }

        @Override
        public List<String> getDeprecatedOptions() {
            ArrayList<String> deprectedOptions = new ArrayList<String>();
            deprectedOptions.addAll(ADDNODE_DEPRECATED_OPTIONS);
            deprectedOptions.addAll(super.getDeprecatedOptions());
            return deprectedOptions;
        }
    }

    static class OUIDelegate
    extends OiicBaseApp {
        private static final String APP_NAME = "oui";
        private static final String SYSTEM_PROPERTY_PREFIX = "oracle.installer.";
        private static final List<String> AUXILIARY_OPTIONS = Arrays.asList("executePrereqs", "ignorePrereq", "ignoreInternalDriverError", "downloadUpdates", "showProgress", "promptForPassword", "deinstall");
        private static final List<String> UNDOCUMENTED_OPTIONS = Arrays.asList("sourceLoc", "nowait", "patchsetBugListFile", "globalvarxml");
        private static final List<String> DEPRECATED_OPTIONS = Arrays.asList("addLangs", "addNode", "ignorePatchConflicts", "record", "destinationFile", "removeallfiles", "removeAllPatches", "updateNodeList", "nobackground", "nowarningonremovefiles", "noclusterEnabled", "oneclick", "deinstall");
        private static final int CONTEXT_VALIDATE_ARGUMENTS = 1;
        private static final int CONTEXT_SHOW_USAGE = 2;
        private int context;

        public OUIDelegate() {
            super(APP_NAME);
        }

        protected String getSystemPropertyPrefix() {
            return SYSTEM_PROPERTY_PREFIX;
        }

        protected List setupAppProperties() throws OiicInvalidCmdLineException {
            List source = super.setupAppProperties();
            List<String> auxiliaryOptions = this.getAuxiliaryOptions();
            List<String> deprectedOptions = this.getDeprecatedOptions();
            List<String> unDocumentedOptions = this.getUnDocumentedOptions();
            ArrayList<OiicCmdLineProperty> allowedOptions = new ArrayList<OiicCmdLineProperty>();
            for (OiicCmdLineProperty oiicCmdLineProperty : source) {
                String name = oiicCmdLineProperty.getNameFromType();
                if (deprectedOptions.contains(name) || this.context != 1 && unDocumentedOptions.contains(name)) continue;
                allowedOptions.add(oiicCmdLineProperty);
            }
            if (this.context == 2) {
                for (String string : auxiliaryOptions) {
                    OiicCmdLineProperty property = new OiicCmdLineProperty(string, 1);
                    property.setHelpId(String.format("cmdlnOption.%s.usageHelp@oracle.install.driver.oui.resource.StringResourceBundle", string));
                    allowedOptions.add(property);
                }
            }
            return allowedOptions;
        }

        public String displayHelp() {
            this.context = 2;
            this.setDefaults();
            return super.displayHelp();
        }

        public String[] validate(String ... args) {
            try {
                this.context = 1;
                List<String> auxiliaryOptions = this.getAuxiliaryOptions();
                ArrayList<String> newArgs = new ArrayList<String>();
                newArgs.addAll(Arrays.asList(args));
                Iterator i = newArgs.iterator();
                while (i.hasNext()) {
                    String arg = (String)i.next();
                    if (!arg.startsWith("-")) continue;
                    for (String option : auxiliaryOptions) {
                        if (!option.equalsIgnoreCase(arg.substring(1))) continue;
                        i.remove();
                        break;
                    }
                    if (!arg.contains("=")) continue;
                    ErrorInfo errorInfo = ErrorInfo.getInstance(InstallEngineErrorCode.INVALID_COMMAND_LINE_ARG, arg);
                    throw new IllegalArgumentException(errorInfo.getMessage());
                }
                args = newArgs.toArray(new String[0]);
                super.processCommandLine(args);
            }
            catch (OiicInvalidCmdLineException e) {
                throw new IllegalArgumentException(e.getErrorMessage());
            }
            return args;
        }

        public List<String> getAuxiliaryOptions() {
            return AUXILIARY_OPTIONS;
        }

        public List<String> getDeprecatedOptions() {
            return DEPRECATED_OPTIONS;
        }

        public List<String> getUnDocumentedOptions() {
            return UNDOCUMENTED_OPTIONS;
        }
    }
}

