/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.ScriptExecutor;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.bean.OracleCloneBean;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUICommandHelper;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.OUIErrorCode;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixNetOps;

public abstract class OUICloneDriver
extends OUISetupDriver<OracleCloneBean> {
    public static final String PROPERTY_PROXY_MAPPINGS = "oracle.install.driver.oui.proxyMappings";
    public static final String ORAINST_ROOT_SCRIPT_FILE = "orainstRoot.sh";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    private static Logger logger = Logger.getLogger(OUICloneDriver.class.getName());
    private Resource stringResource;
    private String oracleHome;
    private String oracleBase;
    private static final boolean gridSetupWizard = Boolean.getBoolean("oracle.installer.setupWizard");
    private String inventoryLoc;

    public String getOracleBase() {
        return this.oracleBase;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    public void setInventoryLoc(String inventoryLoc) {
        this.inventoryLoc = inventoryLoc;
    }

    public OUICloneDriver() {
        this.setupBean = new OracleCloneBean();
        this.stringResource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        OUICommandHelper.setMode(SetupJob.OUISetupMode.CLONE);
    }

    @Override
    public void load() throws SetupDriverException {
        super.load();
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        int returnCodeInvCheck = -1;
        try {
            returnCodeInvCheck = this.inventoryLoc != null ? apiInstaller.initInstallEnvironment(this.properties, true, 3, this.inventoryLoc) : apiInstaller.initInstallEnvironment(this.properties, true, 3);
        }
        catch (OiicIllegalStateException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (OiicInstallAPIException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (Throwable t) {
            throw new SetupDriverException(t, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        if (!gridSetupWizard) {
            OUILogHandler.setDirectLoggingEnabled(true);
        }
        logger.log(Level.INFO, "Entering OUICloneDriver.load() method...");
        if (returnCodeInvCheck == 1001 && !OiiiInstallAreaControl.isCleanMachine()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INVENTORY_INIT_FAILED, new Object[0]);
        }
        if (!PlatformInfo.getInstance().isWindows() && !Boolean.getBoolean("oracle.install.skipInventoryGroupCheck") && InventoryInfo.getInstance().isInventoryExist() && (InventoryInfo.getInstance().getUnixGroupName() == null || InventoryInfo.getInstance().getUnixGroupName().isEmpty())) {
            throw new SetupDriverException((ErrorCode)OUIErrorCode.NO_INVENTORY_GROUP_PRESENT_ORAINST_LOC_FILE, new Object[0]);
        }
        String enableNodelistJobFeatureDBProp = this.getProperty("oracle.install.db.enableNodelistJob");
        String enableNodelistJobFeatureGridProp = this.getProperty("oracle.install.crs.enableNodelistJob");
        if (enableNodelistJobFeatureDBProp != null || enableNodelistJobFeatureGridProp != null) {
            boolean enableNodelistJobFeatureDB = Boolean.parseBoolean(enableNodelistJobFeatureDBProp);
            boolean enableNodelistJobFeatureGRID = Boolean.parseBoolean(enableNodelistJobFeatureGridProp);
            if (!enableNodelistJobFeatureDB && !enableNodelistJobFeatureGRID) {
                System.setProperty("oracle.installer.doNotUpdateNodeList", "true");
            }
        }
    }

    @Override
    public String getProperty(String key) {
        if (key != null && key.length() > 0) {
            String value = System.getProperty(key);
            if (value == null) {
                value = Application.getInstance().getString(key, null, new Object[0]);
            } else {
                logger.log(Level.INFO, "OUICloneDriver.getProperty: key:" + key + " is set as system property");
            }
            return value;
        }
        return null;
    }

    @Override
    protected HashMap constructAdditionalProperties(HashMap hashMap) throws SetupDriverException {
        super.constructAdditionalProperties(hashMap);
        String oracle_home = hashMap.get("ORACLE_HOME").toString();
        File readmeLoc = new File(oracle_home, "install/readme.txt");
        hashMap.put("readme.exist", readmeLoc.exists());
        int j = 0;
        List<String> args = Application.getInstance().getArguments();
        Iterator<String> it = args.iterator();
        Iterator<String> it1 = args.iterator();
        boolean isOracleHomeName = false;
        boolean isSecure = false;
        while (it.hasNext()) {
            String value = it.next();
            if (!value.contains("ORACLE_HOME_NAME")) continue;
            isOracleHomeName = true;
            break;
        }
        int k = 0;
        if (PlatformInfo.getInstance().isWindows()) {
            if (Application.isCommandLineSwitchEnabled("-secure")) {
                while (it1.hasNext()) {
                    String key = it1.next();
                    if (!key.contains("ORACLE_HOME_USER")) continue;
                    isSecure = true;
                    k = key.indexOf("=");
                    String value = key.substring(k + 1);
                    hashMap.put("oracle_install_IsBuiltInAccount", FALSE);
                    hashMap.put("oracle_install_OracleHomeUserName", value);
                    break;
                }
                if (!isSecure) {
                    System.out.println(this.stringResource.getString("clone.secure.flag.error.msessage.windows", "-secure flag should always be used in conjunction with ORACLE_SERVICE_USER", new Object[0]));
                    logger.log(Level.SEVERE, this.stringResource.getString("clone.secure.flag.error.msessage.windows", "-secure flag should always be used in conjunction with ORACLE_SERVICE_USER", new Object[0]));
                    Application.getInstance().shutdown(OUIExitStatus.VAR_VALIDATION_FAILURE);
                }
            } else {
                hashMap.put("oracle_install_IsBuiltInAccount", TRUE);
            }
        }
        if (!isOracleHomeName) {
            String oracleHomeName = InventoryInfo.getInstance().computeOracleHomeName(oracle_home);
            hashMap.put("ORACLE_HOME_NAME", oracleHomeName);
        }
        for (int i = 0; i < args.size(); ++i) {
            j = args.get(i).indexOf("=");
            if (j == -1) continue;
            String key = args.get(i).substring(0, j);
            String value = args.get(i).substring(j + 1);
            if (key.equalsIgnoreCase("CLUSTER_NODES")) {
                if (value == null || value.length() <= 0 || !value.startsWith("{") || !value.endsWith("}")) continue;
                value = value.substring(1, value.length() - 1).replaceAll(" ", "");
                ArrayList<String> nodesList = new ArrayList<String>(Arrays.asList(value.split(",")));
                String localNodeName = OiixNetOps.getMachineName((String)PlatformInfo.getInstance().getFullHostName());
                for (String node : nodesList) {
                    if (!node.toLowerCase().contains(localNodeName.toLowerCase())) continue;
                    nodesList.remove(node);
                    nodesList.add(0, node);
                    break;
                }
                value = ((Object)nodesList).toString().substring(1, ((Object)nodesList).toString().length() - 1);
                hashMap.put("CLUSTER_NODES", value);
                OiixGeneralQueries.setClusterON();
                continue;
            }
            hashMap.put(key, value);
        }
        return hashMap;
    }

    @Override
    public CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob compositeJob = new CompositeJob();
        SetupJob cloneJob = new SetupJob((Object)"Clone", "Oracle Cloning", 0.95f, this.getCloneDetails(), SetupJob.OUISetupMode.CLONE);
        compositeJob.add(cloneJob);
        if (!PlatformInfo.getInstance().isWindows() && !Application.isCommandLineSwitchEnabled("-suppressRootMessage")) {
            logger.log(Level.INFO, "Adding root script.");
            compositeJob.add(new RootScriptJob(cloneJob));
        }
        return compositeJob;
    }

    protected SessionDetails getCloneDetails() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CommandLineArgumentHandler cliArgumentHandler = CommandLineArgumentHandler.getInstance();
        hashMap.put("ORACLE_HOME", cliArgumentHandler.getArgumentValue("ORACLE_HOME"));
        hashMap.put("ORACLE_BASE", cliArgumentHandler.getArgumentValue("ORACLE_BASE"));
        if (cliArgumentHandler.isArgumentPassed("ORACLE_HOME_NAME")) {
            hashMap.put("ORACLE_HOME_NAME", cliArgumentHandler.getArgumentValue("ORACLE_HOME_NAME"));
        }
        if (cliArgumentHandler.isArgumentPassed("virtualAccount")) {
            hashMap.put("oracle_install_IsVirtualAccount", "true");
        }
        if (cliArgumentHandler.isArgumentPassed("OSDBA_GROUP")) {
            hashMap.put("oracle_install_OSDBA", cliArgumentHandler.getArgumentValue("OSDBA_GROUP"));
        }
        if (cliArgumentHandler.isArgumentPassed("OSOPER_GROUP")) {
            hashMap.put("oracle_install_OSOPER", cliArgumentHandler.getArgumentValue("OSOPER_GROUP"));
        }
        if (cliArgumentHandler.isArgumentPassed("OSASM_GROUP")) {
            String value = cliArgumentHandler.getArgumentValue("OSASM_GROUP");
            hashMap.put("oracle_install_OSASM", value);
            hashMap.put("oracle_install_OSBKP", value);
            hashMap.put("oracle_install_OSDGD", value);
            hashMap.put("oracle_install_OSKMT", value);
            hashMap.put("oracle_install_OSRAC", value);
        }
        if (cliArgumentHandler.isArgumentPassed("OSBACKUPDBA_GROUP")) {
            hashMap.put("oracle_install_OSBKP", cliArgumentHandler.getArgumentValue("OSBACKUPDBA_GROUP"));
        }
        if (cliArgumentHandler.isArgumentPassed("OSDGDBA_GROUP")) {
            hashMap.put("oracle_install_OSDGD", cliArgumentHandler.getArgumentValue("OSDGDBA_GROUP"));
        }
        if (cliArgumentHandler.isArgumentPassed("OSKMDBA_GROUP")) {
            hashMap.put("oracle_install_OSKMT", cliArgumentHandler.getArgumentValue("OSKMDBA_GROUP"));
        }
        if (cliArgumentHandler.isArgumentPassed("OSRACDBA_GROUP")) {
            hashMap.put("oracle_install_OSRAC", cliArgumentHandler.getArgumentValue("OSRACDBA_GROUP"));
        }
        int j = 0;
        List<String> args = Application.getInstance().getArguments();
        for (int i = 0; i < args.size(); ++i) {
            j = args.get(i).indexOf("=");
            if (j == -1) continue;
            String key = args.get(i).substring(0, j);
            String value = args.get(i).substring(j + 1);
            hashMap.put(key, value);
        }
        SessionDetails sessionDetails = new SessionDetails("session", hashMap);
        return sessionDetails;
    }

    @Override
    public ScriptExecutor<?> getRootScriptExecutor() {
        return null;
    }

    @Override
    public SessionDetails getSessionDetails(SetupJob.OUISetupMode setupMode) throws SetupDriverException {
        return this.getCloneDetails();
    }

    @Override
    public void showUsage() {
        System.setProperty("application.commandline.hideMutuallyExclusiveArgsNotMatchingContextOrPlatform", "true");
        CommandLineArgumentHandler commandLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        commandLineArgumentHandler.setContextId(System.getProperty("application.commandline.currentContextId", null));
        commandLineArgumentHandler.showHelp(Application.getInstance().getArguments());
    }

    @Override
    public void processCommandLine(String ... args) {
        CommandLineArgumentHandler cliArgumentHandler = CommandLineArgumentHandler.getInstance();
        this.oracleHome = cliArgumentHandler.getArgumentValue("ORACLE_HOME");
        this.oracleBase = cliArgumentHandler.getArgumentValue("ORACLE_BASE");
        super.processCommandLine(args);
    }
}

