/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Conditional;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.ConfigProgressMonitor;
import oracle.install.driver.oui.Configurable;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.util.SetupSummary;

public class ConfigJob
extends CompositeJob
implements Callable<Void>,
Retriable,
Configurable,
Conditional {
    private static final Logger logger = Logger.getLogger(ConfigJob.class.getName());
    private WeakReference<SetupJob> setupJobRef;
    private ConfigProgressMonitor configProgressMonitor;
    private Map<String, String> defaultConfigParameters;
    private Map<String, Map<String, String>> transientParametersMap;
    private String oracleHome;
    private String aggCfgID;

    @Deprecated
    public ConfigJob(Object id, float weightage, SetupJob setupJob) {
        super(id, null, weightage);
        setupJob.setConfigurationRequired(true);
        SetupSummary.getInstance().setUpdateSummaryInSetup(true);
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        String description = resource.getString("configJob.description", "Configuration", new Object[0]);
        this.setDescription(description);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        this.configProgressMonitor = new ConfigProgressMonitor(this, null);
        this.setupJobRef = new WeakReference<SetupJob>(setupJob);
        this.transientParametersMap = new TreeMap<String, Map<String, String>>();
        this.defaultConfigParameters = new TreeMap<String, String>();
        Summary.getInstance().setSuccessfulConfig(false);
    }

    @Deprecated
    public ConfigJob(Object id, float weightage, SetupJob setupJob, Map<String, String> defaultConfigParams) {
        this(id, weightage, setupJob);
        this.defaultConfigParameters.putAll(defaultConfigParams);
    }

    public ConfigJob(Object id, float weightage, String oracleHome, String aggCfgID) {
        super(id, null, weightage);
        this.oracleHome = oracleHome;
        this.aggCfgID = aggCfgID;
        Application application = Application.getInstance();
        Resource resource = application.getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        String description = resource.getString("configJob.description", "Configuration", new Object[0]);
        this.setDescription(description);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        this.configProgressMonitor = new ConfigProgressMonitor(this, null);
        this.transientParametersMap = new TreeMap<String, Map<String, String>>();
        this.defaultConfigParameters = new TreeMap<String, String>();
        Summary.getInstance().setSuccessfulConfig(false);
    }

    @Override
    public void setDefaultConfigParameters(Map<String, String> defaultConfigParams) {
        this.defaultConfigParameters.putAll(defaultConfigParams);
    }

    public Map<String, String> getDefaultConfigParameters() {
        return this.defaultConfigParameters;
    }

    @Override
    public void setTransientParameter(String configToolId, String key, String value) {
        Map<String, String> params = this.transientParametersMap.get(configToolId);
        if (params == null) {
            params = new TreeMap<String, String>();
            this.transientParametersMap.put(configToolId, params);
        }
        params.put(key, value);
    }

    @Override
    public void setTransientParameters(String configToolId, Map<String, String> map) {
        Map<String, String> params = this.transientParametersMap.get(configToolId);
        if (params == null) {
            params = new TreeMap<String, String>();
            this.transientParametersMap.put(configToolId, params);
        }
        params.putAll(map);
    }

    @Override
    public Map<String, Map<String, String>> getTransientParametersMap() {
        return this.transientParametersMap;
    }

    @Override
    public Map<String, String> getTransientParameters(String configToolId) {
        return this.transientParametersMap.get(configToolId);
    }

    @Override
    public void setTransientParametersMap(Map<String, Map<String, String>> transientParametersMap) {
        this.transientParametersMap = transientParametersMap;
    }

    public ConfigProgressMonitor getConfigProgressMonitor() {
        return this.configProgressMonitor;
    }

    public void setConfigProgressMonitor(ConfigProgressMonitor configProgressMonitor) {
        this.configProgressMonitor = configProgressMonitor;
    }

    public SetupJob getSetupJob() {
        return (SetupJob)this.setupJobRef.get();
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    public String getAggCfgID() {
        return this.aggCfgID;
    }

    public Callable<Void> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        Object driver = SetupDriver.getInstance();
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            if (this.setupJobRef != null) {
                ouiSetupDriver.config(this);
            } else {
                ouiSetupDriver.config(this, this.oracleHome, this.aggCfgID);
            }
        }
        return null;
    }

    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List<Job> jobList = this.getJobs();
        for (Job job : jobList) {
            Status status = job.getStatus();
            if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
            logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
            retriableJobs.add(job);
        }
        return retriableJobs;
    }

    @Override
    public void retry() throws Exception {
        Object driver = SetupDriver.getInstance();
        if (driver instanceof OUISetupDriver) {
            OUISetupDriver ouiSetupDriver = (OUISetupDriver)driver;
            if (this.setupJobRef != null) {
                ouiSetupDriver.config(this, true);
            } else {
                ouiSetupDriver.config(this, this.oracleHome, this.aggCfgID, true);
            }
        }
    }

    @Override
    public void check() {
    }
}

