/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.system.filemgmt;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import oracle.install.commons.system.filemgmt.FileSystem;

public class FileExtensionFilter
implements FileFilter,
FilenameFilter {
    private List<String> extensions;

    public FileExtensionFilter(String ... extensions) {
        this.extensions = Arrays.asList(extensions);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File pathname) {
        boolean accept = true;
        if (pathname.isFile()) {
            accept = this.accept(pathname.getParentFile(), pathname.getName());
        }
        return accept;
    }

    @Override
    public boolean accept(File dir, String name) {
        String ext = FileSystem.getFileExtension(name);
        return ext != null && this.extensions != null && this.extensions.contains(ext);
    }
}

