/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.install.commons.swing.HtmlPane;

public class HtmlPaneCellEditorRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
HyperlinkListener {
    private HtmlPane htmlPane;

    public HtmlPaneCellEditorRenderer(String text, String hrefString, HyperlinkListener ... listeners) {
        this.htmlPane = new TableCellHtmlPane(text, hrefString);
        this.htmlPane.setText("<a href=\"" + hrefString + "\">" + text + "</a>");
        this.htmlPane.addHyperlinkListener(this);
        if (listeners != null && listeners.length > 0) {
            for (HyperlinkListener listener : listeners) {
                this.htmlPane.addHyperlinkListener(listener);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.htmlPane.setBackground(table.getSelectionBackground());
            this.htmlPane.setForeground(table.getSelectionForeground());
        } else {
            this.htmlPane.setBackground(table.getBackground());
            this.htmlPane.setForeground(table.getForeground());
        }
        return this.htmlPane;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.htmlPane.setBackground(table.getSelectionBackground());
            this.htmlPane.setForeground(table.getSelectionForeground());
        } else {
            this.htmlPane.setBackground(table.getBackground());
            this.htmlPane.setForeground(table.getForeground());
        }
        return this.htmlPane;
    }

    @Override
    public Object getCellEditorValue() {
        return this.htmlPane.getText();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType eventType = e.getEventType();
        if (eventType == HyperlinkEvent.EventType.ACTIVATED && e.getSource() != null) {
            this.stopCellEditing();
        }
    }

    private class TableCellHtmlPane
    extends HtmlPane {
        private String text;
        private String href;

        public TableCellHtmlPane(String text, String href) {
            this.text = text;
            this.href = href;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

