/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.install.commons.flow.ConditionRoutine;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.util.Graph;

public class Condition {
    private ConditionRoutine conditionRoutine;
    private String id;
    private Map<String, String> parameters;
    private Map<Route, Graph<Route, State>> transitionMap;
    private Graph<Route, State> defaultTarget;

    public Condition() {
    }

    public Condition(Condition condition) {
        this.conditionRoutine = condition.conditionRoutine;
        this.id = condition.id;
        if (condition.parameters != null) {
            this.parameters = new TreeMap<String, String>();
            this.parameters.putAll(condition.parameters);
        }
        if (condition.transitionMap != null) {
            this.transitionMap = new HashMap<Route, Graph<Route, State>>();
            this.transitionMap.putAll(condition.transitionMap);
        }
        this.defaultTarget = condition.defaultTarget;
    }

    public ConditionRoutine getConditionRoutine() {
        return this.conditionRoutine;
    }

    public void setConditionRoutine(ConditionRoutine conditionRoutine) {
        this.conditionRoutine = conditionRoutine;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<Route, Graph<Route, State>> getTransitionMap() {
        return this.transitionMap;
    }

    public void setTransitionMap(Map<Route, Graph<Route, State>> transitionMap) {
        this.transitionMap = transitionMap;
    }

    public Graph<Route, State> getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefaultTarget(Graph<Route, State> defaultTarget) {
        this.defaultTarget = defaultTarget;
    }
}

