/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.JobType;
import oracle.install.commons.base.util.job.view.JobTablePane;
import oracle.install.commons.base.util.job.view.JobTypeUIEnum;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobInfoPane
extends JPanel {
    private JLabel lblJobId;
    private JTextField txtJobId;
    private JLabel lblWeightage;
    private JTextField txtWeightage;
    private JCheckBox cbxRetriable;
    private JLabel lblType;
    private JComboBox<JobTypeUIEnum> cmbType;
    private JLabel lblCommandOrPath;
    private JTextArea txaCommand;
    private JobTablePane childJobsPane;
    private JLabel lblExecuteJob;
    private JComboBox<Boolean> cmbExecDecidingVarValue;
    private JLabel lblIgnorableErrors;
    private JTextField txtIgnorableErrors;
    private boolean canEdit;
    private Resource resource;

    public JobInfoPane(boolean canEdit) {
        this.canEdit = canEdit;
        this.resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
        this.buildUI();
    }

    public void buildUI() {
        this.lblJobId = new JLabel();
        this.txtJobId = new JTextField();
        this.lblWeightage = new JLabel();
        this.txtWeightage = new JTextField();
        this.cbxRetriable = new JCheckBox();
        this.lblType = new JLabel();
        this.cmbType = new JComboBox<JobTypeUIEnum>(JobTypeUIEnum.values());
        this.lblCommandOrPath = new JLabel();
        this.txaCommand = new JTextArea();
        this.childJobsPane = new JobTablePane(this.resource.getString("JobDetailsPane.jobTable.text", "Child jobs", new Object[0]), this.canEdit, JobTablePane.ViewMode.CHILD_JOBS);
        this.lblExecuteJob = new JLabel();
        this.cmbExecDecidingVarValue = new JComboBox<Boolean>(new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.cmbExecDecidingVarValue.setEditable(false);
        this.lblIgnorableErrors = new JLabel();
        this.txtIgnorableErrors = new JTextField();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblJobId, this, 0, 0, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.txtJobId, this, 1, 0, 2, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(Box.createGlue(), this, 3, 0, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.lblWeightage, this, 0, 1, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.txtWeightage, this, 1, 1, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.cbxRetriable, this, 2, 1, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(Box.createGlue(), this, 3, 1, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.lblType, this, 0, 2, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.cmbType, this, 1, 2, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(Box.createGlue(), this, 2, 2, 2, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.lblCommandOrPath, this, 0, 3, 1, 2, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.txaCommand, this, 1, 3, 3, 2, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.childJobsPane, this, 0, 5, 4, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.lblExecuteJob, this, 0, 6, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.cmbExecDecidingVarValue, this, 1, 6, 1, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(Box.createGlue(), this, 2, 6, 2, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.lblIgnorableErrors, this, 0, 7, 1, 1, 2, 18, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.txtIgnorableErrors, this, 1, 7, 3, 1, 2, 18, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        this.cmbType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JobInfoPane.this.lblCommandOrPath.setEnabled(JobInfoPane.this.canEdit && JobInfoPane.this.cmbType.getSelectedItem() != JobTypeUIEnum.COMPOSITE_JOB);
                JobInfoPane.this.txaCommand.setEnabled(JobInfoPane.this.canEdit && JobInfoPane.this.cmbType.getSelectedItem() != JobTypeUIEnum.COMPOSITE_JOB);
                if (JobInfoPane.this.canEdit && JobInfoPane.this.cmbType.getSelectedItem() == JobTypeUIEnum.COMPOSITE_JOB) {
                    SwingUtils.setComponentEnabled(JobInfoPane.this.childJobsPane, JobInfoPane.this.canEdit && JobInfoPane.this.cmbType.getSelectedItem() == JobTypeUIEnum.COMPOSITE_JOB);
                    if (JobInfoPane.this.childJobsPane.getJobs() == null || JobInfoPane.this.childJobsPane.getJobs().isEmpty()) {
                        JobInfoPane.this.childJobsPane.setJobs(new ArrayList<JobSettings>());
                    }
                }
            }
        });
        this.cmbType.setSelectedItem((Object)JobTypeUIEnum.COMPOSITE_JOB);
        this.localize();
        SwingUtils.setComponentEnabled(this, this.canEdit);
    }

    public void setJobInfo(JobSettings jobSettings) {
        this.updatePane(jobSettings);
    }

    private void updatePane(JobSettings jobSettings) {
        this.txtJobId.setText(jobSettings.getId());
        this.txtWeightage.setText(Float.toString(jobSettings.getWeightage()));
        this.cbxRetriable.setSelected(jobSettings.isRetriable());
        if (jobSettings.getType() != null) {
            this.cmbType.setSelectedItem((Object)JobTypeUIEnum.getJobTypeUI(jobSettings.getType()));
        } else {
            this.cmbType.setSelectedItem((Object)JobType.JAVA_CLASS);
        }
        this.txaCommand.setText(jobSettings.getCommand());
        if (jobSettings.getChildJobs() != null) {
            this.childJobsPane.setJobs(new ArrayList<JobSettings>(jobSettings.getChildJobs()));
        }
        if (jobSettings.getIgnorableErrors() != null && jobSettings.getIgnorableErrors().size() > 0) {
            String errors = jobSettings.getIgnorableErrors().toString().substring(1);
            errors = errors.substring(0, errors.length() - 1);
            this.txtIgnorableErrors.setText(errors);
        }
        this.cmbExecDecidingVarValue.setSelectedItem(jobSettings.isExecute());
    }

    public void saveJobInfo(JobSettings jobSettings) {
        if (jobSettings != null) {
            jobSettings.setId(this.txtJobId.getText().trim().replace(" ", "_"));
            jobSettings.setWeightage(Float.valueOf(this.txtWeightage.getText().trim()).floatValue());
            jobSettings.setRetriable(this.cbxRetriable.isSelected());
            jobSettings.setType(((JobTypeUIEnum)((Object)this.cmbType.getSelectedItem())).getJobType());
            jobSettings.setCommand(this.txaCommand.getText().trim());
            jobSettings.setChildJobs(this.childJobsPane.getJobs());
            ArrayList<String> errors = new ArrayList<String>();
            if (!this.txtIgnorableErrors.getText().trim().isEmpty()) {
                String[] ignorableErrors = this.txtIgnorableErrors.getText().trim().split(",");
                errors.addAll(Arrays.asList(ignorableErrors));
            }
            jobSettings.setExecute(Boolean.valueOf(this.cmbExecDecidingVarValue.getSelectedItem().toString()));
            jobSettings.setIgnorableErrors(errors);
        }
    }

    public void localize() {
        String text = this.resource.getString("JobDetailsPane.lblJobId.text", "Job ID:*", new Object[0]);
        SwingUtils.setText(this.lblJobId, text);
        text = this.resource.getString("JobDetailsPane.lblWeightage.text", "Weightage:*", new Object[0]);
        SwingUtils.setText(this.lblWeightage, text);
        text = this.resource.getString("JobDetailsPane.cbxRetriable.text", "Retriable*", new Object[0]);
        SwingUtils.setText(this.cbxRetriable, text);
        text = this.resource.getString("JobDetailsPane.lblType.text", "Job type:*", new Object[0]);
        SwingUtils.setText(this.lblType, text);
        text = this.resource.getString("JobDetailsPane.lblCommandOrPath.text", "Command or Path:*", new Object[0]);
        SwingUtils.setText(this.lblCommandOrPath, text);
        text = this.resource.getString("JobDetailsPane.lblIgnorableErrors.text", "Ignorable errors:*", new Object[0]);
        SwingUtils.setText(this.lblIgnorableErrors, text);
        text = this.resource.getString("JobDetailsPane.lblExecuteJob.text", "Execute job:*", new Object[0]);
        SwingUtils.setText(this.lblExecuteJob, text);
        HashMap<JobType, String> jobTypeNames = new HashMap<JobType, String>();
        jobTypeNames.put(JobType.COMPOSITE_JOB, this.resource.getString(JobType.COMPOSITE_JOB, new Object[0]));
        jobTypeNames.put(JobType.JAVA_CLASS, this.resource.getString(JobType.JAVA_CLASS, new Object[0]));
        jobTypeNames.put(JobType.PLAIN_COMMAND, this.resource.getString(JobType.PLAIN_COMMAND, new Object[0]));
        jobTypeNames.put(JobType.PERL_SCRIPT, this.resource.getString(JobType.PERL_SCRIPT, new Object[0]));
        jobTypeNames.put(JobType.SQL_COMMAND, this.resource.getString(JobType.SQL_COMMAND, new Object[0]));
        jobTypeNames.put(JobType.REMOTE_JOB, this.resource.getString(JobType.REMOTE_JOB, new Object[0]));
        JobTypeUIEnum.setNames(jobTypeNames);
    }
}

