/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.view.JobVariablesTablePane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobArgsPane
extends JPanel {
    private JobVariablesTablePane jobArgsPane;
    private JobVariablesTablePane jobSecreteArgsPane;
    private boolean canEdit;
    private static final Logger logger = Logger.getLogger(JobArgsPane.class.getName());
    Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");

    public JobArgsPane(boolean canEdit) {
        this.canEdit = canEdit;
        this.buildUI();
    }

    private void buildUI() {
        this.jobArgsPane = new JobVariablesTablePane(this.resource.getString("JobArgsPane.args.name", "Arguments", new Object[0]), this.canEdit, JobVariablesTablePane.ShowingContext.ARGUMENTS);
        this.jobSecreteArgsPane = new JobVariablesTablePane(this.resource.getString("JobArgsPane.secreteargs.name", "Secrete Args", new Object[0]), this.canEdit, JobVariablesTablePane.ShowingContext.PASSWORDS);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.jobArgsPane, this, 0, 0, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.jobSecreteArgsPane, this, 0, 1, 1, 1, 1, 18, 1.0, 1.0, LayoutUtils.STANDARD_INSETS);
    }

    public void setJobArgsInfo(JobSettings jobSettings) {
        if (jobSettings.getArgs() != null) {
            this.jobArgsPane.setVariables(new ArrayList<VariableSettings>(jobSettings.getArgs().values()));
        } else {
            this.jobArgsPane.setVariables(new ArrayList<VariableSettings>());
        }
        if (jobSettings.getSecreteArgs() != null) {
            this.jobSecreteArgsPane.setVariables(new ArrayList<VariableSettings>(jobSettings.getSecreteArgs().values()));
        } else {
            this.jobSecreteArgsPane.setVariables(new ArrayList<VariableSettings>());
        }
    }

    protected void saveJobDetails(JobSettings jobSettings) {
        if (jobSettings != null) {
            List<VariableSettings> args = this.jobArgsPane.getVariables();
            LinkedHashMap<String, VariableSettings> argsMap = new LinkedHashMap<String, VariableSettings>();
            if (args != null) {
                for (VariableSettings var : args) {
                    if (var.getName() != null && !var.getName().isEmpty()) {
                        var.setJobId(jobSettings.getId());
                        argsMap.put(var.getName(), var);
                        continue;
                    }
                    logger.log(Level.WARNING, "Variable name is null. So not adding the variable to the job object");
                }
            }
            jobSettings.setArgs(argsMap);
            args = this.jobSecreteArgsPane.getVariables();
            argsMap = new LinkedHashMap();
            if (args != null) {
                for (VariableSettings var : args) {
                    if (var.getName() != null && !var.getName().isEmpty()) {
                        var.setSecure(true);
                        var.setJobId(jobSettings.getId());
                        argsMap.put(var.getName(), var);
                        continue;
                    }
                    logger.log(Level.WARNING, "Secrete Variable name is null. So not adding the variable to the job object");
                }
            }
            jobSettings.setSecreteArgs(argsMap);
        }
    }
}

