/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.install.commons.base.util.job.JobApplication;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationHandler;
import oracle.install.commons.base.util.job.bean.JobsOperationType;
import oracle.install.commons.base.util.job.view.JobApplicationPane;
import oracle.install.commons.swing.BannerFrame;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobApplicationFrame
extends BannerFrame {
    private JobApplicationPane jobApplicationPane;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private JButton btnClose;
    private JButton btnCancel;
    private JButton btnSubmit;

    public JobApplicationFrame(String title) {
        this(title, "");
    }

    public JobApplicationFrame(String title, String bannerText) {
        super(title);
        this.jobApplicationPane = new JobApplicationPane();
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
        if (bannerText == null || bannerText.trim().length() == 0) {
            super.setBannerText(resource.getString("JobApplicationFrame.bannerText.name", "Job Application Framework", new Object[0]));
        }
        JPanel contentPane = new JPanel(new GridBagLayout());
        this.btnClose = new JButton();
        SwingUtils.setText(this.btnClose, resource.getString("JobApplicationFrame.btnClose.text", "Close", new Object[0]));
        this.btnCancel = new JButton();
        SwingUtils.setText(this.btnCancel, resource.getString("JobApplicationFrame.btnCancel.text", "Cancel", new Object[0]));
        this.btnSubmit = new JButton();
        SwingUtils.setText(this.btnSubmit, resource.getString("JobApplicationFrame.btnSubmit.text", "Submit", new Object[0]));
        LayoutUtils.addComponent(this.jobApplicationPane, contentPane, 0, 0, 4, 1, 1, 10, 1.0, 1.0, new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent(Box.createGlue(), contentPane, 0, 1, 1, 1, 2, 17, 1.0, 0.0, new Insets(0, 5, 5, 5));
        LayoutUtils.addComponent(this.btnSubmit, contentPane, 1, 1, 1, 1, 0, 13, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnCancel, contentPane, 2, 1, 1, 1, 0, 13, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnClose, contentPane, 3, 1, 1, 1, 0, 13, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.getContentPane().add(contentPane);
        this.pack();
        this.setSize(JobApplicationConstants.JOB_APPLICAITON_DAILOG_SIZE);
        JobApplication jobApplication = JobApplication.getInstance();
        jobApplication.addJobApplicationListener(this.jobApplicationPane);
        this.updateControlPanels(ViewMode.INTERVIEW_MODE);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.getInstance().shutdown();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.getInstance().shutdown();
            }
        });
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationFrame.this.executorService.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        boolean status = false;
                        JobsOperationType jobOperationType = JobApplicationFrame.this.jobApplicationPane.getSelectionOperationType();
                        if (jobOperationType != null) {
                            switch (jobOperationType) {
                                case EXECUTE: {
                                    status = JobApplicationHandler.getInstance().run(JobApplicationFrame.this.jobApplicationPane.getJobContext());
                                    break;
                                }
                                case GENERATE_XML: {
                                    String jobXML = JobApplicationFrame.this.jobApplicationPane.geXMLFileLocation();
                                    status = JobApplicationHandler.getInstance().createJobsXML(jobXML, JobApplicationFrame.this.jobApplicationPane.getJobContext());
                                }
                            }
                        }
                        return status;
                    }
                });
            }
        });
        this.jobApplicationPane.addPropertyChangeListener("jobApplicationPane.showing.interviewcard", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobApplicationFrame.this.updateControlPanels(ViewMode.INTERVIEW_MODE);
            }
        });
        this.jobApplicationPane.addPropertyChangeListener("jobApplicationPane.showing.progresscard", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobApplicationFrame.this.updateControlPanels(ViewMode.PROGRESS_MODE);
            }
        });
        this.jobApplicationPane.addPropertyChangeListener("jobApplicationPane.showing.resultcard", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobApplicationFrame.this.updateControlPanels(ViewMode.RESULT_MODE);
            }
        });
        this.jobApplicationPane.addPropertyChangeListener("jobApplicationPane.jobs.execution.completed", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JobApplicationFrame.this.updateControlPanels(ViewMode.RESULT_MODE);
            }
        });
    }

    public void updateControlPanels(ViewMode viewMode) {
        if (viewMode != null) {
            switch (viewMode) {
                case INTERVIEW_MODE: {
                    this.btnSubmit.setVisible(true);
                    this.btnCancel.setVisible(true);
                    this.btnClose.setVisible(false);
                    break;
                }
                case PROGRESS_MODE: {
                    this.btnSubmit.setVisible(false);
                    this.btnCancel.setVisible(true);
                    this.btnClose.setVisible(false);
                    break;
                }
                case RESULT_MODE: {
                    this.btnSubmit.setVisible(false);
                    this.btnCancel.setVisible(false);
                    this.btnClose.setVisible(true);
                }
            }
        }
    }

    static enum ViewMode {
        INTERVIEW_MODE,
        PROGRESS_MODE,
        RESULT_MODE;

    }
}

