/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.install.commons.base.util.job.bean.JobCollection;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.JobsOperationType;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.view.JobTablePane;
import oracle.install.commons.base.util.job.view.JobVariablesTablePane;
import oracle.install.commons.swing.FileChooserDialog;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobApplicationDetailsPane
extends JPanel {
    private JLabel lblApplicationName;
    private JTextField txtApplicationName;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private JobTablePane jobsPane;
    private JobVariablesTablePane globalVarsPane;
    private JRadioButton rdbExecuteJobs;
    private JRadioButton rdbGenerateXML;
    private JLabel lblXMLLocation;
    private JTextField txtXMLLocation;
    private JButton btnXLMLocBrowse;
    private JobContext jobContext;
    private Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
    private static final Logger logger = Logger.getLogger(JobApplicationDetailsPane.class.getName());

    public JobApplicationDetailsPane() {
        this.jobContext = new JobContext();
        this.buildPane();
    }

    public void buildPane() {
        this.lblApplicationName = new JLabel();
        this.txtApplicationName = new JTextField();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.rdbExecuteJobs = new JRadioButton();
        this.rdbGenerateXML = new JRadioButton();
        this.lblXMLLocation = new JLabel();
        this.txtXMLLocation = new JTextField();
        this.btnXLMLocBrowse = new JButton();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblApplicationName, this, 0, 0, 1, 1, 2, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.txtApplicationName, this, 1, 0, 1, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(Box.createGlue(), this, 2, 0, 1, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        this.jobsPane = new JobTablePane(this.resource.getString("JobApplicationDetailsPane.jobTable.text", "Jobs", new Object[0]), false);
        LayoutUtils.addComponent(this.jobsPane, this, 0, 1, 3, 1, 1, 18, 1.0, 1.0, new Insets(5, 5, 5, 5));
        JPanel controlPane = new JPanel();
        controlPane.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(Box.createGlue(), controlPane, 0, 0, 1, 1, 2, 10, 1.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.btnMoveUp, controlPane, 1, 0, 1, 1, 0, 10, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.btnMoveDown, controlPane, 2, 0, 1, 1, 0, 10, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.btnAdd, controlPane, 3, 0, 1, 1, 0, 10, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.btnEdit, controlPane, 4, 0, 1, 1, 0, 10, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(this.btnRemove, controlPane, 5, 0, 1, 1, 0, 10, 0.0, 0.0, LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent(controlPane, this, 0, 2, 3, 1, 1, 13, 1.0, 0.0, new Insets(0, 5, 0, 5));
        this.globalVarsPane = new JobVariablesTablePane(this.resource.getString("JobApplicationDetailsPane.globalvars.name", "Global variables", new Object[0]), true, JobVariablesTablePane.ShowingContext.GLOBAL_VARS);
        LayoutUtils.addComponent(this.globalVarsPane, this, 0, 3, 3, 1, 1, 18, 1.0, 0.5, new Insets(5, 5, 5, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdbExecuteJobs);
        buttonGroup.add(this.rdbGenerateXML);
        JPanel xmlLocationPane = new JPanel();
        xmlLocationPane.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.lblXMLLocation, xmlLocationPane, 0, 0, 1, 1, 2, 18, 0.0, 0.0, new Insets(5, 25, 5, 5));
        LayoutUtils.addComponent(this.txtXMLLocation, xmlLocationPane, 1, 0, 1, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnXLMLocBrowse, xmlLocationPane, 2, 0, 1, 1, 2, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
        JPanel operationPane = new JPanel();
        operationPane.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(this.rdbGenerateXML, operationPane, 0, 0, 1, 1, 2, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.rdbExecuteJobs, operationPane, 1, 0, 1, 1, 2, 18, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(Box.createGlue(), operationPane, 2, 0, 1, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(xmlLocationPane, operationPane, 0, 1, 3, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(operationPane, this, 0, 4, 3, 1, 1, 13, 1.0, 0.0, new Insets(0, 5, 0, 5));
        this.lblApplicationName.setName("JobApplicationDetailsPane.lblApplicationName");
        this.txtApplicationName.setName("JobApplicationDetailsPane.txtApplicationName");
        this.btnMoveUp.setName("JobApplicationDetailsPane.btnMoveUp");
        this.btnMoveDown.setName("JobApplicationDetailsPane.btnMoveDown");
        this.btnAdd.setName("JobApplicationDetailsPane.btnAdd");
        this.btnEdit.setName("JobApplicationDetailsPane.btnEdit");
        this.btnMoveDown.setName("JobApplicationDetailsPane.btnMoveDown");
        this.rdbExecuteJobs.setName("JobApplicationDetailsPane.rdbExecuteJobs");
        this.rdbGenerateXML.setName("JobApplicationDetailsPane.rdbGenerateXML");
        this.lblXMLLocation.setName("JobApplicationDetailsPane.lblXMLLocation");
        this.txtXMLLocation.setName("JobApplicationDetailsPane.txtXMLLocation");
        this.btnXLMLocBrowse.setName("JobApplicationDetailsPane.btnXLMLocBrowse");
        this.lblApplicationName.setLabelFor(this.txtApplicationName);
        this.lblXMLLocation.setLabelFor(this.txtXMLLocation);
        this.localize();
        this.addListners();
        this.rdbGenerateXML.setSelected(true);
        this.rdbExecuteJobs.setSelected(true);
    }

    private void addListners() {
        this.rdbGenerateXML.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JobApplicationDetailsPane.this.lblXMLLocation.setEnabled(JobApplicationDetailsPane.this.rdbGenerateXML.isSelected());
                JobApplicationDetailsPane.this.txtXMLLocation.setEnabled(JobApplicationDetailsPane.this.rdbGenerateXML.isSelected());
                JobApplicationDetailsPane.this.btnXLMLocBrowse.setEnabled(JobApplicationDetailsPane.this.rdbGenerateXML.isSelected());
            }
        });
        this.btnXLMLocBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationDetailsPane.this.showFileChooserForXMLLocation();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationDetailsPane.this.jobsPane.firePropertyChange("JobTablePane.job.add.selected", false, true);
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationDetailsPane.this.jobsPane.firePropertyChange("JobTablePane.job.edit.selected", false, true);
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationDetailsPane.this.jobsPane.firePropertyChange("JobTablePane.job.remove.selected", false, true);
            }
        });
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationDetailsPane.this.jobsPane.firePropertyChange("JobTablePane.job.moveup.selected", false, true);
            }
        });
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobApplicationDetailsPane.this.jobsPane.firePropertyChange("JobTablePane.job.movedown.selected", false, true);
            }
        });
    }

    public void localize() {
        SwingUtils.setText(this.lblApplicationName, this.resource.getString("JobApplicationDetailsPane.lblDescription.text", "Job application name:", new Object[0]));
        String text = this.resource.getString("JobApplicationDetailsPane.btnMoveUp.text", "Move up", new Object[0]);
        SwingUtils.setText(this.btnMoveUp, text);
        text = this.resource.getString("JobApplicationDetailsPane.btnMoveDown.text", "Move down", new Object[0]);
        SwingUtils.setText(this.btnMoveDown, text);
        text = this.resource.getString("JobApplicationDetailsPane.btnAdd.text", "Add", new Object[0]);
        SwingUtils.setText(this.btnAdd, text);
        text = this.resource.getString("JobApplicationDetailsPane.btnEdit.text", "Edit", new Object[0]);
        SwingUtils.setText(this.btnEdit, text);
        text = this.resource.getString("JobApplicationDetailsPane.btnRemove.text", "Remove", new Object[0]);
        SwingUtils.setText(this.btnRemove, text);
        text = this.resource.getString("JobApplicationDetailsPane.rdbExecuteJobs.text", "Execute jobs", new Object[0]);
        SwingUtils.setText(this.rdbExecuteJobs, text);
        text = this.resource.getString("JobApplicationDetailsPane.rdbGenerateXML.text", "Generate job application file", new Object[0]);
        SwingUtils.setText(this.rdbGenerateXML, text);
        SwingUtils.setText(this.lblXMLLocation, this.resource.getString("JobApplicationDetailsPane.lblXMLLocation.text", "Location:", new Object[0]));
        text = this.resource.getString("JobApplicationDetailsPane.btnXLMLocBrowse.text", "Browse...", new Object[0]);
        SwingUtils.setText(this.btnXLMLocBrowse, text);
        this.jobsPane.localize();
        this.globalVarsPane.localize(JobVariablesTablePane.ShowingContext.GLOBAL_VARS);
    }

    private void showFileChooserForXMLLocation() {
        FileChooserDialog fileChooserDialog = new FileChooserDialog(this.resource.getString("JobApplicationDetailsPane.fileChooser.text", "Select location", new Object[0]), null, this, 1);
        String path = fileChooserDialog.showDialog(this.txtXMLLocation.getText());
        if (path != null && !path.isEmpty()) {
            this.txtXMLLocation.setText(path);
        }
    }

    protected void disposeDetailsDialog() {
        this.jobsPane.removeNotify();
    }

    protected void updateJobApplicationDetails(JobContext jobContext) {
        if (jobContext != null) {
            this.jobContext = jobContext;
            this.txtApplicationName.setText(jobContext.getName());
            if (this.jobContext.getJobCollection() != null) {
                this.jobsPane.setJobs(this.jobContext.getJobCollection().getJobs());
            }
            if (this.jobContext.getJobIndependentVars() != null) {
                this.globalVarsPane.setVariables(new ArrayList<VariableSettings>(this.jobContext.getJobIndependentVars().values()));
            } else {
                this.globalVarsPane.setVariables(new ArrayList<VariableSettings>());
            }
        } else {
            logger.log(Level.WARNING, "JobContext is null. So resetting all values");
            this.txtApplicationName.setText("");
            this.jobsPane.setJobs(new ArrayList<JobSettings>());
        }
    }

    protected JobContext getJobContext() {
        if (this.jobContext == null) {
            logger.log(Level.INFO, "JobContext object is null. so creating new one");
            this.jobContext = new JobContext();
        }
        this.jobContext.setName(this.txtApplicationName.getText().trim());
        if (this.jobContext.getJobCollection() == null) {
            this.jobContext.setJobCollection(new JobCollection());
        }
        this.jobContext.getJobCollection().setJobs(this.jobsPane.getJobs());
        List<VariableSettings> globalVars = this.globalVarsPane.getVariables();
        LinkedHashMap<String, VariableSettings> globalArgsMap = new LinkedHashMap<String, VariableSettings>();
        if (globalVars != null) {
            for (VariableSettings var : globalVars) {
                if (var.getName() != null && !var.getName().isEmpty()) {
                    globalArgsMap.put(var.getName(), var);
                    continue;
                }
                logger.log(Level.WARNING, "Secrete Variable name is null. So not adding the variable to the job object");
            }
        }
        this.jobContext.setJobIndependentVars(globalArgsMap);
        return this.jobContext;
    }

    public JobsOperationType getSelectedOperationType() {
        if (this.rdbExecuteJobs.isSelected()) {
            return JobsOperationType.EXECUTE;
        }
        return JobsOperationType.GENERATE_XML;
    }

    public String geXMLFileLocation() {
        return this.txtXMLLocation.getText().trim();
    }
}

