/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.engine;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.Checkpointable;
import oracle.install.commons.base.util.job.CommandExecutionJob;
import oracle.install.commons.base.util.job.DataDrivenJob;
import oracle.install.commons.base.util.job.JobApplication;
import oracle.install.commons.base.util.job.JobApplicationEvent;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.JobApplicationListener;
import oracle.install.commons.base.util.job.PerlExecutionJob;
import oracle.install.commons.base.util.job.RemoteCommandExecutionJob;
import oracle.install.commons.base.util.job.SQLExecutionJob;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.JobType;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;

public class JobExecutionEngine {
    private static final Logger logger = Logger.getLogger(JobExecutionEngine.class.getName());
    private static JobExecutionEngine engine;

    public static JobExecutionEngine getInstance() {
        if (engine == null) {
            engine = new JobExecutionEngine();
        }
        return engine;
    }

    private JobExecutionEngine() {
    }

    public List<Job> populateJobs(JobContext jobContext) throws JobApplicationException {
        List<Job> jobs = null;
        if (jobContext != null && jobContext.getJobCollection() != null && jobContext.getJobCollection().getJobs() != null) {
            jobs = this.populateJobs(jobContext, jobContext.getJobCollection().getJobs());
        }
        return jobs;
    }

    private List<Job> populateJobs(JobContext jobContext, List<JobSettings> jobSettingsList) throws JobApplicationException {
        ArrayList<Job> jobs = null;
        if (jobSettingsList != null && !jobSettingsList.isEmpty()) {
            jobs = new ArrayList<Job>();
            for (JobSettings jobSettings : jobSettingsList) {
                if (jobSettings == null) continue;
                if (this.isJobToBeExecuted(jobSettings)) {
                    Job job = null;
                    if (jobSettings.getChildJobs() != null && !jobSettings.getChildJobs().isEmpty()) {
                        String description = jobSettings.getId();
                        description = Application.getInstance().getDefaultResource().getString(jobSettings.getId() + ".description", jobSettings.getId(), new Object[0]);
                        CompositeJob compositeJob = new CompositeJob(jobSettings.getId(), description, jobSettings.getWeightage());
                        List<Job> childJobs = this.populateJobs(jobContext, jobSettings.getChildJobs());
                        if (childJobs != null && !childJobs.isEmpty()) {
                            compositeJob.setJobs(childJobs.toArray(new Job[0]));
                        }
                        job = compositeJob;
                    } else {
                        job = this.buildJob(jobContext, jobSettings);
                    }
                    if (job == null) continue;
                    this.addListners(job, jobSettings, jobContext);
                    if (jobSettings.getStatus() != null) {
                        job.setStatus(jobSettings.getStatus());
                    }
                    jobs.add(job);
                    continue;
                }
                logger.log(Level.INFO, "either execute job is set to false or job status:" + (Object)((Object)jobSettings.getStatus()) + " indicates to skip this job. So not adding job:" + jobSettings.getId() + " to the execution list");
            }
        }
        return jobs;
    }

    private Job buildJob(JobContext jobContext, JobSettings jobSettings) throws JobApplicationException {
        Job job = null;
        if (jobSettings != null) {
            String description = jobSettings.getId();
            description = Application.getInstance().getDefaultResource().getString(jobSettings.getId() + ".description", jobSettings.getId(), new Object[0]);
            if (jobSettings.getType() != null) {
                switch (jobSettings.getType()) {
                    case PERL_SCRIPT: {
                        job = new PerlExecutionJob(jobContext, jobSettings, description);
                        break;
                    }
                    case PLAIN_COMMAND: {
                        job = new CommandExecutionJob(jobContext, jobSettings, description);
                        break;
                    }
                    case REMOTE_JOB: {
                        job = new RemoteCommandExecutionJob(jobContext, jobSettings, description);
                        break;
                    }
                    case SQL_COMMAND: {
                        job = new SQLExecutionJob(jobContext, jobSettings, description);
                        break;
                    }
                    default: {
                        job = this.createJavaClassTypeObj(jobContext, jobSettings, description);
                        break;
                    }
                }
            } else {
                logger.log(Level.INFO, "Since jobtype is null, resetting it to JAVA_CLASS type for job:", jobSettings.getId());
                jobSettings.setType(JobType.JAVA_CLASS);
                job = this.createJavaClassTypeObj(jobContext, jobSettings, description);
            }
        }
        return job;
    }

    private Job createJavaClassTypeObj(JobContext jobContext, JobSettings jobSettings, String description) throws JobApplicationException {
        Job job = null;
        try {
            Class<?> classObj = Class.forName(jobSettings.getCommand());
            if (DataDrivenJob.class.isAssignableFrom(classObj)) {
                job = (Job)classObj.getConstructor(JobContext.class, JobSettings.class, String.class).newInstance(jobContext, jobSettings, description);
            } else {
                Constructor<?>[] constrcutors = classObj.getConstructors();
                if (constrcutors != null && constrcutors.length > 0) {
                    for (Constructor<?> construct : constrcutors) {
                        if (construct.getParameterTypes() == null) continue;
                        Class<?>[] argsType = construct.getParameterTypes();
                        if (argsType.length == 3) {
                            if (argsType[0] != Object.class || argsType[1] != String.class || argsType[2] != Float.TYPE) continue;
                            job = (Job)construct.newInstance(jobSettings.getId(), description, Float.valueOf(jobSettings.getWeightage()));
                            break;
                        }
                        if (argsType.length != 2) continue;
                        if (argsType[0] == Object.class && argsType[1] == String.class) {
                            job = (Job)construct.newInstance(jobSettings.getId(), description);
                            job.setWeightage(jobSettings.getWeightage());
                            break;
                        }
                        if (argsType[0] != Object.class || argsType[1] != Float.TYPE) continue;
                        job = (Job)construct.newInstance(jobSettings.getId(), Float.valueOf(jobSettings.getWeightage()));
                        job.setDescription(description);
                        break;
                    }
                }
                if (job == null) {
                    job = (Job)classObj.newInstance();
                    job.setId(jobSettings.getId());
                    job.setDescription(description);
                    job.setWeightage(jobSettings.getWeightage());
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Class not found exception occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "InstantiationException occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "IllegalAccessException occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "IllegalArgumentException occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, "InvocationTargetException occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "NoSuchMethodException occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "SecurityException occurred while creating a job object for jod id:" + jobSettings.getId() + " path:" + jobSettings.getCommand(), e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_JOB_ERR, jobSettings.getId(), jobSettings.getCommand());
        }
        return job;
    }

    private void addListners(final Job job, final JobSettings jobSettings, final JobContext jobContext) {
        if (job != null && jobSettings != null) {
            job.addPropertyChangeListener("Job.status", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object source = evt.getSource();
                    if (source instanceof Job) {
                        Job task = (Job)source;
                        Status status = task.getStatus();
                        jobSettings.setStatus(status);
                    }
                }
            });
            if (job instanceof Checkpointable) {
                JobApplication.getInstance().addJobApplicationListener(new JobApplicationListener(){

                    @Override
                    public void update(JobApplicationEvent e) {
                        if (e.getType() == JobApplicationEvent.Type.JOB_STARTED) {
                            ((Checkpointable)((Object)job)).loadCheckpoint(jobContext);
                        } else if (e.getType() == JobApplicationEvent.Type.JOB_EXECUTED) {
                            try {
                                ((Checkpointable)((Object)job)).createCheckpoint(jobContext);
                            }
                            catch (JobApplicationException e1) {
                                job.handleException(e1);
                            }
                        }
                    }
                });
            }
        }
    }

    public boolean executeJobs(JobContext jobContext) throws JobApplicationException {
        if (jobContext.getRuntimeJobs() != null && !jobContext.getRuntimeJobs().isEmpty()) {
            return this.executeJobs(jobContext.getRuntimeJobs(), jobContext);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeJobs(List<Job> jobs, JobContext jobContext) {
        boolean overallSuccess = true;
        if (jobs != null && jobContext != null) {
            for (Job job : jobs) {
                JobSettings jobSettings = this.getJobSettings(job.getId().toString(), jobContext.getJobCollection().getJobs());
                if (jobSettings != null && this.isJobToBeExecuted(jobSettings)) {
                    Status s;
                    boolean childJobSuccess;
                    long endTime;
                    Date date;
                    Object jobID;
                    Retriable<?> retriable = job.getRetriable();
                    Callable<?> work = job.getWork();
                    Status status = job.getStatus();
                    jobContext.setCurrentJob(job);
                    if (status == Status.PENDING && work != null) {
                        long startTime = 0L;
                        jobID = job.getId();
                        try {
                            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOB_STARTED, jobContext, new Object[0]));
                            date = JobHelper.getDateTime();
                            logger.log(Level.INFO, "Job :" + jobID + "[ Start Time : " + JobHelper.dateFormat.format(date) + "]");
                            startTime = date.getTime();
                            work.call();
                        }
                        catch (Exception jobException) {
                            job.handleException(jobException);
                        }
                        finally {
                            date = JobHelper.getDateTime();
                            logger.log(Level.INFO, "Job : " + jobID + "[ End Time : " + JobHelper.dateFormat.format(date) + "]");
                            endTime = date.getTime();
                            logger.log(Level.INFO, "Job : " + jobID + " - Time Elapsed : " + (endTime - startTime) / 1000L + "seconds.");
                            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOB_EXECUTED, jobContext, new Object[0]));
                        }
                    } else if (retriable != null) {
                        long startTime = 0L;
                        jobID = job.getId();
                        try {
                            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOB_STARTED, jobContext, new Object[0]));
                            date = JobHelper.getDateTime();
                            logger.log(Level.INFO, "Job :" + jobID + "[ Start Time : " + JobHelper.dateFormat.format(date) + "]");
                            startTime = date.getTime();
                            retriable.retry();
                        }
                        catch (Exception jobException) {
                            job.handleException(jobException);
                        }
                        finally {
                            date = JobHelper.getDateTime();
                            logger.log(Level.INFO, "Job : " + jobID + "[ End Time : " + JobHelper.dateFormat.format(date) + "]");
                            endTime = date.getTime();
                            logger.log(Level.INFO, "Job : " + jobID + " - Time Elapsed : " + (endTime - startTime) / 1000L + "seconds.");
                            JobApplication.getInstance().fireJobApplicationEvent(new JobApplicationEvent(JobApplicationEvent.Type.JOB_EXECUTED, jobContext, new Object[0]));
                        }
                    } else if (jobSettings.getType() != JobType.COMPOSITE_JOB && jobSettings.isRetriable()) {
                        logger.log(Level.WARNING, "Retriable is set to true. But either retriable object is null or work object is null for job:" + job.getId().toString());
                        job.handleException(new JobApplicationException((ErrorCode)JobErrorCode.RETRIABLE_OBJECT_NOT_SET_ERR, job.getId()));
                    } else {
                        logger.log(Level.WARNING, "Job:" + job.getId() + " has not been executed because of the job status:" + (Object)((Object)job.getStatus()));
                    }
                    if (job instanceof CompositeJob && !(childJobSuccess = this.executeJobs(((CompositeJob)job).getJobs(), jobContext))) {
                        overallSuccess = false;
                    }
                    if ((s = job.getStatus()) != Status.SUCCEEDED && s != Status.SUCCEEDED_PARTIALLY && s != Status.IGNORED) {
                        overallSuccess = false;
                    }
                    if (overallSuccess) continue;
                    break;
                }
                logger.log(Level.INFO, "either jobSettings object is null for job:" + job.getId() + " or job is marked as not required to run. status:" + (Object)((Object)job.getStatus()));
            }
        }
        return overallSuccess;
    }

    private boolean isJobToBeExecuted(JobSettings jobSettings) {
        Status s;
        return jobSettings != null && (s = jobSettings.getStatus()) != Status.SUCCEEDED && s != Status.SUCCEEDED_PARTIALLY && s != Status.IGNORED && jobSettings.isExecute();
    }

    public JobSettings getJobSettings(String jobId, List<JobSettings> jobs) {
        if (jobId != null && jobs != null) {
            for (JobSettings jobSettings : jobs) {
                JobSettings foundJob;
                if (jobId.equalsIgnoreCase(jobSettings.getId())) {
                    return jobSettings;
                }
                if (jobSettings.getChildJobs() == null || (foundJob = this.getJobSettings(jobId, jobSettings.getChildJobs())) == null) continue;
                return foundJob;
            }
        }
        return null;
    }

    public List<JobSettings> getJobSettingsList(List<Job> jobs, JobContext jobContext, boolean recursive, boolean onlyJobToBeExecuted) {
        ArrayList<JobSettings> jobSettingsList = null;
        if (jobs != null) {
            jobSettingsList = new ArrayList<JobSettings>();
            for (Job job : jobs) {
                List<JobSettings> childJobSettingsList;
                JobSettings jobSettings = this.getJobSettings(job.getId().toString(), jobContext.getJobCollection().getJobs());
                if (jobSettings != null && (!onlyJobToBeExecuted || this.isJobToBeExecuted(jobSettings))) {
                    jobSettingsList.add(jobSettings);
                }
                if (!recursive || !(job instanceof CompositeJob) || (childJobSettingsList = this.getJobSettingsList(((CompositeJob)job).getJobs(), jobContext, recursive, onlyJobToBeExecuted)) == null || childJobSettingsList.isEmpty()) continue;
                jobSettingsList.addAll(childJobSettingsList);
            }
        }
        return jobSettingsList;
    }
}

