/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.bean.JobCollection;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.JobType;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.bean.TypeTranslator;
import oracle.install.commons.util.XmlSupport;
import oracle.install.commons.util.exception.ApplicationException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.progress.Status;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JobBuilder {
    public static URL jobsDefinitionXSD = JobBuilder.class.getResource(JobApplicationConstants.JOB_DEFINATION_XSD);
    private static final Logger logger = Logger.getLogger(JobBuilder.class.getName());

    public void validateJobXml(URL jobsXML) {
        if (jobsXML != null) {
            try {
                XmlSupport.validate(jobsXML, jobsDefinitionXSD);
            }
            catch (Exception e) {
                throw new ApplicationException((Throwable)e, (ErrorCode)JobErrorCode.INVALID_JOB_DEFINITION_XML, jobsXML.getFile());
            }
        }
    }

    public String getApplicationName(URL jobsXML) throws JobApplicationException {
        InputStream jobsXMLStream = null;
        String applicationName = null;
        try {
            jobsXMLStream = jobsXML.openStream();
            InputSource source = new InputSource(jobsXMLStream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node jobApplciationNode = (Node)xpath.evaluate("JobApplication", source, XPathConstants.NODE);
            NamedNodeMap attributs = jobApplciationNode.getAttributes();
            Node applicationNameNode = attributs.getNamedItem("name");
            if (applicationNameNode != null) {
                applicationName = applicationNameNode.getNodeValue();
            } else {
                logger.log(Level.WARNING, "Application name is not specified in jobs xml.");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception occurred while loading and linking jobs", e);
            throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_LOAD_JOB_XML_ERR, jobsXML);
        }
        finally {
            if (jobsXMLStream != null) {
                try {
                    jobsXMLStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Cloud not close the job stream object", e);
                }
            }
        }
        return applicationName;
    }

    public JobContext buildJobs(URL jobsXML) throws JobApplicationException {
        JobContext jobContext = new JobContext();
        LinkedHashMap<String, VariableSettings> genericVariablesMap = new LinkedHashMap<String, VariableSettings>();
        if (jobsXML != null) {
            this.validateJobXml(jobsXML);
            InputStream jobsXMLStream = null;
            JobCollection jobCollection = new JobCollection();
            try {
                NodeList variables;
                String jobId;
                Node jobIdNode;
                Node jobNode;
                JobSettings jobSettings;
                int i;
                int noOfArgs;
                NodeList jobs;
                jobsXMLStream = jobsXML.openStream();
                InputSource source = new InputSource(jobsXMLStream);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node jobApplciationNode = (Node)xpath.evaluate("JobApplication", source, XPathConstants.NODE);
                NamedNodeMap attributs = jobApplciationNode.getAttributes();
                Node applicationNameNode = attributs.getNamedItem("name");
                if (applicationNameNode != null) {
                    jobContext.setName(applicationNameNode.getNodeValue());
                } else {
                    logger.log(Level.WARNING, "Application name is not specified in jobs xml.");
                }
                Node jobListNode = (Node)xpath.evaluate("JobList", jobApplciationNode, XPathConstants.NODE);
                if (jobListNode != null && (jobs = (NodeList)xpath.evaluate("Job", jobListNode, XPathConstants.NODESET)) != null) {
                    ArrayList<JobSettings> jobsList = new ArrayList<JobSettings>();
                    noOfArgs = jobs.getLength();
                    for (i = 0; i < noOfArgs; ++i) {
                        jobSettings = new JobSettings();
                        jobNode = jobs.item(i);
                        if (jobNode == null) continue;
                        attributs = jobNode.getAttributes();
                        jobIdNode = attributs.getNamedItem("id");
                        if (jobIdNode != null) {
                            jobId = jobIdNode.getNodeValue();
                            if (jobId != null && !jobId.isEmpty()) {
                                jobSettings.setId(jobId.replace(" ", "_"));
                            }
                        } else {
                            logger.log(Level.WARNING, "Job Id is not specified in jobs xml.");
                        }
                        Node weightageNode = attributs.getNamedItem("weightage");
                        if (weightageNode != null) {
                            jobSettings.setWeightage(Float.parseFloat(weightageNode.getNodeValue()));
                        } else {
                            logger.log(Level.WARNING, "weightage is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        jobsList.add(jobSettings);
                    }
                    jobCollection.setJobs(jobsList);
                }
                LinkedHashMap<String, JobSettings> jobsList = new LinkedHashMap<String, JobSettings>();
                NodeList jobNodes = (NodeList)xpath.evaluate("Job", jobApplciationNode, XPathConstants.NODESET);
                if (jobNodes != null) {
                    noOfArgs = jobNodes.getLength();
                    for (i = 0; i < noOfArgs; ++i) {
                        VariableSettings variable;
                        HashMap argsMap;
                        String[] args;
                        String argNames;
                        jobSettings = new JobSettings();
                        jobNode = jobNodes.item(i);
                        if (jobNode == null) continue;
                        attributs = jobNode.getAttributes();
                        jobIdNode = attributs.getNamedItem("id");
                        if (jobIdNode != null) {
                            jobId = jobIdNode.getNodeValue();
                            if (jobId != null && !jobId.isEmpty()) {
                                jobSettings.setId(jobId.replace(" ", "_"));
                            }
                        } else {
                            logger.log(Level.WARNING, "Job Id is not specified in jobs xml.");
                        }
                        Node node = attributs.getNamedItem("jobType");
                        if (node != null) {
                            Class<JobType> typeClass = JobType.class;
                            JobType type = TypeTranslator.translate(node.getNodeValue(), typeClass);
                            jobSettings.setType(type);
                        } else {
                            logger.log(Level.INFO, "Job type is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("commandOrPath");
                        if (node != null) {
                            jobSettings.setCommand(node.getNodeValue());
                        } else {
                            logger.log(Level.INFO, "Job command or path is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("args");
                        if (node != null) {
                            argNames = node.getNodeValue();
                            if (argNames != null && !argNames.isEmpty()) {
                                args = argNames.split(",");
                                argsMap = new LinkedHashMap<String, VariableSettings>();
                                for (String arg : args) {
                                    variable = new VariableSettings();
                                    variable.setName(arg.trim());
                                    variable.setJobId(jobSettings.getId());
                                    argsMap.put((String)arg.trim(), (VariableSettings)variable);
                                }
                                jobSettings.setArgs(argsMap);
                            }
                        } else {
                            logger.log(Level.INFO, "Job args is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("properties");
                        if (node != null) {
                            argNames = node.getNodeValue();
                            if (argNames != null && !argNames.isEmpty()) {
                                args = argNames.split(",");
                                LinkedHashMap<String, VariableSettings> propertiesMap = new LinkedHashMap<String, VariableSettings>();
                                for (String arg : args) {
                                    variable = new VariableSettings();
                                    variable.setName(arg.trim());
                                    variable.setJobId(jobSettings.getId());
                                    propertiesMap.put(arg.trim(), variable);
                                }
                                jobSettings.setCmdProperties(propertiesMap);
                            }
                        } else {
                            logger.log(Level.INFO, "Job args is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("secreteArgsNames");
                        if (node != null) {
                            String secreteArgNames = node.getNodeValue();
                            if (secreteArgNames != null && !secreteArgNames.isEmpty()) {
                                args = secreteArgNames.split(",");
                                argsMap = new HashMap();
                                for (String arg : args) {
                                    variable = new VariableSettings();
                                    variable.setName(arg.trim());
                                    variable.setJobId(jobSettings.getId());
                                    variable.setSecure(true);
                                    argsMap.put(arg.trim(), variable);
                                }
                                jobSettings.setSecreteArgs(argsMap);
                            }
                        } else {
                            logger.log(Level.INFO, "Job secreteargs is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("retriable");
                        if (node != null) {
                            jobSettings.setRetriable(Boolean.parseBoolean(node.getNodeValue()));
                        } else {
                            logger.log(Level.INFO, "Job retriable is not specified for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("ignorableErrors");
                        if (node != null) {
                            String argsValue = node.getNodeValue();
                            if (argsValue != null && !argsValue.isEmpty()) {
                                String[] errorCodes = argsValue.split(",");
                                ArrayList<String> ignorableErrors = new ArrayList<String>();
                                for (String errorCode : errorCodes) {
                                    ignorableErrors.add(errorCode);
                                }
                                jobSettings.setIgnorableErrors(ignorableErrors);
                            }
                        } else {
                            logger.log(Level.INFO, "Job ignorableErrors is not specified for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("envVariablesAndValues");
                        if (node != null) {
                            String nodeValue = node.getNodeValue();
                            if (nodeValue != null && !nodeValue.isEmpty()) {
                                String[] envVarsAndValues = nodeValue.split(",");
                                LinkedHashMap<String, VariableSettings> envVarsMap = new LinkedHashMap<String, VariableSettings>();
                                for (String env : envVarsAndValues) {
                                    String[] nameAndValue = env.split("=");
                                    String envName = "";
                                    String envValue = null;
                                    if (nameAndValue == null) continue;
                                    if (nameAndValue.length > 1) {
                                        envName = nameAndValue[0];
                                        envValue = nameAndValue[1];
                                    } else {
                                        envName = nameAndValue[0];
                                    }
                                    VariableSettings variable2 = new VariableSettings();
                                    variable2.setName(envName.trim());
                                    variable2.setJobId(jobSettings.getId());
                                    variable2.setValue(envValue);
                                    envVarsMap.put(envName.trim(), variable2);
                                }
                                jobSettings.setEnvVariables(envVarsMap);
                            }
                        } else {
                            logger.log(Level.INFO, "Job envVariablesAndValues is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("executeJob");
                        if (node != null) {
                            String value = node.getNodeValue();
                            jobSettings.setExecute(Boolean.valueOf(value));
                        } else {
                            logger.log(Level.INFO, "execute job property is not specified  for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        node = attributs.getNamedItem("status");
                        if (node != null) {
                            jobSettings.setStatus(Status.valueOf(node.getNodeValue()));
                        } else {
                            logger.log(Level.INFO, "Job retriable is not specified for Job Id:" + jobSettings.getId() + " in jobs xml.");
                        }
                        NodeList jobs2 = (NodeList)xpath.evaluate("ChildJob", jobNode, XPathConstants.NODESET);
                        if (jobs2 != null) {
                            ArrayList<JobSettings> childJobs = new ArrayList<JobSettings>();
                            int childJobsCound = jobs2.getLength();
                            for (int j = 0; j < childJobsCound; ++j) {
                                JobSettings childJob = new JobSettings();
                                Node childJobNode = jobs2.item(j);
                                if (childJobNode == null) continue;
                                attributs = childJobNode.getAttributes();
                                Node childJobIdNode = attributs.getNamedItem("id");
                                if (childJobIdNode != null) {
                                    String jobId2 = childJobIdNode.getNodeValue();
                                    if (jobId2 != null && !jobId2.isEmpty()) {
                                        childJob.setId(jobId2.replace(" ", "_"));
                                    }
                                } else {
                                    logger.log(Level.WARNING, "Child Job Id is not specified in jobs xml.");
                                }
                                Node weightageNode = attributs.getNamedItem("weightage");
                                if (weightageNode != null) {
                                    childJob.setWeightage(Float.parseFloat(weightageNode.getNodeValue()));
                                } else {
                                    logger.log(Level.WARNING, "weightage is not specified  for Job Id:" + childJob.getId() + " in jobs xml.");
                                }
                                childJobs.add(childJob);
                            }
                            jobSettings.setChildJobs(childJobs);
                        }
                        jobsList.put(jobSettings.getId(), jobSettings);
                    }
                }
                LinkedHashMap<String, List<VariableSettings>> jobSpecificVariablesMap = new LinkedHashMap<String, List<VariableSettings>>();
                Node variablesNode = (Node)xpath.evaluate("Variables", jobApplciationNode, XPathConstants.NODE);
                if (variablesNode != null && (variables = (NodeList)xpath.evaluate("Variable", variablesNode, XPathConstants.NODESET)) != null) {
                    int noOfVars = variables.getLength();
                    for (int i2 = 0; i2 < noOfVars; ++i2) {
                        Node variableNode = variables.item(i2);
                        if (variableNode == null) continue;
                        VariableSettings variable = new VariableSettings();
                        attributs = variableNode.getAttributes();
                        Node nameNode = attributs.getNamedItem("name");
                        if (nameNode != null) {
                            variable.setName(nameNode.getNodeValue());
                        } else {
                            logger.log(Level.WARNING, "Variable name is not specified in jobs xml.");
                        }
                        Node secureNode = attributs.getNamedItem("secure");
                        if (secureNode != null) {
                            variable.setSecure(Boolean.valueOf(secureNode.getNodeValue()));
                        } else {
                            logger.log(Level.INFO, "secure proeperty is not specified for variable:" + variable.getName() + " in jobs xml.");
                        }
                        Node promptStringNode = attributs.getNamedItem("prmptString");
                        if (promptStringNode != null) {
                            variable.setPromptString(promptStringNode.getNodeValue());
                        } else {
                            logger.log(Level.INFO, "prmptString proeperty is not specified for variable:" + variable.getName() + " in jobs xml.");
                        }
                        Node valueNode = attributs.getNamedItem("value");
                        if (valueNode != null) {
                            variable.setValue(valueNode.getNodeValue());
                        } else {
                            logger.log(Level.INFO, "value is not specified for variable:" + variable.getName() + " in jobs xml.");
                        }
                        Node mandatoryNode = attributs.getNamedItem("optional");
                        if (mandatoryNode != null) {
                            variable.setOptional(Boolean.valueOf(mandatoryNode.getNodeValue()));
                        } else {
                            logger.log(Level.INFO, "mandatory is not specified for variable:" + variable.getName() + " in jobs xml.");
                        }
                        Node valueExpectedPropNode = attributs.getNamedItem("valueExpected");
                        if (valueExpectedPropNode != null) {
                            variable.setValueExpected(Boolean.valueOf(valueExpectedPropNode.getNodeValue()));
                        } else {
                            logger.log(Level.INFO, "includeAsProperty is not specified for variable:" + variable.getName() + " in jobs xml.");
                        }
                        Node jobIdNode2 = attributs.getNamedItem("jobId");
                        if (jobIdNode2 != null) {
                            String jobId3 = jobIdNode2.getNodeValue();
                            if (jobId3 != null && !jobId3.isEmpty()) {
                                variable.setJobId(jobId3.replace(" ", "_"));
                            }
                        } else {
                            logger.log(Level.INFO, "jobId is not specified for variable:" + variable.getName() + " in jobs xml.");
                        }
                        if (variable.getJobId() != null && !variable.getJobId().isEmpty()) {
                            if (jobSpecificVariablesMap.get(variable.getJobId()) == null) {
                                jobSpecificVariablesMap.put(variable.getJobId(), new ArrayList());
                            }
                            ((List)jobSpecificVariablesMap.get(variable.getJobId())).add(variable);
                            continue;
                        }
                        genericVariablesMap.put(variable.getName(), variable);
                    }
                }
                jobContext.setJobCollection(jobCollection);
                this.linkJobsAndVariables(jobContext, jobsList, genericVariablesMap, jobSpecificVariablesMap);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception occurred while loading and linking jobs", e);
                throw new JobApplicationException((ErrorCode)JobErrorCode.UNABLE_TO_LOAD_JOB_XML_ERR, e);
            }
            finally {
                if (jobsXMLStream != null) {
                    try {
                        jobsXMLStream.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Cloud not close the job stream object", e);
                    }
                }
            }
        }
        if (JobApplicationConstants.PREDEINFED_GLOBAL_VARS != null) {
            for (String varName : JobApplicationConstants.PREDEINFED_GLOBAL_VARS) {
                if (genericVariablesMap.containsKey(varName)) continue;
                VariableSettings var = new VariableSettings();
                var.setName(varName);
                var.setValueExpected(true);
                genericVariablesMap.put(varName, var);
            }
        }
        jobContext.setJobIndependentVars(genericVariablesMap);
        return jobContext;
    }

    private void linkJobsAndVariables(JobContext jobContext, Map<String, JobSettings> jobsMap, Map<String, VariableSettings> genericVariables, Map<String, List<VariableSettings>> jobSpecificVariablesMap) throws JobApplicationException {
        if (jobContext != null && jobsMap != null && jobContext.getJobCollection() != null && jobContext.getJobCollection().getJobs() != null) {
            for (JobSettings job : jobContext.getJobCollection().getJobs()) {
                this.updateJobDetails(job, jobsMap, genericVariables, jobSpecificVariablesMap);
            }
        }
    }

    private void updateJobDetails(JobSettings jobSettings, Map<String, JobSettings> jobsMap, Map<String, VariableSettings> genericVariables, Map<String, List<VariableSettings>> jobSpecificVariablesMap) throws JobApplicationException {
        if (jobSettings != null && jobsMap != null) {
            VariableSettings variableSettings;
            JobSettings sourceJob = jobsMap.get(jobSettings.getId());
            if (sourceJob != null) {
                jobSettings = this.copyJobSettings(sourceJob, jobSettings);
            }
            if (jobSettings.getChildJobs() != null && jobSettings.getChildJobs().size() > 0) {
                for (JobSettings jobSettings2 : jobSettings.getChildJobs()) {
                    this.updateJobDetails(jobSettings2, jobsMap, genericVariables, jobSpecificVariablesMap);
                }
            }
            if (jobSettings.getArgs() != null && jobSettings.getArgs().size() > 0) {
                for (Map.Entry entry : jobSettings.getArgs().entrySet()) {
                    variableSettings = (VariableSettings)entry.getValue();
                    this.updateVariableSettings(variableSettings, jobSettings.getId(), genericVariables, jobSpecificVariablesMap);
                }
            }
            if (jobSettings.getCmdProperties() != null && jobSettings.getCmdProperties().size() > 0) {
                for (Map.Entry entry : jobSettings.getCmdProperties().entrySet()) {
                    variableSettings = (VariableSettings)entry.getValue();
                    this.updateVariableSettings(variableSettings, jobSettings.getId(), genericVariables, jobSpecificVariablesMap);
                    variableSettings.setValueExpected(true);
                }
            }
            if (jobSettings.getSecreteArgs() != null && jobSettings.getSecreteArgs().size() > 0) {
                for (Map.Entry entry : jobSettings.getSecreteArgs().entrySet()) {
                    variableSettings = (VariableSettings)entry.getValue();
                    this.updateVariableSettings(variableSettings, jobSettings.getId(), genericVariables, jobSpecificVariablesMap);
                    variableSettings.setSecure(true);
                }
            }
            String executeJobProperty = jobSettings.getId();
            if (jobSpecificVariablesMap != null && jobSpecificVariablesMap.get(jobSettings.getId()) != null) {
                for (VariableSettings variable : jobSpecificVariablesMap.get(jobSettings.getId())) {
                    if (!executeJobProperty.equalsIgnoreCase(variable.getName())) continue;
                    jobSettings.setExecute(Boolean.valueOf(variable.getValue()));
                    break;
                }
            } else if (genericVariables != null && genericVariables.get(executeJobProperty) != null) {
                VariableSettings variableSettings2 = genericVariables.get(executeJobProperty);
                jobSettings.setExecute(Boolean.valueOf(variableSettings2.getValue()));
            } else {
                logger.log(Level.WARNING, "No variable defination found for variable:" + executeJobProperty);
            }
        }
    }

    private void updateVariableSettings(VariableSettings variableSettings, String jobId, Map<String, VariableSettings> genericVariables, Map<String, List<VariableSettings>> jobSpecificVariablesMap) throws JobApplicationException {
        if (jobSpecificVariablesMap != null && jobSpecificVariablesMap.get(jobId) != null && jobSpecificVariablesMap.get(jobId).contains(variableSettings)) {
            for (VariableSettings variable : jobSpecificVariablesMap.get(jobId)) {
                if (!variableSettings.getName().equalsIgnoreCase(variable.getName())) continue;
                this.copyVariableSettings(variable, variableSettings);
                break;
            }
        } else if (genericVariables != null && genericVariables.get(variableSettings.getName()) != null) {
            this.copyVariableSettings(genericVariables.get(variableSettings.getName()), variableSettings);
            variableSettings.setJobId(jobId);
        } else {
            logger.log(Level.WARNING, "No variable defination found for variable:" + variableSettings.getName());
            throw new JobApplicationException((ErrorCode)JobErrorCode.VARIABLE_DEFINITION_NOT_FOUND_ERR, variableSettings.getName());
        }
    }

    private JobSettings copyJobSettings(JobSettings sourceJob, JobSettings destJob) {
        if (sourceJob != null) {
            if (destJob == null) {
                destJob = new JobSettings();
                destJob.setId(sourceJob.getId());
                destJob.setWeightage(sourceJob.getWeightage());
            }
            destJob.setArgs(sourceJob.getArgs());
            destJob.setCmdProperties(sourceJob.getCmdProperties());
            destJob.setCommand(sourceJob.getCommand());
            destJob.setExecute(sourceJob.isExecute());
            destJob.setEnvVariables(sourceJob.getEnvVariables());
            destJob.setIgnorableErrors(sourceJob.getIgnorableErrors());
            destJob.setRetriable(sourceJob.isRetriable());
            destJob.setSecreteArgs(sourceJob.getSecreteArgs());
            destJob.setType(sourceJob.getType());
            destJob.setChildJobs(sourceJob.getChildJobs());
            destJob.setStatus(sourceJob.getStatus());
        }
        return destJob;
    }

    private VariableSettings copyVariableSettings(VariableSettings sourceVariable, VariableSettings destVariable) {
        if (sourceVariable != null) {
            if (destVariable == null) {
                destVariable = new VariableSettings();
                destVariable.setName(sourceVariable.getName());
                destVariable.setJobId(sourceVariable.getJobId());
            }
            destVariable.setPromptString(sourceVariable.getPromptString());
            destVariable.setSecure(sourceVariable.isSecure());
            destVariable.setValueExpected(sourceVariable.isValueExpected());
            destVariable.setOptional(sourceVariable.isOptional());
            destVariable.setValue(sourceVariable.getValue());
        }
        return destVariable;
    }
}

