/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.summary;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.interview.common.bean.Component;
import oracle.install.commons.base.resource.StringResourceBundle;
import oracle.install.commons.base.summary.Category;
import oracle.install.commons.base.summary.ComponentSet;
import oracle.install.commons.base.summary.Percentage;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.summary.SummaryEditEvent;
import oracle.install.commons.base.summary.SummaryEditListener;
import oracle.install.commons.base.summary.Variable;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.XmlBeanStoreFileChooser;
import oracle.install.commons.swing.tree.TreeUtils;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.system.filemgmt.FileSystemErrorCode;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.Resource;

public class SummaryPane
extends JPanel {
    public static final String RECORD_RESPONSE_FILE_OPTION_SUPPORT_PROPERTY = "oracle.install.recordResponseFileSupported";
    private static final Logger logger = Logger.getLogger(SummaryPane.class.getName());
    private JButton btnSave;
    private JFileChooser chooser;
    private Resource resource;
    private SummaryJTree tree;
    private SummaryTreeModel treeModel;
    private PropertyChangeListener summaryPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                SummaryPane.this.treeModel.reloadTree();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SummaryPane.this.treeModel.reloadTree();
                    }
                });
            }
        }
    };
    private EventSupport<SummaryEditEvent> summaryEditEventSupport;
    String editString;

    public SummaryPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource(StringResourceBundle.class.getName());
        this.editString = this.resource.getString("SummaryPane.edit", "Edit", new Object[0]);
        this.summaryEditEventSupport = new EventSupport();
        this.buildUI();
        this.localize();
    }

    public Summary getSummary() {
        return this.treeModel.getSummary();
    }

    public void setSummary(Summary setupSummary) {
        this.treeModel.setSummary(setupSummary);
    }

    public void addSaveActionListener(ActionListener listener) {
        this.btnSave.addActionListener(listener);
    }

    public void removeSaveActionListener(ActionListener listener) {
        this.btnSave.removeActionListener(listener);
    }

    protected void buildUI() {
        this.btnSave = new JButton();
        this.btnSave.setName("SummaryPane.btnSave");
        this.chooser = new XmlBeanStoreFileChooser();
        this.setLayout(new GridBagLayout());
        this.tree = new SummaryJTree();
        this.treeModel = new SummaryTreeModel();
        this.tree.setLargeModel(true);
        this.tree.setModel(this.treeModel);
        HyperLinkTreeCellRenderer renderer = new HyperLinkTreeCellRenderer(null, this.tree);
        this.tree.setCellRenderer(renderer);
        this.tree.setCellEditor(new HyperLinkTreeCellEditor(this.tree, renderer));
        this.tree.setEditable(true);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(Math.round(1.2f * (float)this.tree.getRowHeight()));
        this.tree.setShowsRootHandles(true);
        if (Application.getInstance().getString(RECORD_RESPONSE_FILE_OPTION_SUPPORT_PROPERTY, Boolean.toString(true), new Object[0]).equals("false")) {
            this.showSaveResponseFileOption(false);
        }
        this.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.tree.setAutoscrolls(false);
        LayoutUtils.addComponent(scrollPane, this, 0, 0, 1, 1, 1, 10, 1.0, 1.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnSave, this, 0, 1, 1, 1, 0, 13, 0.0, 0.0, new Insets(5, 5, 5, 5));
    }

    public void showSaveResponseFileOption(boolean show) {
        this.btnSave.setVisible(show);
    }

    public void addSummaryEditListener(SummaryEditListener listener) {
        this.summaryEditEventSupport.addEventListener(listener);
    }

    public void removeSummaryEditListener(SummaryEditListener listener) {
        this.summaryEditEventSupport.removeEventListener(listener);
    }

    protected void fireSummaryEditEvent(SummaryEditEvent summaryEditEvent) {
        this.summaryEditEventSupport.fireEvent(summaryEditEvent);
    }

    public void localize() {
        SwingUtils.setText(this.btnSave, this.resource.getString("SummaryPane.btnSave.text", "&Save Response File...", new Object[0]));
        this.chooser.setDialogTitle(this.resource.getString("SummaryPane.SaveDialog.title", "Save Response File", new Object[0]));
    }

    public File getResponseFile() {
        int returnVal;
        String rspName;
        File responseFile = null;
        Frame parent = (Frame)SwingUtilities.windowForComponent(this);
        Application application = Application.getInstance();
        if (this.chooser.getSelectedFile() == null && (rspName = application.getString("SummaryPane.responseFile.name", null, new Object[0])) != null) {
            if (PlatformInfo.getInstance().isWindows()) {
                this.chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            }
            this.chooser.setSelectedFile(new File(rspName));
        }
        if ((returnVal = this.chooser.showSaveDialog(parent)) == 0) {
            responseFile = this.chooser.getSelectedFile();
            File ParentDir = new File(responseFile.getParent());
            if (!FileSystem.isFileNameValid(responseFile.getName(), FileSystem.getBadCharsSet())) {
                StandardDialog.showError(null, InstallerErrorCode.INVALID_RESPONSE_FILE_NAME, responseFile.getName());
                responseFile = null;
            }
            if (!ParentDir.canWrite()) {
                StandardDialog.showError(null, FileSystemErrorCode.TARGET_DIR_NOT_WRITABLE, ParentDir);
                responseFile = null;
            } else if (responseFile.exists()) {
                String title = this.chooser.getDialogTitle();
                String message = this.resource.getString("SummaryPane.fileReplaceConfirmation.text", "{0} already exists.\nDo you want to replace it ?", responseFile.getPath());
                int result = JOptionPane.showConfirmDialog(parent, message, title, 0, 2);
                if (result != 0) {
                    responseFile = null;
                } else if (!responseFile.canWrite()) {
                    StandardDialog.showError(null, FileSystemErrorCode.TARGET_DIR_NOT_WRITABLE, responseFile);
                    responseFile = null;
                }
            }
        }
        return responseFile;
    }

    class SummaryJTree
    extends JTree {
        MouseMotionListener mouseMotionListener;

        public SummaryJTree() {
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(32, 0, true), "EditLinkSelected");
            ActionMap actionMap = this.getActionMap();
            actionMap.put("EditLinkSelected", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode treeNode;
                    Object userObject;
                    Object node;
                    TreePath path = SummaryJTree.this.getSelectionPath();
                    if (path != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof UserObject && (userObject = ((UserObject)userObject).getUserObject()) instanceof Variable) {
                        SummaryPane.this.fireSummaryEditEvent(new SummaryEditEvent((Variable)userObject, SummaryEditEvent.Type.EDIT_SUMMARY));
                    }
                }
            });
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            if (this.getAutoscrolls()) {
                super.scrollRectToVisible(aRect);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleSummaryJTree();
            }
            return this.accessibleContext;
        }

        protected class AccessibleSummaryJTree
        extends JTree.AccessibleJTree
        implements TreeSelectionListener {
            public AccessibleSummaryJTree() {
                super(SummaryJTree.this);
                SummaryJTree tree = SummaryJTree.this;
                tree.addTreeSelectionListener(this);
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode treeNode;
                Object userObject;
                TreePath treePath = e.getNewLeadSelectionPath();
                if (treePath != null && (userObject = (treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof UserObject) {
                    userObject = ((UserObject)userObject).getUserObject();
                    String newValue = null;
                    if (userObject instanceof Summary) {
                        newValue = ((Summary)userObject).getDescription();
                    } else if (userObject instanceof Category) {
                        newValue = ((Category)userObject).getDescription();
                    } else if (userObject instanceof Variable) {
                        String desc = ((Variable)userObject).getDescription();
                        Object obj = ((Variable)userObject).getValue();
                        if (obj != null) {
                            if (obj instanceof Percentage) {
                                Percentage percentage = (Percentage)obj;
                                String message = percentage.getDescription();
                                if (message == null) {
                                    message = String.valueOf(percentage.getPercentage());
                                }
                                newValue = desc + ": " + message;
                            } else {
                                newValue = desc + ": " + obj;
                            }
                            String stateId = ((Variable)userObject).getAssociatedStateId();
                            if (stateId != null && stateId.length() > 0) {
                                newValue = newValue + ". " + SummaryPane.this.resource.getString("SummaryPane.editoption.description", "Press SPACEBAR to go back to the page to update this field.", new Object[0]);
                            }
                        } else {
                            newValue = desc + ": " + SummaryPane.this.resource.getString("SummaryPane.notSpecified", "<Not Specified>", new Object[0]);
                        }
                    } else if (userObject instanceof ComponentSet) {
                        newValue = ((ComponentSet)userObject).getDescription();
                    } else if (userObject instanceof Component) {
                        Component component = (Component)userObject;
                        newValue = component.getName() + ": " + component.getVersion();
                    }
                    if (newValue != null && newValue.length() > 0) {
                        this.setAccessibleDescription(newValue);
                    }
                }
            }

            public void valueChanged(EventObject e) {
            }
        }
    }

    class HyperLinkTreeCellEditor
    extends DefaultTreeCellEditor {
        JTree tree;
        DefaultTreeCellRenderer renderer;
        HyperlinkListener hyperLinkListener;

        public HyperLinkTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
            this.tree = tree;
            this.renderer = renderer;
            this.hyperLinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    Object variableObj;
                    DefaultMutableTreeNode treeNode;
                    Object userObject;
                    Object node;
                    TreePath path;
                    HyperlinkEvent.EventType eventType = e.getEventType();
                    if (eventType == HyperlinkEvent.EventType.ACTIVATED && e.getSource() != null && (path = HyperLinkTreeCellEditor.this.tree.getSelectionPath()) != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof UserObject && (variableObj = ((UserObject)userObject).getUserObject()) instanceof Variable) {
                        HyperLinkTreeCellEditor.this.cancelCellEditing();
                        SummaryPane.this.fireSummaryEditEvent(new SummaryEditEvent((Variable)variableObj, SummaryEditEvent.Type.EDIT_SUMMARY));
                    }
                }
            };
        }

        @Override
        public java.awt.Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            super.getTreeCellEditorComponent(tree, value, true, expanded, leaf, row);
            java.awt.Component comp = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
            if (comp instanceof SummaryHtmlPane) {
                ((SummaryHtmlPane)comp).removeHyperlinkListener(this.hyperLinkListener);
                ((SummaryHtmlPane)comp).addHyperlinkListener(this.hyperLinkListener);
                InputMap inputMap = ((SummaryHtmlPane)comp).getInputMap();
                ActionMap actionMap = ((SummaryHtmlPane)comp).getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(38, 0, true), "Editing");
                inputMap.put(KeyStroke.getKeyStroke(40, 0, true), "Editing");
                actionMap.remove("Editing");
                actionMap.put("Editing", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HyperLinkTreeCellEditor.this.cancelCellEditing();
                    }
                });
            }
            return comp;
        }

        @Override
        protected boolean canEditImmediately(EventObject event) {
            if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
                MouseEvent me = (MouseEvent)event;
                return me.getClickCount() > 0 && this.inHitRegion(me.getX(), me.getY());
            }
            return event == null;
        }
    }

    class HyperLinkTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        Icon icon;
        Font plainFont;
        Font boldFont;
        JTree tree;

        public HyperLinkTreeCellRenderer(Icon icon, JTree tree) {
            this.icon = icon;
            this.tree = tree;
        }

        @Override
        public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object userObject;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            SummaryHtmlPane pane = null;
            if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof UserObject) {
                pane = ((UserObject)userObject).getHtmlPane();
            }
            if (pane != null) {
                Font font = this.getFont();
                Font font2 = font = font == null ? this.tree.getFont() : font;
                if (font != null) {
                    if (!leaf) {
                        if (this.boldFont == null) {
                            this.boldFont = new Font(font.getFamily(), 1, font.getSize());
                        }
                        pane.setFont(this.boldFont);
                        this.setFont(this.boldFont);
                    } else {
                        if (this.plainFont == null) {
                            this.plainFont = new Font(font.getFamily(), 0, font.getSize());
                        }
                        pane.setFont(this.plainFont);
                        this.setFont(this.plainFont);
                    }
                }
                Color bg = null;
                bg = sel ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor();
                pane.setBackground(bg);
                this.setBackground(bg);
            }
            this.setIcon(this.icon);
            this.setEnabled(tree.isEnabled());
            return pane;
        }
    }

    class SummaryHtmlPane
    extends HtmlPane {
        public SummaryHtmlPane() {
            this.setText("  ");
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = this.getEditorKit() instanceof HTMLEditorKit ? new SummaryHtmlAccessibilityPane() : super.getAccessibleContext();
            }
            return this.accessibleContext;
        }

        class SummaryHtmlAccessibilityPane
        extends JEditorPane.AccessibleJEditorPaneHTML {
            SummaryHtmlAccessibilityPane() {
                super(SummaryHtmlPane.this);
            }

            @Override
            public String getAccessibleDescription() {
                return "";
            }

            @Override
            public String getAccessibleName() {
                return "";
            }
        }
    }

    private class SummaryTreeModel
    extends DefaultTreeModel {
        private Summary summary;

        public SummaryTreeModel() {
            super(new DefaultMutableTreeNode(new UserObject("", new SummaryHtmlPane())), false);
        }

        public Summary getSummary() {
            return this.summary;
        }

        public void setSummary(Summary summary) {
            if (this.summary != summary) {
                this.summary = summary;
                this.summary.addPropertyChangeListener("Summary.ready", SummaryPane.this.summaryPropertyListener);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.reloadTree();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SummaryTreeModel.this.reloadTree();
                        }
                    });
                }
            }
        }

        public void reloadTree() {
            if (this.summary != null && this.summary.isReady()) {
                this.reset();
                this.reload();
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)SummaryPane.this.treeModel.getRoot();
                Category category2 = null;
                ComponentSet componentSet2 = null;
                SummaryHtmlPane pane = null;
                try {
                    pane = new SummaryHtmlPane();
                    pane.setText(this.summary.getDescription());
                    DefaultMutableTreeNode summaryNode = new DefaultMutableTreeNode(new UserObject(this.summary, pane));
                    this.insertNodeInto(summaryNode, root, root.getChildCount());
                    for (Category category2 : this.summary.getCategories()) {
                        pane = new SummaryHtmlPane();
                        pane.setText(category2.getDescription());
                        DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(new UserObject(category2, pane));
                        this.insertNodeInto(categoryNode, summaryNode, summaryNode.getChildCount());
                        for (Variable variable : category2.getVariables()) {
                            String description = variable.getDescription();
                            Object obj = variable.getValue();
                            String newValue = null;
                            if (obj != null) {
                                if (obj instanceof Percentage) {
                                    Percentage percentage = (Percentage)obj;
                                    String message = percentage.getDescription();
                                    if (message == null) {
                                        message = String.valueOf(percentage.getPercentage());
                                    }
                                    newValue = description + ": " + message;
                                } else {
                                    newValue = description + ": " + obj;
                                }
                                String stateId = variable.getAssociatedStateId();
                                if (stateId != null && stateId.length() > 0) {
                                    newValue = newValue + " [<a href=\"" + stateId + "\">" + SummaryPane.this.editString + "</a>]";
                                }
                            } else {
                                newValue = description + ": " + SummaryPane.this.resource.getString("SummaryPane.notSpecified", "<Not Specified>", new Object[0]);
                            }
                            pane = new SummaryHtmlPane();
                            pane.setText(newValue);
                            DefaultMutableTreeNode variableNode = new DefaultMutableTreeNode(new UserObject(variable, pane));
                            this.insertNodeInto(variableNode, categoryNode, categoryNode.getChildCount());
                        }
                    }
                    for (ComponentSet componentSet2 : this.summary.getComponentSets()) {
                        pane = new SummaryHtmlPane();
                        pane.setText(componentSet2.getDescription());
                        DefaultMutableTreeNode componentSetNode = new DefaultMutableTreeNode(new UserObject(componentSet2, pane));
                        this.insertNodeInto(componentSetNode, summaryNode, summaryNode.getChildCount());
                        for (Component component : componentSet2.getComponents()) {
                            pane = new SummaryHtmlPane();
                            String newValue = component.getName() + ": " + component.getVersion();
                            pane.setText(newValue);
                            DefaultMutableTreeNode componentNode = new DefaultMutableTreeNode(new UserObject(component, pane));
                            this.insertNodeInto(componentNode, componentSetNode, componentSetNode.getChildCount());
                        }
                    }
                    TreeUtils.setSubTreeExpanded(SummaryPane.this.tree, root, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void reset() {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
            root.postorderEnumeration();
            TreeCellEditor editor = SummaryPane.this.tree.getCellEditor();
            if (editor != null) {
                editor.cancelCellEditing();
            }
            try {
                this.clearTree(root);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception occurred while clearing summary tree", e);
            }
        }

        private void clearTree(DefaultMutableTreeNode jobTree) throws Exception {
            if (jobTree.isLeaf() && !jobTree.isRoot()) {
                this.removeNodeFromParent(jobTree);
            } else {
                ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                Enumeration<TreeNode> e = jobTree.children();
                while (e.hasMoreElements()) {
                    children.add((DefaultMutableTreeNode)e.nextElement());
                }
                for (DefaultMutableTreeNode node : children) {
                    this.clearTree(node);
                }
                if (!jobTree.isRoot()) {
                    this.removeNodeFromParent(jobTree);
                }
            }
        }

        public void addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) throws Exception {
            parent.add(node);
            int[] childIndices = new int[]{parent.getIndex(node)};
            Object[] path = parent.getPath();
            Object[] children = new Object[]{node};
            this.fireTreeNodesInserted(this, path, childIndices, children);
            this.nodeChanged(node);
        }
    }

    class UserObject {
        Object userObject;
        SummaryHtmlPane htmlPane;

        public UserObject(Object userObject, SummaryHtmlPane pane) {
            this.userObject = userObject;
            this.htmlPane = pane;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        public SummaryHtmlPane getHtmlPane() {
            return this.htmlPane;
        }

        public void setHtmlPane(SummaryHtmlPane htmlPane) {
            this.htmlPane = htmlPane;
        }

        public String toString() {
            String value = "";
            if (this.userObject != null) {
                if (this.userObject instanceof Summary) {
                    value = ((Summary)this.userObject).getDescription();
                } else if (this.userObject instanceof Category) {
                    value = ((Category)this.userObject).getDescription();
                } else if (this.userObject instanceof Variable) {
                    String desc = ((Variable)this.userObject).getDescription();
                    Object obj = ((Variable)this.userObject).getValue();
                    if (obj != null) {
                        if (obj instanceof Percentage) {
                            Percentage percentage = (Percentage)obj;
                            String message = percentage.getDescription();
                            if (message == null) {
                                message = String.valueOf(percentage.getPercentage());
                            }
                            value = desc + ": " + message;
                        } else {
                            value = desc + ": " + obj;
                        }
                    } else {
                        value = desc + ": " + SummaryPane.this.resource.getString("SummaryPane.notSpecified", "<Not Specified>", new Object[0]);
                    }
                }
            }
            return value;
        }
    }
}

