/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.action;

import java.util.concurrent.Callable;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverEvent;
import oracle.install.commons.base.driver.common.SetupDriverListener;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.util.exception.ExceptionManager;

@UIRef(value="SetupUI")
public class SetupAction
extends DefaultAction {
    private static Callable<Void> install = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            try {
                Object setupDriver = SetupDriver.getInstance();
                ((SetupDriver)setupDriver).setup();
            }
            catch (Exception e) {
                ExceptionManager.getInstance().handleException(e);
            }
            return null;
        }
    };

    @Override
    public void execute(FlowContext flowContext) {
        Object setupDriver = SetupDriver.getInstance();
        if (((SetupDriver)setupDriver).getSetupMode() == SetupMode.SILENT) {
            ((SetupDriver)setupDriver).addSetupDriverListener(new SetupDriverListener(){

                @Override
                public void update(SetupDriverEvent e) {
                    boolean isConfigTools = false;
                    CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
                    if (cmdLineArgumentHandler != null && cmdLineArgumentHandler.isArgumentPassed("executeConfigTools")) {
                        isConfigTools = true;
                    }
                    switch (e.getStatus()) {
                        case SUCCEEDED: {
                            if (isConfigTools) {
                                System.out.println("Successfully Configured Software.");
                                break;
                            }
                            System.out.println("Successfully Setup Software.");
                            break;
                        }
                        case FAILED: {
                            if (isConfigTools) {
                                System.out.println("Configuration failed.");
                                break;
                            }
                            System.out.println("Setup failed.");
                        }
                    }
                }
            });
        }
        FlowWorker worker = FlowWorker.getInstance(flowContext);
        worker.perform(install);
    }

    @Override
    public Route transition(FlowContext flowContext) {
        return Route.SUCCESS;
    }
}

