/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.cmdtools.USMDriverUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.AvailableSpaceInfoImpl;
import oracle.cluster.impl.verification.SpaceResultSetImpl;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.SpaceResultSet;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.constraints.CDMCertifiedSystems;
import oracle.cluster.verification.constraints.CDMHost;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.XmlTaskFactory;
import oracle.cluster.verification.constraints.parser.XmlParser;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.LocalCSSException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.GetSpaceCommand;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskMulticastCheck;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariableData;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.CaseInsensitiveMap;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.ConfigUtil;
import oracle.ops.verification.framework.util.CvunetQueryData;
import oracle.ops.verification.framework.util.EraserThread;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.InventoryFilePointerException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.OIFCFGInfo;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VersionComparator;
import oracle.ops.verification.framework.util.sVerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class VerificationUtil
implements VerificationConstants,
CVUHelperConstants {
    public static final String CVUQDISK_PACKAGE_NAME = "cvuqdisk";
    public static final String CVUQDISK_RPM_FILE_NAME = "cvuqdisk-1.0.10-1.rpm";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_pMsgBundle = VerificationUtil.getMessageBundle("Prvp");
    private static long KILO_BYTE = 1024L;
    private static long MEGA_BYTE = 0x100000L;
    private static long GIGA_BYTE = 0x40000000L;
    private static long TERA_BYTE = 0x10000000000L;
    private static String TRACE_CLUVFY_FNAME = "cvutrace.log";
    private static int CLUVFY = 1;
    private static int ORACLEDBDNFSSUPPORTEDVER = 11;
    private static String CV = "cv";
    private static String LOG = "log";
    private static boolean m_noReportException = false;
    private static boolean m_isLocalNodeOperationChecked = false;
    private static boolean m_isLocal = false;
    private static HashMap<String, Boolean> m_isLocalNodeResultStore = new CaseInsensitiveMap<Boolean>();
    private static String m_localHostName = null;
    private static String m_localNodeName = null;
    private static String m_localNode = null;
    private static List<String> m_crsResOwners = null;
    private static String[] m_nodeList = null;
    private static String[] m_nodeListFromOlsnodes = new String[0];
    private static String m_ClusterwarenameFromRemoteOlsnodes = null;
    private static boolean m_olsnodesExecuted = false;
    private static String[] m_nodeListFromInv = new String[0];
    private static boolean m_inventoryInspected = false;
    private static String m_distributionID = null;
    public static final String NODE_ALL = "CV_NODE_ALL";
    public static final String ASSUME_DISTID = "CV_ASSUME_DISTID";
    public static final String ASSUME_CL_VERSION = "CV_ASSUME_CL_VERSION";
    public static final String SUDO_LOCATION_PATH = "CV_SUDO_BINARY_LOCATION";
    public static final String PBRUN_LOCATION_PATH = "CV_PBRUN_BINARY_LOCATION";
    public static final String DEFAULT_BROWSER_LOCATION = "CV_DEFAULT_BROWSER_LOCATION";
    public static final String ORA_INST_INVPTR_PROPERTY = "oracle.installer.invPtrLoc";
    private static final String VDISK_DEFAULT_PERMISSIONS = "0640";
    private static final String ASM_PATH_CHARACTER = "+";
    private static final String EXADATA_PATH_CHARACTERS = "o/";
    private static final String CV_CRS_PREREQ_XML = "crsinst_prereq.xml";
    private static final String CV_DB_PREREQ_XML = "dbinst_prereq.xml";
    private static final String CV_HA_PREREQ_XML = "sihainst_prereq.xml";
    private static final String LIBNFSODM = "libnfsodm";
    private static final String LIBNFSODMLINK = "libodm";
    private static final String LIBSOEXT = ".so";
    public static final String HA_HOME_REQ = "HA";
    public static final String CRS_HOME_REQ = "CRS";
    public static final String HA_OR_CRS_HOME_REQ = "BOTH";
    public static final String ORACLE_USER = "ORACLE_USER";
    public static final String ORA_CRS_HOME = "ORA_CRS_HOME";
    private static final String LS_OPTIONS = "-Lld";
    private static final String CRSCTL_LITE_CMD = "cvunetquery";
    private static final String CRSCTL_CMD = "crsctl";
    public static final String QUERY_COMMAND = " query dns -name ";
    public static final String QUERY_COMMAND_TYPE = " -type ";
    public static final String QUERY_COMMAND_SERVER = " -dnsserver ";
    public static final String QUERY_COMMAND_CVUFORMAT = " -xml ";
    private static final String CRSTXT_SUC = "CRS-10024:";
    private static final String ERRTXT_10035 = "CRS-10035: ";
    private static final String ERRTXT_10038 = "CRS-10038: ";
    private static final String ERRTXT_10047 = "CRS-10047: ";
    private static final String ERRTXT_10048 = "CRS-10048: ";
    private static final String TAG_ARG_START = "<ARG_VALUE>";
    private static final String TAG_ARG_END = "</ARG_VALUE>";
    private static final String TXT_MSG_NUM_START = "CRS-";
    private static final String m_resolvConfLocation = "/etc/resolv.conf";
    private static final String m_nameserverLine = "^nameserver[\\s]+.*";
    private static final String m_nameserverField = "^nameserver[\\s]+";
    private static final String CELL_OS_SETUP_FILE = "/opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP";
    private static String m_cvuQDiskGrp = null;
    protected static String s_cvhome;
    protected static String s_destloc;
    protected static String s_traceloc;
    protected static String s_RDBMSVersion;
    protected static String s_currentGroup;
    protected static boolean m_isLocalNodeOper;
    protected static String s_HAHome;
    protected static Map<VerificationType, String> s_preReqXmlRepos;
    protected static String s_genericPreReqXmlFile;
    protected static String s_cvuLogFile;
    private static boolean m_crsHomeChecked;
    private static String m_crsHome;
    private static boolean m_isODASystemChecked;
    private static boolean m_isODASystem;
    protected static Map<String, String> s_releaseVersionMap;
    protected static HashSet s_secVariable;
    private static HashMap<String, String> m_adminGroups;
    private static boolean m_getAdminGroups;
    private static boolean m_getRACGroups;
    private static boolean m_groupExceptionReported;
    private static String m_asmAdminGroup;
    private static String m_asmOperGroup;
    private static String m_asmDbaGroup;
    private static String m_osAsmGroup;
    private static String m_osOperGroup;
    private static String m_osDbaGroup;
    private static String m_osBackupDBAGroup;
    private static String m_osDgDBAGroup;
    private static String m_osKmDBAGroup;
    private static String m_osRACDBAGroup;
    private static Map<String, Set<String>> m_groupPrivilegesMap;
    private static Hashtable<ShellResourceType, Hashtable<ShellLimitType, String>> m_localNodeShellLimits;
    private static String m_localNodeUmask;
    private static boolean m_cvuSysPropRead;
    public static final Pattern PASSWORD_VAR_NAME_PATTERN;
    private static Boolean m_isLocalNodeCRSConfigured;
    private static Boolean m_isLocalNodeHAConfigured;
    private static boolean m_isPostW2K12;
    private static boolean m_winVersionChecked;
    private static boolean m_isVirtualEnvChecked;
    private static boolean m_isVirtualEnv;
    private static final int TRACE_MAX_OUTPUTSIZE = 100;
    private static HashSet<String> m_nodesWithFrameworkSetup;
    public static final String INPUT_FILE_EXTN = ".in";
    public static final String OUTPUT_FILE_EXTN = ".out";
    public static final String LOCAL_FILE_EXTN = ".lcl";
    public static final String UNDERSCORE = "_";
    private static boolean m_localHostInitialized;
    private static boolean m_localNodeInitialized;

    public static void setNoReportException(boolean x) {
        m_noReportException = x;
    }

    public static synchronized void setNodelist(String[] nodeList) {
        m_nodeList = nodeList;
    }

    public static synchronized String[] getNodelist() throws NodelistNotFoundException {
        int p;
        String[] autoNodes;
        String[] rimNodes;
        String[] hubNodes;
        if (m_nodeList != null) {
            return m_nodeList;
        }
        ArrayList<String> nodelist = new ArrayList<String>();
        String[] classicNodes = VerificationUtil.getNodelist(CVUVariables.getValue(CVUVariableConstants.NODE_LIST));
        if (classicNodes != null) {
            nodelist.addAll(Arrays.asList(classicNodes));
        }
        if ((hubNodes = VerificationUtil.getNodelist(CVUVariables.getValue(CVUVariableConstants.HUB_LIST))) != null) {
            nodelist.addAll(Arrays.asList(hubNodes));
        }
        if ((rimNodes = VerificationUtil.getNodelist(CVUVariables.getValue(CVUVariableConstants.RIM_LIST))) != null) {
            nodelist.addAll(Arrays.asList(rimNodes));
        }
        if ((autoNodes = VerificationUtil.getNodelist(CVUVariables.getValue(CVUVariableConstants.AUTO_LIST))) != null) {
            nodelist.addAll(Arrays.asList(autoNodes));
        }
        if (nodelist.size() > 0) {
            Trace.out((String)"====VerificationUtil gets the nodelist from ParamManager as: ");
            for (int i = 0; i < nodelist.size(); ++i) {
                Trace.out((String)("  ==Node " + i + " is:" + (String)nodelist.get(i)));
            }
        } else {
            Trace.out((String)"Nodelist was null. Trying to get the localhost");
            nodelist.add(VerificationUtil.getLocalNode());
        }
        for (p = 0; p < nodelist.size(); ++p) {
            Trace.out((String)("==== Nodelist before processing: nodelist[" + p + "]:" + (String)nodelist.get(p)));
        }
        if (nodelist != null) {
            for (int k = 0; k < nodelist.size(); ++k) {
                nodelist.set(k, VerificationUtil.getShortHostname((String)nodelist.get(k)));
            }
        }
        for (p = 0; p < nodelist.size(); ++p) {
            Trace.out((String)("==== Nodelist after: nodelist[" + p + "]:" + (String)nodelist.get(p)));
        }
        VerificationUtil.setLocalNodeFirst(nodelist);
        VerificationLogData.logInfo("nodeList: " + VerificationUtil.strCollection2String(nodelist));
        m_nodeList = nodelist.toArray(new String[0]);
        return m_nodeList;
    }

    private static String[] getNodelist(String nodeListStr) throws NodelistNotFoundException {
        String[] nodelist;
        ParamManager pm = null;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new NodelistNotFoundException(e.getMessage());
        }
        if (!VerificationUtil.isStringGood(nodeListStr)) {
            nodelist = null;
        } else if (CLSyntax.STR_ALL.equalsIgnoreCase(nodeListStr)) {
            nodelist = VerificationUtil.getStaticNodelist();
            Trace.out((String)("nodelist obtained from getStaticNodelist(): " + VerificationUtil.strArr2List(nodelist)));
        } else {
            nodelist = nodeListStr.split(CLSyntax.DELIMETER);
        }
        return nodelist;
    }

    public static String getShortHostname(String longHostname) {
        if (longHostname == null) {
            return null;
        }
        int dotIdx = longHostname.indexOf(".");
        String hostName = dotIdx != -1 ? longHostname.substring(0, dotIdx) : longHostname;
        return hostName;
    }

    public static List<String> getCRSResourceOwners(ResultSet resultSet) {
        Trace.out((String)"ENTRY");
        if (m_crsResOwners != null) {
            Trace.out((String)("m_crsResOwners already collected, returning '" + m_crsResOwners + "'"));
            Trace.out((String)"EXIT");
            return m_crsResOwners;
        }
        if (!VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"CRS is NOT FOUND configured. returning null list");
            return m_crsResOwners;
        }
        try {
            String string = VerificationUtil.getLocalNodename();
        }
        catch (NodelistNotFoundException nlnfe) {
            Trace.out((String)("NODELISTNOTFOUNDEXCEPTION: " + nlnfe.getMessage()));
        }
        Version crsVer = VerificationUtil.getCRSActiveVersionObj();
        String errMsg = "";
        if (Version.isPre12102((Version)crsVer)) {
            return m_crsResOwners;
        }
        String CVU_HELPER_ARG = "-getcrsresown";
        Trace.out((String)"Collecting list of CRS userId's that own CRS resources.");
        ArrayList crsOwnerList = new ArrayList();
        String[] args = new String[]{CVU_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)("cvuhelper couldn't be executed: " + e.getMessage()));
            errMsg = s_gMsgBundle.getMessage("1112", true) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            resultSet.addResult(m_localNodeName, 2);
            resultSet.addErrorDescription(m_localNodeName, errorDesc);
            return null;
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)("cvuhelper failed to execute: " + helperExec.getCommandString()));
            errMsg = s_gMsgBundle.getMessage("1112", true) + LSEP + helperExec.getErrorString();
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            resultSet.addResult(m_localNodeName, 2);
            resultSet.addErrorDescription(m_localNodeName, errorDesc);
            return null;
        }
        String[] output = helperExec.getOutput();
        String outputStr = null;
        if (output.length != 0) {
            outputStr = helperExec.getOutputString();
            Trace.out((String)("CVUHelper output string: '" + outputStr + "'"));
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"error during cvu helper execution, no data collected!");
            } else {
                Trace.out((String)"all data collected");
            }
        } else {
            Trace.out((String)("cvuhelper failed to produce output: " + helperExec.getCommandString()));
            errMsg = s_gMsgBundle.getMessage("1112", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            resultSet.addResult(m_localNodeName, 2);
            resultSet.addErrorDescription(m_localNodeName, errorDesc);
            return null;
        }
        String crsResOwnLine = VerificationUtil.fetchTextByTags(outputStr, null, "<CRSRESOWN>", "</CRSRESOWN>");
        Trace.out((String)("crsResOwnLine: '" + crsResOwnLine + "'"));
        String[] crsResOwnArr = crsResOwnLine.split(",");
        m_crsResOwners = new ArrayList<String>();
        if (crsResOwnArr != null && crsResOwnArr.length > 0) {
            for (String resOwnr : crsResOwnArr) {
                if (!VerificationUtil.isStringGood(resOwnr) || m_crsResOwners.contains(resOwnr.trim())) continue;
                m_crsResOwners.add(resOwnr.trim());
            }
        }
        Trace.out((String)("returning: '" + m_crsResOwners.toString() + "'"));
        Trace.out((String)"EXIT");
        return m_crsResOwners;
    }

    public static String getLocalNodename() throws NodelistNotFoundException {
        if (m_localNodeName != null) {
            return m_localNodeName;
        }
        Trace.out((String)"Executing getLocalNodename()");
        if (VerificationUtil.isHAConfigured()) {
            m_localNodeName = VerificationUtil.getLocalNode();
        } else {
            String crsHome = VerificationUtil.getCRSHome();
            try {
                ClusterInfo cluInfo = new ClusterInfo(crsHome);
                m_localNodeName = cluInfo.getLocalNodeName();
            }
            catch (NoSuchCRSHomeException nche) {
                Trace.out((String)("====  ALERT!! CRS_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
                throw new NodelistNotFoundException(s_gMsgBundle.getMessage("8001", false, new Object[]{new String(crsHome)}));
            }
            catch (NoSuchExecutableException nsee) {
                Trace.out((String)("==== ALERT!! olsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
                throw new NodelistNotFoundException(s_gMsgBundle.getMessage("8002", true, (Object[])new String[]{crsHome + FSEP + "bin"}) + LSEP + nsee.getMessage());
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)("==== ALERT!! CRS home available, but olsnodes  does not work. Exception: '" + cie.getMessage() + "'"));
                throw new NodelistNotFoundException(s_gMsgBundle.getMessage("8003", true) + LSEP + cie.getMessage());
            }
        }
        VerificationLogData.logInfo("localNodeName: " + m_localNodeName);
        return m_localNodeName;
    }

    public static String getLocalHostName() {
        if (!m_localHostInitialized) {
            throw new IllegalStateException("m_localHostName not initialized!");
        }
        return m_localHostName;
    }

    public static void setLocalHostName(String localHostName) {
        m_localHostName = localHostName;
        m_localHostInitialized = true;
        m_localNode = VerificationUtil.getNodeName(m_localHostName);
        m_localNodeInitialized = true;
    }

    public static String getLocalNode() {
        if (!m_localNodeInitialized) {
            throw new IllegalStateException("m_localNode not initialized!");
        }
        return m_localNode;
    }

    public static String getLocalHost() throws UnknownHostException {
        String longHostName = InetAddress.getLocalHost().getHostName();
        int dotIdx = longHostName.indexOf(".");
        String hostName = dotIdx != -1 ? longHostName.substring(0, dotIdx) : longHostName;
        Trace.out((String)("Hostname retrieved: " + longHostName + ", returned: " + hostName));
        VerificationLogData.logInfo("LongHostName: " + longHostName + ", HostName: " + hostName);
        return hostName;
    }

    public static String getNodeName(String hostName) {
        if (hostName != null) {
            int dotIdx = hostName.indexOf(".");
            hostName = dotIdx != -1 ? hostName.substring(0, dotIdx) : hostName;
            return hostName.toLowerCase();
        }
        return null;
    }

    public static String[] getStaticNodelist() throws NodelistNotFoundException {
        if (VerificationUtil.isHAConfigured()) {
            Trace.out((String)"Returning local node since HA is configured");
            return new String[]{m_localHostName};
        }
        Trace.out((String)"Attempt to fetch nodelist using olsnodes");
        try {
            String[] olsnodesList = VerificationUtil.getNodelistFromOlsnodesWithException();
            if (olsnodesList != null && olsnodesList.length != 0) {
                return olsnodesList;
            }
        }
        catch (NodelistNotFoundException e) {
            String crsHome = VerificationUtil.getCRSHome();
            if (VerificationUtil.isStringGood(crsHome)) {
                throw e;
            }
            Trace.out((String)("ignoring exception from olsnodes :" + e.getMessage()));
        }
        Trace.out((String)"Nodes not found using olsnodes; Looking for CV_NODE_ALL setting");
        String ndlist = VerificationUtil.getConfiguredValue(NODE_ALL, true);
        if (ndlist == null || ndlist.trim().length() <= 0) {
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9005", false, new Object[]{new String(NODE_ALL)}));
        }
        String[] nodelist = VerificationUtil.getTokensAsArray(ndlist, ",");
        ArrayList<String> nodeListLocal = new ArrayList<String>();
        nodeListLocal.addAll(Arrays.asList(nodelist));
        VerificationUtil.setLocalNodeFirst(nodeListLocal);
        nodelist = nodeListLocal.toArray(new String[0]);
        Trace.out((String)"==== Nodelist retrieved from CV_NODE_ALL variable.");
        Trace.out((String)("==== Nodelist: " + ndlist));
        VerificationLogData.logInfo("staticNodelist: " + VerificationUtil.strArr2List(nodelist));
        return nodelist;
    }

    public static String getClusternameFromOlsnodes(String node, String CRSHome) {
        VerificationUtil.getClusternameFromOlsnodesWithException(node, CRSHome);
        return m_ClusterwarenameFromRemoteOlsnodes;
    }

    public static synchronized String getClusternameFromOlsnodesWithException(String node, String CRSHome) {
        if (VerificationUtil.isStringGood(node) && VerificationUtil.isStringGood(CRSHome)) {
            try {
                ClusterwareInfo clustInfo = new ClusterwareInfo();
                m_ClusterwarenameFromRemoteOlsnodes = clustInfo.getRemoteClusterName(node, CRSHome);
                Trace.out((String)("m_ClusterwarenameFromRemoteOlsnodes: '" + m_ClusterwarenameFromRemoteOlsnodes + "'"));
                VerificationLogData.logInfo("m_ClusterwarenameFromRemoteOlsnodes: '" + m_ClusterwarenameFromRemoteOlsnodes + "' remote node: '" + node + "' remote CRSHome: '" + CRSHome + "'");
            }
            catch (InstallException ie) {
                Trace.out((String)("INSTALLEXCEPTION: couldn't run olsnodes on remote node\nException: " + ie.getMessage()));
            }
        }
        return m_ClusterwarenameFromRemoteOlsnodes;
    }

    public static String[] getNodelistFromOlsnodes() {
        try {
            VerificationUtil.getNodelistFromOlsnodesWithException();
        }
        catch (NodelistNotFoundException nlnfe) {
            Trace.out((String)("Node list could not be found from olsnodes:" + nlnfe.getMessage()));
        }
        return m_nodeListFromOlsnodes;
    }

    public static synchronized String[] getNodelistFromOlsnodesWithException() throws NodelistNotFoundException {
        String crsHome = VerificationUtil.getCRSHome();
        Trace.out((String)("==== CRS home: " + crsHome));
        if (VerificationUtil.isStringGood(crsHome)) {
            try {
                ClusterInfo cluInfo = new ClusterInfo(crsHome);
                m_nodeListFromOlsnodes = cluInfo.getNodeNames();
                Trace.out((String)"==== Nodelist retrieved from Oracle Clusterware");
                Trace.out((String)("==== m_nodeListFromOlsnodes: " + VerificationUtil.strArr2List(m_nodeListFromOlsnodes)));
                VerificationLogData.logInfo("m_nodeListFromOlsnodes: " + VerificationUtil.strArr2List(m_nodeListFromOlsnodes));
                return m_nodeListFromOlsnodes;
            }
            catch (NoSuchCRSHomeException nche) {
                Trace.out((String)("====  ALERT!! CRS_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
                throw new NodelistNotFoundException(s_gMsgBundle.getMessage("8001", true, new Object[]{new String(crsHome)}) + LSEP + nche.getMessage());
            }
            catch (NoSuchExecutableException nsee) {
                Trace.out((String)("==== ALERT!! olsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
                throw new NodelistNotFoundException(s_gMsgBundle.getMessage("8002", true, (Object[])new String[]{crsHome + FSEP + "bin"}) + LSEP + nsee.getMessage());
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)("==== ALERT!! CRS home available, but olsnodes  does not work. Exception: '" + cie.getMessage() + "'"));
                throw new NodelistNotFoundException(s_gMsgBundle.getMessage("8003", true) + LSEP + cie.getMessage());
            }
        }
        throw new NodelistNotFoundException(s_msgBundle.getMessage("5301", true));
    }

    public static String[] getNodelistFromInv() {
        try {
            VerificationUtil.getNodelistFromInvWithException();
        }
        catch (InvalidOUIInventoryDataException inve) {
            Trace.out((String)("Node list could not be found from inventory:" + inve.getMessage()));
        }
        return m_nodeListFromInv;
    }

    public static synchronized String[] getNodelistFromInvWithException() throws InvalidOUIInventoryDataException {
        if (m_inventoryInspected) {
            return m_nodeListFromInv;
        }
        m_inventoryInspected = true;
        String inventoryFile = null;
        OUIData ouid = null;
        inventoryFile = VerificationUtil.getInventoryFileLocation();
        ouid = OUIData.getInstance(inventoryFile);
        if (ouid.isCRSInstalled()) {
            m_nodeListFromInv = ouid.getCRSNodes();
        }
        Trace.out((String)("returning with m_nodeListFromInv as: '" + VerificationUtil.strArr2List(m_nodeListFromInv) + "'"));
        return m_nodeListFromInv;
    }

    public static String[] getVendorStaticNodelist() throws NodelistNotFoundException {
        String[] nodelist = null;
        String lsnodesHome = null;
        try {
            lsnodesHome = CVUAutoUpdateManager.getLSNodesHome(VerificationUtil.isAPIMode());
            ClusterInfo pre10iCluInfo = new ClusterInfo(lsnodesHome, Version.get92Version());
            nodelist = pre10iCluInfo.getNodeNames();
            Trace.out((String)"==== Nodelist retrieved from vendor clusterware");
            Trace.out((String)("==== Nodelist: " + VerificationUtil.strArr2List(nodelist)));
            VerificationLogData.logInfo("vendorStaticNodelist: " + VerificationUtil.strArr2List(nodelist));
            return nodelist;
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)("====  ALERT!! CV_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9000", false, new Object[]{new String(VerificationUtil.getCVHome())}));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)("==== ALERT!! lsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9002", false));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)("==== Unable to retrieve nodelist from vendor clusterware. Exception: '" + cie.getMessage() + "'"));
            VerificationLogData.logInfo("vendorStaticNodelist: " + VerificationUtil.strArr2List(nodelist));
            return nodelist;
        }
    }

    public static Vector listRecursiveFiles(Vector listFilesDirs) {
        Vector fileDirVect = (Vector)listFilesDirs.clone();
        String cvhome = VerificationUtil.getCVHome();
        if (fileDirVect == null || cvhome == null) {
            return null;
        }
        Trace.out((int)1, (String)("InputList=" + VerificationUtil.strVect2List(listFilesDirs)));
        File f = null;
        int i = 0;
        while (i < fileDirVect.size()) {
            String elementName = (String)fileDirVect.elementAt(i);
            Trace.out((int)1, (String)("Working with element:" + elementName));
            if (elementName.startsWith(".")) {
                fileDirVect.removeElementAt(i);
                continue;
            }
            f = new File(cvhome + FILE_SEPARATOR + elementName);
            if (!f.isAbsolute()) {
                Trace.out((int)1, (String)("cvhome '" + cvhome + "'  is not an absolute path"));
                return null;
            }
            if (!f.exists()) {
                fileDirVect.removeElementAt(i);
                continue;
            }
            if (f.isFile()) {
                Trace.out((int)1, (String)" is a File.");
                ++i;
                continue;
            }
            if (f.isDirectory()) {
                Trace.out((int)1, (String)" is a Directory.");
                String[] list = f.list();
                for (int j = 0; list != null && j < list.length; ++j) {
                    Trace.out((int)1, (String)("Working with directory element: " + list[j]));
                    if (!list[j].startsWith(".")) {
                        String path = elementName + FILE_SEPARATOR + list[j];
                        fileDirVect.add(path);
                        Trace.out((int)1, (String)("Adding: '" + path + "'"));
                        continue;
                    }
                    Trace.out((int)1, (String)("Ignoring: '" + elementName + FILE_SEPARATOR + list[j] + "'"));
                }
                fileDirVect.removeElementAt(i);
                continue;
            }
            ++i;
        }
        Trace.out((int)1, (String)("OutputList=" + VerificationUtil.strVect2List(fileDirVect)));
        return fileDirVect;
    }

    public static void updateResultMap(Hashtable<Object, Vector<Object>> t, Object key, Object vectElem) {
        if (t.containsKey(key)) {
            if (!t.get(key).contains(vectElem)) {
                t.get(key).add(vectElem);
            }
        } else {
            Vector<Object> newVal = new Vector<Object>();
            newVal.add(vectElem);
            t.put(key, newVal);
        }
    }

    public static boolean inListIgnoreCase(List<String> strList, String searchStr) {
        if (strList != null) {
            for (String strInList : strList) {
                if (!strInList.equalsIgnoreCase(searchStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean inVectorIgnoreCase(Vector<String> strVec, String searchStr) {
        if (strVec != null) {
            for (String strInVec : strVec) {
                if (!strInVec.equalsIgnoreCase(searchStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static String strArr2List(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        return VerificationUtil.strCollection2String(Arrays.asList(strArr));
    }

    public static String strArr2List(String[] strArr, String delimiter) {
        if (strArr == null) {
            return "";
        }
        return VerificationUtil.strCollection2String(Arrays.asList(strArr), delimiter);
    }

    public static String objArr2String(Object[] objArr) {
        return VerificationUtil.objArr2String(objArr, ",");
    }

    public static String objArr2String(Object[] objArr, String delim) {
        if (objArr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objArr.length; ++i) {
            sb.append(objArr[i].toString());
            if (i >= objArr.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String strArr2String(String[] strarr) {
        if (strarr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strarr.length; ++i) {
            sb.append(strarr[i]);
        }
        return sb.toString();
    }

    public static String strArr2String(String[] strarr, String delim) {
        if (strarr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strarr.length; ++i) {
            sb.append(strarr[i]);
            if (i >= strarr.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String stringToAsciiValueStr(String input) {
        return VerificationUtil.stringToAsciiValueStr(input, ",");
    }

    public static String stringToAsciiValueStr(String input, String delim) {
        if (input == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            sb.append((int)input.charAt(i));
            if (input.length() <= i + 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String[] string2strArr(String str) {
        return VerificationUtil.string2strArr(str, ",");
    }

    public static String[] string2strArr(String str, String delim) {
        return VerificationUtil.string2strArr(str, delim, true);
    }

    public static String[] string2strArr(String str, String delim, boolean ignoreEmpty) {
        Vector<String> strVect = new Vector<String>();
        int strMaxPos = str.length();
        if (!ignoreEmpty) {
            ++strMaxPos;
        }
        int dlmPos = 0;
        int index = 0;
        while (index < strMaxPos) {
            dlmPos = str.indexOf(delim, index);
            if (dlmPos == -1) {
                strVect.add(str.substring(index));
                break;
            }
            if (ignoreEmpty && dlmPos == index) {
                ++index;
                continue;
            }
            strVect.add(str.substring(index, dlmPos));
            index = dlmPos + 1;
        }
        return strVect.toArray(new String[strVect.size()]);
    }

    public static String strVect2List(Vector<String> v) {
        return VerificationUtil.strCollection2String(v);
    }

    public static String strList2List(List<String> l) {
        return VerificationUtil.strCollection2String(l);
    }

    public static String strList2List(List<String> l, String delimiter) {
        return VerificationUtil.strCollection2String(l, delimiter);
    }

    public static <T> String strCollection2String(Collection<T> l) {
        return VerificationUtil.strCollection2String(l, ",");
    }

    public static <T> String strCollection2String(Collection<T> l, String delim) {
        StringBuffer strBuf = new StringBuffer("");
        if (l != null) {
            boolean first = true;
            for (T item : l) {
                if (first) {
                    first = false;
                } else {
                    strBuf.append(delim);
                }
                strBuf.append(String.valueOf(item));
            }
        }
        return strBuf.toString();
    }

    public static String errorCollection2String(Collection<VerificationError> l) {
        StringBuffer buf = new StringBuffer();
        if (l != null && !l.isEmpty()) {
            for (VerificationError ve : l) {
                buf.append(ve.getErrorMessage() + LSEP);
            }
        }
        return buf.toString();
    }

    public static String errDescCol2errMsgStr(Collection<ErrorDescription> errDescCol) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        for (ErrorDescription errDesc : errDescCol) {
            errMsgList.add(errDesc.getErrorMessage());
        }
        return VerificationUtil.strList2List(errMsgList, LSEP);
    }

    public static Vector getTokens(String str, String dlm) {
        int dlmPos = 0;
        Vector<String> tokenList = new Vector<String>();
        int index = 0;
        while (index < str.length()) {
            dlmPos = str.indexOf(dlm, index);
            if (dlmPos == -1) {
                tokenList.add(str.substring(index));
                return tokenList;
            }
            if (dlmPos == index) {
                index += dlm.length();
                continue;
            }
            tokenList.add(str.substring(index, dlmPos));
            index = dlmPos + dlm.length();
        }
        return tokenList;
    }

    public static String[] getTokensAsArray(String str, String dlm) {
        String[] tokarr;
        Vector vector = VerificationUtil.getTokens(str, dlm);
        if (vector != null) {
            tokarr = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                tokarr[i] = (String)vector.elementAt(i);
            }
        } else {
            tokarr = new String[]{};
        }
        return tokarr;
    }

    public static String getDefaultOracleUser() {
        String userDomain;
        String curUser = System.getProperty("user.name");
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem() && VerificationUtil.isStringGood(userDomain = VerificationUtil.getEnv("USERDOMAIN"))) {
            curUser = userDomain + File.separator + curUser;
        }
        VerificationLogData.logInfo("DefaultOracleUser: " + curUser);
        Trace.out((String)("==== Oracle user(current user) is " + curUser));
        return curUser;
    }

    public static String getDefaultCRSUser() {
        String curUser = System.getProperty("user.name");
        Trace.out((String)("==== Oracle user(current user) is " + curUser));
        VerificationLogData.logInfo("DefaultCRSUser: " + curUser);
        return curUser;
    }

    public static String getCRSHome(String node, Result result) {
        Trace.out((String)("Executing getCRSHome(node=" + node + ", result)"));
        if (!VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"getCRSHome() : Returning NULL as CRS is not found configured");
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription("7593", new String[]{result.getNode()}, s_msgBundle));
            return null;
        }
        String crsHome = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        try {
            crsHome = nativeSys.getCRSHome(node, new Version());
        }
        catch (NativeException e) {
            Trace.out((String)("IGNORED: " + e.getMessage()));
            Trace.out((String)"Will attempt a fallback.");
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
        }
        if (crsHome != null) {
            Trace.out((String)("Returning CRS home '" + crsHome + "' from olr.loc"));
            result.setStatus(1);
            VerificationLogData.logInfo("CRSHome: " + crsHome);
            return crsHome;
        }
        if (ParamManager.isInstantiated()) {
            crsHome = VerificationUtil.getCRSHomeFromInitCSSD(node, result);
            if (crsHome != null) {
                result.setStatus(1);
                VerificationLogData.logInfo("CRSHome: " + crsHome);
                return crsHome;
            }
        } else {
            Trace.out((String)"getCRSHomeFromInitCSSD() skipped because ParamManager is not instantated yet.");
        }
        String crsHomeFromInv = VerificationUtil.getCRSHomeFromInventory(result);
        Trace.out((String)("crsHomeFromInv=" + crsHomeFromInv));
        if (ParamManager.isInstantiated()) {
            crsHome = VerificationUtil.getCRSHomeFromOCRDump(crsHomeFromInv, node, result);
            if (crsHome != null) {
                Trace.out((String)("Returning CRS home '" + crsHome + "' from OCR Dump"));
                result.setStatus(1);
                VerificationLogData.logInfo("CRSHome: " + crsHome);
                return crsHome;
            }
        } else {
            Trace.out((String)"getCRSHomeFromOCRDump() skipped because ParamManager is not instantated yet.");
        }
        if ((crsHome = crsHomeFromInv) != null) {
            Trace.out((String)("Returning CRS home '" + crsHome + "' from Oracle inventory"));
            result.setStatus(1);
            VerificationLogData.logInfo("CRSHome: " + crsHome);
            return crsHome;
        }
        ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
        result.addErrorDescription(errDesc);
        result.setStatus(3);
        Trace.out((String)"Returning failure in getting CRS home");
        VerificationLogData.logError("CRSHome: NULL!!!");
        return null;
    }

    public static String getCRSUser(String node, Result result, boolean isSIHA) {
        Trace.out((String)("Executing getCRSUser(node=" + node + ", isSIHA=" + isSIHA + ")"));
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        ErrorDescription errDesc = null;
        String version = null;
        String errorMsg = null;
        String home = null;
        String userNameStr = null;
        try {
            if (isSIHA) {
                if (VerificationUtil.isHAConfigured()) {
                    home = VerificationUtil.getHAHomeWithException();
                    version = VerificationUtil.getSIHAReleaseVersionWithException();
                } else {
                    home = ClusterInfo.getLocalCSSHome((Version)new Version());
                    version = VerificationUtil.getCRSActiveVersionWithException();
                }
            } else {
                home = VerificationUtil.getCRSHome();
                version = VerificationUtil.getCRSActiveVersionWithException();
            }
        }
        catch (NoSuchCRSHomeException nscrse) {
            errorMsg = nscrse.getMessage();
        }
        catch (NoSuchExecutableException nsee) {
            errorMsg = nsee.getMessage();
        }
        catch (ClusterInfoException cie) {
            errorMsg = cie.getMessage();
        }
        catch (ConfigurationException cfge) {
            errorMsg = cfge.getMessage();
        }
        catch (HAHomeNotFoundException hae) {
            errorMsg = hae.getMessage();
        }
        catch (LocalCSSException lce) {
            errorMsg = lce.getMessage();
        }
        if (version == null && home != null) {
            Trace.out((String)"Retreival of Active version failed, now taking fallback approach");
            version = VerificationUtil.getCRSReleaseVersionUsingSRVCTL(home, m_localHostName, result);
        }
        if (VerificationUtil.isStringGood(version)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Active CRS Version is: " + version));
            }
            String crsUserName = null;
            if (!VerificationUtil.isVersionPre(version, "11.2")) {
                return VerificationUtil.getCRSHomeUser(node, result, isSIHA);
            }
            String cssdFileLocation = sVerificationUtil.getCSSDFileLoc();
            userNameStr = VerificationUtil.grepCRSUserFromCSSD(node, cssdFileLocation);
            if (!VerificationUtil.isStringGood(userNameStr)) {
                cssdFileLocation = home + FILE_SEPARATOR + "css" + FILE_SEPARATOR + "admin" + FILE_SEPARATOR + new File(cssdFileLocation).getName();
                Trace.out((String)("Trying to get the CRS user from init.cssd SBS at location path " + cssdFileLocation));
                userNameStr = VerificationUtil.grepCRSUserFromCSSD(node, cssdFileLocation);
            }
            if (!VerificationUtil.isStringGood(userNameStr)) {
                Trace.out((String)"Retrieving the CRS User using OCR DUMP");
                userNameStr = VerificationUtil.getCrsUserFromOCRDump(home, result);
                if (VerificationUtil.isStringGood(userNameStr) && result.getStatus() == 1) {
                    Trace.out((int)5, (String)("OCR returned the CRS user name as : " + userNameStr));
                    userNameStr = userNameStr.trim();
                } else {
                    Trace.out((int)5, (String)"Failed to retrieve the CRS user name from OCR using OCR dump approach");
                }
            }
            if (VerificationUtil.isStringGood(userNameStr)) {
                if (userNameStr.contains("=")) {
                    int equalIndex = userNameStr.indexOf("=");
                    crsUserName = userNameStr.length() > equalIndex ? userNameStr.substring(equalIndex + 1) : null;
                } else {
                    crsUserName = userNameStr;
                }
            }
            if (VerificationUtil.isStringGood(crsUserName)) {
                Trace.out((int)5, (String)("The CRS User  name retrieved is :" + crsUserName));
                result.setStatus(1);
                VerificationLogData.logInfo("CRSUserName: " + crsUserName);
                return crsUserName;
            }
            Trace.out((String)"Failed to retrieve the crs user name ");
            errDesc = new ErrorDescription(s_msgBundle.getMessage("9556", true));
            result.addErrorDescription(errDesc);
            result.setStatus(3);
            return null;
        }
        errorMsg = VerificationUtil.isStringGood(errorMsg) ? s_msgBundle.getMessage("5300", true) + LSEP + errorMsg : s_msgBundle.getMessage("5300", true);
        errDesc = new ErrorDescription(errorMsg);
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    private static String grepCRSUserFromCSSD(String node, String cssdFileLocation) {
        CommandsUtil cmdUtil = new CommandsUtil();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        String userNameStr = null;
        Trace.out((String)("Trying Grep approach on init.cssd at path " + cssdFileLocation + " to get the crs user"));
        String command = cmdUtil.getGrep() + " " + ORACLE_USER + "= " + cssdFileLocation;
        ResultSet usrInfoRsltSet = new ResultSet();
        rslt = globalExec.runExe(new String[]{node}, command, usrInfoRsltSet, false);
        Result usrResult = (Result)usrInfoRsltSet.getResultTable().get(node);
        if (rslt && usrResult != null && usrResult.getStatus() == 1) {
            Vector resultInfoset = usrResult.getResultInfoSet();
            String exectaskOutput = null;
            if (resultInfoset.size() > 1 && (exectaskOutput = (String)resultInfoset.elementAt(1)) != null && VerificationUtil.fetchVerificationResult(exectaskOutput).equals("0") && VerificationUtil.isStringGood(userNameStr = VerificationUtil.fetchVerificationValue(exectaskOutput))) {
                userNameStr = userNameStr.trim();
            }
        } else {
            Trace.out((String)("Failed to grep approach for crs user from init.cssd at path " + cssdFileLocation));
        }
        Trace.out((String)("Retrieved the CRS user name string from init.cssd as " + userNameStr));
        return userNameStr;
    }

    public static String getCRSUser(Result result, boolean isSIHA) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        Object errDesc = null;
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        return VerificationUtil.getCRSUser(VerificationUtil.getLocalNode(), result, isSIHA);
    }

    public static String getCRSHomeUser(String node, Result result, boolean isSIHA) {
        FileInfo nodeFileInfo = VerificationUtil.getOracleBinaryFileAttributes(node, result);
        if (nodeFileInfo != null) {
            return nodeFileInfo.getFileOwner();
        }
        return null;
    }

    public static String getCRSUserGroup(String node, Result result) {
        FileInfo nodeFileInfo = VerificationUtil.getOracleBinaryFileAttributes(node, result);
        if (nodeFileInfo != null) {
            return nodeFileInfo.getFileGroup();
        }
        return null;
    }

    private static FileInfo getOracleBinaryFileAttributes(String node, Result result) {
        Hashtable nodeFileList;
        FileInfo nodeFileInfo;
        String oracleBinaryName = "oracle";
        String home = null;
        ErrorDescription errDesc = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        if (node == null) {
            errDesc = new ErrorDescription("7514", s_msgBundle);
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        if (VerificationUtil.isHAConfigured()) {
            try {
                home = VerificationUtil.getHAHomeWithException();
            }
            catch (HAHomeNotFoundException e) {
                result.addErrorDescription(new ErrorDescription(e.getMessage()));
                result.setStatus(2);
            }
        } else {
            home = VerificationUtil.getCRSHome(node, result);
        }
        if (home == null) {
            VerificationUtil.traceAndLogWarning("Retreived CRS/HA Home as <NULL> for node : " + node);
            return null;
        }
        Trace.out((String)("Retreived Home as:" + home + " for node : " + node));
        String oracleBinary = home + File.separator + "bin" + File.separator + nativeSys.getExeName(oracleBinaryName);
        Trace.out((String)("Get file info of File:" + oracleBinary + " from node : " + node));
        ResultSet fileInfoRS = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        boolean fileInfoResult = globalExec.getFileInfo(new String[]{node}, fileList, fileInfoRS);
        if (!fileInfoResult) {
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5323", true, (Object[])new String[]{oracleBinary}), s_msgBundle, "5323");
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        Result fiResult = (Result)fileInfoRS.getResultTable().get(node);
        if (fiResult != null && fiResult.getStatus() == 1 && !(nodeFileInfo = (FileInfo)(nodeFileList = (Hashtable)fiResult.getResultInfoSet().elementAt(0)).get(oracleBinary)).getStatus().equals("1")) {
            result.setStatus(1);
            return nodeFileInfo;
        }
        errDesc = new ErrorDescription(s_msgBundle.getMessage("5322", true, (Object[])new String[]{home}), s_msgBundle, "5322");
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    public static String getOracleUser(String home, String node, Result result) {
        Hashtable nodeFileList;
        FileInfo nodeFileInfo;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        ErrorDescription errDesc = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        if (node == null) {
            errDesc = new ErrorDescription("7514", s_msgBundle);
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        String oracleBinary = home + File.separator + "bin" + File.separator + nativeSys.getExeName("oracle");
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        ResultSet resultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(new String[]{node}, fileList, resultSet);
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            result.setStatus(2);
            return null;
        }
        Result nodeResult = (Result)resultSet.getResultTable().get(node);
        if (nodeResult != null && nodeResult.getStatus() == 1 && !(nodeFileInfo = (FileInfo)(nodeFileList = (Hashtable)nodeResult.getResultInfoSet().elementAt(0)).get(oracleBinary)).getStatus().equals("1")) {
            result.setStatus(1);
            VerificationLogData.logInfo("OracleUser: " + nodeFileInfo.getFileOwner());
            return nodeFileInfo.getFileOwner();
        }
        errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1186", true, (Object[])new String[]{home}), s_msgBundle, "5322");
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    public static StringBuffer getKeyValueFromOCRDump(String crsHome, String ocrKey, Result result) {
        Trace.out((String)("Executing getKeyValueFromOCRDump(crsHome=" + crsHome + ", ocrKey=" + ocrKey + ")"));
        String command = null;
        Object errDesc = null;
        String errorMsg = null;
        StringBuffer value = new StringBuffer();
        ResultSet homeInfoRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        command = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "ocrdump -stdout -noheader -keyname " + ocrKey;
        Trace.out((int)5, (String)("Executing command=>" + command));
        rslt = globalExec.runExe(new String[]{m_localHostName}, command, homeInfoRsltSet, false);
        Result homeResult = (Result)homeInfoRsltSet.getResultTable().get(m_localHostName);
        if (rslt && homeResult != null && homeResult.getStatus() == 1) {
            Vector resultInfoset = homeResult.getResultInfoSet();
            Object cvVal = null;
            String[] exectaskOutput = null;
            if (resultInfoset.size() > 0) {
                exectaskOutput = (String[])resultInfoset.elementAt(0);
                boolean found = false;
                for (String line : exectaskOutput) {
                    if ((line = line.trim()).equals("[" + ocrKey + "]")) {
                        found = true;
                    }
                    if (!found) continue;
                    if (!line.equals("[" + ocrKey + "]") && line.startsWith("[" + ocrKey)) break;
                    value.append(line + LINE_SEPARATOR);
                }
            }
            if (value.length() > 0) {
                Trace.out((int)5, (String)("Successfully Retrieved value for key " + ocrKey + " the Value is :" + value.toString()));
                result.setStatus(1);
            } else {
                result.setStatus(3);
                errorMsg = s_gMsgBundle.getMessage("0551", true, (Object[])new String[]{ocrKey});
                result.addErrorDescription(new ErrorDescription(errorMsg));
            }
        } else {
            result.setStatus(2);
            errorMsg = s_gMsgBundle.getMessage("0550", true, (Object[])new String[]{ocrKey});
            result.addErrorDescription(new ErrorDescription(errorMsg));
            Trace.out((String)("Error in executing ocrdump command:" + command));
        }
        return value;
    }

    public static String getCrsUserFromOCRDump(String crsHome, Result result) {
        String key = "DATABASE.DATABASES";
        String usrName = null;
        StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, key, result);
        if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            String[] lineByLine;
            for (String line : lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR)) {
                Pattern userNamePattern = Pattern.compile("(.*)USER_NAME([^:]*):(\\s*)([^,]*)(.*)");
                Matcher m = userNamePattern.matcher(line);
                if (!m.matches()) continue;
                usrName = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(usrName)) {
            Trace.out((String)"Failed to retrieve the CRS user using OCRDUMP");
            result.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("9556", true)));
            result.setStatus(3);
            return null;
        }
        Trace.out((int)5, (String)("The CRS User name retrieved using OCR dump is " + usrName));
        result.setStatus(1);
        return usrName;
    }

    public static String getGroupValueForVfyType(VerificationType vfyType, CVUVariableConstants groupVarName) {
        if (vfyType == null) {
            Trace.out((String)"The given vfyType is null");
            return null;
        }
        if (groupVarName == null) {
            Trace.out((String)"The given groupVarName is null");
            return null;
        }
        Trace.out((String)("Method Entry : vfyType = " + (Object)((Object)vfyType) + " groupVarName = " + groupVarName.toString()));
        String result = null;
        CVUVariableData groupVar = CVUVariables.getCVUVariable(groupVarName.toString());
        if (groupVar != null) {
            result = groupVar.getValue();
        }
        CVUVariableConstants vfyTypeGroupVarName = VerificationUtil.getGroupVarNameForVfyType(groupVarName, vfyType);
        switch (vfyType) {
            case PREREQ_CRS_INST: {
                if (!(result != null || VerificationUtil.isUpgrade() || VerificationUtil.isHealthCheckMode() || VerificationUtil.isBaselineCollectionMode())) {
                    result = VerificationUtil.getDefaultValueForGroup(vfyTypeGroupVarName);
                    break;
                }
            }
            case PREREQ_SI_DB_INST: 
            case PREREQ_DB_PROV: 
            case PREREQ_DB_INST: {
                if (vfyTypeGroupVarName == CVUVariableConstants.OSOPER_GROUP) break;
            }
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_DB_CONFIG: 
            case POSTREQ_DB_CONFIG: 
            case BESTPRACTICE_POSTREQ_DB_CONFIG: 
            case PREREQ_RACNODE_ADD: 
            case PREREQ_NODE_ADD: {
                if (result != null) break;
                result = VerificationUtil.getConfiguredOrDefaultGroupValue(vfyTypeGroupVarName);
                break;
            }
            default: {
                Trace.out((String)("Did not find a valid value for the CRS mode group : " + groupVarName.toString()));
            }
        }
        if (result != null) {
            Trace.out((String)("Succesfully obtained a group value for group name : " + groupVarName.toString()));
        } else {
            Trace.out((String)("Unable to get a configured nor a default value for group name : " + groupVarName.toString()));
        }
        return result;
    }

    private static CVUVariableConstants getGroupVarNameForVfyType(CVUVariableConstants groupVarName, VerificationType vfyType) {
        CVUVariableConstants configuredVarName = null;
        block0 : switch (vfyType) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_NODE_ADD: {
                switch (groupVarName) {
                    case ASM_GROUP: {
                        configuredVarName = CVUVariableConstants.ASM_ADMIN_GROUP;
                        break block0;
                    }
                    case OPER_GROUP: {
                        configuredVarName = CVUVariableConstants.ASM_OPER_GROUP;
                        break block0;
                    }
                    case DBA_GROUP: {
                        configuredVarName = CVUVariableConstants.ASM_DBA_GROUP;
                        break block0;
                    }
                }
                Trace.out((String)("Did not find a configured group name for the CRS mode group :" + groupVarName.toString()));
                break;
            }
            case PREREQ_SI_DB_INST: 
            case PREREQ_DB_PROV: 
            case PREREQ_DB_INST: 
            case PREREQ_DB_CONFIG: 
            case POSTREQ_DB_CONFIG: 
            case BESTPRACTICE_POSTREQ_DB_CONFIG: 
            case PREREQ_RACNODE_ADD: {
                switch (groupVarName) {
                    case ASM_GROUP: {
                        configuredVarName = CVUVariableConstants.OSASM_GROUP;
                        break block0;
                    }
                    case OPER_GROUP: {
                        configuredVarName = CVUVariableConstants.OSOPER_GROUP;
                        break block0;
                    }
                    case DBA_GROUP: {
                        configuredVarName = CVUVariableConstants.OSDBA_GROUP;
                        break block0;
                    }
                    case DBA_ASM_GROUP: {
                        configuredVarName = CVUVariableConstants.OSDBA_ASM_GROUP;
                        break block0;
                    }
                    case BACKUPDBA_GROUP: {
                        configuredVarName = CVUVariableConstants.OSBACKUPDBA_GROUP;
                        break block0;
                    }
                    case DGDBA_GROUP: {
                        configuredVarName = CVUVariableConstants.OSDGDBA_GROUP;
                        break block0;
                    }
                    case KMDBA_GROUP: {
                        configuredVarName = CVUVariableConstants.OSKMDBA_GROUP;
                        break block0;
                    }
                    case RACDBA_GROUP: {
                        configuredVarName = CVUVariableConstants.OSRACDBA_GROUP;
                        break block0;
                    }
                }
                Trace.out((String)("Did not find a configured group name for the the RAC/DB mode group :" + groupVarName.toString()));
                break;
            }
            default: {
                Trace.out((String)("Did not find a configured group name for the verification type :" + groupVarName.toString()));
            }
        }
        return configuredVarName;
    }

    private static String getConfiguredOrDefaultGroupValue(CVUVariableConstants groupVarName) {
        if (groupVarName == null) {
            Trace.out((String)"The given group variable name is null");
            return null;
        }
        String retValue = null;
        String configuredValue = null;
        switch (groupVarName) {
            case ASM_ADMIN_GROUP: 
            case ASM_OPER_GROUP: 
            case ASM_DBA_GROUP: 
            case OSASM_GROUP: 
            case OSOPER_GROUP: 
            case OSDBA_GROUP: 
            case OSDBA_ASM_GROUP: 
            case OSBACKUPDBA_GROUP: 
            case OSDGDBA_GROUP: 
            case OSKMDBA_GROUP: 
            case OSRACDBA_GROUP: {
                configuredValue = CVUVariables.getValue(groupVarName);
                break;
            }
            default: {
                Trace.out((String)("Unknown configured group name for the the CRS or RAC/DB returning null:" + groupVarName.toString()));
                return null;
            }
        }
        if (VerificationUtil.isStringGood(configuredValue)) {
            Trace.out((String)("Using configured value for group : " + groupVarName.toString()));
            retValue = configuredValue;
        } else {
            retValue = VerificationUtil.getDefaultValueForGroup(groupVarName);
        }
        Trace.out((String)("Returning value : " + retValue + " for group : " + groupVarName.toString()));
        return retValue;
    }

    private static String getDefaultValueForGroup(CVUVariableConstants groupVarName) {
        if (groupVarName == null) {
            Trace.out((String)"The given group variable name is null");
            return null;
        }
        Trace.out((String)("Method Entry: groupVarName =" + groupVarName.toString()));
        String retValue = null;
        switch (groupVarName) {
            case ASM_ADMIN_GROUP: {
                retValue = VerificationUtil.getDefaultAsmAdminGroup();
                break;
            }
            case ASM_DBA_GROUP: {
                retValue = VerificationUtil.getDefaultAsmDbaGroup();
                break;
            }
            case OSDBA_GROUP: {
                retValue = VerificationUtil.getDefaultDbaGroup();
                break;
            }
            default: {
                Trace.out((String)("There is no default value defined for the group name: " + groupVarName.toString()));
            }
        }
        if (retValue != null) {
            Trace.out((String)("Returning default value for group : " + groupVarName.toString()));
        }
        return retValue;
    }

    public static String getGroupPrivileges(String group) {
        Trace.out((Object)"Group = %s", (String)group);
        String groupPrivileges = null;
        if (VerificationUtil.isStringGood(group)) {
            if (!m_groupPrivilegesMap.isEmpty()) {
                groupPrivileges = VerificationUtil.strCollection2String((Collection)m_groupPrivilegesMap.get(group));
            } else {
                Trace.out((String)"Group privileges have not been initialized");
            }
        } else {
            Trace.out((String)"Invalid group value");
        }
        return groupPrivileges;
    }

    public static void addGroupPrivilege(String group, String privilege) {
        Trace.out((String)"Group = %s, Privilege = %s", (Object[])new Object[]{group, privilege});
        if (VerificationUtil.isStringGood(group) && VerificationUtil.isStringGood(privilege)) {
            if (m_groupPrivilegesMap.containsKey(group)) {
                m_groupPrivilegesMap.get(group).add(privilege);
            } else {
                HashSet<String> privileges = new HashSet<String>();
                privileges.add(privilege);
                m_groupPrivilegesMap.put(group, privileges);
            }
        } else {
            Trace.out((String)"Invalid group or privilege");
        }
    }

    public static String getDefaultOperGroup() {
        VerificationLogData.logInfo("DefaultOperGroup: " + VDMUtil.getDefaultOperGroup());
        return VDMUtil.getDefaultOperGroup();
    }

    public static String getDefaultDbaGroup() {
        VerificationLogData.logInfo("DefaultDbaGroup: " + VDMUtil.getDefaultDbaGroup());
        return VDMUtil.getDefaultDbaGroup();
    }

    public static String getDefaultAsmAdminGroup() {
        VerificationLogData.logInfo("Default ASM Admin Group: " + VDMUtil.getDefaultAsmAdminGroup());
        return VDMUtil.getDefaultAsmAdminGroup();
    }

    public static String getDefaultAsmDbaGroup() {
        VerificationLogData.logInfo("Default ASM Dba Group: " + VDMUtil.getDefaultAsmDbaGroup());
        return VDMUtil.getDefaultAsmDbaGroup();
    }

    public static String getDefaultOraInvGroup(Result result) {
        ResultSet resultSet = null;
        Hashtable<String, String> primaryGroupMap = null;
        Hashtable<String, List<String>> groupMap = null;
        String oraInvGrp = null;
        String user = null;
        String[] nodeList = new String[]{m_localNode};
        result.setStatus(1);
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            if (VerificationUtil.isCRSConfigured()) {
                oraInvGrp = VerificationUtil.getOraInventoryGroup();
                if (oraInvGrp == null) {
                    result.setStatus(2);
                    result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10468", true)));
                }
            } else {
                resultSet = new ResultSet();
                primaryGroupMap = new Hashtable<String, String>();
                groupMap = new Hashtable<String, List<String>>();
                user = VerificationUtil.getDefaultOracleUser();
                VerificationUtil.getUserGroups(nodeList, user, primaryGroupMap, groupMap, resultSet);
                oraInvGrp = primaryGroupMap.get(m_localNode);
                if (oraInvGrp == null) {
                    result.setStatus(2);
                    result.addErrorDescription(resultSet.getResult(m_localNode).getErrors());
                }
            }
        } else {
            oraInvGrp = "ORA_INSTALL";
        }
        VerificationLogData.logInfo("DefaultOraInvGroup: " + oraInvGrp);
        return oraInvGrp;
    }

    public static String getAntiVirusList() {
        VerificationLogData.logInfo("AntiVirusList: " + VDMUtil.getAntiVirusList());
        return VDMUtil.getAntiVirusList();
    }

    public static String getCVUQDiskGroup() {
        Result result = null;
        if (m_cvuQDiskGrp == null) {
            ParamManager pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((String)"Caught UninitializedParamManagerException - Ignoring");
            }
            if (pm != null) {
                m_cvuQDiskGrp = CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
            }
            if (m_cvuQDiskGrp == null) {
                m_cvuQDiskGrp = VerificationUtil.getOraInventoryGroup();
            }
            if (m_cvuQDiskGrp == null && (m_cvuQDiskGrp = VerificationUtil.getDefaultOraInvGroup(result = new Result(m_localNode))) == null) {
                Trace.out((String)"getCVUQDiskGroup: default inventory group is null");
            }
        }
        return m_cvuQDiskGrp;
    }

    public static String getDefaultUmask() {
        return VDMUtil.getDefaultUmask();
    }

    public static String fetchTextByTags(String sfmtd, String tag) {
        return VerificationUtil.fetchTextByTags(sfmtd, "<" + tag + ">", "</" + tag + ">");
    }

    public static String fetchTextByTags(String sfmtd, String start_tag, String end_tag) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, start_tag, end_tag);
    }

    public static String[] fetchTextByTagsRepeat(String sfmtd, String tag) {
        return VerificationUtil.fetchTextByTagsRepeat(sfmtd, "<" + tag + ">", "</" + tag + ">");
    }

    public static String[] fetchTextByTagsRepeat(String sfmtd, String start_tag, String end_tag) {
        Vector<String> data = new Vector<String>();
        String tmpStr = null;
        Trace.out((int)1, (String)("Looking for tags " + start_tag + " and " + end_tag + " in string: '" + sfmtd + "'"));
        if (VerificationUtil.isStringGood(sfmtd)) {
            sfmtd = sfmtd.trim();
            while (sfmtd.length() > 0) {
                tmpStr = VerificationUtil.fetchTextByTags(sfmtd, start_tag, end_tag);
                Trace.out((int)1, (String)("tmpStr=" + tmpStr));
                if (tmpStr == null) break;
                Trace.out((int)1, (String)("Adding to data:" + tmpStr));
                data.add(tmpStr);
                if (sfmtd.indexOf(end_tag) + end_tag.length() >= sfmtd.length()) break;
                sfmtd = sfmtd.substring(sfmtd.indexOf(end_tag) + end_tag.length());
                Trace.out((int)1, (String)("sfmtd=" + sfmtd));
                sfmtd = sfmtd.trim();
            }
        }
        return data.toArray(new String[0]);
    }

    public static String fetchTextByTags(String sfmtd, String entity, String start_tag, String end_tag) {
        if (null == sfmtd || sfmtd.length() == 0) {
            return null;
        }
        String fmtdstr = null == entity || entity.trim().length() == 0 ? sfmtd : sfmtd;
        int begin = fmtdstr.indexOf(start_tag);
        if (begin == -1) {
            return null;
        }
        begin += start_tag.length();
        int end = fmtdstr.indexOf(end_tag);
        if (end == -1) {
            return null;
        }
        String data = fmtdstr.substring(begin, end);
        Trace.out((String)("\nTags " + start_tag + " and " + end_tag + " contains:" + data + "\n"));
        return data;
    }

    public static boolean fetchExecResult(String sfmtd) {
        int res;
        String eres = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_ERES>", "</CV_ERES>");
        try {
            res = Integer.parseInt(eres);
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Invalid exec result in the output. " + e.getMessage()));
            return false;
        }
        return res == 0;
    }

    public static String fetchVerificationResult(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VRES>", "</CV_VRES>");
    }

    public static String fetchVerificationValue(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VAL>", "</CV_VAL>");
    }

    public static boolean fetchVerificationStatus(String sfmtd) {
        String tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VRES>", "</CV_VRES>");
        return tagValue.equals("0");
    }

    public static String fetchCommandValue(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, "<CV_CMD>", "</CV_CMD>");
    }

    public static String fetchError(String sfmtd) {
        String fmtErrStr = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_ERR>", "</CV_ERR>");
        if (fmtErrStr == null) {
            Trace.out((String)"No errors to return.");
            return fmtErrStr;
        }
        StringBuffer retErrBuf = new StringBuffer();
        Object tmpStr = null;
        Trace.out((String)("Removing developer info from error message results: '" + fmtErrStr + "'"));
        if (fmtErrStr.indexOf("<SLOS_LOCINFOSTR>") != -1) {
            retErrBuf.append(VerificationUtil.fetchTextByTags(fmtErrStr, "<SLOS_LOCINFOSTR>", "</SLOS_LOCINFOSTR>") + "\n");
            fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_LOCINFOSTR", fmtErrStr);
        }
        if (fmtErrStr.indexOf("<SLOS_DEPINFOSTR>") != -1) {
            retErrBuf.append(VerificationUtil.fetchTextByTags(fmtErrStr, "<SLOS_DEPINFOSTR>", "</SLOS_DEPINFOSTR>") + "\n");
            fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_DEPINFOSTR", fmtErrStr);
        }
        if (fmtErrStr.indexOf("<SLOS_OTHERINFO>") != -1) {
            retErrBuf.append(VerificationUtil.fetchTextByTags(fmtErrStr, "<SLOS_OTHERINFO>", "</SLOS_OTHERINFO>") + "\n");
            fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_OTHERINFO", fmtErrStr);
        }
        fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_LOC", fmtErrStr);
        fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_OP", fmtErrStr);
        fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_CAT", fmtErrStr);
        if ((fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_DEPINFO", fmtErrStr)) != null && fmtErrStr.length() > 0) {
            retErrBuf.append(fmtErrStr);
        }
        Trace.out((String)("Returning error string: '" + retErrBuf.toString() + "'"));
        return retErrBuf.toString();
    }

    private static String removeTaggedSubstring(String tag, String srcStr) {
        String startTag = new String("<" + tag + ">");
        String endTag = new String("</" + tag + ">");
        String newStr = srcStr;
        int startOffst = 0;
        int endOffst = 0;
        startOffst = srcStr.indexOf(startTag);
        endOffst = srcStr.indexOf(endTag);
        if (startOffst == -1 || endOffst == -1) {
            return srcStr;
        }
        Trace.out((int)1, (String)("Removing tag '<" + tag + ">' from '" + srcStr + "'"));
        newStr = startOffst == 0 ? (endOffst + endTag.length() >= srcStr.length() ? new String("") : srcStr.substring(endOffst + endTag.length())) : (endOffst + endTag.length() >= srcStr.length() ? srcStr.substring(0, startOffst) : srcStr.substring(0, startOffst) + srcStr.substring(endOffst + endTag.length()));
        Trace.out((int)1, (String)("Returning new string: '" + newStr + "'"));
        return newStr;
    }

    public static String fetchTrace(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_TRC>", "</CV_TRC>");
    }

    public static String fetchLog(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_LOG>", "</CV_LOG>");
    }

    public static String fetchProgressText(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_PTXT>", "</CV_PTXT>");
    }

    public static String fetchExecutionDetailsMessage(String node, String exectaskOutput) {
        VerificationUtil.logAllExecutionDetails(node, exectaskOutput);
        StringBuilder sb = new StringBuilder();
        sb.append(VerificationUtil.fetchCommandDetailsMessage(node, exectaskOutput));
        String apiDetails = VerificationUtil.fetchAPIDetailsMessage(node, exectaskOutput);
        if (sb.length() != 0 && apiDetails.length() != 0) {
            sb.append(LSEP);
        }
        sb.append(apiDetails);
        return sb.toString();
    }

    public static void logAllExecutionDetails(String node, String exectaskOutput) {
        VerificationUtil.logAllCommandDetails(node, exectaskOutput);
        VerificationUtil.logAllAPIDetails(node, exectaskOutput);
    }

    public static String fetchCommandDetailsMessage(String node, String exectaskOutput) {
        return VerificationUtil.fetchCommandDetailsMessage(node, exectaskOutput, false);
    }

    public static void logAllCommandDetails(String node, String exectaskOutput) {
        String allCmdDetails = VerificationUtil.fetchCommandDetailsMessage(node, exectaskOutput, true);
        if (VerificationUtil.isStringGood(allCmdDetails)) {
            Trace.out((String)("The details of executed commands are as follows:" + LSEP + "XXXXXXXXXXXXXXXXXX" + LSEP + allCmdDetails + LSEP + "XXXXXXXXXXXXXXXXXX"));
        } else {
            Trace.out((String)("No command execution details are available for node '" + node + "'"));
        }
    }

    public static String fetchCommandDetailsMessage(String node, String exectaskOutput, boolean logAll) {
        Trace.out((int)1, (String)("exectaskOutput=" + exectaskOutput));
        StringBuilder completeMsg = new StringBuilder();
        List<CmdExecInfo> listCmdExecInfo = VerificationUtil.fetchCmdExecInfo(exectaskOutput);
        if (listCmdExecInfo.size() == 0) {
            return "";
        }
        for (CmdExecInfo cmdExecInfo : listCmdExecInfo) {
            int exitVal = cmdExecInfo.getExitVal();
            if (!logAll && exitVal == 0) {
                Trace.out((String)"Encountered details with exitVal as 0; skipped it");
                continue;
            }
            String cmd = cmdExecInfo.getCmd();
            String output = cmdExecInfo.getOutput();
            if (!VerificationUtil.isStringGood(cmd)) {
                Trace.out((String)"APPLICATION ERROR (IGNORED):: Empty CV_CMD value has been encountered");
                continue;
            }
            String msg = logAll ? (VerificationUtil.isStringGood(output) ? "Command '" + cmd + "' executed on node '" + node + "' had an exit value of '" + exitVal + "' and produced the following output:" + LSEP + output : "Command '" + cmd + "' executed on node '" + node + "' had an exit value of '" + exitVal + "' and produced no output") : (VerificationUtil.isStringGood(output) ? s_gMsgBundle.getMessage("2043", true, (Object[])new String[]{cmd, node}) + LSEP + output : s_gMsgBundle.getMessage("2044", true, (Object[])new String[]{cmd, node}));
            Trace.out((String)("Message being added is:" + msg));
            if (completeMsg.length() != 0) {
                completeMsg.append(LSEP + msg);
                continue;
            }
            completeMsg.append(msg);
        }
        return completeMsg.toString();
    }

    public static String fetchAPIDetailsMessage(String node, String exectaskOutput) {
        return VerificationUtil.fetchAPIDetailsMessage(node, exectaskOutput, false);
    }

    public static void logAllAPIDetails(String node, String exectaskOutput) {
        String allAPIDetails = VerificationUtil.fetchAPIDetailsMessage(node, exectaskOutput, true);
        if (VerificationUtil.isStringGood(allAPIDetails)) {
            Trace.out((String)("The details of executed APIs are as follows:" + LSEP + "XXXXXXXXXXXXXXXXXX" + LSEP + allAPIDetails + LSEP + "XXXXXXXXXXXXXXXXXX"));
        } else {
            Trace.out((String)("No API execution details are available for node '" + node + "'"));
        }
    }

    public static String fetchAPIDetailsMessage(String node, String exectaskOutput, boolean logAll) {
        Trace.out((int)1, (String)("exectaskOutput=" + exectaskOutput));
        StringBuilder completeMsg = new StringBuilder();
        List<APIExecInfo> listAPIExecInfo = VerificationUtil.fetchAPIExecInfo(exectaskOutput);
        if (listAPIExecInfo.size() == 0) {
            return "";
        }
        for (APIExecInfo apiExecInfo : listAPIExecInfo) {
            String msg;
            String slosCategory = apiExecInfo.getSlosCategory();
            Trace.out((String)("slosCategory=" + slosCategory));
            if (!VerificationUtil.isStringGood(slosCategory) || !slosCategory.equals("OTHEROS")) {
                Trace.out((String)"No system call errors to return.");
                continue;
            }
            String apiName = apiExecInfo.getApiName();
            Trace.out((String)("apiName=" + apiName));
            if (!VerificationUtil.isStringGood(apiName)) {
                Trace.out((String)"No API name is found.");
                continue;
            }
            String errorNum = apiExecInfo.getErrorNum();
            Trace.out((String)("errorNum=" + errorNum));
            if (!VerificationUtil.isStringGood(errorNum)) {
                Trace.out((String)"No value of errno is found.");
                continue;
            }
            String otherInfo = apiExecInfo.getOtherInfo();
            Trace.out((String)("otherInfo=" + otherInfo));
            String errTxtInCurrLocale = apiExecInfo.getErrTxtInCurrLocale();
            Trace.out((String)("errTxtInCurrLocale=" + errTxtInCurrLocale));
            String errTxtInEnglish = apiExecInfo.getErrTxtInEnglish();
            Trace.out((String)("errTxtInEnglish=" + errTxtInEnglish));
            if (logAll) {
                msg = "Operating system function:'" + apiName + "' failed on node:'" + node + "' with error data: '" + errorNum + "'";
                if (VerificationUtil.isStringGood(errTxtInEnglish)) {
                    msg = msg + LSEP + "Operating system error message: '" + errTxtInEnglish + "'";
                }
                if (VerificationUtil.isStringGood(errTxtInEnglish)) {
                    msg = msg + LSEP + "Additional information: '" + otherInfo + "'";
                }
            } else {
                msg = s_gMsgBundle.getMessage("2045", true, (Object[])new String[]{apiName, node, errorNum});
                if (VerificationUtil.isStringGood(errTxtInCurrLocale)) {
                    msg = msg + LSEP + s_gMsgBundle.getMessage("2046", true, (Object[])new String[]{errTxtInCurrLocale});
                }
                if (VerificationUtil.isStringGood(otherInfo)) {
                    msg = msg + LSEP + s_gMsgBundle.getMessage("2047", true, (Object[])new String[]{otherInfo});
                }
            }
            Trace.out((String)("Message being added is:" + msg));
            if (completeMsg.length() != 0) {
                completeMsg.append(LSEP + msg);
                continue;
            }
            completeMsg.append(msg);
        }
        return completeMsg.toString();
    }

    public static String getSrcLoc() {
        String cvhome;
        String srcLoc = cvhome = VerificationUtil.getCVHome();
        Trace.out((String)("==== Source location is: " + srcLoc));
        return srcLoc;
    }

    public static String getCVHome() {
        if (s_cvhome != null) {
            return s_cvhome;
        }
        String prop = System.getProperty("CV_HOME");
        if (prop == null || prop.trim().length() <= 0) {
            prop = "." + FSEP;
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        prop = prop.trim();
        if (!nativeSys.isUnixSystem() && prop.startsWith("\\") && !prop.startsWith("\\\\")) {
            File f = new File(prop);
            prop = f.getAbsolutePath();
        }
        if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_cvhome = prop;
        return s_cvhome;
    }

    public static String getCurrentGroup() throws InvalidEnvironmentException {
        if (s_currentGroup == null) {
            s_currentGroup = sVerificationUtil.getCurrentGroup();
        }
        return s_currentGroup;
    }

    public static void setCurrentGroup(String curGrp) {
        s_currentGroup = curGrp;
    }

    public static String getCVUSubDir() {
        if (VerificationUtil.isCVUResource()) {
            return "CVU_" + VerificationUtil.getRDBMSVersion() + UNDERSCORE + "resource";
        }
        return "CVU_" + VerificationUtil.getRDBMSVersion() + UNDERSCORE + System.getProperty("user.name");
    }

    public static String getCVUSubDirPath() {
        return VerificationUtil.getDestLoc() + VerificationUtil.getCVUSubDir() + FSEP;
    }

    public static String getPathToExectask() {
        String exectaskWrapper = "exectask" + (VerificationUtil.isPlatformWindows() ? ".exe" : ".sh");
        return VerificationUtil.getCVUSubDirPath() + exectaskWrapper;
    }

    public static String getDestLoc() {
        String destLocAttributeValue;
        if (s_destloc != null) {
            Trace.out((String)("==== CV_DESTLOC(pre-fetched value): '" + s_destloc + "'"));
            return s_destloc;
        }
        String prop = System.getProperty("CV_DESTLOC");
        if (VerificationUtil.isCVUResource() && VerificationUtil.isStringGood(destLocAttributeValue = HeavyWeightVerificationUtil.getDestLocAttribute())) {
            prop = destLocAttributeValue;
        }
        Trace.out((String)("==== CV_DESTLOC system property set as '" + prop + "'"));
        if (prop == null || prop.trim().length() <= 0) {
            Trace.out((String)"==== Null(or empty) CV_DESTLOC property.");
        } else if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_destloc = prop;
        Trace.out((String)("==== CV_DESTLOC: '" + s_destloc + "'"));
        return s_destloc;
    }

    public static void setDestLoc(String destloc) {
        s_destloc = destloc;
        if (!s_destloc.endsWith(FSEP)) {
            s_destloc = s_destloc + FSEP;
        }
    }

    public static void setCVHome(String cvhome) {
        s_cvhome = cvhome;
        if (!s_cvhome.endsWith(FSEP)) {
            s_cvhome = s_cvhome + FSEP;
        }
    }

    public static String getTraceLoc() {
        if (s_traceloc != null) {
            return s_traceloc;
        }
        String prop = System.getProperty("CV_TRACELOC");
        if (prop == null || prop.trim().length() <= 0) {
            prop = VerificationUtil.getEnv("CV_TRACELOC");
        }
        if (Boolean.getBoolean("CV_ROOTUSERCHECK") && (prop == null || prop.trim().length() <= 0)) {
            prop = VerificationUtil.getDestLoc() + FSEP + "log" + FSEP;
        }
        if (prop == null || prop.trim().length() <= 0) {
            return null;
        }
        if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_traceloc = prop;
        return s_traceloc;
    }

    public static String getCmd4RemExec() {
        String remExec = VDMUtil.getCmd4RemExec();
        Trace.out((String)("==== Remote Exec name: " + remExec));
        return remExec;
    }

    public static String[] getCmdFiles4RemExec() {
        return VDMUtil.getCmdFiles4RemExec();
    }

    public static String getConfiguredCRSOrHAHome() {
        if (VerificationUtil.isHAConfigured()) {
            return VerificationUtil.getHAHome();
        }
        if (VerificationUtil.isCRSConfigured()) {
            return VerificationUtil.getCRSHome();
        }
        return null;
    }

    public static String getCRSHome() {
        Trace.out((String)"Executing getCRSHome()");
        String crsHomeCvuVarName = CVUVariableConstants.CONFIGURED_CRS_HOME.toString();
        CVUVariableData crsHomeCvuVar = CVUVariables.getCVUVariable(crsHomeCvuVarName);
        String crsHome = null;
        if (crsHomeCvuVar != null && !crsHomeCvuVar.isLookUpForced() && crsHomeCvuVar.getValue() != null) {
            Trace.out((String)"LookUp is NOT forced returning cached value");
            crsHome = crsHomeCvuVar.getValue();
        } else {
            Trace.out((String)"Checking Configured CRS Home on local node ");
            crsHome = VerificationUtil.getCRSHome(m_localHostName, new Result(m_localHostName));
            if (crsHome != null) {
                Trace.out((String)"CONFIGURED_CRS_HOME is correctly resolved, save it");
                CVUVariables.setValue(CVUVariableConstants.CONFIGURED_CRS_HOME, crsHome);
            }
        }
        Trace.out((String)("Returning Configured CRS home as '" + crsHome + "'"));
        return crsHome;
    }

    public static String getCRSHomeFromInventory(Result result) {
        Trace.out((String)"Executing getCRSHomeFromInventory(result)");
        String inventoryFile = null;
        OUIData ouid = null;
        if (!VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"getCRSHome() : Returning NULL as CRS is not found configured");
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription("7593", new String[]{result.getNode()}, s_msgBundle));
            return null;
        }
        try {
            inventoryFile = VerificationUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            Trace.out((String)("getCRSHome() : Returning NULL as encounterd InvalidOUIInventoryDataException: " + e.getMessage()));
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(3);
            return null;
        }
        result.setStatus(1);
        return ouid.getCRSHomeLocation();
    }

    public static String getCRSHomeFromOCRDump(String crsHomeFromInv, String node, Result result) {
        Trace.out((String)("Executing getCRSHomeFromOCRDump(crsHomeFromInv=" + crsHomeFromInv + ", node=" + node + ")"));
        if (!VerificationUtil.isStringGood(crsHomeFromInv)) {
            Trace.out((int)5, (String)"CRS home could not be retrieved from inventory hence returning null!");
            return null;
        }
        String crsHome = null;
        String homeOCRKey = "SYSTEM.ORA_CRS_HOME";
        result.setStatus(1);
        StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHomeFromInv, "SYSTEM.ORA_CRS_HOME", result);
        if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            String[] lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
            Pattern p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
            for (String outputLine : lineByLine) {
                Matcher m = p.matcher(outputLine);
                if (!m.matches()) continue;
                crsHome = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(crsHome)) {
            Trace.out((String)"Failed to retrieve the CRS home using OCRDUMP");
            result.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5301", true)));
            result.setStatus(3);
            return null;
        }
        Trace.out((int)5, (String)("The CRS home retrieved using OCR dump is " + crsHome));
        result.setStatus(1);
        return crsHome;
    }

    public static String getCRSHomeFromInitCSSD(String node, Result result) {
        Trace.out((String)("Executing getCRSHomeFromInitCSSD(node=" + node + ", result)"));
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        String command = null;
        ErrorDescription errDesc = null;
        CommandsUtil cmdUtil = new CommandsUtil();
        ResultSet homeInfoRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        String crsHome = null;
        String cssdFileLocation = sVerificationUtil.getCSSDFileLoc();
        Trace.out((String)"The command Approach failed, now using Fallback (grep) approach");
        command = cmdUtil.getGrep() + " " + ORA_CRS_HOME + "= " + cssdFileLocation;
        homeInfoRsltSet.clear();
        rslt = globalExec.runExe(new String[]{node}, command, homeInfoRsltSet, false);
        if (rslt) {
            Result usrResult = (Result)homeInfoRsltSet.getResultTable().get(node);
            if (usrResult != null && usrResult.getStatus() == 1) {
                Vector resultInfoset = usrResult.getResultInfoSet();
                String homeStr = null;
                String exectaskOutput = null;
                if (resultInfoset.size() > 1 && (exectaskOutput = (String)resultInfoset.elementAt(1)) != null && VerificationUtil.fetchVerificationResult(exectaskOutput).equals("0") && (homeStr = VerificationUtil.fetchVerificationValue(exectaskOutput)) != null) {
                    homeStr = homeStr.trim();
                }
                if (homeStr == null || homeStr.length() == 0) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"Failed, the command did not return success (CV Val is non-zero).");
                    }
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
                    result.addErrorDescription(errDesc);
                    result.setStatus(3);
                    return null;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("The Output returned from the command is :" + homeStr));
                }
                if (homeStr != null && homeStr.length() > 0) {
                    if (homeStr.contains("=")) {
                        int equalIndex = homeStr.indexOf("=");
                        crsHome = homeStr.length() > equalIndex ? homeStr.substring(equalIndex + 1) : null;
                    } else {
                        crsHome = homeStr;
                    }
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("The CRS home name returned from the command is :" + crsHome));
                }
                if (crsHome != null && crsHome.trim().length() > 0) {
                    result.setStatus(1);
                    return crsHome;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"The command run was successful but returned nothing.");
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
                result.addErrorDescription(errDesc);
                result.setStatus(3);
                return null;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to run the command.");
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
            result.addErrorDescription(errDesc);
            result.setStatus(3);
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Failed in globalExec.runExe.");
        }
        errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    public static String getInventoryFileLocation() throws InvalidOUIInventoryDataException {
        return new sVerificationUtil().getInventoryFileLocation();
    }

    public static boolean isHAInstalled() {
        boolean haInstalled = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        String ouiLoc = VerificationUtil.getCVHome() + FSEP + "oui";
        String invPtrProp = null;
        invPtrProp = sVerificationUtil.getInventoryConfigFilePointer();
        if (invPtrProp != null && invPtrProp.trim().length() > 0) {
            String oldInvPtrProp;
            block5: {
                oldInvPtrProp = System.setProperty(ORA_INST_INVPTR_PROPERTY, invPtrProp.trim());
                try {
                    haInstalled = clustInfo.isHAInstalled(ouiLoc);
                    Trace.out((String)("haInstalled=" + haInstalled));
                }
                catch (InstallException ie) {
                    Trace.out((String)"Caught InstallException");
                    VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
                    if (m_noReportException) break block5;
                    VerificationUtil.reportException((Exception)((Object)ie));
                }
            }
            if (oldInvPtrProp == null) {
                System.clearProperty(ORA_INST_INVPTR_PROPERTY);
            } else {
                System.setProperty(ORA_INST_INVPTR_PROPERTY, oldInvPtrProp);
            }
        }
        return haInstalled;
    }

    public static boolean isHAConfigured() {
        if (!VerificationUtil.isAPIMode() && m_isLocalNodeHAConfigured != null) {
            return m_isLocalNodeHAConfigured;
        }
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        try {
            m_isLocalNodeHAConfigured = clustInfo.isHAConfigured();
            Trace.out((String)("haConfigured=" + m_isLocalNodeHAConfigured));
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
            if (!m_noReportException) {
                VerificationUtil.reportException((Exception)((Object)ie));
            }
            m_isLocalNodeHAConfigured = false;
        }
        return m_isLocalNodeHAConfigured;
    }

    public static boolean isCRSConfigured() {
        if (!VerificationUtil.isAPIMode() && m_isLocalNodeCRSConfigured != null) {
            return m_isLocalNodeCRSConfigured;
        }
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        try {
            m_isLocalNodeCRSConfigured = clustInfo.isCRSConfigured();
            Trace.out((String)("crsConfigured=" + m_isLocalNodeCRSConfigured));
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
            if (!m_noReportException) {
                VerificationUtil.reportException((Exception)((Object)ie));
            }
            m_isLocalNodeCRSConfigured = false;
        }
        return m_isLocalNodeCRSConfigured;
    }

    public static boolean isCRSInstalled() {
        boolean crsInstalled = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        String ouiLoc = VerificationUtil.getCVHome() + FSEP + "oui";
        String invPtrProp = sVerificationUtil.getInventoryConfigFilePointer();
        if (invPtrProp != null && invPtrProp.trim().length() > 0) {
            String oldInvPtrProp;
            block5: {
                oldInvPtrProp = System.setProperty(ORA_INST_INVPTR_PROPERTY, invPtrProp.trim());
                try {
                    crsInstalled = clustInfo.isCRSInstalled(ouiLoc);
                    Trace.out((String)("crsInstalled=" + crsInstalled));
                }
                catch (InstallException ie) {
                    Trace.out((String)"Caught InstallException");
                    VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
                    if (m_noReportException) break block5;
                    VerificationUtil.reportException((Exception)((Object)ie));
                }
            }
            if (oldInvPtrProp == null) {
                System.clearProperty(ORA_INST_INVPTR_PROPERTY);
            } else {
                System.setProperty(ORA_INST_INVPTR_PROPERTY, oldInvPtrProp);
            }
        }
        return crsInstalled;
    }

    public static Result isDNFSPathInUse() {
        Trace.out((String)"isDNFSPathInUse check called");
        Result result = new Result(m_localNode);
        String commaSeparatedPathList = CVUVariables.getValue(CVUVariableConstants.DATAFILE_DESTINATION_PATH);
        if (!VerificationUtil.isStringGood(commaSeparatedPathList)) {
            Trace.out((String)"The variable VAR_DATAFILE_DESTINATION_PATH was not found set returning false");
            String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"DATAFILE_DESTINATION_PATH IS EMPTY"});
            result.addErrorDescription(new ErrorDescription(msg));
            result.setStatus(3);
            return result;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"WINDOWS PLATFORM"});
            result.addErrorDescription(new ErrorDescription(msg));
            result.setStatus(2);
            return result;
        }
        Result resFromCheckDNFSEnabled = VerificationUtil.checkDNFSEnabled();
        if (1 == resFromCheckDNFSEnabled.getStatus()) {
            String oracle_home = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
            Trace.out((String)("isDNFSPathInUse :: Oracle Home :: " + oracle_home));
            if (!VerificationUtil.isStringGood(oracle_home)) {
                String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"ORACLE_HOME"});
                result.addErrorDescription(new ErrorDescription(msg));
                result.setStatus(2);
                return result;
            }
            Trace.out((String)("The comma separated paths " + commaSeparatedPathList));
            String[] pathList = commaSeparatedPathList.split(",");
            String[] filePathList = new String[]{oracle_home + FSEP + "dbs" + FSEP + "oranfstab", FSEP + "etc" + FSEP + "oranfstab", FSEP + "etc" + FSEP + "mtab"};
            boolean finished = false;
            for (String filePath : filePathList) {
                File file = new File(filePath);
                if (!file.exists()) continue;
                for (String pathValue : pathList) {
                    Result res = VerificationUtil.checkForNFSMountPoint(filePath, pathValue);
                    if (1 == res.getStatus()) {
                        Trace.out((String)("The Path " + pathValue + " was mounted in the config file " + file));
                        result.setStatus(1);
                        finished = true;
                        break;
                    }
                    if (2 != res.getStatus()) continue;
                    result = res;
                    finished = true;
                    break;
                }
                if (!finished) {
                    continue;
                }
                break;
            }
        } else {
            result = resFromCheckDNFSEnabled;
        }
        return result;
    }

    public static Result checkDNFSEnabled() {
        Trace.out((String)"checkDNFSEnabled Called");
        Result resultObj = new Result(m_localNode);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"WINDOWS PLATFORM"});
            resultObj.addErrorDescription(new ErrorDescription(msg));
            resultObj.setStatus(2);
            return resultObj;
        }
        String oracle_home = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        Trace.out((String)("checkDNFSEnabled :: Oracle Home :: " + oracle_home));
        if (!VerificationUtil.isStringGood(oracle_home)) {
            String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"ORACLE_HOME"});
            resultObj.addErrorDescription(new ErrorDescription(msg));
            resultObj.setStatus(2);
            return resultObj;
        }
        String majVer = null;
        try {
            Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
            if (crsActiveVersion != null) {
                majVer = new DBUtils(crsActiveVersion).getDBVersion(oracle_home).getMajorVersion();
            }
        }
        catch (DBUtilsException e) {
            Trace.out((String)("Exception : " + e.getMessage()));
            String msg = s_gMsgBundle.getMessage("0364", true, (Object[])new String[]{m_localNode}) + LSEP + e.getMessage();
            resultObj.addErrorDescription(new ErrorDescription(msg));
            resultObj.setStatus(2);
            return resultObj;
        }
        int mVersion = Integer.parseInt(majVer);
        if (mVersion < ORACLEDBDNFSSUPPORTEDVER) {
            Trace.out((String)("DNFS not supported for the version : " + mVersion));
            String msg = s_gMsgBundle.getMessage("0363", true, (Object[])new String[]{majVer});
            resultObj.addErrorDescription(new ErrorDescription(msg));
            resultObj.setStatus(2);
            return resultObj;
        }
        String libFile = LIBNFSODM + majVer + LIBSOEXT;
        String linkFile = LIBNFSODMLINK + majVer + LIBSOEXT;
        File file1 = new File(oracle_home + FSEP + "lib" + FSEP + libFile);
        File file2 = new File(oracle_home + FSEP + "lib" + FSEP + linkFile);
        if (file1.exists() && file2.exists()) {
            Trace.out((String)"Both the files exist now checking the link");
            String filename = oracle_home + FSEP + "lib" + FSEP + libFile;
            String linkfilename = oracle_home + FSEP + "lib" + FSEP + linkFile;
            ResultSet resultSet = new ResultSet();
            String[] nodelist = new String[]{m_localNode};
            boolean result = new GlobalExecution().checkFileLink(nodelist, filename, linkfilename, resultSet);
            resultObj = resultSet.getResult(m_localNode);
            if (result) {
                Trace.out((String)"The link exists ");
                resultObj.setStatus(1);
            } else {
                Trace.out((String)"The link does not exist ");
                String msg = s_gMsgBundle.getMessage("0362", true, (Object[])new String[]{m_localNode});
                resultObj.addErrorDescription(new ErrorDescription(msg));
                resultObj.setStatus(3);
            }
        } else {
            String msg = s_gMsgBundle.getMessage("0362", true, (Object[])new String[]{m_localNode});
            resultObj.addErrorDescription(new ErrorDescription(msg));
            resultObj.setStatus(3);
        }
        return resultObj;
    }

    private static Result checkForNFSMountPoint(String configFilePath, String dbcaDataFilePath) {
        Trace.out((String)("checkForNFSMountPoint called with configFilePath = " + configFilePath + " dbcaDataFilePath = " + dbcaDataFilePath));
        Result result = new Result(m_localNode, 3);
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(configFilePath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String exportTag = "export:";
            String mountTag = "mount:";
            String nfsTag = " nfs ";
            String mtabPath = "/etc/mtab";
            File dbcaDataFilePathFile = new File(dbcaDataFilePath);
            String candbcaDataFilePath = dbcaDataFilePathFile.getCanonicalPath();
            while ((strLine = br.readLine()) != null) {
                int endIndex;
                strLine = strLine.trim();
                if (configFilePath.equals(mtabPath)) {
                    if (!strLine.contains(nfsTag)) continue;
                    int startIndex = strLine.indexOf(" ", 0);
                    endIndex = strLine.indexOf(" ", ++startIndex);
                    String path = strLine.substring(startIndex, endIndex);
                    File pathFile = new File(path);
                    String canPath = pathFile.getCanonicalPath();
                    Trace.out((String)("File line =" + strLine + " candbcaDataFilePath = " + candbcaDataFilePath + " canPath = " + canPath));
                    if (!candbcaDataFilePath.equals(canPath) && !candbcaDataFilePath.startsWith(canPath)) continue;
                    result.setStatus(1);
                    break;
                }
                if (!strLine.startsWith(exportTag)) continue;
                String path = strLine.substring(strLine.indexOf(mountTag) + mountTag.length()).trim();
                endIndex = path.indexOf(" ", mountTag.length());
                if (endIndex > 0) {
                    path = path.substring(0, endIndex);
                }
                File pathFile = new File(path);
                String canPath = pathFile.getCanonicalPath();
                Trace.out((String)("File line =" + strLine + " candbcaDataFilePath = " + candbcaDataFilePath + " canPath = " + canPath));
                if (!candbcaDataFilePath.equals(canPath) && !candbcaDataFilePath.startsWith(canPath)) continue;
                result.setStatus(1);
                break;
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Trace.out((String)("Error: " + e.getMessage()));
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
        }
        catch (IOException e) {
            Trace.out((String)("Error: " + e.getMessage()));
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
        }
        return result;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            if (!cluInfo.isHAConfigured()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"HA is not configured");
                }
                throw new HAHomeNotFoundException(s_msgBundle.getMessage("5318", true));
            }
        }
        catch (InstallException ie) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(" Could not detemine whether HA is configured:" + ie.getMessage()));
            }
            throw new HAHomeNotFoundException(ie.getMessage());
        }
        return sVerificationUtil.getHAHomeWithException();
    }

    public static String getHAHome() {
        String haHome;
        block4: {
            Trace.out((String)"Executing getHAHome()");
            String haHomeCvuVarName = CVUVariableConstants.SIHA_HOME.toString();
            CVUVariableData haHomeCvuVar = CVUVariables.getCVUVariable(haHomeCvuVarName);
            haHome = null;
            if (haHomeCvuVar != null && !haHomeCvuVar.isLookUpForced()) {
                Trace.out((String)"LookUp is NOT forced returning cached value");
                haHome = haHomeCvuVar.getValue();
            } else {
                try {
                    haHome = VerificationUtil.getHAHomeWithException();
                }
                catch (HAHomeNotFoundException hae) {
                    if (!Trace.isLevelEnabled((int)5)) break block4;
                    Trace.out((String)("HA home can not be found:" + hae.getMessage()));
                    Trace.out((Exception)hae);
                }
            }
        }
        Trace.out((String)("Returning HA home as '" + haHome + "'"));
        return haHome;
    }

    public static String getHAorCRSHome(String[] nodeList, String homeType, List<String> validNodes, ResultSet resultSet) {
        String exeHome = null;
        ErrorDescription errDesc = null;
        if (homeType.contentEquals(HA_HOME_REQ) || homeType.contentEquals(HA_OR_CRS_HOME_REQ)) {
            block18: {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Attempt to get HA (OracleRestart) home");
                }
                try {
                    exeHome = VerificationUtil.getHAHomeWithException();
                }
                catch (HAHomeNotFoundException hae) {
                    if (!homeType.contentEquals(HA_HOME_REQ)) break block18;
                    String errMsg1 = hae.getMessage();
                    if (errMsg1 != null && errMsg1.length() > 0) {
                        VerificationLogData.addGlobalError(new ErrorDescription(errMsg1), new String[]{VerificationUtil.getLocalNode()}, false);
                    }
                    Trace.out((String)("\nHAHomeNotFoundEXCEPTION: \n" + hae));
                }
            }
            if (exeHome == null) {
                if (homeType.contentEquals(HA_HOME_REQ)) {
                    errDesc = new ErrorDescription("5307", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    VerificationLogData.addGlobalErrorOnce("Prvf", "5307", true, null, null, new String[]{VerificationUtil.getLocalNode()});
                    resultSet.addResult(nodeList, 2);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"\nReturning NULL HA (OracleRestart) home");
                    }
                    return null;
                }
            } else {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nReturning HA (OracleRestart) home: " + exeHome));
                }
                resultSet.addResult(nodeList, 1);
                validNodes.addAll(Arrays.asList(nodeList));
                return exeHome;
            }
        }
        if (homeType.contentEquals(CRS_HOME_REQ) || homeType.contentEquals(HA_OR_CRS_HOME_REQ) && exeHome == null) {
            String[] validNodeArr = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Attempt to get CRS home");
            }
            if ((exeHome = VerificationUtil.getCRSHome()) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Failed to retrieve CRS home");
                }
                errDesc = new ErrorDescription("5301", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                VerificationLogData.addGlobalErrorOnce("Prvf", "5301", true, null, null, new String[]{VerificationUtil.getLocalNode()});
                resultSet.addResult(nodeList, 2);
                return null;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nReturning CRS home: " + exeHome));
            }
            if ((validNodeArr = VerificationUtil.getNodesWithCRSInstall(nodeList, resultSet)) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"CRS is not installed on any given node");
                }
                resultSet.addResult(nodeList, 2);
                return null;
            }
            resultSet.addResult(validNodeArr, 1);
            validNodes.addAll(Arrays.asList(validNodeArr));
            return exeHome;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Failed to retrieve HA (OracleRestart) orCRS home");
        }
        errDesc = new ErrorDescription("5321", s_msgBundle);
        resultSet.addErrorDescription(errDesc);
        VerificationLogData.addGlobalErrorOnce("Prvf", "5321", true, null, null, new String[]{VerificationUtil.getLocalNode()});
        resultSet.addResult(nodeList, 2);
        return null;
    }

    public static boolean isCRSInstalledOnNode(String node) {
        return VerificationUtil.isCRSInstalledOnNode(node, false);
    }

    public static boolean isCRSInstalledOnNode(String node, boolean mute) {
        String[] ndList = new String[]{node};
        Vector<String> sucV = new Vector<String>(1);
        Vector<String> failV = new Vector<String>(1);
        return VerificationUtil.isCRSInstalled(ndList, sucV, failV, mute);
    }

    public static boolean isCRSInstalledOnLocalNode() {
        String localNd = VerificationUtil.getLocalNode();
        String[] ndList = new String[]{localNd};
        Vector<String> sucV = new Vector<String>(1);
        Vector<String> failV = new Vector<String>(1);
        return VerificationUtil.isCRSInstalled(ndList, sucV, failV);
    }

    public static boolean isCRSInstalled(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        return VerificationUtil.isCRSInstalled(nodeList, succNodeVect, failNodeVect, false);
    }

    public static boolean isCRSInstalled(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect, boolean mute) {
        ResultSet resultSet = new ResultSet();
        return VerificationUtil.isCRSInstalled(nodeList, succNodeVect, failNodeVect, resultSet, mute);
    }

    public static boolean isCRSInstalled(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect, ResultSet resultSet, boolean mute) {
        Trace.out((String)("nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        VerificationLogData.logFine(LSEP + "nodeList='" + VerificationUtil.strArr2List(nodeList) + "'");
        boolean isNodeListFound = false;
        succNodeVect.clear();
        failNodeVect.clear();
        try {
            VerificationUtil.getNodelistFromOlsnodesWithException();
            isNodeListFound = true;
        }
        catch (NodelistNotFoundException e) {
            if (!mute) {
                ReportUtil.printError(e.getMessage());
            }
            resultSet.addResult(nodeList, 2);
            resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            Trace.out((String)("IGNORED: " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
        for (String node : nodeList) {
            boolean foundNode = false;
            for (String olsNodeArrElem : m_nodeListFromOlsnodes) {
                if (!olsNodeArrElem.equalsIgnoreCase(VerificationUtil.getShortHostname(node))) continue;
                Trace.out((String)("CRS found installed  on node (olsnodes): " + node));
                succNodeVect.add(node);
                resultSet.addResult(node, 1);
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            Trace.out((String)("Not found in olsnodes & inventory: " + node));
            failNodeVect.add(node);
            resultSet.addResult(node, 2);
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7593", true, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
        }
        if (failNodeVect.size() == 0) {
            return true;
        }
        if (isNodeListFound && !mute && succNodeVect.size() == 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4037", true));
        }
        return false;
    }

    public static boolean isDirWritable(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 4, succNodes, failNodes);
    }

    public static boolean isDirWritable(String[] nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        return VerificationUtil.pathExists(nodeList, path, 4, succNodes, failNodes);
    }

    public static boolean isDirPathWritable(String[] nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        NativeSystem nativeSys;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!(nativeSys = new SystemFactory().CreateSystem()).isUnixSystem() && VerificationUtil.isStringGood(path) && path.contains("/")) {
            path = new File(path).getAbsolutePath();
        }
        if (VerificationUtil.pathExists(nodeList, path, 1, succNodes, failNodes)) {
            return VerificationUtil.pathExists(nodeList, path, 4, succNodes, failNodes);
        }
        if (path.lastIndexOf(FSEP) == -1) {
            return false;
        }
        succNodes.clear();
        failNodes.clear();
        String parent = path.substring(0, path.lastIndexOf(FSEP));
        if (parent.length() == 0) {
            parent = FSEP;
        } else if (parent.charAt(parent.length() - 1) == ':' && VerificationUtil.getCurrentOS().toLowerCase().startsWith("windows") && parent.length() == 2) {
            parent = new String(parent + FSEP);
            Trace.out((String)("Added '" + FSEP + "' to: '" + parent + "'"));
        }
        while (true) {
            Trace.out((String)("Checking path: '" + parent + "'"));
            if (VerificationUtil.pathExists(nodeList, parent, 1, succNodes, failNodes)) {
                return VerificationUtil.pathExists(nodeList, parent, 4, succNodes, failNodes);
            }
            if (parent.lastIndexOf(FSEP) == -1) {
                return false;
            }
            if (parent.length() == parent.lastIndexOf(FSEP) + 1) break;
            if ((parent = parent.substring(0, parent.lastIndexOf(FSEP))).length() == 0) {
                parent = FSEP;
                continue;
            }
            if (parent.charAt(parent.length() - 1) != ':' || !VerificationUtil.getCurrentOS().toLowerCase().startsWith("windows") || parent.length() != 2) continue;
            parent = new String(parent + FSEP);
            Trace.out((String)("Added '" + FSEP + "' to: '" + parent + "'"));
        }
        return false;
    }

    private static boolean dirExists(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 1, succNodes, failNodes);
    }

    private static boolean pathExists(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 0, succNodes, failNodes);
    }

    public static boolean pathExists(String[] nodeList, String path, int pathType, Collection<String> succNodes, Collection<String> failNodes) {
        boolean succ;
        block10: {
            ClusterCmd clusterCmd = new ClusterCmd();
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            succNodes.clear();
            failNodes.clear();
            Trace.out((String)("nodeList: '" + VerificationUtil.strArr2List(nodeList) + "' path: '" + path + "' pathType: '" + pathType + "' isLocalNodeOperation(): '" + VerificationUtil.isLocalNodeOperation() + "'"));
            try {
                succ = VerificationUtil.isLocalNodeOperation() ? clusterCmd.pathExists(new String[]{"localnode"}, path, pathType) : clusterCmd.pathExists(nodeList, path, pathType);
                if (!succ) break block10;
                for (int i = 0; i < nodeList.length; ++i) {
                    succNodes.add(nodeList[i]);
                }
            }
            catch (ClusterException ce) {
                Trace.out((String)("Exception occured: \n" + (Object)((Object)ce)));
                succ = false;
                VerificationLogData.logError("CLUSTEREXCEPTION: " + ce.getMessage() + LSEP + Trace.getStackTrace((Throwable)ce));
                for (int i = 0; i < nodeList.length; ++i) {
                    failNodes.add(nodeList[i]);
                }
            }
            catch (ClusterOperationException coe) {
                Trace.out((String)("Didn't expect ClusterOperationException " + (Object)((Object)coe)));
                succ = false;
                for (int i = 0; i < nodeList.length; ++i) {
                    try {
                        int status = coe.getStatus(nodeList[i]);
                        if (0 == status) {
                            succNodes.add(nodeList[i]);
                            continue;
                        }
                        failNodes.add(nodeList[i]);
                        if (2 != status) continue;
                        Trace.out((String)coe.getException(nodeList[i]).getMessage());
                        VerificationLogData.logError("CLUSTEROPERATIONEXCEPTION: " + coe.getException(nodeList[i]).getMessage() + LSEP + Trace.getStackTrace((Throwable)coe.getException(nodeList[i])));
                        continue;
                    }
                    catch (NoSuchNodeException ns) {
                        Trace.out((String)("\n UNEXPECTED::: \n" + (Object)((Object)ns)));
                        failNodes.add(nodeList[i]);
                        VerificationLogData.logError("NOSUCHNODEEXCEPTION: " + ns.getMessage() + LSEP + Trace.getStackTrace((Throwable)ns));
                    }
                }
            }
        }
        Trace.out((String)"returning success");
        return succ;
    }

    public static boolean checkDestLoc(String[] nodeArray, ResultSet resultSet, Collection<String> succNodes, Collection<String> failNodes, boolean report) {
        String[] tempNodeList;
        Object[] args;
        Vector<String> wDLNodes = new Vector<String>();
        Vector<String> noWDLNodes = new Vector<String>();
        String destLoc = VerificationUtil.getDestLoc();
        String subDirPath = VerificationUtil.getCVUSubDirPath();
        ResultSet verResultSet = new ResultSet();
        Vector<String> incompatibleNodes = new Vector<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        ArrayList<String> succNodesLocal = new ArrayList<String>();
        String subDirErrMsg = null;
        Trace.out((String)("destloc is--->" + destLoc));
        Trace.out((String)("subDirPath is--->" + subDirPath));
        succNodes.clear();
        failNodes.clear();
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        Collection<String> nodesToCheckDestLoc = VerificationUtil.getFrameworkSetupNotCheckedNodes(nodeArray, succNodes, resultSet);
        if (nodesToCheckDestLoc.isEmpty()) {
            return true;
        }
        String[] nodeList = nodesToCheckDestLoc.toArray(new String[0]);
        try {
            VerificationUtil.traceAndLog("Creating directory " + destLoc);
            clusterCmd.createDirWithModeOnNodes(nodeList, subDirPath);
        }
        catch (ClusterException e) {
            Trace.out((String)("ce exception occurred when trying to create CV_DESTLOC:" + e.getMessage()));
            VerificationUtil.traceAndLogError("CLUSTEREXCEPTION: " + e.getMessage() + LSEP + Trace.getStackTrace((Throwable)e));
            subDirErrMsg = e.getMessage();
            subDirErrMsg = subDirErrMsg.replaceAll(" :successful" + LSEP, "");
            subDirErrMsg = subDirErrMsg.trim();
        }
        VerificationUtil.isDirWritable(nodeList, destLoc, wDLNodes, noWDLNodes);
        if (wDLNodes.size() > 0) {
            Vector<String> wSubDirNodes = new Vector<String>();
            Vector<String> noWSubDirNodes = new Vector<String>();
            VerificationUtil.isDirWritable(wDLNodes, subDirPath, wSubDirNodes, noWSubDirNodes);
            succNodesLocal.addAll(wSubDirNodes);
            if (noWSubDirNodes.size() > 0) {
                Vector<String> subDirNodes = new Vector<String>();
                Vector<String> noSubDirNodes = new Vector<String>();
                VerificationUtil.dirExists(noWSubDirNodes, subDirPath, subDirNodes, noSubDirNodes);
                succNodesLocal.addAll(noSubDirNodes);
                if (subDirNodes.size() > 0) {
                    if (report) {
                        args = new String[]{subDirPath};
                        VerificationLogData.addGlobalErrorOnce("Prvf", "9013", true, args, new String[]{VerificationUtil.strCollection2String(subDirNodes)}, subDirNodes.toArray(new String[0]));
                    }
                    subDirErrMsg = s_msgBundle.getMessage("9013", true, (Object[])new String[]{subDirPath}) + VerificationUtil.strCollection2String(subDirNodes) + LSEP + s_msgBundle.getMessage("7547", false, (Object[])new String[]{subDirPath}) + LSEP + s_msgBundle.getMessage("7548", false);
                    failNodes.addAll(subDirNodes);
                }
            }
        }
        if (noWDLNodes.size() > 0) {
            Vector<String> dLNodes = new Vector<String>();
            Vector<String> noDLNodes = new Vector<String>();
            VerificationUtil.pathExists(noWDLNodes, destLoc, dLNodes, noDLNodes);
            if (dLNodes.size() > 0) {
                failNodes.addAll(dLNodes);
                tempNodeList = dLNodes.toArray(new String[dLNodes.size()]);
                resultSet.addResult(tempNodeList, 2);
                if (report) {
                    args = new String[]{destLoc};
                    VerificationLogData.addGlobalErrorOnce("Prvf", "9012", false, args, new String[]{VerificationUtil.strCollection2String(dLNodes)}, dLNodes.toArray(new String[0]));
                }
                subDirErrMsg = s_msgBundle.getMessage("7549", true, (Object[])new String[]{destLoc}) + LSEP + subDirErrMsg;
            }
            if (noDLNodes.size() > 0) {
                Vector<String> wParentNodes = new Vector<String>();
                Vector<String> noWParentNodes = new Vector<String>();
                String destLocParent = new File(destLoc).getParent();
                VerificationUtil.isDirWritable(noDLNodes, destLocParent, wParentNodes, noWParentNodes);
                succNodesLocal.addAll(wParentNodes);
                if (noWParentNodes.size() > 0) {
                    failNodes.addAll(noWParentNodes);
                    tempNodeList = noWParentNodes.toArray(new String[noWParentNodes.size()]);
                    resultSet.addResult(tempNodeList, 2);
                    if (report) {
                        args = new String[]{destLoc};
                        VerificationLogData.addGlobalErrorOnce("Prvf", "9014", false, args, new String[]{VerificationUtil.strCollection2String(noWParentNodes)}, noWParentNodes.toArray(new String[0]));
                    }
                    subDirErrMsg = s_msgBundle.getMessage("7550", true, (Object[])new String[]{destLoc, VerificationUtil.strCollection2String(noWParentNodes)}) + LSEP + subDirErrMsg;
                }
            }
        }
        if (succNodesLocal.size() > 0) {
            tempNodeList = succNodesLocal.toArray(new String[succNodesLocal.size()]);
            resultSet.addResult(tempNodeList, 1);
        }
        if (failNodes.size() > 0) {
            ErrorDescription errDesc;
            String errMsg;
            resultSet.addResult(failNodes, 2);
            if (1 == nodeList.length) {
                args = null;
                if (report) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9016", false, args));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                errMsg = s_gMsgBundle.getMessage("1900", true, (Object[])new String[]{subDirPath, VerificationUtil.strCollection2String(failNodes)});
                if (subDirErrMsg != null) {
                    errMsg = errMsg + LSEP + subDirErrMsg;
                }
                errDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(errDesc);
            } else if (failNodes.size() == nodeList.length) {
                args = null;
                if (report) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9016", false, args));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                errMsg = s_gMsgBundle.getMessage("1903", true, (Object[])new String[]{subDirPath});
                if (subDirErrMsg != null) {
                    errMsg = errMsg + LSEP + subDirErrMsg;
                }
                errDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(errDesc);
            } else {
                errMsg = s_gMsgBundle.getMessage("1900", true, (Object[])new String[]{subDirPath, VerificationUtil.strCollection2String(failNodes)});
                if (subDirErrMsg != null) {
                    errMsg = errMsg + LSEP + subDirErrMsg;
                }
                String limitedVerificationMsg = s_msgBundle.getMessage("0008", false) + LSEP + VerificationUtil.strCollection2String(succNodesLocal);
                errMsg = errMsg + LSEP + limitedVerificationMsg;
                errDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(failNodes, errDesc);
                if (report) {
                    ReportUtil.sureprintln(limitedVerificationMsg);
                }
            }
        }
        if (succNodesLocal.isEmpty()) {
            return false;
        }
        String localNode = VerificationUtil.getLocalNode();
        boolean isAddLocalNodeToSuccNodes = false;
        if (succNodesLocal.contains(localNode)) {
            succNodesLocal.remove(localNode);
            isAddLocalNodeToSuccNodes = true;
        }
        for (int numAttempts = 0; numAttempts <= 1; ++numAttempts) {
            ResultSet localNodeRS = new ResultSet();
            new GlobalExecution().getExectaskVer(new String[]{localNode}, localNodeRS, true);
            ArrayList<String> succLocalList = new ArrayList<String>();
            Vector<String> incompatibleLocalVect = new Vector<String>();
            Vector<String> failLocalVect = new Vector<String>();
            VerificationUtil.checkGetExectaskVerResults(resultSet, localNodeRS, succLocalList, failLocalVect, incompatibleLocalVect, report);
            if (incompatibleLocalVect.size() != 0 || failLocalVect.size() != 0) {
                if (numAttempts > 1) {
                    VerificationUtil.reportCheckDestLocFailureOnLocalNode(localNode, resultSet, failNodes, succNodes, nodeList, null, subDirPath, report);
                    return false;
                }
                Trace.out((String)"removing destloc on local node");
                try {
                    clusterCmd.removeDirectory(new String[]{localNode}, subDirPath, true);
                }
                catch (ClusterException e) {
                    Trace.out((String)("directory can't be removed: " + e.getMessage()));
                    VerificationUtil.reportCheckDestLocFailureOnLocalNode(localNode, resultSet, failNodes, succNodes, nodeList, e.getMessage(), subDirPath, report);
                    return false;
                }
                Trace.out((String)"retrying destloc check on local node after remove");
                continue;
            }
            ArrayList<String> remExecFailLocal = new ArrayList<String>();
            ResultSet localRS = new ResultSet();
            VerificationUtil.checkRemExecFileList(succLocalList, remExecFailLocal, localRS);
            if (remExecFailLocal.size() == 0) {
                Trace.out((String)"destloc setup on local node succeeded");
                break;
            }
            if (numAttempts > 1) {
                VerificationUtil.reportCheckDestLocFailureOnLocalNode(localNode, resultSet, failNodes, succNodes, nodeList, null, subDirPath, report);
                return false;
            }
            try {
                clusterCmd.removeDirectory(new String[]{localNode}, subDirPath, true);
            }
            catch (ClusterException e) {
                Trace.out((String)("directory can't be removed: " + e.getMessage()));
                VerificationUtil.reportCheckDestLocFailureOnLocalNode(localNode, resultSet, failNodes, succNodes, nodeList, e.getMessage(), subDirPath, report);
                return false;
            }
            Trace.out((String)"improper files/permission issue in destloc, trying again");
        }
        tempNodeList = succNodesLocal.toArray(new String[succNodesLocal.size()]);
        new GlobalExecution().getExectaskVer(tempNodeList, verResultSet, false);
        Trace.out((String)"VerificationUtil::getExectaskVer() performed!!");
        succNodesLocal.clear();
        incompatibleNodes.clear();
        ResultSet firstRS = new ResultSet();
        Vector<String> failLocalVect = new Vector<String>();
        VerificationUtil.checkGetExectaskVerResults(firstRS, verResultSet, succNodesLocal, failLocalVect, incompatibleNodes, report);
        String[] exectaskSuccNodes = firstRS.getSuccNodes();
        resultSet.addResult(exectaskSuccNodes, 1);
        if (incompatibleNodes.size() != 0 || failLocalVect.size() != 0) {
            Trace.out((String)("In the first attempt to execute exectask, it was is found to be incompatiable on nodes: " + VerificationUtil.strVect2List(incompatibleNodes) + " and execute exectask " + "failed on nodes: " + VerificationUtil.strCollection2String(failLocalVect)));
            int incompatibleNodesSize = incompatibleNodes.size();
            int failNodesSize = failLocalVect.size();
            int tempSize = incompatibleNodesSize + failNodesSize;
            Vector<String> tempNodeVect = new Vector<String>();
            tempNodeVect.addAll(incompatibleNodes);
            tempNodeVect.addAll(failLocalVect);
            tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
            try {
                clusterCmd.removeDirectory(tempNodeList, subDirPath, true);
            }
            catch (ClusterException ce) {
                VerificationUtil.traceAndLogError("failed to remove " + subDirPath + " on some nodes");
                tempNodeVect = VerificationUtil.reportCheckDestLocFailureOnRemoteNodes(tempNodeVect, failNodes, resultSet, ce, subDirPath, true, false, report);
                tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
            }
            if (tempNodeList.length > 0) {
                Trace.out((String)("Successfully deleted the contents of directory '" + subDirPath + "' on nodes '" + VerificationUtil.strArr2List(tempNodeList) + "'"));
                try {
                    clusterCmd.createDirInNodes(tempNodeList, subDirPath);
                }
                catch (ClusterException ce) {
                    VerificationUtil.traceAndLogError("failed to create directory " + subDirPath + " on some nodes ");
                    tempNodeVect = VerificationUtil.reportCheckDestLocFailureOnRemoteNodes(tempNodeVect, failNodes, resultSet, ce, subDirPath, false, false, report);
                    tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
                }
            }
            if (tempNodeList.length > 0) {
                Trace.out((String)("Successfully created " + subDirPath + " on nodes " + VerificationUtil.strArr2List(tempNodeList)));
                try {
                    clusterCmd.copyDirContentsToNodes(tempNodeList, subDirPath);
                }
                catch (ClusterException ce) {
                    VerificationUtil.traceAndLogError("failed to create directory " + subDirPath + " on some nodes ");
                    tempNodeVect = VerificationUtil.reportCheckDestLocFailureOnRemoteNodes(tempNodeVect, failNodes, resultSet, ce, subDirPath, false, true, report);
                    tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
                }
            }
            if (tempNodeList.length > 0) {
                Vector<String> newSuccNode = new Vector<String>();
                Vector<String> newFailNode = new Vector<String>();
                Vector<String> newIncompatibleNode = new Vector<String>();
                Trace.out((String)("Populated destloc with new exectask on nodes :" + VerificationUtil.strArr2List(tempNodeList)));
                verResultSet.clear();
                new GlobalExecution().getExectaskVer(tempNodeList, verResultSet, false);
                VerificationUtil.checkGetExectaskVerResults(resultSet, verResultSet, newSuccNode, newFailNode, newIncompatibleNode, report);
                for (String tempNode : tempNodeList) {
                    if (newSuccNode.contains(tempNode)) {
                        Trace.out((String)("Compatible exectask copied to node :" + tempNode));
                        succNodesLocal.add(tempNode);
                        resultSet.addResult(tempNode, new Result(tempNode, 1));
                        continue;
                    }
                    Trace.out((String)("Incompatible exectask. New exectask couldn't be copied to node :" + tempNode));
                    failNodes.add(tempNode);
                    resultSet.addResult(tempNode, 2);
                }
            }
        }
        if (succNodesLocal.size() > 0) {
            ArrayList<String> remExecFailNodes = new ArrayList<String>();
            ResultSet locRS = new ResultSet();
            VerificationUtil.checkRemExecFileList(succNodesLocal, remExecFailNodes, locRS);
            if (remExecFailNodes.size() != 0) {
                Trace.out((String)("Some of the remote files are found missing on nodes: " + VerificationUtil.strCollection2String(remExecFailNodes)));
                Vector<String> tempNodeVect = new Vector<String>();
                tempNodeVect.addAll(remExecFailNodes);
                tempNodeList = remExecFailNodes.toArray(new String[remExecFailNodes.size()]);
                try {
                    clusterCmd.removeDirectory(tempNodeList, subDirPath, true);
                }
                catch (ClusterException ce) {
                    VerificationUtil.traceAndLogError("failed to remove " + subDirPath + " on some nodes");
                    tempNodeVect = VerificationUtil.reportCheckDestLocFailureOnRemoteNodes(tempNodeVect, failNodes, resultSet, ce, subDirPath, true, false, report);
                    tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
                }
                if (tempNodeList.length > 0) {
                    Trace.out((String)("Successfully deleted the contents of directory '" + subDirPath + "' on nodes '" + VerificationUtil.strArr2List(tempNodeList) + "'"));
                    try {
                        clusterCmd.createDirInNodes(tempNodeList, subDirPath);
                    }
                    catch (ClusterException ce) {
                        VerificationUtil.traceAndLogError("failed to create directory " + subDirPath + " on some nodes ");
                        tempNodeVect = VerificationUtil.reportCheckDestLocFailureOnRemoteNodes(tempNodeVect, failNodes, resultSet, ce, subDirPath, false, false, report);
                        tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
                    }
                }
                if (tempNodeList.length > 0) {
                    Trace.out((String)("Successfully created " + subDirPath + " on nodes " + VerificationUtil.strArr2List(tempNodeList)));
                    try {
                        clusterCmd.copyDirContentsToNodes(tempNodeList, subDirPath);
                    }
                    catch (ClusterException ce) {
                        VerificationUtil.traceAndLogError("failed to copy files to directory " + subDirPath + " on some nodes ");
                        tempNodeVect = VerificationUtil.reportCheckDestLocFailureOnRemoteNodes(tempNodeVect, failNodes, resultSet, ce, subDirPath, false, true, report);
                        tempNodeList = tempNodeVect.toArray(new String[tempNodeVect.size()]);
                    }
                }
                if (tempNodeList.length > 0) {
                    Vector<String> newSuccNode = new Vector<String>();
                    Vector<String> newFailNode = new Vector<String>();
                    Vector<String> newIncompatibleNode = new Vector<String>();
                    ResultSet remVerResultSet = new ResultSet();
                    Trace.out((String)("Populated destloc with new exectask binaries on nodes: " + VerificationUtil.strArr2List(tempNodeList)));
                    new GlobalExecution().getExectaskVer(tempNodeList, remVerResultSet, false);
                    VerificationUtil.checkGetExectaskVerResults(resultSet, remVerResultSet, newSuccNode, newFailNode, newIncompatibleNode, report);
                    for (String tempNode : tempNodeList) {
                        if (newSuccNode.contains(tempNode)) {
                            Trace.out((String)("Populated destloc with new exectask on node :" + tempNode));
                            remExecFailNodes.remove(tempNode);
                            resultSet.addResult(tempNode, new Result(tempNode, 1));
                            continue;
                        }
                        Trace.out((String)("Incompatible exectask. New exectask couldn't be copied to node :" + tempNode));
                        resultSet.addResult(tempNode, 2);
                    }
                }
                if (remExecFailNodes.size() != 0) {
                    if (report) {
                        VerificationLogData.addGlobalErrorOnce("Prvf", "7650", true, new String[]{subDirPath}, new String[]{VerificationUtil.strCollection2String(remExecFailNodes)}, remExecFailNodes.toArray(new String[0]));
                    }
                    succNodesLocal.removeAll(remExecFailNodes);
                    if (report && succNodesLocal.size() > 0) {
                        ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                        succNodesLocal.add(localNode);
                        ReportUtil.sureprintNodelist(new Vector<String>(succNodesLocal));
                    }
                }
            }
        }
        if (isAddLocalNodeToSuccNodes) {
            succNodesLocal.add(localNode);
        }
        VerificationUtil.setLocalNodeFirst(succNodesLocal);
        succNodes.addAll(succNodesLocal);
        m_nodesWithFrameworkSetup.addAll(succNodes);
        resultSet.traceResultSet("Before return from checkDestLoc with #succNodes=" + succNodes.size() + ";#failNodes=" + failNodes.size() + ";#nodes=" + nodeArray.length);
        return succNodes.size() == nodeArray.length;
    }

    private static void reportCheckDestLocFailureOnLocalNode(String localNode, ResultSet resultSet, Collection<String> failNodes, Collection<String> succNodes, String[] nodeList, String errorStack, String destLoc, boolean report) {
        Trace.out((String)("The exectask is found to be incompatiable on local node: " + localNode));
        for (String node : nodeList) {
            failNodes.add(node);
        }
        succNodes.clear();
        resultSet.addResult(nodeList, 2);
        String errMsg = s_gMsgBundle.getMessage("1901", true, (Object[])new String[]{destLoc, localNode});
        if (VerificationUtil.isStringGood(errorStack)) {
            errMsg = errMsg + LSEP + errorStack;
        }
        if (report) {
            ReportUtil.printError(errMsg + LSEP + s_msgBundle.getMessage("0007", false));
        }
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        resultSet.addErrorDescription(errDesc);
    }

    private static Vector<String> reportCheckDestLocFailureOnRemoteNodes(Vector<String> allNodes, Collection<String> failNodes, ResultSet resultSet, ClusterException ce, String subDirPath, boolean isDirExistFailure, boolean isCopyDirFailed, boolean report) {
        Vector<String> failedNodes = null;
        if (!isCopyDirFailed) {
            Vector<String> dirExistNodes = new Vector<String>();
            Vector<String> dirNotExistNodes = new Vector<String>();
            VerificationUtil.dirExists(allNodes, subDirPath, dirExistNodes, dirNotExistNodes);
            failedNodes = isDirExistFailure ? dirExistNodes : dirNotExistNodes;
        } else {
            ResultSet rs = new ResultSet();
            failedNodes = new Vector<String>();
            VerificationUtil.checkRemExecFileList(allNodes, failedNodes, rs);
        }
        VerificationUtil.traceAndLogError("dest loc setup operation failed with error " + ce.getMessage() + LSEP + Trace.getStackTrace((Throwable)ce) + "on nodes " + VerificationUtil.strList2List(failedNodes));
        failNodes.addAll(failedNodes);
        resultSet.addResult(failedNodes, 2);
        String errMsg = s_gMsgBundle.getMessage("1900", true, (Object[])new String[]{subDirPath, VerificationUtil.strList2List(failedNodes)}) + LSEP + ce.getMessage() + LSEP;
        if (report) {
            ReportUtil.printError(errMsg + s_msgBundle.getMessage("0007", false) + LSEP);
        }
        ErrorDescription errDesc = new ErrorDescription(errMsg + s_gMsgBundle.getMessage("1902", false));
        resultSet.addErrorDescription(failedNodes, errDesc);
        return failedNodes;
    }

    private static void checkRemExecFileList(Collection<String> succNodes, Collection<String> failNodes, ResultSet resultSet) {
        String[] remExecFiles;
        HashSet<String> failedNodeSet = new HashSet<String>();
        String[] nodeArr = succNodes.toArray(new String[0]);
        ArrayList<String> remExecFileList = new ArrayList<String>();
        for (String remExecFile : remExecFiles = VerificationUtil.getCmdFiles4RemExec()) {
            remExecFileList.add(VerificationUtil.getDestLoc() + VerificationUtil.getCVUSubDir() + FSEP + new File(remExecFile).getName());
        }
        ResultSet fileInfoResultSet = new ResultSet();
        boolean fileInfoResult = new GlobalExecution().getFileInfo(nodeArr, remExecFileList, fileInfoResultSet);
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        if (!fileInfoResult) {
            fileInfoResultSet.addResult(nodeArr, 2);
            ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
            fileInfoResultSet.addErrorDescription(nodeArr, errDesc);
            failNodes.addAll(succNodes);
            resultSet.addResult(failNodes, 2);
        } else {
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            for (String node1 : nodeArr) {
                Result result = (Result)fileInforResultTable.get(node1);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                nodeFileInfo.put(node1, nodeFileList);
            }
            for (String file : remExecFileList) {
                Hashtable<String, List<String>> failedNodes = VerificationUtil.checkFileAttributes(nodeArr, file, nodeFileInfo, null, null, null, resultSet);
                failedNodeSet.addAll(failedNodes.keySet());
                if (failedNodes.keySet().size() <= 0) continue;
                Trace.out((String)("file " + file + " missing on " + failedNodes.keySet()));
            }
            failNodes.addAll(failedNodeSet);
        }
    }

    public static void setLocalNodeFirst(List<String> nodeList) {
        if (nodeList.contains(m_localHostName)) {
            nodeList.remove(m_localHostName);
            nodeList.add(0, m_localHostName);
        }
    }

    public static Hashtable<String, FileInfo> getFileAttributes(String file, String[] nodeList, ResultSet resultSet) {
        Hashtable<String, Hashtable<String, FileInfo>> fileAttrTable = VerificationUtil.getFileAttributes(nodeList, file, resultSet);
        Hashtable<String, FileInfo> nodeFileInfoTable = new Hashtable<String, FileInfo>();
        for (String node : fileAttrTable.keySet()) {
            if (fileAttrTable.get(node).containsKey(file)) {
                nodeFileInfoTable.put(node, fileAttrTable.get(node).get(file));
                continue;
            }
            Trace.out((String)("The result table does not have file information for file (" + file + ") on node (" + node + ")"));
        }
        return nodeFileInfoTable;
    }

    public static Hashtable<String, Hashtable<String, FileInfo>> getFileAttributes(String[] validNodeArr, String file, ResultSet resultSet) {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(file);
        return VerificationUtil.getFileAttributes(validNodeArr, fileList, null, null, null, resultSet);
    }

    public static Hashtable<String, Hashtable<String, FileInfo>> getFileAttributes(String[] validNodeArr, List<String> fileList, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        if (fileList.size() > 0) {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet fileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(validNodeArr, fileList, fileInfoResultSet);
            resultSet.uploadResultSet(fileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                resultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                return null;
            }
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            for (String node : validNodeArr) {
                Result result = (Result)fileInforResultTable.get(node);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                nodeFileInfo.put(node, nodeFileList);
            }
        }
        return nodeFileInfo;
    }

    public static Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String file, Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        return VerificationUtil.checkFileAttributes(validNodeArr, file, null, nodeFileInfoTable, refOwner, refGroup, refPermissions, resultSet);
    }

    public static Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String file, String fileDescription, Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        Hashtable<String, FileInfo> nodeFileList;
        Enumeration e;
        FileInfo nodeFileInfo;
        Hashtable<String, List<String>> failedNodes = new Hashtable<String, List<String>>();
        Hashtable<String, ArrayList<String>> consistOwner = new Hashtable<String, ArrayList<String>>();
        Hashtable<String, ArrayList<String>> consistGroup = new Hashtable<String, ArrayList<String>>();
        Hashtable<String, ArrayList<String>> consistPerms = new Hashtable<String, ArrayList<String>>();
        List<Object> nodeErrors = null;
        ArrayList<CollectionElement> fileCollectionElementList = new ArrayList<CollectionElement>();
        ArrayList<CollectionElement> ownerCollectionElementList = new ArrayList<CollectionElement>();
        ArrayList<CollectionElement> groupCollectionElementList = new ArrayList<CollectionElement>();
        ArrayList<CollectionElement> permissionsCollectionElementList = new ArrayList<CollectionElement>();
        for (String node : validNodeArr) {
            nodeErrors = new ArrayList<String>();
            Hashtable<String, FileInfo> nodeFileList2 = nodeFileInfoTable.get(node);
            CollectionElement fileCollectionElement = new CollectionElement(file, null, null, null, fileDescription, 1);
            CollectionElement ownerCollectionElement = new CollectionElement(ReportUtil.OWNER, null, null, null, ReportUtil.OWNER, 1);
            CollectionElement groupCollectionElement = new CollectionElement(ReportUtil.GROUP, null, null, null, ReportUtil.GROUP, 1);
            CollectionElement permissionsCollectionElement = new CollectionElement(ReportUtil.PERMISSION, null, null, null, ReportUtil.PERMISSION, 1);
            fileCollectionElement.addChild(ownerCollectionElement);
            fileCollectionElement.addChild(groupCollectionElement);
            fileCollectionElement.addChild(permissionsCollectionElement);
            resultSet.addCollectionElement(node, fileCollectionElement);
            fileCollectionElementList.add(fileCollectionElement);
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                ownerCollectionElementList.add(ownerCollectionElement);
                groupCollectionElementList.add(groupCollectionElement);
                permissionsCollectionElementList.add(permissionsCollectionElement);
            }
            String referenceValue = null;
            if (refOwner != null) {
                referenceValue = "Owner=" + refOwner;
                ownerCollectionElement.setExpectedValue(refOwner);
            }
            if (refGroup != null) {
                referenceValue = referenceValue != null ? referenceValue + "; Group=" + refGroup : "Group=" + refGroup;
                groupCollectionElement.setExpectedValue(refGroup);
            }
            if (refPermissions != null) {
                referenceValue = referenceValue != null ? referenceValue + "; Permissions=" + refPermissions : "Permissions=" + refPermissions;
                permissionsCollectionElement.setExpectedValue(refPermissions);
            }
            fileCollectionElement.setExpectedValue(referenceValue);
            if (nodeFileList2 != null && nodeFileList2.size() > 0) {
                ErrorDescription error;
                String errorMessage;
                boolean nodeFailed = false;
                nodeFileInfo = nodeFileList2.get(file);
                if ("1".equals(nodeFileInfo.getStatus())) {
                    resultSet.addResult(node, 3);
                    ErrorDescription error2 = new ErrorDescription(nodeFileInfo.getErrorString());
                    resultSet.addErrorDescription(node, error2);
                    nodeErrors.add(nodeFileInfo.getErrorString());
                    failedNodes.put(node, nodeErrors);
                    nodeFailed = true;
                    fileCollectionElement.setStatus(3);
                    fileCollectionElement.addErrorDescription(error2);
                    ownerCollectionElement.setStatus(3);
                    ownerCollectionElement.addErrorDescription(error2);
                    groupCollectionElement.setStatus(3);
                    groupCollectionElement.addErrorDescription(error2);
                    permissionsCollectionElement.setStatus(3);
                    permissionsCollectionElement.addErrorDescription(error2);
                    continue;
                }
                String nodeValue = "Owner=" + nodeFileInfo.getFileOwner() + "; Group=" + nodeFileInfo.getFileGroup() + "; Permissions=" + nodeFileInfo.getFilePermissions();
                fileCollectionElement.setValue(nodeValue);
                ownerCollectionElement.setValue(nodeFileInfo.getFileOwner() == null ? "N/A" : nodeFileInfo.getFileOwner());
                groupCollectionElement.setValue(nodeFileInfo.getFileGroup() == null ? "N/A" : nodeFileInfo.getFileGroup());
                permissionsCollectionElement.setValue(nodeFileInfo.getFilePermissions() == null ? "N/A" : nodeFileInfo.getFilePermissions());
                Trace.out((String)("Checking file: " + nodeFileInfo.getFileName() + "\n Owner: " + nodeFileInfo.getFileOwner() + "\n Group: " + nodeFileInfo.getFileGroup() + "\n Perms: " + nodeFileInfo.getFilePermissions() + "\n"));
                if (refOwner != null && refOwner.length() > 0) {
                    if (!nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                        resultSet.addResult(node, 3);
                        errorMessage = s_gMsgBundle.getMessage("2031", true, (Object[])new String[]{nodeFileInfo.getFileName(), node, refOwner, nodeFileInfo.getFileOwner()});
                        error = new ErrorDescription(errorMessage);
                        resultSet.addErrorDescription(node, error);
                        nodeErrors.add(errorMessage);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error);
                        ownerCollectionElement.setStatus(3);
                        ownerCollectionElement.addErrorDescription(error);
                        nodeFailed = true;
                    }
                } else {
                    ArrayList<String> ownerNodes = null;
                    if (nodeFileInfo.getFileOwner() != null) {
                        ownerNodes = (ArrayList<String>)consistOwner.get(nodeFileInfo.getFileOwner());
                        if (ownerNodes == null) {
                            ownerNodes = new ArrayList<String>();
                        }
                        ownerNodes.add(node);
                        consistOwner.put(nodeFileInfo.getFileOwner(), ownerNodes);
                    }
                }
                if (refGroup != null && refGroup.length() > 0) {
                    if (!nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                        resultSet.addResult(node, 3);
                        errorMessage = s_gMsgBundle.getMessage("2032", true, (Object[])new String[]{nodeFileInfo.getFileName(), node, refGroup, nodeFileInfo.getFileGroup()});
                        error = new ErrorDescription(errorMessage);
                        resultSet.addErrorDescription(node, error);
                        nodeErrors.add(errorMessage);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error);
                        groupCollectionElement.setStatus(3);
                        groupCollectionElement.addErrorDescription(error);
                        nodeFailed = true;
                    }
                } else {
                    ArrayList<String> groupNodes = null;
                    if (nodeFileInfo.getFileGroup() != null) {
                        groupNodes = (ArrayList<String>)consistGroup.get(nodeFileInfo.getFileGroup());
                        if (groupNodes == null) {
                            groupNodes = new ArrayList<String>();
                        }
                        groupNodes.add(node);
                        consistGroup.put(nodeFileInfo.getFileGroup(), groupNodes);
                    }
                }
                if (refPermissions != null && refPermissions.length() > 0) {
                    if (!nodeFileInfo.getFilePermissions().equalsIgnoreCase(refPermissions)) {
                        resultSet.addResult(node, 3);
                        errorMessage = s_gMsgBundle.getMessage("2033", true, (Object[])new String[]{nodeFileInfo.getFileName(), node, refPermissions, nodeFileInfo.getFilePermissions()});
                        error = new ErrorDescription(errorMessage);
                        resultSet.addErrorDescription(node, error);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error);
                        permissionsCollectionElement.setStatus(3);
                        permissionsCollectionElement.addErrorDescription(error);
                        nodeErrors.add(errorMessage);
                        nodeFailed = true;
                    }
                } else {
                    ArrayList<String> permNodes = null;
                    if (nodeFileInfo.getFilePermissions() != null) {
                        permNodes = (ArrayList<String>)consistPerms.get(nodeFileInfo.getFilePermissions());
                        if (permNodes == null) {
                            permNodes = new ArrayList<String>();
                        }
                        permNodes.add(node);
                        consistPerms.put(nodeFileInfo.getFilePermissions(), permNodes);
                    }
                }
                if (!nodeFailed) continue;
                failedNodes.put(node, nodeErrors);
                continue;
            }
            String error = s_msgBundle.getMessage("4160", false);
            nodeErrors.add(error);
            failedNodes.put(node, nodeErrors);
        }
        if ((refOwner == null || refOwner != null && refOwner.length() == 0) && consistOwner.keySet().size() > 1) {
            e = consistOwner.keys();
            while (e.hasMoreElements()) {
                String owner = (String)e.nextElement();
                List ownerNodes = (List)consistOwner.get(owner);
                for (String ownNode : ownerNodes) {
                    nodeFileList = nodeFileInfoTable.get(ownNode);
                    if (nodeFileList == null || "1".equals((nodeFileInfo = nodeFileList.get(file)).getStatus())) continue;
                    resultSet.addResult(ownNode, 3);
                    String errorMessage = s_gMsgBundle.getMessage("2027", true, (Object[])new String[]{nodeFileInfo.getFileName(), owner, ownNode});
                    ErrorDescription error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    for (CollectionElement element : ownerCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    nodeErrors = failedNodes.get(ownNode);
                    if (nodeErrors == null) {
                        nodeErrors = new ArrayList();
                    }
                    nodeErrors.add(errorMessage);
                    failedNodes.put(ownNode, nodeErrors);
                }
            }
        }
        if ((refGroup == null || refGroup != null && refGroup.length() == 0) && consistGroup.keySet().size() > 1) {
            e = consistGroup.keys();
            while (e.hasMoreElements()) {
                String group = (String)e.nextElement();
                List grpNodes = (List)consistGroup.get(group);
                for (String grpNode : grpNodes) {
                    nodeFileList = nodeFileInfoTable.get(grpNode);
                    if (nodeFileList == null || "1".equals((nodeFileInfo = nodeFileList.get(file)).getStatus())) continue;
                    resultSet.addResult(grpNode, 3);
                    String errorMessage = s_gMsgBundle.getMessage("2028", true, (Object[])new String[]{nodeFileInfo.getFileName(), group});
                    ErrorDescription error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    for (CollectionElement element : groupCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    nodeErrors = failedNodes.get(grpNode);
                    if (nodeErrors == null) {
                        nodeErrors = new ArrayList();
                    }
                    nodeErrors.add(errorMessage);
                    failedNodes.put(grpNode, nodeErrors);
                }
            }
        }
        if ((refPermissions == null || refPermissions != null && refPermissions.length() == 0) && consistPerms.keySet().size() > 1) {
            e = consistPerms.keys();
            while (e.hasMoreElements()) {
                String perm = (String)e.nextElement();
                List permNodes = (List)consistPerms.get(perm);
                for (String permNode : permNodes) {
                    nodeFileList = nodeFileInfoTable.get(permNode);
                    if (nodeFileList == null || "1".equals((nodeFileInfo = nodeFileList.get(file)).getStatus())) continue;
                    resultSet.addResult(permNode, 3);
                    String errorMessage = s_gMsgBundle.getMessage("2029", true, (Object[])new String[]{nodeFileInfo.getFileName(), perm});
                    ErrorDescription error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    for (CollectionElement element : permissionsCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    nodeErrors = failedNodes.get(permNode);
                    if (nodeErrors == null) {
                        nodeErrors = new ArrayList();
                    }
                    nodeErrors.add(errorMessage);
                    failedNodes.put(permNode, nodeErrors);
                }
            }
        }
        return failedNodes;
    }

    private static void checkGetExectaskVerResults(ResultSet resultSet, ResultSet verResultSet, Collection<String> succNodes, Collection<String> failNodes, Collection<String> incompatibleNodes, boolean report) {
        Hashtable t = verResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                String exectaskVersion = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Exectask version on node '" + node + "' is '" + exectaskVersion + '\"'));
                if (VerificationUtil.compatibleExectask(exectaskVersion)) {
                    Trace.out((String)("Compatible exectask found on node: " + node));
                    succNodes.add(node);
                    continue;
                }
                Trace.out((String)("Incompatible exectask found on node: " + node));
                incompatibleNodes.add(node);
                continue;
            }
            failNodes.add(node);
            resultSet.addResult(node, 2);
            List<VerificationError> errors = result.getErrors();
            if (errors != null) {
                for (VerificationError error : errors) {
                    resultSet.addErrorDescription(node, (ErrorDescription)error);
                }
            }
            Trace.out((String)("Exectask version couldn't be fetched from node: " + node));
            if (report) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("7559", false, (Object[])new String[]{node}));
                if (errors != null) {
                    for (VerificationError error : errors) {
                        ReportUtil.printError(error.getErrorMessage());
                    }
                }
            }
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7559", false, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
        }
    }

    public static void checkPathWriteableCreateable(String[] nodeList, String path, ResultSet resultSet, boolean quietMode) {
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Trace.out((String)("path[" + path + "]"));
        String[] succNodeList = null;
        String[] failNodeList = null;
        VerificationUtil.pathExists(nodeList, path, 1, succNodes, failNodes);
        failNodeList = failNodes.toArray(new String[0]);
        succNodeList = succNodes.toArray(new String[0]);
        if (succNodes.size() > 0) {
            succNodes.clear();
            failNodes.clear();
            VerificationUtil.pathExists(succNodeList, path, 4, succNodes, failNodes);
            resultSet.addResult(succNodes, 1);
            for (String node : failNodes) {
                String errMsg = s_gMsgBundle.getMessage("11931", true, (Object[])new String[]{path, node});
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                resultSet.addErrorDescription(node, errorDesc);
                resultSet.addResult(node, 3);
                VerificationLogData.log(errMsg);
                if (quietMode) continue;
                ReportUtil.sureprintln(errMsg);
            }
        }
        if (failNodeList.length > 0) {
            if (path.lastIndexOf(FSEP) == -1) {
                return;
            }
            String parent = path.substring(0, path.lastIndexOf(FSEP));
            while (failNodeList.length > 0) {
                succNodes.clear();
                failNodes.clear();
                Trace.out((String)("Checking path: '" + parent + "'"));
                VerificationUtil.pathExists(failNodeList, parent, 1, succNodes, failNodes);
                succNodeList = succNodes.toArray(new String[0]);
                failNodeList = failNodes.toArray(new String[0]);
                if (succNodes.size() > 0) {
                    succNodes.clear();
                    failNodes.clear();
                    VerificationUtil.pathExists(succNodeList, parent, 4, succNodes, failNodes);
                    resultSet.addResult(succNodes, 1);
                    for (String node : failNodes) {
                        String errMsg = s_gMsgBundle.getMessage("11932", true, (Object[])new String[]{path, node});
                        ErrorDescription errorDesc = new ErrorDescription(errMsg);
                        resultSet.addErrorDescription(node, errorDesc);
                        resultSet.addResult(node, 3);
                        VerificationLogData.log(errMsg);
                        if (quietMode) continue;
                        ReportUtil.sureprintln(errMsg);
                    }
                }
                if (parent.lastIndexOf(FSEP) == -1 || parent.length() == parent.lastIndexOf(FSEP) + 1) break;
                parent = parent.substring(0, parent.lastIndexOf(FSEP));
                Trace.out((String)("Checking parent: '" + parent + "'     " + parent.length()));
                if (parent.length() <= 0 || parent.charAt(parent.length() - 1) != ':' || !VerificationUtil.getCurrentOS().toLowerCase().startsWith("windows") || parent.length() != 2) continue;
                parent = new String(parent + FSEP);
                Trace.out((String)("Added '" + FSEP + "' to: '" + parent + "'"));
            }
            return;
        }
    }

    public static String[] getUserEquivalentNodes(String[] nodeList, ResultSet resultSet) {
        HashSet<String> nodesWithUserEquiv = new HashSet<String>();
        Collection<String> nodesToCheckUserEquiv = VerificationUtil.getFrameworkSetupNotCheckedNodes(nodeList, nodesWithUserEquiv, resultSet);
        if (nodesToCheckUserEquiv.isEmpty()) {
            return nodeList;
        }
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        String[] reachableNodeArr = VerificationUtil.getReachableNodes(nodesToCheckUserEquiv.toArray(new String[0]), resultSet, true);
        if (reachableNodeArr != null && reachableNodeArr.length > 0) {
            VerificationUtil.isUserEquivalence(reachableNodeArr, succNodeVect, failNodeVect);
            nodesWithUserEquiv.addAll(succNodeVect);
            if (nodesWithUserEquiv.isEmpty()) {
                ReportUtil.printError(s_msgBundle.getMessage("4008", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                if (resultSet != null) {
                    resultSet.addResult(reachableNodeArr, 2);
                    ErrorDescription errDesc = new ErrorDescription("4008", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    for (String node : reachableNodeArr) {
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("4098", true, (Object[])new String[]{node}), s_msgBundle, "4098");
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                String noEquivMsg = s_msgBundle.getMessage("4009", true);
                String limitedVerMsg = s_msgBundle.getMessage("0008", false);
                String[] failNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
                String[] succNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
                ReportUtil.printWarning(noEquivMsg);
                ReportUtil.sureprintNodelist(failNodeVect);
                ReportUtil.sureprintln(limitedVerMsg);
                ReportUtil.sureprintNodelist(succNodeVect);
                if (resultSet == null) {
                    ReportUtil.reportFormatPrintln(noEquivMsg + VerificationUtil.strArr2List(failNodeArr, ", "));
                    ReportUtil.reportFormatPrintln(limitedVerMsg + VerificationUtil.strArr2List(succNodeArr, ", "));
                }
                if (resultSet != null && failNodeArr != null && failNodeArr.length != 0) {
                    resultSet.addResult(failNodeArr, 2);
                    for (String node : failNodeArr) {
                        String nodeNoEquivMsg = noEquivMsg + " " + node;
                        ErrorDescription errDesc = new ErrorDescription(nodeNoEquivMsg + LSEP + limitedVerMsg + VerificationUtil.strArr2List(succNodeArr, ", "));
                        resultSet.addErrorDescription(node, errDesc);
                        Trace.out((String)("User Equivalence OK for nodes: '" + VerificationUtil.strArr2List(succNodeArr, ", ") + "'\nError Message: '" + errDesc.getErrorMessage()));
                    }
                }
            }
        }
        if (resultSet != null) {
            resultSet.addResult(nodesWithUserEquiv, 1);
        }
        return nodesWithUserEquiv.toArray(new String[0]);
    }

    public static String[] getUserEquivalentNodes(String[] nodeList) {
        ResultSet resultSet = new ResultSet();
        return VerificationUtil.getUserEquivalentNodes(nodeList, resultSet);
    }

    public static boolean isUserEquivalence(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        succNodeVect.clear();
        failNodeVect.clear();
        ResultSet resultSet = new ResultSet();
        Collection<String> nodesToCheckUserEquiv = VerificationUtil.getFrameworkSetupNotCheckedNodes(nodeList, succNodeVect, resultSet);
        if (nodesToCheckUserEquiv.isEmpty()) {
            return true;
        }
        ResultSet userEquivResultSet = new ResultSet();
        new GlobalExecution().checkUserEquiv(nodesToCheckUserEquiv.toArray(new String[0]), userEquivResultSet);
        Trace.out((String)"VerificationUtil:: checkUserEquiv() performed!!");
        Hashtable t = userEquivResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                succNodeVect.add(node);
                Trace.out((String)("User Equivalence exists on on node: " + node));
                continue;
            }
            failNodeVect.add(node);
            Trace.out((String)("User Equivalence couldn't be performed on node: " + node));
        }
        return failNodeVect.size() == 0;
    }

    public static boolean isUserEquivalenceOnNode(String node, boolean displayErr) {
        boolean nodeReachable = false;
        HashMap<String, String> failedNode = new HashMap<String, String>();
        HashMap<String, String> succNode = new HashMap<String, String>();
        try {
            nodeReachable = VerificationUtil.areNodesReachable(new String[]{node}, succNode, failedNode);
        }
        catch (NetworkException e) {
            if (displayErr) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "4097", false, new String[]{node}, new String[]{e.getMessage()}, new String[]{node});
            }
            return false;
        }
        if (!nodeReachable) {
            if (displayErr) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "4097", false, new String[]{node}, null, new String[]{node});
            }
            return false;
        }
        if (!VerificationUtil.isUserEquivalence(new String[]{node}, new Vector<String>(), new Vector<String>())) {
            if (displayErr) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "4098", false, new String[]{node}, null, new String[]{node});
            }
            return false;
        }
        return true;
    }

    public static boolean areNodesReachable(String[] nodeList, HashMap<String, String> succNodes, HashMap<String, String> failedNodes) throws NetworkException {
        succNodes.clear();
        failedNodes.clear();
        boolean[] nodeConArray = new boolean[nodeList.length];
        String[] nodeErrorArray = new String[nodeList.length];
        try {
            new VerifyNetwork().checkReachFromLocalNode(nodeList, nodeConArray, nodeErrorArray);
        }
        catch (NetworkException e) {
            Trace.out((String)("NetworkException " + e));
            throw e;
        }
        Trace.out((String)"VerificationUtil::   checkReachFromSrcNode() performed!!");
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            if (nodeConArray[i]) {
                succNodes.put(node, "");
                Trace.out((String)("Node '" + node + "' is reachable"));
                continue;
            }
            failedNodes.put(node, nodeErrorArray[i]);
            Trace.out((String)("Node '" + node + "' is not reachable"));
        }
        return failedNodes.size() == 0;
    }

    public static String[] getReachableNodes(String[] nodeList, ResultSet resultSet) {
        return VerificationUtil.getReachableNodes(nodeList, resultSet, true);
    }

    public static String[] getReachableNodes(String[] nodeList, ResultSet resultSet, boolean bShowErr) {
        HashSet<String> reachableNodes = new HashSet<String>();
        Collection<String> nodesToCheckReachability = VerificationUtil.getFrameworkSetupNotCheckedNodes(nodeList, reachableNodes, resultSet);
        if (nodesToCheckReachability.isEmpty()) {
            return reachableNodes.toArray(new String[0]);
        }
        HashMap<String, String> succNodes = new HashMap<String, String>();
        HashMap<String, String> failedNodes = new HashMap<String, String>();
        try {
            VerificationUtil.areNodesReachable(nodesToCheckReachability.toArray(new String[0]), succNodes, failedNodes);
            reachableNodes.addAll(succNodes.keySet());
        }
        catch (NetworkException e) {
            Trace.out((String)("NETWORKEXCEPTION: " + e.getMessage()));
            String displayError = e.getMessage();
            if (bShowErr) {
                ReportUtil.printError(displayError + LSEP + s_msgBundle.getMessage("0007", false));
                ReportUtil.reportFormatPrintln(displayError + LSEP + s_msgBundle.getMessage("0007", false));
            }
            if (resultSet != null) {
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4095", false, (Object[])new String[]{VerificationUtil.strArr2String(nodeList)}) + LSEP + e.getMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(nodeList, 2);
            }
            return null;
        }
        if (reachableNodes.isEmpty()) {
            if (succNodes.size() == 0) {
                String displayError = "";
                if (bShowErr) {
                    ReportUtil.printError(displayError + LSEP + s_msgBundle.getMessage("0007", false));
                    ReportUtil.reportFormatPrintln(displayError + LSEP + s_msgBundle.getMessage("0007", false));
                }
                if (resultSet != null) {
                    ErrorDescription errDesc = new ErrorDescription("4095", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    resultSet.addResult(nodeList, 2);
                    if (failedNodes.size() > 0) {
                        Set<String> nodes = failedNodes.keySet();
                        for (String node : nodes) {
                            errDesc = new ErrorDescription(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}) + LSEP + failedNodes.get(node));
                            resultSet.addErrorDescription(node, errDesc);
                            Trace.out((String)("Adding error: " + errDesc.getErrorMessage()));
                        }
                    }
                }
                return null;
            }
        } else if (failedNodes.size() != 0 && bShowErr) {
            String limitedVerMsg = s_msgBundle.getMessage("0008", false);
            String notReachable = s_msgBundle.getMessage("4096", true);
            ReportUtil.sureprintln(VerificationUtil.strCollection2String(failedNodes.keySet(), ", "));
            ReportUtil.sureprintln(limitedVerMsg);
            ReportUtil.sureprintNodelist(reachableNodes);
            if (failedNodes.size() > 0) {
                for (String node : failedNodes.keySet()) {
                    String notReachableMsg = notReachable + " " + node;
                    Trace.out((String)("notReachableMsg: '" + notReachableMsg + "'"));
                    notReachableMsg = notReachableMsg + LSEP + failedNodes.get(node);
                    Trace.out((String)("node failure msg: '" + failedNodes.get(node) + "'"));
                    ErrorDescription errDesc = new ErrorDescription(notReachableMsg + LSEP + limitedVerMsg + VerificationUtil.strCollection2String(reachableNodes, ", "));
                    if (resultSet != null) {
                        resultSet.addErrorDescription(node, errDesc);
                        resultSet.addResult(node, 2);
                        Trace.out((String)("Failed node: '" + node + "'\nError Message: '" + errDesc.getErrorMessage()));
                        continue;
                    }
                    Trace.out((String)("NO RESULT SET FOR MESSAGE!!: Failed node: '" + node + "'\nError Message: '" + errDesc.getErrorMessage()));
                }
            }
        }
        if (resultSet != null) {
            resultSet.addResult(reachableNodes, 1);
        }
        return reachableNodes.toArray(new String[0]);
    }

    public static String[] getReachableNodes(String[] nodeList) {
        return VerificationUtil.getReachableNodes(nodeList, null);
    }

    public static boolean isNodeReachable(String node) {
        Trace.out((String)("==== Checking rechability of node: " + node));
        String[] nodelist = new String[]{node};
        String[] noderslt = VerificationUtil.getReachableNodes(nodelist, null, false);
        return null != noderslt && noderslt.length != 0;
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList, ResultSet resultSet) {
        return VerificationUtil.getNodesWithCRSInstall(nodeList, resultSet, false);
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList, ResultSet resultSet, boolean mute) {
        String[] validNodeArr = nodeList;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        Trace.out((String)("nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        VerificationLogData.logFine(LSEP + "nodeList='" + VerificationUtil.strArr2List(nodeList) + "'");
        boolean crsInstallOnAll = VerificationUtil.isCRSInstalled(nodeList, succNodeVect, failNodeVect, resultSet, mute);
        if (!crsInstallOnAll) {
            if (succNodeVect.size() == 0) {
                if (!mute) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                if (!mute) {
                    ReportUtil.printWarning(s_msgBundle.getMessage("4038", true));
                    ReportUtil.sureprintNodelist(failNodeVect);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(succNodeVect);
                }
                String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        return validNodeArr;
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList) {
        return VerificationUtil.getReachableNodes(nodeList, null);
    }

    public static String[] diffStringArr(String[] masterArr, String[] subArr) {
        Vector<String> resultVect = new Vector<String>();
        for (int i = 0; i < masterArr.length; ++i) {
            boolean toInclude = true;
            for (int j = 0; j < subArr.length; ++j) {
                if (!subArr[j].equals(masterArr[i])) continue;
                toInclude = false;
                break;
            }
            if (!toInclude) continue;
            resultVect.add(masterArr[i]);
        }
        return resultVect.toArray(new String[resultVect.size()]);
    }

    public static String getDaemonDisplayName(String daemonTag) {
        String daemonDispName;
        if (daemonTag.equalsIgnoreCase("crsd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("crsd");
            if (daemonDispName == null) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "9006", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
        } else if (daemonTag.equalsIgnoreCase("ocssd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("ocssd");
            if (daemonDispName == null) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "9007", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
        } else if (daemonTag.equalsIgnoreCase("evmd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("evmd");
            if (daemonDispName == null) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "9008", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
        } else {
            daemonDispName = daemonTag;
        }
        return daemonDispName;
    }

    public static String getDaemonInternalName(String daemonTag) {
        String daemonIntlName;
        if (daemonTag.equalsIgnoreCase("crsd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("crsd");
            if (daemonIntlName == null) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "9009", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
        } else if (daemonTag.equalsIgnoreCase("ocssd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("ocssd");
            if (daemonIntlName == null) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "9010", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
        } else if (daemonTag.equalsIgnoreCase("evmd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("evmd");
            if (daemonIntlName == null) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "9011", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
        } else {
            daemonIntlName = daemonTag;
        }
        return daemonIntlName;
    }

    public static MessageBundle getMessageBundle(String facility) {
        return MessageBundle.getMessageBundle((String)facility);
    }

    public static String getEnv(String envVar) {
        String value = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        NativeResult nativeRes = nativeSys.getEnvironment(envVar);
        value = nativeRes != null && nativeRes.getStatus() ? nativeRes.getStringResult() : null;
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("==== getEnv reports: " + envVar + "=" + value));
        }
        return value;
    }

    public static String getEnv(String nodeName, String envVar) {
        if (VerificationUtil.isLocalNode(nodeName)) {
            return VerificationUtil.getEnv(envVar);
        }
        String value = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet envResultSet = new ResultSet();
        boolean res = globalExec.getSysParam(new String[]{nodeName}, envVar, envResultSet);
        Hashtable hostsTable = new Hashtable();
        Hashtable ht = envResultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                value = (String)result.getResultInfoSet().elementAt(0);
                Trace.out((String)("Retrieved value of an Environment Variable " + envVar + " from node: " + node + " The Value is :" + value));
                continue;
            }
            Trace.out((String)("Failed to retrieved value of an Environment Variable " + envVar + " from node: " + node));
        }
        return value;
    }

    public static String getUniqueDistributionID() {
        String udid = null;
        try {
            udid = VerificationUtil.getUniqueDistributionIDWithException();
        }
        catch (VerificationException ve) {
            Trace.out((String)("Caught VerificationException with error " + ve.getMessage()));
            udid = "unknown";
        }
        return udid;
    }

    public static String getUniqueDistributionIDWithException() throws VerificationException {
        Result result = new Result(VerificationUtil.getLocalNode());
        String udid = VerificationUtil.getUniqueDistributionID(result);
        if (result.getStatus() != 1) {
            throw new VerificationException(VerificationUtil.errorCollection2String(result.getErrors()));
        }
        return udid;
    }

    public static String getUniqueDistributionID(Result result) {
        if (!VerificationUtil.isStringGood(m_distributionID)) {
            sVerificationUtil sUtil = new sVerificationUtil();
            String udid = sVerificationUtil.getUniqueDistributionID(result);
            if (!VerificationUtil.isStringGood(udid)) {
                udid = VerificationUtil.getConfiguredValue(ASSUME_DISTID, true);
                if (VerificationUtil.isStringGood(udid)) {
                    Trace.out((String)("Using distribution ID from cvu_config file: " + udid));
                    result.setStatus(1);
                } else {
                    Trace.out((String)"Value not configured for CV_ASSUME_DISTID");
                }
            }
            m_distributionID = udid;
        } else {
            result.setStatus(1);
        }
        return m_distributionID;
    }

    public static String getUniqueDistributionID(VerificationType verType, String xmlFile) throws XmlParserException {
        String udid = null;
        try {
            udid = VerificationUtil.getUniqueDistributionIDWithException();
        }
        catch (VerificationException ve) {
            throw new XmlParserException(ve.getMessage());
        }
        XmlParser xmlParser = new XmlParser(new File(xmlFile));
        xmlParser.parse(verType);
        CDMHost cdmHost = xmlParser.getCDMData();
        if (cdmHost == null) {
            Trace.out((String)"ERROR: Invalid root element");
            String msg = s_msgBundle.getMessage("1108", false);
            throw new XmlParserException(msg);
        }
        Vector<CDMCertifiedSystems> csList = cdmHost.getCDMCertifiedSystems();
        if (csList.size() != 1) {
            Object[] msgParams = new String[]{Integer.toString(csList.size())};
            String msg = s_msgBundle.getMessage("1099", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        return udid;
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name") + System.getProperty("os.version");
    }

    public static boolean compareByOperator(RangeOperator operator, long refValue, long value, boolean considerRelaxationFactor) {
        Trace.out((String)("The operator is (" + (Object)((Object)operator) + ") reference value (" + refValue + ") and value to compare is (" + value + ") consider relaxation factor is (" + considerRelaxationFactor + ")"));
        int relaxationFactor = 0;
        if (considerRelaxationFactor) {
            String defaultRelaxationFactorStr = VDMUtil.getDefaultRelaxationFactor();
            if (VerificationUtil.isStringGood(defaultRelaxationFactorStr)) {
                relaxationFactor = Integer.parseInt(defaultRelaxationFactorStr);
            }
            Trace.out((String)("The relaxation factor is " + relaxationFactor));
        }
        switch (operator) {
            case GE: {
                if (value >= refValue) {
                    return true;
                }
                if (relaxationFactor != 0 && refValue != 0L) {
                    double difference = refValue - value;
                    Trace.out((String)("The difference is " + difference));
                    double relax = refValue * (long)relaxationFactor / 100L;
                    Trace.out((String)("Allowed to relax " + relax + " based on the relaxation factor."));
                    if (relax >= difference) {
                        return true;
                    }
                }
                return false;
            }
            case LE: {
                if (value <= refValue) {
                    return true;
                }
                if (relaxationFactor != 0 && refValue != 0L) {
                    double difference = value - refValue;
                    Trace.out((String)("The difference is " + difference));
                    double relax = refValue * (long)relaxationFactor / 100L;
                    Trace.out((String)("Allowed to relax " + relax + " based on the relaxation factor."));
                    if (difference <= relax) {
                        return true;
                    }
                }
                return false;
            }
            case GT: {
                if (value > refValue) {
                    return true;
                }
                if (relaxationFactor != 0 && refValue != 0L) {
                    double difference = refValue - value;
                    Trace.out((String)("The difference is " + difference));
                    double relax = refValue * (long)relaxationFactor / 100L;
                    Trace.out((String)("Allowed to relax " + relax + " based on the relaxation factor."));
                    if (relax >= difference) {
                        return true;
                    }
                }
                return false;
            }
            case LT: {
                if (value < refValue) {
                    return true;
                }
                if (relaxationFactor != 0 && refValue != 0L) {
                    double difference = value - refValue;
                    Trace.out((String)("The difference is " + difference));
                    double relax = refValue * (long)relaxationFactor / 100L;
                    Trace.out((String)("Allowed to relax " + relax + " based on the relaxation factor."));
                    if (difference <= relax) {
                        return true;
                    }
                }
                return false;
            }
            case EQ: {
                if (refValue == value) {
                    return true;
                }
                if (relaxationFactor != 0 && refValue != 0L) {
                    double difference = value > refValue ? value - refValue : refValue - value;
                    Trace.out((String)("The difference is " + difference));
                    double relax = refValue * (long)relaxationFactor / 100L;
                    Trace.out((String)("Allowed to relax " + relax + " based on the relaxation factor."));
                    if (difference <= relax) {
                        return true;
                    }
                }
                return false;
            }
            case NE: {
                return refValue != value;
            }
        }
        Trace.out((String)"Incorrect operator, returning false");
        return false;
    }

    public static int compareVersions(String str1, String str2, String dlm) {
        VersionComparator versionComparator = new VersionComparator(dlm);
        return versionComparator.compare(str1, str2);
    }

    public static boolean compareStringCollections(String[] setToCompare, String[] sourceSet, boolean checkSameSize, boolean ignoreCase) {
        if (setToCompare != null && sourceSet != null) {
            return VerificationUtil.compareStringCollections(Arrays.asList(setToCompare), Arrays.asList(sourceSet), checkSameSize, ignoreCase);
        }
        return false;
    }

    public static boolean compareStringCollections(Collection<String> setToCompare, Collection<String> sourceSet, boolean checkSameSize, boolean ignoreCase) {
        if (checkSameSize && setToCompare.size() != sourceSet.size()) {
            return false;
        }
        if (setToCompare == null || sourceSet == null) {
            return false;
        }
        for (String s1 : setToCompare) {
            s1 = s1.trim();
            boolean found = false;
            for (String s2 : sourceSet) {
                if (!s1.equals(s2 = s2.trim()) && (!ignoreCase || !s1.equalsIgnoreCase(s2))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return found;
        }
        return true;
    }

    public static String getConfiguredValue(String var, boolean bFBToEnv) {
        ConfigUtil cu = ConfigUtil.getInstance();
        return cu.getConfiguredValue(var, bFBToEnv);
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        String destLoc = VerificationUtil.getDestLoc();
        if (!new File(destLoc).isAbsolute()) {
            throw new InvalidEnvironmentException(s_msgBundle.getMessage("9018", false, (Object[])new String[]{destLoc}));
        }
        VerificationUtil.setRDBMSVersion("12.2.0.1.0");
        Trace.out((String)("RDBMS Version is -->" + VerificationUtil.getRDBMSVersion()));
        sVerificationUtil.getExecutionEnvironment();
    }

    public static boolean compatibleExectask(String exectaskVersion) {
        Trace.out((String)("Comparing framework version '" + VerificationUtil.getFrameworkVersion() + "' with exectask version '" + exectaskVersion + "'"));
        return VerificationUtil.getFrameworkVersion().equals(exectaskVersion);
    }

    public static String getFrameworkVersion() {
        return VerificationUtil.getRDBMSVersion() + "." + "03_03_17_nt";
    }

    public static String getRDBMSVersion() {
        return s_RDBMSVersion;
    }

    public static void setRDBMSVersion(String rdbmsVer) {
        s_RDBMSVersion = rdbmsVer;
    }

    public static String getRequestedRelease() {
        String reqRel = null;
        reqRel = CVUVariables.getValue(CVUVariableConstants.RELEASE);
        if ("10gR1".equals(reqRel)) {
            reqRel = "10.1";
        } else if ("10gR2".equals(reqRel)) {
            reqRel = "10.2";
        } else if ("11gR1".equals(reqRel)) {
            reqRel = "11.1";
        } else if ("11gR2".equals(reqRel)) {
            reqRel = "11.2";
        }
        Trace.out((String)("==== Requested release is: " + reqRel));
        return reqRel;
    }

    public static String getSIHAReleaseVersion() {
        return VerificationUtil.getSIHAReleaseVersion(false);
    }

    public static String getSIHAReleaseVersionWithException() throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException, ConfigurationException, HAHomeNotFoundException {
        Version version = VerificationUtil.getSIHAReleaseVersionObjWithException();
        return version != null ? version.toString4() : null;
    }

    public static String getSIHAReleaseVersion(boolean ignoreException) {
        Version version = VerificationUtil.getSIHAReleaseVersionObj(ignoreException);
        return version != null ? version.toString4() : null;
    }

    public static Version getSIHAReleaseVersionObj() {
        return VerificationUtil.getSIHAReleaseVersionObj(false);
    }

    public static Version getSIHAReleaseVersionObj(String sihaHome, boolean ignoreException) {
        try {
            return VerificationUtil.getSIHAReleaseVersionObjWithException(sihaHome);
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nche));
            }
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nsee));
            }
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)cie));
            }
            return null;
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)ce));
            }
            return null;
        }
    }

    public static Version getSIHAReleaseVersionObj(boolean ignoreException) {
        try {
            return VerificationUtil.getSIHAReleaseVersionObjWithException();
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nche));
            }
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nsee));
            }
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)cie));
            }
            return null;
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)ce));
            }
            return null;
        }
        catch (HAHomeNotFoundException hae) {
            Trace.out((String)("HAHomeNotFoundException Exception: \n" + hae.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException(hae);
            }
            return null;
        }
    }

    public static Version getSIHAReleaseVersionObjWithException() throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException, ConfigurationException, HAHomeNotFoundException {
        String haHome;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((haHome = VerificationUtil.getHAHomeWithException()) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: HA home undefined.");
            }
            return null;
        }
        return VerificationUtil.getSIHAReleaseVersionObjWithException(haHome);
    }

    public static Version getSIHAReleaseVersionObjWithException(String haHome) throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException, ConfigurationException {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        String actVersion = null;
        Version activeVersion = null;
        ClusterInfo cluInfo = new ClusterInfo(haHome);
        actVersion = cluInfo.getSIHAReleaseVersionString();
        if (actVersion == null) {
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("HA version string obtained: '" + actVersion + "' "));
        }
        activeVersion = VerificationUtil.getVersionObject(actVersion);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for HA on the local node is: " + activeVersion.toString()));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return activeVersion;
    }

    public static String getCRSActiveVersion() {
        Trace.out((String)"Executing getCRSActiveVersion()");
        return VerificationUtil.getCRSActiveVersion(false);
    }

    public static String getCRSActiveVersion(boolean ignoreException) {
        Trace.out((String)("Executing getCRSActiveVersion(ignoreException=" + ignoreException + ")"));
        String activeVerStr = null;
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null || crsHome.trim().length() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        try {
            activeVerStr = VerificationUtil.getCRSActiveVersionWithException();
            if (activeVerStr == null) {
                return null;
            }
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nche));
            }
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nsee));
            }
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)cie));
            }
            return null;
        }
        return activeVerStr;
    }

    public static String getCRSActiveVersionWithException() throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        Trace.out((String)"Executing getCRSActiveVersionWithException()");
        String activeVerStr = null;
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null || crsHome.trim().length() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        ClusterInfo cluInfo = new ClusterInfo(crsHome);
        try {
            String releaseVersion;
            activeVerStr = cluInfo.getCRSActiveVersionString();
            if (activeVerStr == null && (releaseVersion = VerificationUtil.getCRSReleaseVersion(VerificationUtil.getLocalNode())) != null) {
                activeVerStr = releaseVersion;
            }
        }
        catch (ClusterInfoException cie) {
            String releaseVersion = VerificationUtil.getCRSReleaseVersion(VerificationUtil.getLocalNode());
            if (releaseVersion != null) {
                activeVerStr = releaseVersion;
            }
            throw cie;
        }
        return activeVerStr;
    }

    public static Version getCRSActiveVersionObj() {
        Trace.out((String)"Executing getCRSActiveVersionObj()");
        return VerificationUtil.getCRSActiveVersionObj(false);
    }

    public static Version getCRSActiveVersionObj(boolean ignoreException) {
        Trace.out((String)("Executing getCRSActiveVersionObj(ignoreException=" + ignoreException + ")"));
        Version activeVersion = null;
        String activeVerStr = null;
        activeVerStr = VerificationUtil.getCRSActiveVersion(ignoreException);
        if (activeVerStr == null) {
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS version string obtained: '" + activeVerStr + "' "));
        }
        try {
            activeVersion = VerificationUtil.getVersionObject(activeVerStr);
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)ce));
            }
            VerificationLogData.addGlobalErrorOnce("Prvg", "6020", true, new String[]{VerificationUtil.getLocalNode()}, null, new String[]{VerificationUtil.getLocalNode()});
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for CRS on the local node is: " + String.valueOf(activeVersion)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return activeVersion;
    }

    public static Version getVersionObject(String versionStr) throws ConfigurationException {
        Version version;
        block13: {
            version = new Version();
            String verStr = version.toString4();
            if (VerificationUtil.isVersionPost(versionStr, verStr)) {
                Trace.out((String)("Returning the maximum supported version " + verStr + " as the specified version " + versionStr + " " + "is found to be more recent than what we can instantiate"));
                return version;
            }
            version = null;
            try {
                version = Version.getVersion((String)versionStr);
            }
            catch (ConfigurationException e) {
                if (versionStr != null) break block13;
                throw e;
            }
        }
        if (version == null) {
            if (versionStr.startsWith("10.1")) {
                version = Version.get101Version();
            } else if (versionStr.startsWith("10.2")) {
                version = Version.get102Version();
            } else if (versionStr.startsWith("11.1")) {
                version = Version.get111Version();
            } else if (versionStr.startsWith("11.2")) {
                version = Version.get11201Version();
            } else if (versionStr.startsWith("12.1")) {
                version = Version.get12100Version();
            }
        }
        return version;
    }

    public static String getCRSSoftwareVersion(String hostname) {
        Trace.out((String)("Executing getCRSSoftwareVersion(hostname=" + hostname + ")"));
        Object softVersion = null;
        String node = VerificationUtil.getNodeName(hostname);
        String crsHome = VerificationUtil.getCRSHome();
        return VerificationUtil.getCRSSoftwareVersion(crsHome, node);
    }

    public static String getCRSSoftwareVersion(String crsHome, String hostname) {
        Trace.out((String)("Executing getCRSSoftwareVersion(crsHome=" + crsHome + ", hostname=" + hostname + ")"));
        String softVersion = null;
        if (crsHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("crsHome=" + crsHome));
        }
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            softVersion = cluInfo.getCRSSoftwareVersionString(hostname);
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe software version for CRS on node '" + hostname + "' is: " + softVersion));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return softVersion;
    }

    public static String getCRSReleaseVersion(String crsHome, boolean reportException) {
        Trace.out((String)("Executing getCRSReleaseVersion(crsHome=" + crsHome + ", reportException=" + reportException + ")"));
        String version = null;
        String localNode = VerificationUtil.getLocalNode();
        version = VerificationUtil.getCRSReleaseVersion(crsHome, localNode);
        return version;
    }

    public static String getCRSReleaseVersion(String hostname) {
        Trace.out((String)("Executing getCRSReleaseVersion(hostname=" + hostname + ")"));
        Result rslt = new Result(hostname);
        String crsHome = VerificationUtil.getCRSHome(hostname, rslt);
        if (crsHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        return VerificationUtil.getCRSReleaseVersion(crsHome, hostname);
    }

    public static String getCRSReleaseVersion(String crsHome, String hostname) {
        return VerificationUtil.getCRSReleaseVersion(crsHome, hostname, true);
    }

    public static String getCRSReleaseVersion(String crsHome, String hostname, boolean useChache) {
        String version = null;
        String key = crsHome + "@" + hostname;
        if (useChache && (version = s_releaseVersionMap.get(key)) != null) {
            Trace.out((String)("Returning version: " + version + " from cache. key used is " + key));
            return version;
        }
        Result crsctlRslt = new Result(hostname);
        version = VerificationUtil.getCRSReleaseVersionUsingCRSCTL(crsHome, hostname, crsctlRslt);
        Trace.out((int)5, (String)"release version using crsctl=%s", (Object[])new Object[]{version});
        if (VerificationUtil.isStringGood(version)) {
            s_releaseVersionMap.put(key, version);
            VerificationLogData.logInfo("CRSReleaseVersion: " + version);
            return version;
        }
        Result ocrDumpRslt = new Result(hostname);
        version = VerificationUtil.getCRSReleaseVersionUsingOCRDump(crsHome, hostname, ocrDumpRslt);
        Trace.out((int)5, (String)"release version using ocrdump=%s", (Object[])new Object[]{version});
        if (VerificationUtil.isStringGood(version)) {
            s_releaseVersionMap.put(key, version);
            VerificationLogData.logInfo("CRSReleaseVersion: " + version);
            return version;
        }
        Result srvctlRslt = new Result(hostname);
        version = VerificationUtil.getCRSReleaseVersionUsingSRVCTL(crsHome, hostname, srvctlRslt);
        Trace.out((int)5, (String)"release version using srvctl=%s", (Object[])new Object[]{version});
        if (!VerificationUtil.isStringGood(version)) {
            String activeCRSVersion = null;
            try {
                activeCRSVersion = new ClusterInfo(crsHome).getCRSActiveVersionString();
            }
            catch (NoSuchCRSHomeException e) {
                Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
            catch (NoSuchExecutableException e) {
                Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
            catch (ClusterInfoException e) {
                Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
            if (activeCRSVersion != null && VerificationUtil.isVersionPre(activeCRSVersion, "10.2") && VerificationUtil.isVersionPost(activeCRSVersion, "10")) {
                version = Version.get101Version().toString();
                Trace.out((int)5, (String)"active version is %s, defaulting release version to %s", (Object[])new Object[]{activeCRSVersion, version});
            }
        }
        s_releaseVersionMap.put(key, version);
        VerificationLogData.logInfo("CRSReleaseVersion: " + version);
        return version;
    }

    public static String getCRSReleaseVersionUsingCRSCTL(String crsHome, String hostname, Result rslt) {
        Trace.out((String)("Executing getCRSReleaseVersionUsingCRSCTL(crsHome=" + crsHome + ", hostname=" + hostname + ")"));
        String releaseVersion = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String cmd = crsHome + File.separator + "bin" + File.separator + nativeSystem.getExeName(CRSCTL_CMD);
        String[] cmdArg = new String[3];
        String RELEASE_VERSION = "releaseversion";
        cmdArg[0] = "query";
        cmdArg[1] = "crs";
        cmdArg[2] = "releaseversion";
        NativeResult result = new NativeResult();
        if (nativeSystem.isRemoteExecServerNeeded()) {
            try {
                NativeResult serverResult = new NativeResult();
                String localNode = VerificationUtil.getLocalNode();
                if (!nativeSystem.isRemExecServiceRunning(localNode, serverResult)) {
                    Trace.out((String)"starting remote exec service as it was not running");
                    nativeSystem.startRemoteExecServer(crsHome, crsHome);
                }
            }
            catch (NativeException e) {
                Trace.out((String)"nativeSystem.startRemoteExecServer failed");
                rslt.addErrorDescription(new ErrorDescription(e.getMessage()));
                rslt.setStatus(2);
                return null;
            }
        }
        nativeSystem.runRemoteExecCmd(cmd, cmdArg, new String[]{"NLS_LANG="}, hostname, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null && res.length > 0) {
                String output = VerificationUtil.strArr2List(res, "").trim();
                releaseVersion = output;
                if (releaseVersion.indexOf("]") >= 0) {
                    StringTokenizer st = new StringTokenizer(output, "[", false);
                    st.nextToken();
                    releaseVersion = st.hasMoreTokens() ? st.nextToken() : null;
                    int index = releaseVersion.indexOf("]");
                    if (index != -1) {
                        releaseVersion = releaseVersion.substring(0, index);
                        rslt.setStatus(1);
                    } else {
                        rslt.setStatus(2);
                        releaseVersion = null;
                    }
                } else if (releaseVersion.indexOf("releaseversion") > 0) {
                    releaseVersion = null;
                }
                if (releaseVersion != null) {
                    Trace.out((String)("validating release version " + releaseVersion));
                    Pattern p = Pattern.compile("[1-9][0-9]\\.[0-9].*");
                    if (!p.matcher(releaseVersion).matches()) {
                        String logMsg = "release version [" + releaseVersion + "] is garbage. returning null";
                        Trace.out((String)logMsg);
                        VerificationLogData.log(logMsg);
                        rslt.setStatus(2);
                        return null;
                    }
                }
                Trace.out((String)("Release version = " + releaseVersion));
            } else {
                rslt.setStatus(2);
                Trace.out((String)"runCmd failed to return successful status");
            }
        } else {
            rslt.setStatus(2);
            Trace.out((String)"runCmd failed to return successful status");
        }
        return releaseVersion;
    }

    public static String getCRSReleaseVersionUsingSRVCTL(String crsHome, String hostname, Result result) {
        Version version;
        Trace.out((String)("Executing getCRSReleaseVersionUsingSRVCTL(crsHome=" + crsHome + ", hostname=" + hostname + ")"));
        ArrayList<VerificationError> errors = new ArrayList<VerificationError>();
        int status = 5;
        try {
            version = new ClusterwareInfo().getSRVCTLVersion(hostname, crsHome);
            if (version != null) {
                result.setStatus(1);
                return version.toString();
            }
        }
        catch (InstallException e) {
            Trace.out((int)5, (String)"Exception  %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
            VerificationLogData.logError(((Object)((Object)e)).getClass() + ": " + e.getMessage() + LSEP + Trace.getStackTrace((Throwable)e));
            errors.add(new ErrorDescription(e.getMessage()));
            status = 2;
        }
        try {
            version = new ClusterwareInfo().getSRVCTLVersionNLS(hostname, crsHome);
            if (version != null) {
                result.setStatus(1);
                return version.toString();
            }
        }
        catch (InstallException e) {
            Trace.out((int)5, (String)"Exception  %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
            VerificationLogData.logError(((Object)((Object)e)).getClass() + ": " + e.getMessage() + LSEP + Trace.getStackTrace((Throwable)e));
            errors.add(new ErrorDescription(e.getMessage()));
            status = 2;
        }
        result.setStatus(status);
        result.addErrorDescription(errors);
        return null;
    }

    public static String getCRSReleaseVersionUsingOCRDump(String crsHome, String node, Result result) {
        Matcher m;
        Pattern p;
        String[] lineByLine;
        Trace.out((String)("Executing getCRSReleaseVersionUsingOCRDump(crsHome=" + crsHome + ", node=" + node + ")"));
        String nodeNumber = null;
        String releaseVersion = null;
        try {
            nodeNumber = new ClusterInfo(crsHome).getNodeNumber(node);
            Trace.out((int)5, (String)"Node name=%s, node number retrieved from olsnodes=%s", (Object[])new Object[]{node, nodeNumber});
        }
        catch (NoSuchCRSHomeException e) {
            Trace.out((int)5, (String)e.getMessage());
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
            return null;
        }
        catch (NoSuchExecutableException e) {
            Trace.out((int)5, (String)e.getMessage());
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
            return null;
        }
        catch (ClusterInfoException e) {
            Trace.out((int)5, (String)e.getMessage());
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
            return null;
        }
        String nodeVersionKey = "SYSTEM.version.node_numbers.node" + nodeNumber;
        StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, nodeVersionKey, result);
        if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
            p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
            for (String outputLine : lineByLine) {
                m = p.matcher(outputLine);
                if (!m.matches()) continue;
                releaseVersion = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(releaseVersion) && (ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, nodeVersionKey = "SYSTEM.version.hostnames." + node, result)) != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
            p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
            for (String outputLine : lineByLine) {
                m = p.matcher(outputLine);
                if (!m.matches()) continue;
                releaseVersion = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(releaseVersion)) {
            Trace.out((String)"Failed to retrieve the CRS version using OCRDUMP");
            result.setStatus(3);
            return null;
        }
        Trace.out((int)5, (String)("The CRS release version retrieved using OCR dump is " + releaseVersion));
        result.setStatus(1);
        return releaseVersion;
    }

    public static Version getCRSSoftwareVersionObj() {
        String crsHome;
        Trace.out((String)"Executing getCRSSoftwareVersionObj()");
        Version softVersion = null;
        String softVerStr = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((crsHome = VerificationUtil.getCRSHome()) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            softVerStr = cluInfo.getCRSSoftwareVersionString();
            if (softVerStr == null) {
                return null;
            }
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS version string obtained: '" + softVerStr + "' "));
        }
        try {
            softVersion = VerificationUtil.getVersionObject(softVerStr);
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for CRS on the local node is: " + String.valueOf(softVersion)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return softVersion;
    }

    public static void setLocalNodeOperation(boolean isLocalNodeOper) {
        m_isLocalNodeOper = isLocalNodeOper;
        m_isLocalNodeOperationChecked = true;
        m_isLocal = isLocalNodeOper;
    }

    public static boolean isLocalNodeOperation() {
        return VerificationUtil.isLocalNodeOperation(false);
    }

    public static boolean isLocalNodeOperation(boolean forceRecheck) {
        String[] nodelist;
        boolean localNode;
        block21: {
            if (m_isLocalNodeOperationChecked &= !forceRecheck) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Returning saved value of: " + m_isLocal));
                }
                return m_isLocal;
            }
            ParamManager pm = null;
            localNode = false;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((Exception)e);
                return false;
            }
            if (VerificationUtil.isAPIMode()) {
                return m_isLocalNodeOper;
            }
            m_isLocalNodeOperationChecked = true;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"nodelistArg not NULL");
            }
            try {
                nodelist = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException nlnfe) {
                nodelist = new String[]{};
            }
            if (nodelist.length == 1) {
                String localhost = null;
                try {
                    localhost = VerificationUtil.getLocalHostName();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing localhost '" + localhost + "' with nodelist[0] '" + nodelist[0] + "'\n"));
                    }
                    if (nodelist[0].equalsIgnoreCase(localhost) || VerificationUtil.sameHost(nodelist[0], localhost)) {
                        localNode = true;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Nodelist equal to localhost: " + localhost));
                        }
                    } else {
                        ClusterInfo cInfo;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)"Nodelist not equal to localhost");
                        }
                        if (localhost.equalsIgnoreCase((cInfo = new ClusterInfo(VerificationUtil.getCRSHome())).getHostName(nodelist[0]))) {
                            localNode = true;
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)"localhost equal to cluster info host name.");
                            }
                        }
                    }
                }
                catch (ClusterInfoException cie) {
                    if (!Trace.isLevelEnabled((int)5)) break block21;
                    Trace.out((String)"ClusterInfoException caught");
                }
            }
        }
        String referenceNode = CVUVariables.getValue(CVUVariableConstants.REFERENCE_NODE);
        String sourceNodeNode = CVUVariables.getValue(CVUVariableConstants.SOURCE_NODE);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nnodelist is: '" + VerificationUtil.strArr2List(nodelist) + "'" + "\nreferenceNodeArg is: '" + referenceNode + "'" + "\nsourceNodeArg is: '" + sourceNodeNode + "'" + "\nlocalNode is: '" + localNode + "'"));
        }
        boolean bl = m_isLocal = localNode && referenceNode == null && sourceNodeNode == null;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("m_isLocal is: '" + m_isLocal + "'"));
        }
        return m_isLocal;
    }

    public static boolean isLocalNode(String node) {
        boolean localNodeResult;
        block14: {
            int dotIdx;
            if (m_isLocalNodeResultStore.containsKey(node)) {
                return m_isLocalNodeResultStore.get(node);
            }
            String nodeName = null;
            String localHost = null;
            String localNode = null;
            localNodeResult = false;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            nodeName = (dotIdx = node.indexOf(".")) != -1 ? node.substring(0, dotIdx) : node;
            localHost = VerificationUtil.getLocalHostName();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nComparing '" + nodeName + "' to localHOST '" + localHost + "'"));
            }
            if (nodeName.equalsIgnoreCase(localHost)) {
                if (Trace.isLevelEnabled((int)2)) {
                    Trace.out((String)"EXIT - returning: true");
                }
                localNodeResult = true;
                m_isLocalNodeResultStore.put(node, localNodeResult);
                return localNodeResult;
            }
            if (VerificationUtil.sameHost(nodeName, localHost)) {
                localNodeResult = true;
                m_isLocalNodeResultStore.put(node, localNodeResult);
                return localNodeResult;
            }
            if (VerificationUtil.isCRSConfigured()) {
                try {
                    localNode = VerificationUtil.getLocalNodename();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing '" + nodeName + "' to localNODE '" + localNode + "'"));
                    }
                    if (nodeName.equalsIgnoreCase(localNode)) {
                        if (Trace.isLevelEnabled((int)2)) {
                            Trace.out((String)"EXIT - returning: true");
                        }
                        localNodeResult = true;
                        m_isLocalNodeResultStore.put(node, localNodeResult);
                        return localNodeResult;
                    }
                }
                catch (NodelistNotFoundException nlnfe) {
                    if (!Trace.isLevelEnabled((int)5)) break block14;
                    Trace.out((String)"NodelistNotFoundException caught");
                }
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Returning: false");
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        localNodeResult = false;
        m_isLocalNodeResultStore.put(node, localNodeResult);
        return localNodeResult;
    }

    public static boolean sameHost(String host1, String host2) {
        InetAddress[] inetArr1 = null;
        InetAddress[] inetArr2 = null;
        try {
            inetArr1 = InetAddress.getAllByName(host1);
            inetArr2 = InetAddress.getAllByName(host2);
        }
        catch (UnknownHostException e) {
            return false;
        }
        for (int i = 0; i < inetArr1.length; ++i) {
            for (int j = 0; j < inetArr2.length; ++j) {
                if (!inetArr1[i].getHostAddress().equals(inetArr2[j].getHostAddress())) continue;
                return true;
            }
        }
        Trace.out((String)("VerificationUtil::sameHost() Host:" + host1 + " and Host: " + host2 + " are not same."));
        return false;
    }

    public static String getPreReqXmlPath(VerificationType vfyType) throws XmlFilePathException {
        String reqRel = VerificationUtil.getRequestedRelease();
        if ("10gR1".equalsIgnoreCase(reqRel)) {
            reqRel = "10.1";
        } else if ("10gR2".equalsIgnoreCase(reqRel)) {
            reqRel = "10.2";
        } else if ("11gR1".equalsIgnoreCase(reqRel)) {
            reqRel = "11.1";
        } else if ("11gR2".equalsIgnoreCase(reqRel)) {
            reqRel = "11.2";
        }
        if (reqRel == null) {
            reqRel = "12.2";
        }
        return VerificationUtil.getPreReqXmlPath(vfyType, reqRel);
    }

    public static String getPreReqXmlPath(VerificationType vfyType, String reqRel) throws XmlFilePathException {
        File filePath;
        String xmlFilePath = s_preReqXmlRepos.get((Object)vfyType);
        if (xmlFilePath == null) {
            xmlFilePath = s_genericPreReqXmlFile;
            if (xmlFilePath == null) {
                xmlFilePath = sVerificationUtil.getPreReqXmlPath();
            }
            String xmlDirPath = null;
            if (xmlFilePath == null) {
                xmlDirPath = VerificationUtil.getPreReqDirPath(reqRel);
                xmlFilePath = CVUAutoUpdateManager.getCVUFileLocation(xmlDirPath + VerificationUtil.getPreReqXmlFileName(vfyType));
            }
        }
        if (!(filePath = new File(xmlFilePath)).exists()) {
            throw new XmlFilePathException(s_gMsgBundle.getMessage("7500", true, (Object[])new String[]{xmlFilePath}));
        }
        Trace.out((String)("Pre-req xml file is: '" + xmlFilePath + "'"));
        return xmlFilePath;
    }

    public static String getPreReqDirPath(String release) {
        int secondDot;
        int firstDot;
        String xmlDirPath = null;
        if (release == null) {
            release = "12.2";
        }
        if ((firstDot = release.indexOf(46)) != -1 && (secondDot = release.indexOf(46, firstDot + 1)) != -1) {
            release = release.substring(0, secondDot);
        }
        String releaseDir = release.replace(".", "");
        xmlDirPath = "cv" + FILE_SEPARATOR + "cvdata" + FILE_SEPARATOR + releaseDir + FILE_SEPARATOR;
        return xmlDirPath;
    }

    public static String getPreReqXmlFileName(VerificationType vfyType) {
        String preReqXmlFileName = null;
        switch (vfyType) {
            case PREREQ_CRS_INST: 
            case PREREQ_NODE_ADD: 
            case SYSREQ_CRS: 
            case PREREQ_APPLICATION_CLUSTER_INST: 
            case PREREQ_GENERIC_INST: {
                preReqXmlFileName = CV_CRS_PREREQ_XML;
                break;
            }
            case PREREQ_SI_DB_INST: 
            case PREREQ_DB_INST: 
            case PREREQ_DB_CONFIG: 
            case PREREQ_SI_DB_CONFIG: 
            case SYSREQ_DB: 
            case SYSREQ_SI_DB: {
                preReqXmlFileName = CV_DB_PREREQ_XML;
                break;
            }
            case PREREQ_SI_HA_INST: 
            case PREREQ_SI_HA_CONFIG: 
            case SYSREQ_SI_HA: {
                preReqXmlFileName = CV_HA_PREREQ_XML;
            }
        }
        return preReqXmlFileName;
    }

    public static String getPreReqXmlSchemaURI(String release) throws XmlFilePathException {
        String fsep = File.separator;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "prereq.xsd")).toURI().toString();
        Trace.out((String)("==== Pre-req schema file: " + fullpath));
        return fullpath;
    }

    public static String getVariablesXmlSchemaURI() throws XmlFilePathException {
        String fsep = File.separator;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "variables.xsd")).toURI().toString();
        Trace.out((String)("==== XML variables schema file: " + fullpath));
        return fullpath;
    }

    public static String getVariablesXmlURI() throws XmlFilePathException {
        String fsep = File.separator;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "variables.xml")).toURI().toString();
        Trace.out((String)("====  XML variables file: " + fullpath));
        return fullpath;
    }

    public static String getResponseVarsXmlSchemaURI() throws XmlFilePathException {
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "cvdata" + FSEP + "responsevars.xsd")).toURI().toString();
        Trace.out((int)1, (String)("==== XML responsevars schema file: " + fullpath));
        return fullpath;
    }

    public static String getResponseVarsXmlURI() throws XmlFilePathException {
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + FSEP + "cvdata" + FSEP + "responsevars.xml")).toURI().toString();
        Trace.out((int)1, (String)("====  XML responsevars file: " + fullpath));
        return fullpath;
    }

    public static String getTaskFactoryXmlSchemaURI() throws XmlFilePathException {
        String fsep = File.separator;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "taskfactory.xsd")).toURI().toString();
        Trace.out((String)("==== Task factory schema file: " + fullpath));
        return fullpath;
    }

    public static String getTaskPlacementXmlURI() throws XmlFilePathException {
        String fsep = FILE_SEPARATOR;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "taskplacement.xml")).toURI().toString();
        Trace.out((String)("==== Task placement xml file: " + fullpath));
        return fullpath;
    }

    public static String getTaskDefinitionXmlURI() throws XmlFilePathException {
        String fsep = FILE_SEPARATOR;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "taskdefinition.xml")).toURI().toString();
        Trace.out((String)("==== Task definition xml file: " + fullpath));
        return fullpath;
    }

    public static String getPluggableTaskDarwinXmlURI() throws XmlFilePathException {
        String fsep = FILE_SEPARATOR;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "darwin_pluggable.xml")).toURI().toString();
        Trace.out((String)("==== Pluggable task schema file: " + fullpath));
        return fullpath;
    }

    public static boolean isPreReqSupported() throws VerificationException {
        String prereqFile = s_genericPreReqXmlFile;
        return VerificationUtil.isPreReqSupported(prereqFile);
    }

    public static boolean isPreReqSupported(VerificationType vfyType) throws VerificationException {
        try {
            String prereqFile = VerificationUtil.getPreReqXmlPath(vfyType);
            return VerificationUtil.isPreReqSupported(prereqFile);
        }
        catch (XmlFilePathException e) {
            throw new VerificationException(e);
        }
    }

    private static boolean isPreReqSupported(String prereqFile) throws VerificationException, PreReqNotSupportedException {
        try {
            XmlTaskFactory xmlTaskFactory = XmlTaskFactory.getInstance();
            String uniqueID = VerificationUtil.getUniqueDistributionID();
            xmlTaskFactory.getTasks(prereqFile, uniqueID, new String[]{VerificationUtil.getLocalNode()});
            return true;
        }
        catch (XmlParserException e) {
            throw new VerificationException(e);
        }
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        return VerificationUtil.getCompSoftwareConfigXmlPath("12.2");
    }

    public static String getCompSoftwareConfigXmlPath(String release) throws XmlFilePathException {
        if (release == null) {
            release = "12.2";
        }
        String releaseDir = release.replace(".", "");
        String fullpath = CVUAutoUpdateManager.getCVUFileLocation("cv" + FILE_SEPARATOR + "cvdata" + FILE_SEPARATOR + releaseDir + FILE_SEPARATOR + "ora_software_cfg.xml");
        Trace.out((String)("==== Software Config data file: " + fullpath));
        return fullpath;
    }

    public static String getCompSoftwareConfigXmlPath(String home, String release) throws XmlFilePathException {
        return home + "/cv/cvdata/" + "ora_software_cfg.xml";
    }

    public static String getOSVersionCompatXmlPath() throws XmlFilePathException {
        String xmlFilePath = sVerificationUtil.getOSVersionCompatXmlPath();
        return xmlFilePath;
    }

    public static String getVariableValue(String variable) {
        String returnValue = null;
        returnValue = CVUVariables.getValue(variable);
        return returnValue;
    }

    public static void setVariableValue(String varName, String varValue) {
        CVUVariables.setValue(varName, varValue);
        if (PASSWORD_VAR_NAME_PATTERN.matcher(varName).matches()) {
            Trace.out((String)("setting variable: VAR = " + varName + " VALUE = *****"));
            VerificationLogData.logInfo("Variable set by client for CVU: VAR = " + varName + " VALUE = ***");
        } else {
            Trace.out((String)("setting variable: VAR = " + varName + " VALUE = " + varValue));
            VerificationLogData.logInfo("Variable set by client for CVU: VAR = " + varName + " VALUE = " + varValue);
        }
    }

    public static void clearVariableValue(String varName) {
        CVUVariables.clear(varName);
    }

    public static void setVariableForceLookUp(String name, boolean forceVal) {
        CVUVariables.setForceLookUpForVariable(name, forceVal);
    }

    public static void setupTracing(boolean isCLImode) {
        VerificationUtil.setupTracing(isCLImode, CLUVFY);
    }

    public static void setupTracing(boolean isCLImode, int whoIsIt) {
        int tracingLvl;
        String traceFileName;
        String traceProp = System.getProperty("TRACING.ENABLED");
        String traceLvl = System.getProperty("TRACING.LEVEL");
        boolean tracetostdout = false;
        boolean saveTraceState = false;
        if (traceProp != null && traceProp.equalsIgnoreCase("false")) {
            Trace.setSavePreviousLog((boolean)false);
            return;
        }
        if (!isCLImode) {
            return;
        }
        if (null != System.getProperty("TRACING.STDOUT")) {
            tracetostdout = true;
        }
        System.setProperty("TRACING.ENABLED", "true");
        if (!tracetostdout) {
            saveTraceState = Trace.isTraceEnabled();
            Trace.traceEnabled((boolean)false);
        }
        if ((traceFileName = VerificationUtil.getTraceFile(whoIsIt)) == null) {
            Trace.traceEnabled((boolean)false);
            return;
        }
        boolean bSavePreviousLog = VerificationUtil.isCVUTestEnv();
        boolean bAppend = !bSavePreviousLog;
        Trace.setSavePreviousLog((boolean)bSavePreviousLog);
        if (traceLvl != null) {
            try {
                tracingLvl = Integer.parseInt(traceLvl);
            }
            catch (NumberFormatException e) {
                tracingLvl = 5;
            }
        } else {
            tracingLvl = 5;
        }
        Trace.enableTracing();
        Trace.setMaxLogOutputSize((int)100);
        Trace.setMaxLogOutputFiles((int)4);
        Trace.setTraceProcessOption((boolean)true);
        Trace.setTraceFilePerm((String)"0666");
        Trace.enableLogging((String)traceFileName, (boolean)bAppend);
        if (!tracetostdout) {
            Trace.traceEnabled((boolean)saveTraceState);
        }
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true, (boolean)bAppend);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }

    public static void adjustTraceSize(int nodeListSize) {
        int sizeMultiplier = nodeListSize / 10 + 1;
        String configSizeMultiplier = VerificationUtil.getConfiguredValue("CV_TRACE_SIZE_MULTIPLIER", false);
        if (VerificationUtil.isStringGood(configSizeMultiplier)) {
            sizeMultiplier = Integer.parseInt(configSizeMultiplier);
        }
        if (sizeMultiplier <= 1) {
            return;
        }
        Trace.out((String)("using " + sizeMultiplier + " as trace multiplier"));
        Trace.adjustTraceSize((int)(100 * sizeMultiplier));
    }

    private static String getTraceFile(int whoIsIt) {
        String errmsg;
        ClusterCmd clusterCmd;
        String traceFileName;
        String logDir;
        String fileSep;
        block21: {
            fileSep = System.getProperty("file.separator");
            logDir = VerificationUtil.getCVHome() + CV + fileSep + LOG;
            traceFileName = null;
            clusterCmd = new ClusterCmd();
            String traceLoc = VerificationUtil.getTraceLoc();
            if (traceLoc != null) {
                logDir = traceLoc;
            } else {
                String orabaseExe = new SystemFactory().CreateSystem().getExeName("orabase");
                String orabasePath = VerificationUtil.getCVHome() + "bin" + fileSep + orabaseExe;
                File oraBase = new File(orabasePath);
                if (oraBase.exists()) {
                    String[] output = null;
                    String[] cmd = new String[]{orabasePath};
                    RuntimeExec rt = new RuntimeExec(cmd, null, null);
                    rt.runCommand();
                    String[] error = rt.getError();
                    output = rt.getOutput();
                    if (rt.getExitValue() == 0 && (error == null || error.length == 0) && output != null && output.length == 1 && VerificationUtil.isStringGood(m_localNode)) {
                        logDir = output[0] + FSEP + "crsdata" + FSEP + m_localNode.toLowerCase() + FSEP + "cvu";
                    }
                }
            }
            errmsg = LSEP + s_msgBundle.getMessage("8503", false) + LSEP + s_msgBundle.getMessage("7728", false, (Object[])new String[]{logDir}) + LSEP;
            try {
                if (clusterCmd.isDirWritable(logDir)) break block21;
                File fLogDir = new File(logDir);
                try {
                    if (!fLogDir.exists()) {
                        try {
                            String[] lclNode = new String[]{VerificationUtil.getLocalHost()};
                            clusterCmd.createDirWithPermissionsOnNodes(lclNode, logDir, "775");
                        }
                        catch (UnknownHostException e) {
                            System.out.println(errmsg);
                            return traceFileName;
                        }
                        catch (ClusterException ce) {
                            System.out.println(errmsg);
                            return traceFileName;
                        }
                    }
                    if (clusterCmd.isDirWritable(logDir)) break block21;
                    String cmdToRun = "chmod 775 " + logDir;
                    try {
                        Runtime rt = Runtime.getRuntime();
                        Process proc = rt.exec(cmdToRun);
                        int n = proc.waitFor();
                    }
                    catch (IOException e) {
                        System.out.println(errmsg);
                        return traceFileName;
                    }
                    catch (InterruptedException e) {
                        System.out.println(errmsg);
                        return traceFileName;
                    }
                }
                catch (SecurityException e) {
                    System.out.println(errmsg);
                    return traceFileName;
                }
                catch (ClusterException ce) {
                    System.out.println(errmsg);
                    return traceFileName;
                }
            }
            catch (ClusterException ce) {
                System.out.println(errmsg);
                return traceFileName;
            }
        }
        try {
            if (!clusterCmd.isDirWritable(logDir)) {
                System.out.println(errmsg);
                return traceFileName;
            }
        }
        catch (ClusterException ce) {
            System.out.println(errmsg);
            return traceFileName;
        }
        if (whoIsIt == CLUVFY) {
            traceFileName = logDir + fileSep + TRACE_CLUVFY_FNAME;
        }
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("Using trace file: '" + traceFileName + "'"));
        }
        return traceFileName;
    }

    public static long sizeInBytes(long size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size * KILO_BYTE;
            }
            case MBYTE: {
                return size * MEGA_BYTE;
            }
            case GBYTE: {
                return size * GIGA_BYTE;
            }
            case TBYTE: {
                return size * TERA_BYTE;
            }
        }
        return -1L;
    }

    public static double sizeInBytes(double size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size * 1024.0;
            }
            case MBYTE: {
                return size * 1024.0 * 1024.0;
            }
            case GBYTE: {
                return size * 1024.0 * 1024.0 * 1024.0;
            }
            case TBYTE: {
                return size * 1024.0 * 1024.0 * 1024.0 * 1024.0;
            }
        }
        return -1.0;
    }

    public static double sizeInSpecificUnit(long size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size / KILO_BYTE;
            }
            case MBYTE: {
                return size / MEGA_BYTE;
            }
            case GBYTE: {
                return size / GIGA_BYTE;
            }
            case TBYTE: {
                return size / TERA_BYTE;
            }
        }
        return -1.0;
    }

    public static String getCompleteMessage(Throwable e) {
        Throwable nextCause;
        StringBuffer sb = new StringBuffer();
        Throwable thrw = e;
        sb.append(e.getMessage());
        while ((nextCause = thrw.getCause()) != null) {
            sb.append(LSEP + nextCause.getMessage());
            thrw = nextCause;
        }
        return sb.toString();
    }

    public static String[] getDefaultDiscoveryDevice(String version) {
        return new sVerificationUtil().getDefaultDiscoveryDevice(version);
    }

    public static boolean containsWildCard(String path) {
        return new sVerificationUtil().containsWildCard(path);
    }

    public static String getFileListCommand() {
        return new sVerificationUtil().getFileListCommand();
    }

    public static List parseFileListOutput(String[] cmdOut) {
        return new sVerificationUtil().parseFileListOutput(cmdOut);
    }

    public static String getOraInventoryGroup() {
        return sVerificationUtil.getOraInventoryGroup();
    }

    public static String getOSAsmGroup(String loc) throws CVUException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            VerificationUtil.getAdmnGrps(loc, true);
            Trace.out((String)("Returning OSASM group: '" + m_osAsmGroup + "'"));
            return m_osAsmGroup;
        }
        Trace.out((String)"Returning 'null'");
        return null;
    }

    public static String getASMAdminGroup() throws CVUException {
        return VerificationUtil.getASMAdminGroup(null);
    }

    public static String getASMAdminGroup(String loc) throws CVUException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            VerificationUtil.getAdmnGrps(loc, false);
            Trace.out((String)("Returning ASMAdmin group: '" + m_asmAdminGroup + "'"));
            return m_asmAdminGroup;
        }
        String crsHomeForASM = VerificationUtil.getCRSHome();
        String asmGroup = null;
        try {
            asmGroup = nativeSystem.getASMAdminGroup(crsHomeForASM);
        }
        catch (NativeException e) {
            Trace.out((String)("ERROR: Problem in getting ASMADMIN group from CRS Home: '" + crsHomeForASM + "'"));
            Trace.out((String)("NATIVEEXCEPTION: \n" + e.getMessage()));
            Trace.stackTrace();
            String errorMsg = s_gMsgBundle.getMessage("10488", true, (Object[])new String[]{crsHomeForASM});
            errorMsg = errorMsg + LSEP + e.getMessage();
            throw new CVUException(errorMsg);
        }
        return asmGroup;
    }

    public static String getOSOPERGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSOPER group: '" + m_osOperGroup + "'"));
        return m_osOperGroup;
    }

    public static String getASMOPERGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, false);
        Trace.out((String)("Returning ASMOPER group: '" + m_asmOperGroup + "'"));
        return m_asmOperGroup;
    }

    public static String getOSDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSDBA group: '" + m_osDbaGroup + "'"));
        return m_osDbaGroup;
    }

    public static String getASMDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, false);
        Trace.out((String)("Returning ASMDBA group: '" + m_asmDbaGroup + "'"));
        return m_asmDbaGroup;
    }

    public static String getOSBACKUPDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSBACKUPDBA group: '" + m_osBackupDBAGroup + "'"));
        return m_osBackupDBAGroup;
    }

    public static String getOSDGDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSDGDBA group: '" + m_osDgDBAGroup + "'"));
        return m_osDgDBAGroup;
    }

    public static String getOSKMDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSKMDBA group: '" + m_osKmDBAGroup + "'"));
        return m_osKmDBAGroup;
    }

    public static String getOSRACDBAGroup(String loc) throws CVUException {
        if (!m_getRACGroups) {
            VerificationUtil.getAdmnGrps(loc, true);
        }
        Trace.out((String)("Returning OSRACDBA group: '" + m_osRACDBAGroup + "'"));
        return m_osRACDBAGroup;
    }

    private static void getAdmnGrps(String loc, boolean dbhome) throws CVUException {
        String osdbagrpPath = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            Trace.out((String)"Not on Unix system, do nothing.");
            return;
        }
        Version sourceHomeVersion = VerificationUtil.getCRSActiveVersionObj();
        if (sourceHomeVersion == null) {
            Trace.out((String)"crsActiveVersion is null, using a new Version object");
            sourceHomeVersion = new Version();
        }
        if (!dbhome) {
            if (m_getAdminGroups) {
                return;
            }
            osdbagrpPath = VerificationUtil.isStringGood(loc) ? loc + File.separator + "bin" : VerificationUtil.getCRSHome() + File.separator + "bin";
            try {
                Trace.out((String)("CRS: Calling OSDBAGRPUtil from: '" + osdbagrpPath + "'"));
                m_adminGroups = new ClusterwareInfo().getAdminGroups(osdbagrpPath, sourceHomeVersion);
                m_asmOperGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSOPER"));
                m_asmAdminGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSASM"));
                m_asmDbaGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSDBA"));
                Trace.out((String)("Setting 'm_asmDbaGroup' to: '" + m_asmDbaGroup + "'\n" + "Setting 'm_asmOperGroup' to: '" + m_asmOperGroup + "'\n" + "Setting 'm_asmAdminGroup' to: '" + m_asmAdminGroup + "'\n"));
                m_getAdminGroups = true;
            }
            catch (InstallException ie) {
                Trace.out((String)("INSTALLEXCEPTION: " + ie.getMessage()));
                String errorMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{ie.getMessage()});
                VerificationLogData.logError("InstallException: " + errorMsg);
                if (!m_groupExceptionReported) {
                    Trace.out((String)"Exception not reported, inform user.");
                    m_groupExceptionReported = true;
                    VerificationLogData.addGlobalErrorOnce("Prvg", "11318", true, new String[]{ie.getMessage()}, null, new String[]{VerificationUtil.getLocalNode()});
                }
                return;
            }
        }
        if (!VerificationUtil.isStringGood(loc) || m_getRACGroups) {
            Trace.out((String)("Either the location '" + loc + "' is not valid, " + "or we already got the RAC groups '" + m_getRACGroups + "'"));
            return;
        }
        osdbagrpPath = loc + File.separator + "bin";
        try {
            Trace.out((String)("RAC/DB: Calling OSDBAGRPUtil from: '" + osdbagrpPath + "'"));
            Trace.out((String)("Trying to obtain db version from db home : " + loc));
            Version dbVersion = new ClusterwareInfo().getSRVCTLVersion(loc);
            Trace.out((String)("Trying to obtain admin groups info using dbVersion : " + dbVersion));
            m_adminGroups = new ClusterwareInfo().getAdminGroups(osdbagrpPath, dbVersion);
            m_osOperGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSOPER"));
            m_osAsmGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSASM"));
            m_osDbaGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSDBA"));
            m_osBackupDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSBACKUP"));
            m_osDgDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSDG"));
            m_osKmDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSKM"));
            m_osRACDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSRAC"));
            Trace.out((String)("Setting 'm_osDbaGroup' to: '" + m_osDbaGroup + "'\n" + "Setting 'm_osOperGroup' to: '" + m_osOperGroup + "'\n" + "Setting 'm_osAsmGroup' to: '" + m_osAsmGroup + "'\n" + "Setting 'm_osBackupDBAGroup' to: '" + m_osBackupDBAGroup + "'\n" + "Setting 'm_osDgDBAGroup' to: '" + m_osDgDBAGroup + "'\n" + "Setting 'm_osKmDBAGroup' to: '" + m_osKmDBAGroup + "'\n" + "Setting 'm_osRACDBAGroup' to: '" + m_osRACDBAGroup + "'"));
            m_getRACGroups = true;
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: " + ie.getMessage()));
            String errorMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{ie.getMessage()});
            VerificationLogData.logError("InstallException: " + errorMsg);
            if (!m_groupExceptionReported) {
                Trace.out((String)"Exception not reported, inform user.");
                m_groupExceptionReported = true;
                VerificationLogData.addGlobalErrorOnce("Prvg", "11318", true, new String[]{ie.getMessage()}, null, new String[]{VerificationUtil.getLocalNode()});
            }
            return;
        }
    }

    private static String removeBrackets(String brcktStr) {
        String noBrcktGrpName;
        if (!VerificationUtil.isStringGood(brcktStr)) {
            return brcktStr;
        }
        int opnBrckt = brcktStr.indexOf("[");
        int clsBrckt = brcktStr.indexOf("]");
        String tmpStr = new String(brcktStr);
        if (brcktStr.contentEquals("[]")) {
            Trace.out((String)("Input string: '" + brcktStr + "' returning <null>"));
            return null;
        }
        if (clsBrckt != -1) {
            tmpStr = noBrcktGrpName = tmpStr.substring(0, clsBrckt);
        }
        if (opnBrckt != -1) {
            tmpStr = noBrcktGrpName = tmpStr.substring(opnBrckt + 1);
        }
        Trace.out((String)("Removed brackets from: '" + brcktStr + "' and returned: '" + tmpStr + "'"));
        return tmpStr;
    }

    public static String getUSMDriverStatePath() {
        return new String(VerificationUtil.getCRSHome() + FSEP + "bin" + FSEP + new sVerificationUtil().getUSMDriverScript());
    }

    public static String getUSMDeviceOwner() {
        return new sVerificationUtil().getUSMDeviceOwner();
    }

    public static String getDefaultUSMDevPerms() {
        return new sVerificationUtil().getDefaultUSMDevPerms();
    }

    public static boolean checkPlatform() {
        String osname = sVerificationUtil.getCurrentOS();
        String osarch = sVerificationUtil.getCurrentArch();
        return sVerificationUtil.checkPlatform(osname, osarch);
    }

    public static String getCurrentOS() {
        return sVerificationUtil.getCurrentOS();
    }

    public static String getCurrentArch() {
        return sVerificationUtil.getCurrentArch();
    }

    public static boolean checkPlatform(String osname, String osarch) {
        Trace.out((String)("Check Platform: osname=" + osname + " ; osarch=" + osarch));
        return sVerificationUtil.checkPlatform(osname, osarch);
    }

    public static boolean checkPlatformOS() {
        Trace.out((String)"Check Platform OS.");
        String osname = sVerificationUtil.getCurrentOS();
        return sVerificationUtil.checkPlatformOS(osname);
    }

    public static boolean checkPlatformOS(String osname) {
        Trace.out((String)("Check Platform OS: osname=" + osname));
        return sVerificationUtil.checkPlatformOS(osname);
    }

    public static VerificationConstants.OSType getSupportedOSPlatform() {
        return sVerificationUtil.getSupportedOSPlatform();
    }

    public static String getSupportedArch() {
        return sVerificationUtil.getSupportedArch();
    }

    public static String getInventoryConfigFilePointer() throws InventoryFilePointerException {
        String defaultInvPtr = sVerificationUtil.getInventoryConfigFilePointer();
        String invPtrProp = System.getProperty(ORA_INST_INVPTR_PROPERTY);
        String invPtr = defaultInvPtr;
        boolean crs_or_siha = true;
        if (!VerificationUtil.isCRSConfigured() && !VerificationUtil.isHAConfigured()) {
            crs_or_siha = false;
        }
        if (crs_or_siha) {
            if (invPtrProp != null && !invPtrProp.equals(defaultInvPtr)) {
                throw new InventoryFilePointerException(s_msgBundle.getMessage("7608", false, (Object[])new String[]{ORA_INST_INVPTR_PROPERTY, defaultInvPtr, invPtrProp}));
            }
        } else if (invPtrProp != null && invPtrProp.length() != 0) {
            invPtr = invPtrProp;
        }
        return invPtr;
    }

    private static void reportException(Exception e) {
        String errMsg = e.getMessage();
        if (VerificationUtil.isStringGood(errMsg)) {
            ReportUtil.processAlert(LSEP + ReportUtil.ERROR + LSEP + errMsg);
        }
        Trace.out((Exception)e);
    }

    public static boolean isAbsoluteURI(String str) {
        return str.startsWith("file:") || str.startsWith("http:");
    }

    public static void setPreReqXmlFile(String xmlFilePath) throws VerificationException {
        Trace.out((String)("setting xml file: PATH = " + xmlFilePath));
        s_genericPreReqXmlFile = xmlFilePath;
    }

    public static void setPreReqXmlFile(VerificationType prereqType, String xmlFilePath) throws VerificationException {
        Trace.out((String)("setting xml file: PATH = " + xmlFilePath + " verification type =" + (Object)((Object)prereqType)));
        s_preReqXmlRepos.put(prereqType, xmlFilePath);
    }

    public static float getCTSSOffsetLimit() {
        return sVerificationUtil.getCTSSOffsetLimit();
    }

    public static String getVDiskPermissions() {
        return VDISK_DEFAULT_PERMISSIONS;
    }

    public static String getOCROwner() {
        return VDMUtil.getDefaultOcrOwner();
    }

    public static String getOCRPermissions() {
        return VDMUtil.getDefaultOcrPermissions();
    }

    public static int getRemoteSSHBatchSize() {
        return VDMUtil.getRemoteSSHBatchSize();
    }

    public static boolean isASMPath(String inpath) {
        if (inpath.contains(ASM_PATH_CHARACTER) || inpath.startsWith(EXADATA_PATH_CHARACTERS)) {
            Trace.out((String)("Path: '" + inpath + "' is managed by ASM"));
            return true;
        }
        return false;
    }

    public static boolean isASMRunning() {
        return VerificationUtil.isASMRunningOnAnyNode(new String[]{VerificationUtil.getLocalNode()});
    }

    public static boolean isASMRunningOnAnyNode(String[] nodes) {
        try {
            ArrayList<String> runningNodeList = new ArrayList<String>();
            ArrayList<String> notRunningNodeList = new ArrayList<String>();
            new ASMDiskGroupsUtil().checkASMRunning(nodes, runningNodeList, notRunningNodeList);
            return runningNodeList.size() > 0;
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((String)(e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    public static String getCvuqdiskRPMname() {
        return CVUQDISK_RPM_FILE_NAME;
    }

    public static boolean isVersionPre(String version, int majorVersion, int minorVersion) {
        String versionSeparator = ".";
        String requiredVersion = Integer.toString(majorVersion) + versionSeparator + Integer.toString(minorVersion);
        return VerificationUtil.isVersionPre(version, requiredVersion);
    }

    public static boolean isVersionPre(String version, String requiredVersion) {
        String versionSeparator = ".";
        int comparisonResult = new VersionComparator(versionSeparator).compare(version, requiredVersion);
        return comparisonResult < 0;
    }

    public static boolean isVersionPost(String version, String requiredVersion) {
        String versionSeparator = ".";
        int comparisonResult = new VersionComparator(versionSeparator).compare(version, requiredVersion);
        return comparisonResult >= 0;
    }

    public static boolean isCVUTestEnv() {
        String sysprop = System.getProperty("CVU_TEST_ENV");
        if (sysprop == null || sysprop.trim().length() <= 0) {
            sysprop = VerificationUtil.getEnv("CVU_TEST_ENV");
        }
        return Boolean.parseBoolean(sysprop);
    }

    public static String getLoginShell() {
        return sVerificationUtil.getLoginShell();
    }

    public static boolean isACFSSupported(boolean dispError) {
        return VerificationUtil.checkACFSState(USMDriverUtil.ACFSDriverState.SUPPORTED, dispError);
    }

    public static boolean isACFSInstalled(boolean dispError) {
        if (VerificationUtil.isACFSSupported(dispError)) {
            return VerificationUtil.checkACFSState(USMDriverUtil.ACFSDriverState.INSTALLED, dispError);
        }
        return false;
    }

    private static boolean checkACFSState(USMDriverUtil.ACFSDriverState state, boolean dispError) {
        String crsHome = VerificationUtil.getCRSHome();
        String errMsg = null;
        boolean isSupported = false;
        if (crsHome == null) {
            if (dispError) {
                errMsg = s_msgBundle.getMessage("5301", true);
                VerificationLogData.addGlobalErrorOnce("Prvf", "5301", true, null, null, new String[]{VerificationUtil.getLocalNode()});
                Trace.out((String)errMsg);
            }
            VerificationUtil.traceAndLogError("Could not retrieve CRS Home, failed to retrieve an information about ACFS support on this platform");
            return false;
        }
        try {
            USMDriverUtil usmUtil = new USMDriverUtil(crsHome);
            isSupported = usmUtil.checkACFSState(state, crsHome);
        }
        catch (CmdToolUtilException e) {
            if (dispError) {
                VerificationUtil.reportException((Exception)((Object)e));
            }
            VerificationUtil.traceAndLogError("An exception occured while retrieving information about ACFS support for this platform.");
            return false;
        }
        if (isSupported) {
            Trace.out((String)"ACFS is supported on this platform.");
            return true;
        }
        if (dispError) {
            ReportUtil.processAlert(LSEP + s_gMsgBundle.getMessage("1300", true));
        }
        Trace.out((String)"ACFS is NOT supported on this platform.");
        return false;
    }

    public static boolean isUDEVSupported() {
        return sVerificationUtil.isUDEVSupported();
    }

    public static String getVersionForCL() {
        Trace.out((String)"Executing getVersionForCL()");
        String version = VerificationUtil.getEnv(ASSUME_CL_VERSION);
        if (version != null && version.length() > 0) {
            return version;
        }
        version = VerificationUtil.getConfiguredValue(ASSUME_CL_VERSION, true);
        if (version != null && version.length() > 0) {
            return version;
        }
        if (VerificationUtil.isHAConfigured()) {
            version = VerificationUtil.getSIHAReleaseVersion(true);
        } else if (VerificationUtil.isCRSConfigured()) {
            version = VerificationUtil.getCRSActiveVersion(true);
        }
        if (version != null && version.length() > 0) {
            return version;
        }
        return "12.2.0.1.0";
    }

    public static String getSudoPbrunLocationFromConfigFile(ConfigurationSetup.ConfigMethod method) {
        String m_sudoPbrunloc = null;
        String binaryName = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (method != null) {
            switch (method) {
                case ROOT: {
                    return null;
                }
                case PBRUN: {
                    m_sudoPbrunloc = VerificationUtil.getConfiguredValue(PBRUN_LOCATION_PATH, true);
                    binaryName = nativeSys.getExeName(ConfigurationSetup.ConfigMethod.PBRUN.toString().toLowerCase());
                    break;
                }
                case SUDO: {
                    m_sudoPbrunloc = VerificationUtil.getConfiguredValue(SUDO_LOCATION_PATH, true);
                    binaryName = "not supported on windows";
                }
            }
        }
        if (!VerificationUtil.isStringGood(m_sudoPbrunloc)) {
            m_sudoPbrunloc = "/usr/local/bin/" + binaryName;
        }
        return m_sudoPbrunloc;
    }

    public static boolean isUpgrade() {
        return VerificationAPIConstants.VAR_VAL_UPGRADE.equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.INSTALL_OPTION));
    }

    public static boolean isRollingUpgrade() {
        return VerificationUtil.isUpgrade() && "true".equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.ISROLLING));
    }

    public static boolean isCRSSoftwareOnlyInstall() {
        return VerificationAPIConstants.VAR_VAL_CRS_SOFT_ONLY.equalsIgnoreCase(CVUVariables.getValue(CVUVariableConstants.INSTALL_OPTION));
    }

    public static boolean isCVUResource() {
        String mode = System.getProperty("RUNNING.MODE");
        return mode != null && mode.equalsIgnoreCase("cvuresource");
    }

    public static boolean isCLIMode() {
        String mode = CVUVariables.getValue(CVUVariableConstants.MODE_CLI);
        return VerificationUtil.isStringGood(mode) && mode.trim().equalsIgnoreCase("true");
    }

    public static boolean isAPIMode() {
        String mode = CVUVariables.getValue(CVUVariableConstants.MODE_API);
        return VerificationUtil.isStringGood(mode) && mode.trim().equalsIgnoreCase("true");
    }

    public static boolean isBestPracticeMode() {
        String mode = CVUVariables.getValue(CVUVariableConstants.MODE_BEST_PRACTICE);
        return VerificationUtil.isStringGood(mode) && mode.trim().equalsIgnoreCase("true");
    }

    public static boolean isHealthCheckMode() {
        String mode = CVUVariables.getValue(CVUVariableConstants.MODE_HEALTH_CHECK);
        return VerificationUtil.isStringGood(mode) && mode.trim().equalsIgnoreCase("true");
    }

    public static boolean isBaselineCollectionMode() {
        String mode = CVUVariables.getValue(CVUVariableConstants.MODE_BASELINE_COLLECTION);
        return VerificationUtil.isStringGood(mode) && mode.trim().equalsIgnoreCase("true");
    }

    public static String getLogFileName() {
        if (!VerificationUtil.isCVUResource()) {
            return null;
        }
        if (s_cvuLogFile != null) {
            return s_cvuLogFile;
        }
        String strTimeStamp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        strTimeStamp = sdf.format(new Date());
        s_cvuLogFile = System.getProperty("CV_LOG_LOCATION") + FILE_SEPARATOR + "cvu" + strTimeStamp + ".log";
        Trace.out((String)("writing to " + s_cvuLogFile));
        return s_cvuLogFile;
    }

    public static String getCVUResourcePidFile() {
        if (!VerificationUtil.isCVUResource()) {
            return null;
        }
        String cvuPidFile = System.getProperty("CV_PID_FILE");
        Trace.out((String)("pid file is " + cvuPidFile));
        return cvuPidFile;
    }

    public static void deleteLogFiles() {
        if (!VerificationUtil.isCVUResource()) {
            return;
        }
        String logDir = System.getProperty("CV_LOG_LOCATION");
        File directory = new File(logDir);
        if (directory.exists()) {
            File[] listFiles = directory.listFiles();
            long purgeTime = System.currentTimeMillis() - -1702967296L;
            for (File listFile : listFiles) {
                if (listFile.lastModified() >= purgeTime || listFile.delete()) continue;
                ReportUtil.sureprintln(s_msgBundle.getMessage("7555", false, (Object[])new String[]{logDir}));
                return;
            }
        }
    }

    public static String getTZFileLoc() {
        return sVerificationUtil.getTZFileLoc();
    }

    public static OIFCFGInfo getOIFCFGInfo(String node, boolean preCheck) throws VerificationException {
        String cvHome = VerificationUtil.getCVHome();
        String oifcfgLocation = cvHome + "bin";
        String crsHome = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        boolean isWindows = !nativeSys.isUnixSystem();
        boolean lightWeight = true;
        ParamManager pm = null;
        if (!preCheck) {
            crsHome = VerificationUtil.getCRSHome();
            if (crsHome != null) {
                Trace.out((String)"post check crshome not null");
                return new OIFCFGInfo(crsHome + FSEP + "bin", false);
            }
            throw new VerificationException(s_msgBundle.getMessage("7593", false, (Object[])new String[]{node}));
        }
        String installOption = CVUVariables.getValue(CVUVariableConstants.INSTALL_OPTION);
        String configOption = CVUVariables.getValue(CVUVariableConstants.POST_SW_INSTALL_API_MODE);
        boolean isPostSWConfig = false;
        if (configOption != null && configOption.equalsIgnoreCase("true")) {
            isPostSWConfig = true;
        }
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        if (!preCheck && !VerificationUtil.isAPIMode()) {
            crsHome = VerificationUtil.getCRSHome();
            Trace.out((String)("crshome got is : " + crsHome));
        } else if (installOption != null && !installOption.equalsIgnoreCase(VerificationConstants.VAR_CRS_CONFIG) && installOption != null && !installOption.equalsIgnoreCase(VerificationConstants.VAR_HA_CONFIG)) {
            crsHome = VerificationUtil.getCRSHome();
            Trace.out((String)("crshome obtained is " + crsHome));
        }
        if (!VerificationUtil.isAPIMode() && pm.checkInstallConfigFile()) {
            if (crsHome != null) {
                oifcfgLocation = crsHome + FSEP + "bin";
                lightWeight = false;
            } else {
                oifcfgLocation = cvHome + "bin";
                lightWeight = true;
            }
        } else if (crsHome != null) {
            if (VerificationUtil.isAPIMode() && "UPGRADE".equalsIgnoreCase(installOption)) {
                if (isPostSWConfig) {
                    oifcfgLocation = VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
                    Trace.out((String)"post software install configuraion in upgrade api mode");
                } else {
                    oifcfgLocation = !isWindows ? cvHome + ".." + FSEP + "ext" + FSEP + "bin" : System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
                    Trace.out((String)"upgrade api mode using lightweight oifcfg");
                }
            } else {
                lightWeight = false;
                oifcfgLocation = crsHome + FSEP + "bin";
                Trace.out((String)"using oifcfg from crshome");
            }
        } else if (VerificationUtil.isAPIMode()) {
            if (Utils.isDevelopmentEnv()) {
                oifcfgLocation = cvHome + FSEP + "bin";
                lightWeight = false;
                Trace.out((String)"cvu test env");
            } else if (isPostSWConfig) {
                oifcfgLocation = VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
                Trace.out((String)"post software install configuraion mode");
            } else {
                oifcfgLocation = !isWindows ? cvHome + ".." + FSEP + "ext" + FSEP + "bin" : System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
                Trace.out((String)"shiphome test env");
            }
        } else if (Utils.isDevelopmentEnv()) {
            lightWeight = false;
            Trace.out((String)"cvu test env");
        }
        String OIFCFGUTL = nativeSys.getExeName("oifcfg");
        if (!new File(oifcfgLocation + FSEP + OIFCFGUTL).exists()) {
            Trace.out((String)(" oifcfg not found in " + oifcfgLocation));
            throw new VerificationException(s_msgBundle.getMessage("0054", true, (Object[])new String[]{oifcfgLocation}));
        }
        Trace.out((String)("using " + lightWeight + " oifcfg"));
        OIFCFGInfo oifcfgInfo = new OIFCFGInfo(oifcfgLocation, lightWeight);
        return oifcfgInfo;
    }

    private static String getInstallBinariesLocWhenPostSWConfig() throws VerificationException {
        String oHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        if (oHome == null || oHome.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("5461", true, (Object[])new String[]{"ORACLE_HOME"}));
        }
        return oHome + FSEP + "inventory" + FSEP + "Scripts" + FSEP + "ext" + FSEP + "bin";
    }

    public static Set<NetworkInfo> getIPNetworks(String node, InetAddress ipAddress, boolean preCheck, ResultSet resultSet) throws InstallException, CVUException {
        Set<NetworkInfo> clusterNetworks = null;
        HashSet<NetworkInfo> ipNetworkList = new HashSet<NetworkInfo>();
        HashSet nodeNetworksList = new HashSet();
        Set<NetworkInfo> matchingNetworksOnTheNode = null;
        byte[] ipAddressBytes = ipAddress.getAddress();
        try {
            clusterNetworks = preCheck ? NetworkDataDiscovery.getClusterNetworksFromCVUVariable(resultSet) : NetworkDataDiscovery.getClusterNetworksFromOifcfg(resultSet);
            NetworkDataDiscovery networkDataDiscovery = NetworkDataDiscovery.getInstance(new String[]{node}, resultSet);
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks) || resultSet.anyFailure()) {
                return clusterNetworks;
            }
            matchingNetworksOnTheNode = NetworkDataDiscovery.getMatchingNetworksOnNode(NetworkDataDiscovery.m_nodeNetworksMap, clusterNetworks, node, resultSet);
            if (!NetworkUtility.isNetworksSetGood(matchingNetworksOnTheNode) || resultSet.anyFailure()) {
                return clusterNetworks;
            }
            matchingNetworksOnTheNode = NetworkDataDiscovery.getNetworksWithStatusUp(matchingNetworksOnTheNode);
        }
        catch (NodelistNotFoundException nodelistNotFoundException) {
            Trace.out((String)("NodelistNotFoundException occured while trying to get interfaces info on " + node + ". msg:" + nodelistNotFoundException.getMessage()));
            throw new CVUException(nodelistNotFoundException.getMessage());
        }
        if (!NetworkUtility.isNetworksSetGood(matchingNetworksOnTheNode)) {
            HashSet<String> networkNames = new HashSet<String>(NetworkDataDiscovery.getClusterNetworkNames(clusterNetworks));
            HashSet<String> hashSet = new HashSet<String>(NetworkDataDiscovery.getClusterNetworkSubnets(clusterNetworks));
        }
        String notMatchIPaddress = "";
        InetAddress resultingSubnet = null;
        InetAddress subnetMask = null;
        InetAddress subnet = null;
        for (NetworkInfo network : matchingNetworksOnTheNode) {
            try {
                subnetMask = network.getSubnetMask();
                subnet = network.getSubnet();
                byte[] subnetMaskBytes = subnetMask.getAddress();
                if (ipAddressBytes.length != subnetMaskBytes.length) {
                    String subnetAsString = network.getSubnetAsString();
                    if (notMatchIPaddress.indexOf(subnetAsString) != -1) continue;
                    notMatchIPaddress = notMatchIPaddress.concat(subnetAsString + ", ");
                    continue;
                }
                byte[] resultingSubnetBytes = new byte[ipAddressBytes.length];
                for (int i = 0; i < ipAddressBytes.length; i = (int)((byte)(i + 1))) {
                    resultingSubnetBytes[i] = Integer.valueOf(Byte.valueOf(ipAddressBytes[i]).intValue() & Byte.valueOf(subnetMaskBytes[i]).intValue()).byteValue();
                }
                resultingSubnet = InetAddress.getByAddress(resultingSubnetBytes);
                if (resultingSubnet.equals(subnet)) {
                    ipNetworkList.add(network);
                    continue;
                }
                String subnetAsString = network.getSubnetAsString();
                if (notMatchIPaddress.indexOf(subnetAsString) != -1) continue;
                notMatchIPaddress = notMatchIPaddress.concat(subnetAsString + ", ");
            }
            catch (UnknownHostException ohe) {
                throw new InstallException((MessageKey)PrCiMsgID.INVALID_RESULTING_SUBNET_FORMAT, new Object[]{subnetMask.getHostAddress(), ipAddress.getHostAddress()});
            }
        }
        if (ipNetworkList.size() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_MISMATCH, new Object[]{ipAddress.getHostAddress(), notMatchIPaddress.substring(0, notMatchIPaddress.length() - 2)});
        }
        return ipNetworkList;
    }

    public static List<OIFCFGResult> resolveSubNetMask(List<OIFCFGResult> oifcfgGetifList, List<OIFCFGResult> oifcfgIfList, OIFCFGUtil oifcfgUtil) {
        ArrayList<OIFCFGResult> updatedList = new ArrayList<OIFCFGResult>();
        block0: for (OIFCFGResult getifElem : oifcfgGetifList) {
            for (OIFCFGResult iflstElem : oifcfgIfList) {
                if (!iflstElem.getInterfaceName().equalsIgnoreCase(getifElem.getInterfaceName()) || !iflstElem.getSubnet().equals(getifElem.getSubnet()) || iflstElem.getType() != getifElem.getType()) continue;
                Trace.out((String)("updating " + getifElem.getInterfaceName() + "'s subnet"));
                updatedList.add(oifcfgUtil.getOIFCFGResultObj(getifElem.getInterfaceName(), getifElem.getSubnet(), getifElem.getInterfaceType(), iflstElem.getSubnetMask(), getifElem.getNodeScope()));
                continue block0;
            }
        }
        return updatedList;
    }

    public static String getKFODLocation(String node, boolean preCheck) throws VerificationException {
        boolean isWindows;
        String cvHome = VerificationUtil.getCVHome();
        String crsHome = null;
        String kfodBinary = "kfod.bin";
        ParamManager pm = null;
        Version curVer = null;
        Result result = new Result(VerificationUtil.getLocalNode());
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        boolean bl = isWindows = !nativeSys.isUnixSystem();
        if (!preCheck) {
            if (VerificationUtil.isHAConfigured()) {
                curVer = VerificationUtil.getSIHAReleaseVersionObj();
                crsHome = VerificationUtil.getHAHome();
            } else if (VerificationUtil.isCRSConfigured()) {
                curVer = VerificationUtil.getCRSActiveVersionObj();
                crsHome = VerificationUtil.getCRSHome();
            }
            Trace.out((String)("Crs home is : " + crsHome + " CRS version " + curVer));
            if (curVer != null && Version.isPre112((Version)curVer)) {
                crsHome = CVUHelperUtil.getASMhome(result);
                Trace.out((String)("Using ASM home " + crsHome));
            }
            if (VerificationUtil.isStringGood(crsHome)) {
                if (Utils.isDevelopmentEnv()) {
                    Trace.out((String)"post check dev env");
                    return crsHome + FSEP + "rdbms" + FSEP + "bin";
                }
                Trace.out((String)"post check crshome was found");
                return crsHome + FSEP + "bin";
            }
            throw new VerificationException(s_msgBundle.getMessage("7593", true, (Object[])new String[]{node}));
        }
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        String installOption = CVUVariables.getValue(CVUVariableConstants.INSTALL_OPTION);
        String configOption = CVUVariables.getValue(CVUVariableConstants.POST_SW_INSTALL_API_MODE);
        boolean isPostSWConfig = false;
        if (configOption != null && configOption.equalsIgnoreCase("true")) {
            isPostSWConfig = true;
        }
        crsHome = VerificationUtil.getCRSHome();
        Trace.out((String)("crshome obtained is " + crsHome));
        if (crsHome != null && !VerificationUtil.isAPIMode() && pm.checkInstallConfigFile()) {
            Trace.out((String)"cmdline mode with -file option before clusterware config");
            return crsHome + FSEP + "bin";
        }
        if (VerificationUtil.isAPIMode() || ParamManager.isRuncluvfy()) {
            if (isPostSWConfig) {
                Trace.out((String)"post software install configuraion in upgrade api mode");
                return VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
            }
            Trace.out((String)"Shiphome Test env");
            if (!isWindows) {
                if (!VerificationUtil.isBinaryExistsInsideHome(cvHome, kfodBinary)) {
                    return cvHome + FSEP + ".." + FSEP + "ext" + FSEP + "bin";
                }
                return cvHome + FSEP + "bin";
            }
            if (VerificationUtil.isBinaryExistsInsideHome(cvHome, "kfod")) {
                return cvHome + FSEP + "bin";
            }
            return System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
        }
        if (Utils.isDevelopmentEnv()) {
            if (crsHome != null) {
                Trace.out((String)"post check dev env");
                return crsHome + FSEP + "rdbms" + FSEP + "bin";
            }
            Trace.out((String)"cvu cmdline test env");
            return cvHome + FSEP + "rdbms" + FSEP + "bin";
        }
        if (crsHome != null) {
            Trace.out((String)"Pre Upgrade check from OTN");
            return crsHome + FSEP + "bin";
        }
        Trace.out((String)"default location");
        return cvHome + FSEP + "bin";
    }

    public static boolean isAutoMountEnabled(String node) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            return sVerificationUtil.isAutoMountEnabled(node);
        }
        return false;
    }

    public static boolean isAutoMountEnabled(String[] nodes) {
        boolean autoMntEnabled = true;
        for (String node : nodes) {
            if (VerificationUtil.isAutoMountEnabled(node)) continue;
            autoMntEnabled = false;
        }
        return autoMntEnabled;
    }

    public static String[] getLdLibraryStrings() {
        return sVerificationUtil.getLdLibraryStrings();
    }

    public static Vector<String> tagHashFilter(String input, String tagPattern) {
        String retstr = "";
        String pattern = "#" + tagPattern + "#";
        Vector<String> tokenList = new Vector<String>();
        if (VerificationUtil.isStringGood(input) && VerificationUtil.isStringGood(pattern) && input.contains(pattern)) {
            int endpos;
            int beginpos;
            String copy = input;
            while (copy.contains(pattern) && (beginpos = copy.indexOf(pattern)) >= 0 && (endpos = (copy = copy.substring(beginpos + pattern.length())).indexOf(pattern)) >= 0) {
                String value = copy.substring(0, endpos);
                Trace.out((String)("Retrieved the value from Tag hashes as :" + value));
                copy = copy.substring(endpos + pattern.length());
                if (!VerificationUtil.isStringGood(value)) continue;
                tokenList.add(value.trim());
            }
        }
        return tokenList;
    }

    public static String[] getOCRLocations(Version version, ResultSet resultSet) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return VerificationUtil.getOCRLocationsUnix(version, resultSet);
        }
        return VerificationUtil.getOCRLocationsWindows(version, resultSet);
    }

    private static String[] getOCRLocationsUnix(Version version, ResultSet resultSet) {
        ArrayList<String> ocrLocList = new ArrayList<String>();
        String ocrLoc = null;
        String fileName = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        fileName = nativeSys.getConfigLocation(version);
        String ocrConfigPropName = Version.isPre10i((Version)version) ? "srvconfig_loc" : "ocrconfig_loc";
        String ocrMirrorPropName = "ocrmirrorconfig_loc";
        String ocrConfig3PropNameLocation = "ocrconfig_loc3";
        String ocrConfig4PropNameLocation = "ocrconfig_loc4";
        String ocrConfig5PropNameLocation = "ocrconfig_loc5";
        try {
            ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfigPropName, (boolean)true);
            if (ocrLoc != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrMirrorPropName, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfig3PropNameLocation, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfig4PropNameLocation, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfig5PropNameLocation, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
        }
        catch (FileNotFoundException e) {
            Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            return null;
        }
        catch (IOException e) {
            Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            return null;
        }
        resultSet.setStatus(1);
        return ocrLocList.toArray(new String[0]);
    }

    private static String[] getOCRLocationsWindows(Version version, ResultSet resultSet) {
        ErrorDescription errorDescription;
        MessageBundle msgBundle;
        String[] args;
        String ocrLoc;
        ArrayList<String> ocrLocList = new ArrayList<String>();
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String configLocation = nativeSys.getConfigLocation(version);
        String ocrConfigPropName = Version.isPre10i((Version)version) ? "srvconfig_loc" : "ocrconfig_loc";
        String ocrMirrorPropName = "ocrmirrorconfig_loc";
        RegistryKeyData regData = new RegistryKeyData(configLocation, ocrConfigPropName);
        String nodeName = null;
        NativeResult nativeResult = new NativeResult();
        if (nativeSys.regKeyExists(nodeName, configLocation, nativeResult)) {
            nativeResult.setStatus(false);
            nativeSys.regGetData(nodeName, configLocation, ocrConfigPropName, regData, nativeResult);
            if (nativeResult.getStatus() && (ocrLoc = regData.getStringData()) != null && ocrLoc.length() > 0) {
                ocrLocList.add(ocrLoc);
            }
        } else if (!nativeResult.getStatus()) {
            args = new String[]{ocrConfigPropName, configLocation, "localnode", nativeResult.getOSString()};
            msgBundle = VerificationUtil.getMessageBundle("Prvf");
            errorDescription = new ErrorDescription("1011", args, msgBundle);
            resultSet.setStatus(2);
            resultSet.addErrorDescription(errorDescription);
        }
        if (!Version.isPre10i((Version)version)) {
            regData = new RegistryKeyData(configLocation, ocrMirrorPropName);
            nativeResult = new NativeResult();
            if (nativeSys.regKeyExists(nodeName, configLocation, nativeResult)) {
                nativeResult.setStatus(false);
                nativeSys.regGetData(nodeName, configLocation, ocrMirrorPropName, regData, nativeResult);
                if (nativeResult.getStatus() && (ocrLoc = regData.getStringData()) != null && ocrLoc.length() > 0) {
                    ocrLocList.add(ocrLoc);
                }
            } else if (!nativeResult.getStatus()) {
                args = new String[]{ocrMirrorPropName, configLocation, "localnode", nativeResult.getOSString()};
                msgBundle = VerificationUtil.getMessageBundle("Prvf");
                errorDescription = new ErrorDescription("1011", args, msgBundle);
                resultSet.setStatus(2);
                resultSet.addErrorDescription(errorDescription);
            }
        }
        resultSet.setStatus(1);
        return ocrLocList.toArray(new String[0]);
    }

    public static DiskInfoResultSet getDiskInfoForPath(String[] nodeList, String path) throws InvalidPathException {
        return sVerificationUtil.getDiskInfoForPath(nodeList, path);
    }

    public static ResultSet getSharedMemory(String[] nodeList, StorageUnit unit) {
        return sVerificationUtil.getSharedMemory(nodeList, unit);
    }

    public static SpaceResultSet getAvailableSpace(String[] nodeList, String path, boolean isWritePermissionRequired) {
        SpaceResultSetImpl spaceRsltSet = new SpaceResultSetImpl();
        ErrorDescription errorDesc = null;
        String errMsg = null;
        if (nodeList == null || nodeList.length == 0) {
            errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"nodeList"});
            errorDesc = new ErrorDescription(errMsg);
            spaceRsltSet.addErrorDescription(errorDesc);
            spaceRsltSet.setStatus(2);
            return spaceRsltSet;
        }
        if (!VerificationUtil.isStringGood(path)) {
            errMsg = s_msgBundle.getMessage("7517", false);
            errorDesc = new ErrorDescription(errMsg);
            spaceRsltSet.addErrorDescription(errorDesc);
            spaceRsltSet.addResult(nodeList, 2);
            return spaceRsltSet;
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " isWritePermissionRequired=" + isWritePermissionRequired));
        }
        StorageUnit unit = StorageUnit.BYTE;
        ResultSet validPathResSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        HashMap<String, String> nodePath = new HashMap<String, String>();
        boolean cmdResult = false;
        cmdResult = globalExec.getLongestValidPath(nodeList, path, isWritePermissionRequired, validPathResSet);
        Hashtable ht = validPathResSet.getResultTable();
        Enumeration e = ht.keys();
        int nodeCount = ht.size();
        ArrayList<GetSpaceCommand> cmdList = new ArrayList<GetSpaceCommand>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result pathResult = (Result)ht.get(node);
            if (pathResult.getStatus() == 1) {
                String longestPath = (String)pathResult.getResultInfoSet().firstElement();
                nodePath.put(node, longestPath);
                Object stInfo = null;
                cmdList.add(new GetSpaceCommand(node, longestPath));
                continue;
            }
            MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvg");
            errMsg = s_msgBundle.getMessage(isWritePermissionRequired ? "7051" : "7050", true, (Object[])new String[]{path, node});
            errorDesc = new ErrorDescription(errMsg);
            Result rslt = new Result(node, 2);
            rslt.addErrorDescription(errorDesc);
            spaceRsltSet.addResult(node, rslt);
        }
        ResultSet spaceResSet = new ResultSet();
        cmdResult = new GlobalHandler().submit(cmdList.toArray(new Command[0]), 0, spaceResSet);
        Enumeration e1 = spaceResSet.getResultTable().keys();
        while (e1.hasMoreElements()) {
            String node = (String)e1.nextElement();
            Trace.out((String)("--------- Execution Trace for GetSpaceCommand from node: " + node + " ------------"));
            Result result = (Result)spaceResSet.getResultTable().get(node);
            if (result.getStatus() == 1) {
                Long lAvl = (Long)result.getResultInfoSet().firstElement();
                long space = lAvl;
                String location = (String)nodePath.get(node);
                AvailableSpaceInfoImpl spaceInfo = new AvailableSpaceInfoImpl(node, location, space, unit);
                spaceRsltSet.addSpaceInfo(spaceInfo);
            }
            spaceRsltSet.addResult(node, result);
            Vector traceSet = result.getTraceInfoSet();
            Enumeration t = traceSet.elements();
            while (t.hasMoreElements()) {
                Trace.out((String)((String)t.nextElement()));
            }
        }
        return spaceRsltSet;
    }

    public static boolean isStringGood(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static String readPassword(String prompt) {
        EraserThread et = new EraserThread(prompt);
        Thread mask = new Thread(et);
        mask.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String password = "";
        try {
            password = in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        et.stopMasking();
        return password;
    }

    public static boolean isDisplayEnabled() {
        return sVerificationUtil.isDisplayEnabled();
    }

    public static String getOLRPropertyValue(String node, String propertyName, Result result, boolean ignoreCase) {
        return sVerificationUtil.getOLRPropertyValue(node, propertyName, result, ignoreCase);
    }

    public static String getOLRPropertyValueLocalNode(String propertyName, Result result, boolean ignoreCase) {
        return VerificationUtil.getOLRPropertyValue("localnode", propertyName, result, ignoreCase);
    }

    public static String getLocalRootGroup(ResultSet rootGrpRS) {
        return sVerificationUtil.getLocalRootGroup(rootGrpRS);
    }

    public static String getRootUsername() {
        return sVerificationUtil.getRootUsername();
    }

    public static boolean skipTask(Task task) {
        boolean retVal = false;
        if (task instanceof TaskMulticastCheck) {
            if (VerificationUtil.getSupportedOSPlatform() != VerificationConstants.OSType.SOLARIS) {
                return false;
            }
            File cluFile = null;
            cluFile = new File("/opt/FJSVhanet/usr/sbin/hanetconfig");
            if (cluFile.exists()) {
                return true;
            }
        }
        return retVal;
    }

    public static StorageSize parseStringToNumberWithUnit(String numberStr, String unitString) {
        return new StorageSize(VerificationUtil.parseStringToNumber(numberStr), VerificationUtil.parseStorageUnitFromString(unitString));
    }

    private static StorageUnit parseStorageUnitFromString(String unit) {
        if (unit.equalsIgnoreCase("bytes") || unit.equalsIgnoreCase("B")) {
            return StorageUnit.BYTE;
        }
        if (unit.equalsIgnoreCase("Kilobytes") || unit.equalsIgnoreCase("KB")) {
            return StorageUnit.KBYTE;
        }
        if (unit.equalsIgnoreCase("Megabytes") || unit.equalsIgnoreCase("MB")) {
            return StorageUnit.MBYTE;
        }
        if (unit.equalsIgnoreCase("Gigabytes") || unit.equalsIgnoreCase("GB")) {
            return StorageUnit.GBYTE;
        }
        if (unit.equalsIgnoreCase("Terabytes") || unit.equalsIgnoreCase("TB")) {
            return StorageUnit.TBYTE;
        }
        return StorageUnit.BYTE;
    }

    public static double parseStringToNumber(String numberStr) {
        double value = 0.0;
        try {
            long lval = Long.parseLong(numberStr);
            value = lval;
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Caught NumberFormatException while parsing " + numberStr + " as Long, Now trying to parse it as Double"));
            value = Double.parseDouble(numberStr);
        }
        return value;
    }

    public static String parseObjectToString(Object obj) {
        String strForObj = null;
        if (obj == null) {
            return strForObj;
        }
        if (obj instanceof Number) {
            if (obj instanceof Short) {
                strForObj = BigDecimal.valueOf(((Short)obj).shortValue()).toPlainString();
            } else if (obj instanceof Long) {
                strForObj = BigDecimal.valueOf((Long)obj).toPlainString();
            } else if (obj instanceof Integer) {
                strForObj = BigDecimal.valueOf(((Integer)obj).intValue()).toPlainString();
            } else if (obj instanceof Float) {
                strForObj = BigDecimal.valueOf(((Float)obj).floatValue()).toPlainString();
            } else if (obj instanceof Byte) {
                strForObj = BigDecimal.valueOf(((Byte)obj).byteValue()).toPlainString();
            } else if (obj instanceof Double) {
                String numStr = obj.toString();
                if (numStr.endsWith(".0")) {
                    DecimalFormat decimalFormatter = new DecimalFormat("0");
                    strForObj = decimalFormatter.format(obj);
                } else {
                    strForObj = BigDecimal.valueOf((Double)obj).toPlainString();
                }
            } else {
                strForObj = obj.toString();
            }
        } else {
            strForObj = obj.toString();
        }
        Trace.out((String)("Converted object " + obj.toString() + " To " + strForObj));
        return strForObj;
    }

    public static boolean isIPv6Cluster(String node, boolean preCheck) throws VerificationException {
        boolean isIPv6OnlyCluster = true;
        Trace.out((String)"ENTRY");
        if (!preCheck) {
            isIPv6OnlyCluster = VerificationUtil.isIPv6FromOIFCFG(node, preCheck);
        } else {
            String interfaceList = CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST);
            if (interfaceList == null) {
                Trace.out((String)"trying oifcfg iflist fallback as INTERCONNECT_LIST was not specified");
                return VerificationUtil.isIPv6FromOIFCFG(node, preCheck);
            }
            String[] interconnectLst = null;
            Trace.out((String)("INTERCONNECT_LIST : " + interfaceList));
            String[] stringArray = interconnectLst = VerificationUtil.string2strArr(interfaceList);
            int n = stringArray.length;
            int n2 = 0;
            if (n2 < n) {
                int end;
                String token = stringArray[n2];
                int start = token.indexOf(":");
                if (start < (end = token.lastIndexOf(":"))) {
                    String itr_name = token.substring(0, start);
                    String subnet = token.substring(start + 1, end);
                    String iftype = token.substring(end + 1);
                    Trace.out((String)("Name: " + itr_name + " " + "Subnet: " + subnet + " " + "Type: " + iftype));
                    if (IPAddressUtil.isIPv4AddressString((String)subnet) && VerificationUtil.isStringGood(iftype) && iftype.toLowerCase().startsWith("pub")) {
                        isIPv6OnlyCluster = false;
                    }
                } else {
                    Object[] args = new String[]{"error-invalid-interconnect-list"};
                    throw new VerificationException(s_gMsgBundle.getMessage("13201", true, args));
                }
            }
        }
        Trace.out((String)"EXIT");
        return isIPv6OnlyCluster;
    }

    private static boolean isIPv6FromOIFCFG(String node, boolean isPreCheck) throws VerificationException {
        boolean isIPv6OnlyCluster = true;
        ClusterwareInfo cluInfo = new ClusterwareInfo();
        OIFCFGInfo oifcfgInfo = VerificationUtil.getOIFCFGInfo(node, isPreCheck);
        String oifcfgLocation = oifcfgInfo.getOIFCFGLocation();
        List oifcfgIfList = null;
        try {
            oifcfgIfList = !isPreCheck ? cluInfo.listClusterInterfaces(oifcfgLocation) : cluInfo.listInterfaces(oifcfgLocation, isPreCheck);
        }
        catch (InstallException ie) {
            Trace.out((String)("Install Exception : Message: " + ie.getMessage()));
            Trace.out((String)"Error while retrieving the interface information using oifcfg");
            throw new VerificationException(ie.getMessage());
        }
        for (OIFCFGResult result : oifcfgIfList) {
            String interfaceType = result.getInterfaceType();
            IPAddressUtil.IPAddrType ipType = result.getType();
            Trace.out((String)("Name: " + result.getInterfaceName() + ", " + "Subnet: " + result.getSubnet() + ", " + "Type: " + ipType + ", " + "Interface Type: " + interfaceType));
            if (ipType != IPAddressUtil.IPAddrType.IPv4) continue;
            if ("PUBLIC".equalsIgnoreCase(interfaceType)) {
                isIPv6OnlyCluster = false;
                break;
            }
            if (isPreCheck && "UNKNOWN".equalsIgnoreCase(interfaceType)) {
                isIPv6OnlyCluster = false;
                break;
            }
            if (!VerificationUtil.isCVUTestEnv() || interfaceType == null || !interfaceType.contains("PUBLIC") && !interfaceType.contains("public")) continue;
            isIPv6OnlyCluster = false;
            break;
        }
        Trace.out((String)("cluster is ipv6 status is " + isIPv6OnlyCluster));
        return isIPv6OnlyCluster;
    }

    public static boolean isOTN() {
        File crsStrHome = null;
        File cvStrHome = null;
        if (VerificationUtil.isAPIMode()) {
            return false;
        }
        String crsHome = VerificationUtil.getCRSHome();
        if (!VerificationUtil.isStringGood(crsHome)) {
            Trace.out((String)"crsHome is null. Clusterware is not configured");
            return true;
        }
        String cvHome = System.getProperty("CV_HOME");
        if (!VerificationUtil.isStringGood(cvHome)) {
            cvHome = VerificationUtil.getEnv("CV_HOME");
        }
        if (!VerificationUtil.isStringGood(cvHome)) {
            Trace.out((String)"cvHome is null. THIS SHOULD NOT HAPPEN");
            return true;
        }
        try {
            crsStrHome = new File(crsHome).getCanonicalFile();
            cvStrHome = new File(cvHome).getCanonicalFile();
        }
        catch (IOException e) {
            Trace.out((String)("An exception happened while getting canonical path " + e.getMessage()));
            return true;
        }
        return crsStrHome.compareTo(cvStrHome) != 0;
    }

    public static void validateNewNodeRoles(String[] nodeList, NodeRoleCapability[] nodeRoleList, ParamPreReqNodeAddDel param) throws VerificationException {
        NodeManager nm = null;
        String[] confHubNodes = null;
        String[] confRimNodes = null;
        String[] confAutoNodes = null;
        String[] hubCapableNodes = null;
        int targetHubSize = -1;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager();
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        for (int i = 0; i < 4; ++i) {
            try {
                if (i == 0) {
                    confHubNodes = nm.getConfiguredHubNodes();
                    continue;
                }
                if (i == 1) {
                    confRimNodes = nm.getConfiguredRimNodes();
                    continue;
                }
                if (i == 2) {
                    confAutoNodes = nm.getConfiguredAutoNodes();
                    continue;
                }
                hubCapableNodes = nm.getHubCapableNodes();
                continue;
            }
            catch (NoSuchNodesException nse) {
                Trace.out((String)("NoSuchNodesException :" + nse.getMessage()));
                if (i == 0) {
                    confHubNodes = new String[]{};
                    continue;
                }
                if (i == 1) {
                    confRimNodes = new String[]{};
                    continue;
                }
                if (i == 2) {
                    confAutoNodes = new String[]{};
                    continue;
                }
                hubCapableNodes = new String[]{};
                continue;
            }
            catch (NodeManagerException nme) {
                Trace.out((String)("NodeManagerFactoryException :" + nme.getMessage()));
                throw new VerificationException(nme);
            }
        }
        targetHubSize = nm.getTargetHubSize();
        Trace.out((String)("targetHubSize=" + targetHubSize));
        ArrayList<String> hubList = new ArrayList<String>();
        ArrayList<String> rimList = new ArrayList<String>();
        ArrayList<String> autoList = new ArrayList<String>();
        for (int i = 0; i < nodeList.length; ++i) {
            if (nodeRoleList[i] == NodeRoleCapability.HUB) {
                hubList.add(nodeList[i]);
                Trace.out((String)("Added node '" + nodeList[i] + "' to hubList"));
                continue;
            }
            if (nodeRoleList[i] == NodeRoleCapability.RIM) {
                rimList.add(nodeList[i]);
                Trace.out((String)("Added node '" + nodeList[i] + "' to rimList"));
                continue;
            }
            if (nodeRoleList[i] == NodeRoleCapability.AUTO) {
                autoList.add(nodeList[i]);
                Trace.out((String)("Added node '" + nodeList[i] + "' to autoList"));
                continue;
            }
            throw new VerificationException(s_gMsgBundle.getMessage("11400", true));
        }
        if (autoList.size() > 0 && (hubList.size() > 0 || rimList.size() > 0)) {
            throw new VerificationException(s_gMsgBundle.getMessage("11401", true));
        }
        if (autoList.size() != 0 && (confAutoNodes.length == 0 || confHubNodes.length != 0 || confRimNodes.length != 0)) {
            throw new VerificationException(s_gMsgBundle.getMessage("11402", true));
        }
        if (hubList.size() == 0 && rimList.size() != 0 && confHubNodes.length == 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("11403", true));
        }
        if (hubList.size() > 0 && hubCapableNodes.length > 0 && hubCapableNodes.length + hubList.size() > targetHubSize) {
            throw new VerificationException(s_gMsgBundle.getMessage("11404", true, (Object[])new String[]{Integer.toString(targetHubSize)}));
        }
        try {
            nm.addNodes(hubList.toArray(new String[0]), rimList.toArray(new String[0]), autoList.toArray(new String[0]));
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException :" + nmEx.getMessage()));
            throw new VerificationException(nmEx);
        }
    }

    public static void checkFileExistence(String[] nodeList, String file, ResultSet resultSet) {
        ErrorDescription errDesc = null;
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList) + ";file=" + file));
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet locrs = new ResultSet();
        globalExec.checkFileExistence(nodeList, file, locrs);
        Hashtable cfresultHT = locrs.getResultTable();
        Enumeration e = cfresultHT.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)cfresultHT.get(node);
            if (result != null) {
                if (3 == result.getStatus()) {
                    errDesc = new ErrorDescription("5311", new String[]{file, node}, s_msgBundle);
                    resultSet.addResult(node, 3);
                    resultSet.addErrorDescription(node, errDesc);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    continue;
                }
                if (1 != result.getStatus()) {
                    errDesc = new ErrorDescription("5310", new String[]{file, node}, s_msgBundle);
                    errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + result.getErrMessage());
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                    resultSet.addResult(node, 2);
                    continue;
                }
                if (1 != result.getStatus()) continue;
                resultSet.addResult(node, 1);
                continue;
            }
            String errMsg = s_msgBundle.getMessage("5310", true, (Object[])new String[]{file, node});
            errDesc = new ErrorDescription(errMsg);
            ReportUtil.printError(errDesc.getErrorMessage());
            resultSet.addErrorDescription(node, errDesc);
            resultSet.addResult(node, 2);
        }
    }

    public static void checkFileAbsence(String[] nodeList, String file, ResultSet resultSet) {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList) + ";file=" + file));
        ErrorDescription errDesc = null;
        for (String node : nodeList) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Check existence of file '" + file + "'\n on node '" + node + "'"));
            }
            ClusterCmd cmd = new ClusterCmd();
            try {
                if (cmd.fileExists(node, file)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("File '" + file + "' exists on node '" + node + "'"));
                    }
                    errDesc = new ErrorDescription("11750", new String[]{file, node}, s_gMsgBundle);
                    resultSet.addResult(node, 3);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nCannot access file '" + file + "'" + "\n on node '" + node + "'"));
                }
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11751", false, (Object[])new String[]{file}));
                resultSet.addResult(node, 1);
            }
            catch (ClusterException e) {
                errDesc = new ErrorDescription("5310", new String[]{file, node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + e.getMessage());
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(node, 2);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("ClusterException: \n" + (Object)((Object)e)));
            }
        }
    }

    public static void checkDirAbsence(String[] nodeList, String file, ResultSet resultSet) {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList) + ";file=" + file));
        ErrorDescription errDesc = null;
        for (String node : nodeList) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Check existence of file '" + file + "'\n on node '" + node + "'"));
            }
            ClusterCmd cmd = new ClusterCmd();
            try {
                if (cmd.dirExists(node, file)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("File '" + file + "' exists on node '" + node + "'"));
                    }
                    errDesc = new ErrorDescription("11752", new String[]{file, node}, s_gMsgBundle);
                    resultSet.addResult(node, 3);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nCannot access file '" + file + "'" + "\n on node '" + node + "'"));
                }
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11753", false, (Object[])new String[]{file}));
                resultSet.addResult(node, 1);
            }
            catch (ClusterException e) {
                errDesc = new ErrorDescription("11754", new String[]{file, node}, s_gMsgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + e.getMessage());
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(node, 2);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("ClusterException: \n" + (Object)((Object)e)));
            }
        }
    }

    public static boolean isCellOSSetup() {
        if (VerificationUtil.isPlatformLinux() || VerificationUtil.isPlatformSolaris()) {
            File setupFile = new File(CELL_OS_SETUP_FILE);
            return setupFile.exists();
        }
        return false;
    }

    public static boolean isExadataSystem() {
        return sVerificationUtil.isExadataSystem();
    }

    public static boolean isASMLibConfigured(String[] nodeList) {
        return sVerificationUtil.isASMLibConfigured(nodeList);
    }

    public static boolean isODASystem() {
        if (!m_isODASystemChecked) {
            m_isODASystem = VerificationUtil.isODAEnv() || VerificationUtil.isODALiteEnv() || VerificationUtil.isODASingleIPEnv();
            m_isODASystemChecked = true;
        }
        return m_isODASystem;
    }

    public static boolean isEngineeredSystem() {
        return VerificationUtil.isExadataSystem() || VerificationUtil.isODASystem();
    }

    public static boolean isNameServerConfigured() {
        ClusterCmd clusterCmd = new ClusterCmd();
        ResultSet rsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        String node = VerificationUtil.getLocalNode();
        if (VerificationUtil.isPlatformWindows()) {
            return false;
        }
        try {
            boolean currentNodeStatus = clusterCmd.fileExists(node, m_resolvConfLocation);
            if (!currentNodeStatus) {
                Trace.out((String)("/etc/resolv.conf file does not exist on node " + node));
                return false;
            }
        }
        catch (ClusterException e) {
            Trace.out((String)"ClusterException while looking for resolv.conf");
            return false;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(m_resolvConfLocation));
            while ((line = in.readLine()) != null) {
                String[] tokens;
                line = line.trim();
                Trace.out((String)("line [" + line + "]"));
                if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                int index = line.indexOf("#");
                if (index != -1) {
                    line = line.substring(0, index).trim();
                }
                if ((index = line.indexOf(";")) != -1) {
                    line = line.substring(0, index).trim();
                }
                if (!(line = VerificationUtil.strArr2String(tokens = line.split("\\s+"), " ")).matches(m_nameserverLine)) continue;
                String[] nameServerArr = line.split(m_nameserverField);
                if (nameServerArr.length != 2) {
                    Trace.out((String)"valid nameserver entry not found");
                    continue;
                }
                String nameServer = nameServerArr[1].trim();
                Trace.out((String)("Valid name server entry found, name server = " + nameServer));
                return true;
            }
        }
        catch (IOException e) {
            Trace.out((String)("IOException while reading resolv.conf for node :" + node));
        }
        return false;
    }

    public static boolean isChronySupported() {
        return sVerificationUtil.isChronySupported();
    }

    public static boolean isPlatformLinux() {
        return VerificationUtil.getSupportedOSPlatform() == VerificationConstants.OSType.LINUX;
    }

    public static boolean isPlatformWindows() {
        return VerificationUtil.getSupportedOSPlatform() == VerificationConstants.OSType.WINDOWS;
    }

    public static boolean isPlatformAix() {
        return VerificationUtil.getSupportedOSPlatform() == VerificationConstants.OSType.AIX;
    }

    public static boolean isPlatformSolaris() {
        return VerificationUtil.getSupportedOSPlatform() == VerificationConstants.OSType.SOLARIS;
    }

    public static boolean isPlatformHp() {
        return VerificationUtil.getSupportedOSPlatform() == VerificationConstants.OSType.HPUX;
    }

    public static String getShellEscapedString(String node, String string) {
        if (node == null || string == null) {
            return string;
        }
        String escapeSequence = null;
        escapeSequence = VerificationUtil.isLocalNode(node) ? "\\" : "\\\\\\";
        string = string.replaceAll("\\*", Matcher.quoteReplacement(escapeSequence + "*"));
        string = string.replaceAll("\\[", Matcher.quoteReplacement(escapeSequence + "["));
        string = string.replaceAll("\\]", Matcher.quoteReplacement(escapeSequence + "]"));
        string = string.replaceAll("\\?", Matcher.quoteReplacement(escapeSequence + "?"));
        return string;
    }

    public static VoteDiskInfo[] getVoteDiskListFromNode(String crsHome, String hubNode) throws VerificationException {
        String CRSCTL_QUERY_VOTEDISK_CMD = "crsctl query css votedisk";
        Trace.out((String)"getting vote disk information from some other node");
        String crsctlCmd = crsHome + FSEP + "bin" + FSEP + CRSCTL_QUERY_VOTEDISK_CMD;
        Command[] queryCmdArr = new Command[]{new RunGenericCommand(hubNode, crsctlCmd, null, new String[]{"NLS_LANG="})};
        ResultSet cmdExecRS = new ResultSet();
        Trace.out((String)("running " + CRSCTL_QUERY_VOTEDISK_CMD));
        new GlobalHandler().submit(queryCmdArr, 0, cmdExecRS);
        Hashtable t = cmdExecRS.getResultTable();
        Enumeration en = t.keys();
        String[] outputLines = null;
        boolean noOutput = true;
        Result result = ((VerificationCommand)queryCmdArr[0]).getResult();
        if (result.getStatus() == 1 && result.getResultInfoSet().size() > 1 && ((outputLines = (String[])result.getResultInfoSet().get(1)) != null || outputLines.length > 0)) {
            for (String line : outputLines) {
                if (!VerificationUtil.isStringGood(line)) continue;
                noOutput = false;
            }
        }
        if (noOutput || outputLines == null) {
            Trace.out((String)"command didn't produce result");
            String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{CRSCTL_QUERY_VOTEDISK_CMD, hubNode});
            throw new VerificationException(errMsg);
        }
        ArrayList<VoteDiskInfo> votediskList = new ArrayList<VoteDiskInfo>(outputLines.length - 1);
        int vdisk_num = 0;
        int vdisk_status = 0;
        String vdisk_VDIN = null;
        String vdisk_path = null;
        String vdisk_group = null;
        String disk_no_string = null;
        String path_string = null;
        String grp_string = null;
        for (int i = 0; i < outputLines.length - 1; ++i) {
            Trace.out((String)("parsing line " + outputLines[i]));
            StringTokenizer st = new StringTokenizer(outputLines[i]);
            if (st.countTokens() == 0) {
                Trace.out((String)"empty line");
                continue;
            }
            if (st.countTokens() != 5) {
                Trace.out((String)"more than expected token");
                continue;
            }
            disk_no_string = st.nextToken();
            if (disk_no_string.endsWith(".")) {
                disk_no_string = disk_no_string.substring(0, disk_no_string.length() - 1);
            }
            try {
                vdisk_num = Integer.parseInt(disk_no_string);
            }
            catch (NumberFormatException e) {
                Trace.out((String)"couldn't parse the number");
                continue;
            }
            if (st.hasMoreTokens()) {
                vdisk_status = VoteDiskInfo.mapStatusToInt((String)st.nextToken());
            }
            vdisk_VDIN = st.hasMoreTokens() ? st.nextToken() : null;
            path_string = st.hasMoreTokens() ? st.nextToken() : null;
            vdisk_path = path_string != null && path_string.charAt(0) == '(' ? path_string.substring(1, path_string.length() - 1) : path_string;
            grp_string = st.hasMoreTokens() ? st.nextToken() : null;
            vdisk_group = grp_string != null && grp_string.equals("[]") ? null : grp_string.substring(1, grp_string.length() - 1);
            if (vdisk_path != null && vdisk_status != 0) {
                VoteDiskInfo votedisk = new VoteDiskInfo(vdisk_num, 0L, vdisk_status, vdisk_VDIN, vdisk_path, vdisk_group);
                Trace.out((String)votedisk.toString());
                votediskList.add(votedisk);
                continue;
            }
            Trace.out((String)"vote disk path is null or status not 0");
        }
        return votediskList.toArray(new VoteDiskInfo[0]);
    }

    public static List<String> getASMLibInstalledNodes(String[] nodeList, ResultSet asmLibInstallRsltSet) {
        Vector<String> asmLibNotInstallNodes = new Vector<String>();
        ArrayList<String> asmLibInstalledNodes = new ArrayList<String>();
        Vector<String> operationFailedNode = new Vector<String>();
        ResultSet asmLibInstallConsistentResultSet = new ResultSet();
        VerificationUtil.isASMLibInstallConsistent(nodeList, asmLibInstallConsistentResultSet, asmLibNotInstallNodes, operationFailedNode);
        if (asmLibInstallConsistentResultSet.anySuccess()) {
            for (String node : nodeList) {
                if (asmLibNotInstallNodes.contains(node)) continue;
                asmLibInstalledNodes.add(node);
            }
        }
        asmLibInstallRsltSet.uploadResultSet(asmLibInstallConsistentResultSet);
        return asmLibInstalledNodes;
    }

    public static boolean isASMLibInstallConsistent(String[] nodeList, ResultSet asmLibInstallRsltSet, Vector<String> asmLibNotInstallNodes, Vector<String> operationFailedNode) {
        return sVerificationUtil.isASMLibInstallConsistent(nodeList, asmLibInstallRsltSet, asmLibNotInstallNodes, operationFailedNode);
    }

    public static boolean isASMLibConfiguredConsistently(String[] nodeList, ResultSet asmLibconfiguredRsltSet, Vector<String> asmLibInconsistantConfigNodes, Vector<String> operationFailedNode) {
        return sVerificationUtil.isASMLibConfiguredConsistently(nodeList, asmLibconfiguredRsltSet, asmLibInconsistantConfigNodes, operationFailedNode);
    }

    public static String getDomainSocketsDir() {
        if (VerificationUtil.isPlatformAix() || VerificationUtil.isPlatformHp()) {
            return "/tmp/.oracle";
        }
        return "/var/tmp/.oracle";
    }

    public static String getInitTabLoc() {
        return sVerificationUtil.getInitTabLoc();
    }

    public static String getInitdLoc() {
        return sVerificationUtil.getInitdLoc();
    }

    public static boolean isIPV6Host(String hostName) throws CVUException {
        Map addrMap = null;
        try {
            addrMap = IPAddressUtil.resolveHostname((String)hostName);
        }
        catch (IPAddressException ipAddrEx) {
            Trace.out((String)("IPAddressException exception occured while resolving hostname " + hostName + ". Msg " + ipAddrEx.getMessage()));
            throw new CVUException(ipAddrEx);
        }
        return addrMap.containsKey(IPAddressUtil.IPAddrType.IPv6) && !addrMap.containsKey(IPAddressUtil.IPAddrType.IPv4);
    }

    public static boolean isBinaryExistsInsideHome(String homeLoc, String binaryName) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (VerificationUtil.isStringGood(homeLoc)) {
            String binaryPathComplete = homeLoc + File.separator + "bin" + File.separator + nativeSys.getExeName(binaryName);
            File binaryFile = new File(binaryPathComplete);
            if (binaryFile.exists()) {
                Trace.out((String)("The binary file " + binaryName + "  was found inside home location " + homeLoc));
                VerificationLogData.log("The binary file " + binaryName + "  was found inside home location " + homeLoc);
                return true;
            }
            Trace.out((String)("The binary file " + binaryName + "  was not found inside home location " + homeLoc));
            VerificationLogData.log("The binary file " + binaryName + "  was not found inside home location " + homeLoc);
            return false;
        }
        Trace.out((String)"Supplied home location is null or an empty string");
        VerificationLogData.log("Supplied home location is null or an empty string");
        return false;
    }

    public static String printWarningAndRemoveDomainNames(String[] nodeList) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> fqdnNodeList = new ArrayList<String>();
        for (int i = 0; i < nodeList.length; ++i) {
            if (nodeList[i].contains(".")) {
                fqdnNodeList.add(nodeList[i]);
                String[] splitNodeName = nodeList[i].split("\\.");
                if (splitNodeName.length > 0) {
                    nodeList[i] = splitNodeName[0];
                }
            }
            if (sb.length() != 0) {
                sb.append(CLSyntax.DELIMETER);
            }
            sb.append(nodeList[i]);
        }
        if (!fqdnNodeList.isEmpty()) {
            String fqdnNodes = VerificationUtil.strList2List(fqdnNodeList);
            Trace.out((String)("Nodes " + fqdnNodes + " have domain names and hence " + "domain part will be removed for verification"));
            System.out.println(LSEP + s_msgBundle.getMessage("8503", false) + LSEP + s_pMsgBundle.getMessage("1061", false, (Object[])new String[]{fqdnNodes, sb.toString()}));
        }
        return sb.toString();
    }

    public static String[] getNodenamesInLowerCase(String[] nodeList) {
        ArrayList<String> nodeListLower = new ArrayList<String>();
        for (String node : nodeList) {
            node = node.toLowerCase();
            nodeListLower.add(node);
        }
        return nodeListLower.toArray(new String[nodeListLower.size()]);
    }

    public static boolean checkSetUID(String[] nodeList, String filePath, ResultSet resultSet) {
        CommandsUtil cmdUtil = new CommandsUtil();
        GlobalExecution globalExec = new GlobalExecution();
        boolean retVal = true;
        boolean rslt = false;
        String command = cmdUtil.getLs() + " " + LS_OPTIONS + " " + filePath;
        rslt = globalExec.runExe(nodeList, command, resultSet, false);
        Hashtable htable = resultSet.getResultTable();
        Enumeration en = htable.keys();
        if (rslt) {
            while (en.hasMoreElements()) {
                String node = (String)en.nextElement();
                Result result = (Result)htable.get(node);
                if (result.getStatus() != 1) continue;
                Vector resultInfoset = result.getResultInfoSet();
                String[] ping6Info = null;
                String outStr = null;
                String exectaskOutput = null;
                if (resultInfoset.size() <= 1 || (exectaskOutput = (String)resultInfoset.elementAt(1)) == null || !VerificationUtil.fetchVerificationResult(exectaskOutput).equals("0") || !VerificationUtil.isStringGood(outStr = VerificationUtil.fetchVerificationValue(exectaskOutput))) continue;
                Trace.out((String)("LS info for /usr/sbin/ping6 is : " + outStr));
                ping6Info = VerificationUtil.string2strArr(outStr.trim(), " ");
                if (ping6Info[0].charAt(3) == 's') {
                    retVal &= true;
                    continue;
                }
                Trace.out((String)"setuid for /usr/sbin/ping6 was not set");
                VerificationLogData.logError("setuid for /usr/sbin/ping6 was not set");
                String errMsg = s_gMsgBundle.getMessage("11960", true, (Object[])new String[]{filePath, node});
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                resultSet.addResult(node, 3);
                resultSet.addErrorDescription(node, errorDesc);
                ReportUtil.printError(errMsg);
                retVal = false;
            }
        } else {
            Trace.out((String)"Failed in GlobalExec.runexe: ");
            String errMsg = s_gMsgBundle.getMessage("11961", true, (Object[])new String[]{filePath, VerificationUtil.strArr2List(nodeList)});
            resultSet.addResult(nodeList, 2);
            resultSet.addErrorDescription(new ErrorDescription(errMsg));
            ReportUtil.printError(errMsg);
            retVal = false;
        }
        return retVal;
    }

    public static String getMsgWithExecutionDetails(String msg, Result result) {
        if (msg != null && result != null) {
            String cmdDetailsMsg;
            String node = result.getNode();
            String exectaskOutput = result.getExectaskOutput();
            if (VerificationUtil.isStringGood(node) && VerificationUtil.isStringGood(exectaskOutput) && VerificationUtil.isStringGood(cmdDetailsMsg = VerificationUtil.fetchExecutionDetailsMessage(node, exectaskOutput))) {
                return msg + LSEP + cmdDetailsMsg;
            }
        }
        return msg;
    }

    static List<CmdExecInfo> fetchCmdExecInfo(String exectaskOutput) {
        Trace.out((int)1, (String)("exectaskOutput=" + exectaskOutput));
        ArrayList<CmdExecInfo> listCmdExecInfo = new ArrayList<CmdExecInfo>();
        String[] cmdArr = VerificationUtil.fetchTextByTagsRepeat(exectaskOutput, "<CV_CMD>", "</CV_CMD>");
        String[] outputArr = VerificationUtil.fetchTextByTagsRepeat(exectaskOutput, "<CV_CMDOUT>", "</CV_CMDOUT>");
        String[] exitValArr = VerificationUtil.fetchTextByTagsRepeat(exectaskOutput, "<CV_CMDSTAT>", "</CV_CMDSTAT>");
        Trace.out((int)1, (String)("cmdArr=" + VerificationUtil.strArr2List(cmdArr)));
        Trace.out((int)1, (String)("outputArr=" + VerificationUtil.strArr2List(outputArr)));
        Trace.out((int)1, (String)("exitValArr=" + VerificationUtil.strArr2List(exitValArr)));
        if (cmdArr.length != outputArr.length || cmdArr.length != exitValArr.length) {
            Trace.out((String)("APPLICATION ERROR (IGNORED):: Found improper sets of CV_CMD, CV_CMDOUT and CV_CMDSTAT tags'cmdArr.length=" + cmdArr.length + "; outputArr.length=" + outputArr.length + "; exitValArr.length=" + exitValArr.length));
            return listCmdExecInfo;
        }
        for (int i = 0; i < exitValArr.length; ++i) {
            String exitValStr = exitValArr[i];
            try {
                int exitValInt = Integer.parseInt(exitValStr);
                listCmdExecInfo.add(new CmdExecInfo(cmdArr[i], outputArr[i], exitValInt));
                continue;
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("APPLICATION ERROR (IGNORED):: Found a non-numeric value '" + exitValStr + "' for exit Value"));
                return listCmdExecInfo;
            }
        }
        return listCmdExecInfo;
    }

    static List<APIExecInfo> fetchAPIExecInfo(String exectaskOutput) {
        String[] slosEntriesArr;
        Trace.out((int)1, (String)("exectaskOutput=" + exectaskOutput));
        ArrayList<APIExecInfo> listAPIExecInfo = new ArrayList<APIExecInfo>();
        for (String slosEntry : slosEntriesArr = VerificationUtil.fetchTextByTagsRepeat(exectaskOutput, "<CV_ERR>", "</CV_ERR>")) {
            Trace.out((String)("SLOS entry ==>" + LSEP + slosEntry));
            String slosCategory = VerificationUtil.fetchTextByTags(slosEntry, "SLOS_CAT");
            String apiName = VerificationUtil.fetchTextByTags(slosEntry, "SLOS_OP");
            String errorNum = VerificationUtil.fetchTextByTags(slosEntry, "SLOS_DEPINFO");
            String paramValues = VerificationUtil.fetchTextByTags(slosEntry, "SLOS_OTHERINFO");
            String errTxtInEnglish = VerificationUtil.fetchTextByTags(slosEntry, "SLOS_DEPINFOSTR");
            String errTxtInCurrLocale = VerificationUtil.fetchTextByTags(slosEntry, "SLOS_LOCINFOSTR");
            Trace.out((String)("slosCategory=" + slosCategory));
            Trace.out((String)("apiName=" + apiName));
            Trace.out((String)("errorNum=" + errorNum));
            Trace.out((String)("paramValues=" + paramValues));
            Trace.out((String)("errTxtInEnglish=" + errTxtInEnglish));
            Trace.out((String)("errTxtInCurrLocale=" + errTxtInCurrLocale));
            listAPIExecInfo.add(new APIExecInfo(slosCategory, apiName, errorNum, paramValues, errTxtInEnglish, errTxtInCurrLocale));
        }
        return listAPIExecInfo;
    }

    public static String getAFDDriverCommandPath(String giHome) {
        return sVerificationUtil.getAFDDriverCommandPath(giHome);
    }

    public static String getAFDToolCommandPath(String giHome) {
        return sVerificationUtil.getAFDToolCommandPath(giHome);
    }

    public static Hashtable<ShellResourceType, Hashtable<ShellLimitType, String>> getLocalNodeShellLimitsFromCVUSystemProperty() {
        if (m_localNodeShellLimits == null) {
            VerificationUtil.readCVUOSSettingProperty();
        }
        return m_localNodeShellLimits;
    }

    public static String getLocalNodeUmaskFromCVUSystemProperty() {
        if (m_localNodeUmask == null) {
            VerificationUtil.readCVUOSSettingProperty();
        }
        return m_localNodeUmask;
    }

    private static void readCVUOSSettingProperty() {
        if (!m_cvuSysPropRead) {
            String propVal;
            m_cvuSysPropRead = true;
            if (m_localNodeShellLimits == null) {
                m_localNodeShellLimits = new Hashtable();
            }
            if (VerificationUtil.isStringGood(propVal = System.getProperty("CVU_OS_SETTINGS"))) {
                Trace.out((String)("The CVU_OS_SETTINGS system property is set to value (" + propVal + ")"));
                String[] propValuePairs = VerificationUtil.string2strArr(propVal, ",");
                if (propValuePairs != null && propValuePairs.length > 0) {
                    for (String propValPair : propValuePairs) {
                        Hashtable<ShellLimitType, String> valTbl;
                        ShellLimitType limType;
                        ShellResourceType resType;
                        String[] propAndVal = VerificationUtil.string2strArr(propValPair, ":");
                        if (propAndVal == null || propAndVal.length <= 1) continue;
                        String value = propAndVal[1];
                        if ("SHELL_NOFILE_SOFT_LIMIT".equals(propAndVal[0])) {
                            resType = ShellResourceType.MAX_FILEDESC;
                            limType = ShellLimitType.SOFT;
                            if (m_localNodeShellLimits.containsKey((Object)resType)) {
                                m_localNodeShellLimits.get((Object)resType).put(limType, value);
                                continue;
                            }
                            valTbl = new Hashtable<ShellLimitType, String>();
                            valTbl.put(limType, value);
                            m_localNodeShellLimits.put(resType, valTbl);
                            continue;
                        }
                        if ("SHELL_STACK_SOFT_LIMIT".equals(propAndVal[0])) {
                            resType = ShellResourceType.MAX_STACK_SIZE;
                            limType = ShellLimitType.SOFT;
                            if (m_localNodeShellLimits.containsKey((Object)resType)) {
                                m_localNodeShellLimits.get((Object)resType).put(limType, value);
                                continue;
                            }
                            valTbl = new Hashtable();
                            valTbl.put(limType, value);
                            m_localNodeShellLimits.put(resType, valTbl);
                            continue;
                        }
                        if (!"SHELL_UMASK".equals(propAndVal[0])) continue;
                        m_localNodeUmask = value;
                    }
                }
            }
        }
    }

    public static void validateOracleHome(String[] nodeList, String homePath, ResultSet validationRS) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String binOracle = homePath + FSEP + "bin" + FSEP + nativeSys.getExeName("oracle");
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        VerificationUtil.pathExists(nodeList, binOracle, 2, succNodes, failNodes);
        if (succNodes.size() == 0) {
            validationRS.addResult(failNodes, 3);
            String msg = s_gMsgBundle.getMessage("11950", true, (Object[])new String[]{binOracle, homePath});
            validationRS.addErrorDescription(new ErrorDescription(msg));
            return;
        }
        validationRS.addResult(succNodes, 1);
        if (failNodes.size() > 0) {
            validationRS.addResult(failNodes, 3);
            for (Object e : failNodes) {
                String msg = s_gMsgBundle.getMessage("11951", true, (Object[])new String[]{binOracle, String.valueOf(e)});
                validationRS.addErrorDescription(String.valueOf(e), new ErrorDescription(msg));
            }
        }
    }

    public static boolean isInterconnectListDefined() {
        boolean retVal = true;
        if (!VerificationUtil.isCRSConfigured() && CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST) == null) {
            retVal = false;
        }
        return retVal;
    }

    public static void startRemoteExecServer() throws VerificationException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isRemoteExecServerNeeded()) {
            try {
                NativeResult serverResult = new NativeResult();
                String localNode = VerificationUtil.getLocalNode();
                if (!nativeSystem.isRemExecServiceRunning(localNode, serverResult)) {
                    Trace.out((String)"starting remote exec service as it was not running");
                    nativeSystem.startRemoteExecServer(localNode, VerificationUtil.getCVHome(), VerificationUtil.getDestLoc());
                }
                Trace.out((String)"remote exec server is already running");
            }
            catch (NativeException e) {
                Trace.out((String)("nativeSystem.startRemoteExecServer failed with error" + e.getMessage()));
                throw new VerificationException(e.getMessage());
            }
        }
    }

    public static String[] getNodesWith6digitPID(String[] nodeList) {
        String KERNPARAM_PIDMAX_ID = "pid_max";
        ArrayList<String> succNodesLocal = new ArrayList<String>();
        ResultSet knlparamRsltSet = new ResultSet();
        ResultSet configKnlparamRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getKerParam(nodeList, KERNPARAM_PIDMAX_ID, knlparamRsltSet);
        globalExec.getConfigKerParam(nodeList, KERNPARAM_PIDMAX_ID, configKnlparamRsltSet);
        Hashtable t = knlparamRsltSet.getResultTable();
        Enumeration e = t.keys();
        for (String node : nodeList) {
            boolean configuredValueVerified;
            String curVal;
            Object cur = null;
            Object config = null;
            Result currentValueResult = (Result)knlparamRsltSet.getResultTable().get(node);
            Result configValueResult = (Result)configKnlparamRsltSet.getResultTable().get(node);
            if (currentValueResult.getStatus() == 1) {
                curVal = VerificationUtil.getPIDMAXValue(currentValueResult);
                if (!VerificationUtil.isStringGood(curVal)) {
                    Trace.out((String)("FAILED:: Invalid value returned for current param: " + KERNPARAM_PIDMAX_ID + " on node:" + node));
                    continue;
                }
            } else {
                Trace.out((String)("FAILED:: Unable to check value for param: " + KERNPARAM_PIDMAX_ID + " on node:" + node));
                continue;
            }
            boolean currentValueVerified = VerificationUtil.is6DigitPIDSupported(curVal);
            if (configValueResult.getStatus() == 1) {
                String configVal = VerificationUtil.getPIDMAXValue(configValueResult);
                if (VerificationUtil.isStringGood(configVal)) {
                    configuredValueVerified = VerificationUtil.is6DigitPIDSupported(configVal);
                } else {
                    Trace.out((String)("FAILED:: Invalid value returned for configured param: " + KERNPARAM_PIDMAX_ID + " on node:" + node + "configured Value :" + configVal));
                    configuredValueVerified = false;
                }
            } else {
                Trace.out((String)("FAILED:: Unable to check configured value for param: " + KERNPARAM_PIDMAX_ID + " on node:" + node));
                configuredValueVerified = true;
            }
            if (!currentValueVerified || !configuredValueVerified) continue;
            succNodesLocal.add(node);
        }
        int size = succNodesLocal.size();
        return succNodesLocal.toArray(new String[size]);
    }

    private static String getData(String cmdoutput) {
        String zero = new String("0");
        if (cmdoutput.indexOf("=") <= 0) {
            return zero;
        }
        String tval = cmdoutput.split("=")[1];
        return tval.trim();
    }

    private static String getPIDMAXValue(Result ValueResult) {
        Object val = null;
        int resInfoSetSize = ValueResult.getResultInfoSet().size();
        if (resInfoSetSize > 0) {
            val = ValueResult.getResultInfoSet().elementAt(0);
        }
        if (val != null && VerificationUtil.isStringGood(val.toString())) {
            String curVal = VerificationUtil.getData(val.toString());
            try {
                double dCurval = VerificationUtil.parseStringToNumber(curVal);
                return curVal;
            }
            catch (NumberFormatException ne) {
                return null;
            }
        }
        return null;
    }

    private static boolean is6DigitPIDSupported(String value) {
        String KERNPARAM_PIDMAX_MAXVAL = "100000";
        try {
            double dCurval = VerificationUtil.parseStringToNumber(value);
            double dReqval = VerificationUtil.parseStringToNumber(KERNPARAM_PIDMAX_MAXVAL);
            return dCurval >= dReqval;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }

    public static boolean isCVUQDiskAvailable(String[] nodeList, ResultSet resultSet, Task parentTask) {
        TaskPackage taskPackage = new TaskPackage(CVUQDISK_PACKAGE_NAME, "1.0.10-1", null);
        taskPackage.setNodeList(nodeList);
        taskPackage.setMute(true);
        taskPackage.setSeverity(SeverityType.IGNORABLE);
        parentTask.addChildTask(taskPackage);
        taskPackage.perform();
        resultSet.uploadResultSet(taskPackage.getResultSet());
        return resultSet.allSuccess();
    }

    public static void traceAndLogWarning(String message) {
        VerificationUtil.traceAndLogInternal(message, VerificationUtil.getLocationInSource(), 3);
    }

    public static void traceAndLogError(String message) {
        VerificationUtil.traceAndLogInternal(message, VerificationUtil.getLocationInSource(), 4);
    }

    public static void traceAndLog(String message) {
        VerificationUtil.traceAndLogInternal(message, VerificationUtil.getLocationInSource(), 2);
    }

    public static void traceAndLogWarning(String format, Object ... args) {
        VerificationUtil.traceAndLogInternal(String.format(format, args), VerificationUtil.getLocationInSource(), 3);
    }

    public static void traceAndLogError(String format, Object ... args) {
        VerificationUtil.traceAndLogInternal(String.format(format, args), VerificationUtil.getLocationInSource(), 4);
    }

    public static void traceAndLog(String format, Object ... args) {
        VerificationUtil.traceAndLogInternal(String.format(format, args), VerificationUtil.getLocationInSource(), 2);
    }

    private static void traceAndLogInternal(String message, String whereFrom, int level) {
        Trace.out((String)("[" + whereFrom + "] " + message));
        VerificationLogData.log(message, whereFrom, level);
    }

    public static synchronized String getLocationInSource() {
        return VerificationUtil.getLocationInSource(false);
    }

    public static synchronized String getLocationInSource(boolean skipCaller) {
        StackTraceElement stElem;
        int numFramesToSkip;
        Throwable throwable = new Throwable();
        StackTraceElement[] elements = throwable.getStackTrace();
        if (elements.length == 0) {
            return null;
        }
        for (numFramesToSkip = 0; numFramesToSkip < elements.length && elements[numFramesToSkip].getClassName().endsWith("VerificationUtil"); ++numFramesToSkip) {
        }
        if (skipCaller) {
            stElem = elements[numFramesToSkip];
            String packageName = VerificationUtil.extractPackageName(stElem.toString());
            String nameToSkip = stElem.getClassName();
            String string = nameToSkip = nameToSkip.length() > packageName.length() ? nameToSkip.substring(packageName.length() + 1) : nameToSkip;
            if (VerificationUtil.isStringGood(nameToSkip)) {
                while (numFramesToSkip < elements.length && elements[numFramesToSkip].getClassName().endsWith(nameToSkip)) {
                    ++numFramesToSkip;
                }
            }
        }
        stElem = elements[numFramesToSkip];
        String log_info_line = stElem.toString();
        String packageName = VerificationUtil.extractPackageName(log_info_line);
        String className = stElem.getClassName();
        return (className.length() > packageName.length() ? className.substring(packageName.length() + 1) : className) + "." + (stElem.isNativeMethod() ? "Native" : stElem.getMethodName() + ":" + stElem.getLineNumber());
    }

    private static String getStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] elements = throwable.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                sb.append(LSEP + elements[i].toString());
                continue;
            }
            sb.append(elements[i].toString());
        }
        return sb.toString();
    }

    private static String extractPackageName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        int count = st.countTokens();
        StringBuffer buf = new StringBuffer();
        String packagename = null;
        for (int i = 0; i < count - 4; ++i) {
            String newtoken = st.nextToken();
            buf.append(newtoken + ".");
        }
        buf.append(st.nextToken());
        packagename = buf.toString();
        return packagename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CvunetQueryData getCvunetqueryLocation(Result result) {
        String crsctlCmd = null;
        String binLocation = null;
        boolean isCvunetQuery = true;
        CvunetQueryData data = null;
        boolean isUpgrade = VerificationUtil.isUpgrade();
        String[] envPath = null;
        if (!isUpgrade && VerificationUtil.isCRSConfigured()) {
            VerificationUtil.traceAndLog("[getCvunetquery] crs is configure, we use crsctl");
            crsctlCmd = CRSCTL_CMD;
            isCvunetQuery = false;
            binLocation = VerificationUtil.getCRSHome(result.getNode(), result);
            if (binLocation == null) {
                VerificationUtil.traceAndLog("[getCvunetquery] crshome was not found");
                result.setStatus(2);
                return null;
            }
            boolean isCRSRunning = false;
            try {
                ClusterwareInfo clustInfo = new ClusterwareInfo();
                isCRSRunning = clustInfo.isCRSRunning(binLocation);
            }
            catch (InstallException clustInfo) {
            }
            finally {
                if (!isCRSRunning) {
                    VerificationUtil.traceAndLog("[getCvunetquery] crs is not running, we switch to use cvunetquery");
                    crsctlCmd = CRSCTL_LITE_CMD;
                    binLocation = VerificationUtil.getCVHome();
                    isCvunetQuery = true;
                }
            }
        } else {
            VerificationUtil.traceAndLog("[getCvunetquery] crs is not configure, we use cvunetquery, isUpgrade? " + isUpgrade);
            crsctlCmd = CRSCTL_LITE_CMD;
            binLocation = VerificationUtil.getCVHome();
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String liteFullName = nativeSystem.getExeName(crsctlCmd);
        File liteFile = null;
        if (VerificationUtil.isCVUTestEnv()) {
            VerificationUtil.traceAndLog("[getCvunetquery] running from a development environment path " + binLocation);
            liteFile = new File(binLocation + FSEP + "bin" + FSEP + liteFullName);
            if (liteFile.exists()) {
                VerificationUtil.traceAndLog("[getCvunetquery] crsctl/cvunetquery found in " + liteFile.getAbsolutePath());
                binLocation = binLocation + FSEP + "bin" + FSEP;
            } else if (isCvunetQuery) {
                VerificationUtil.traceAndLog("[getCvunetquery] cvunetquery is not in bin, we try in cv/admin");
                binLocation = binLocation + FSEP + "cv" + FSEP + "admin" + FSEP;
            }
        } else {
            liteFile = new File(binLocation + FSEP + "bin" + FSEP + liteFullName);
            if (liteFile.exists()) {
                VerificationUtil.traceAndLog("[getCvunetquery] crsctl/cvunetquery found in " + liteFile.getAbsolutePath());
                binLocation = binLocation + FSEP + "bin" + FSEP;
            } else {
                VerificationUtil.traceAndLog("[getCvunetquery] crsctl/cvunetquery not found in " + liteFile.getAbsolutePath());
                liteFile = new File(binLocation + FSEP + "cv" + FSEP + "admin" + FSEP + liteFullName);
                if (liteFile.exists()) {
                    binLocation = binLocation + FSEP + "cv" + FSEP + "admin" + FSEP;
                    VerificationUtil.traceAndLog("[getCvunetquery] cvunetquery exist in location " + binLocation);
                }
            }
        }
        VerificationUtil.traceAndLog("[getCvunetquery] cvunetquery exist in location " + binLocation);
        String rhp = CVUVariables.getValue("RHP_MOUNT");
        String configOption = CVUVariables.getValue(CVUVariableConstants.POST_SW_INSTALL_API_MODE);
        if (!VerificationUtil.isPlatformWindows() && (rhp != null && rhp.equalsIgnoreCase("TRUE") || configOption != null && configOption.equalsIgnoreCase("TRUE"))) {
            VerificationUtil.traceAndLog("[getCvunetquery] cvunetquery.bin should run");
            envPath = new String[]{"LD_LIBRARY_PATH=" + VerificationUtil.getCVHome() + "/lib"};
            crsctlCmd = "cvunetquery.bin";
        }
        data = new CvunetQueryData(binLocation + crsctlCmd, envPath, isCvunetQuery);
        result.setStatus(1);
        return data;
    }

    public static List<String> resolveIPAddressbyName(String host, boolean isIPv4, Result result) {
        return VerificationUtil.resolveIPAddressbyName(host, null, isIPv4, result);
    }

    public static List<String> resolveIPAddressbyName(String host, String server, boolean isIPv4, Result result) {
        ErrorDescription errorDesc;
        String errMsg;
        List<String> listIPs = null;
        CvunetQueryData locationAndEnv = null;
        String queryType = isIPv4 ? "A" : "AAAA";
        String cmdError = null;
        String binLocation = null;
        String[] envPath = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        locationAndEnv = VerificationUtil.getCvunetqueryLocation(result);
        if (result.getStatus() == 1) {
            binLocation = locationAndEnv.getLocation();
            envPath = locationAndEnv.getEnv();
            if (!nativeSystem.isUnixSystem() && locationAndEnv.isCvunetquery()) {
                envPath = new String[]{"PATH=" + System.getenv("PATH")};
            }
        } else {
            result.setStatus(2);
            return null;
        }
        String cmd = binLocation + QUERY_COMMAND + host + QUERY_COMMAND_TYPE + queryType;
        if (server != null) {
            cmd = cmd + QUERY_COMMAND_SERVER + server;
        }
        cmdError = cmd;
        if (!locationAndEnv.isCvunetquery()) {
            cmd = cmd + QUERY_COMMAND_CVUFORMAT;
        }
        Trace.out((String)("executing crsct/cvunetquery with " + cmd));
        VerificationCommand[] queryCmd = new VerificationCommand[1];
        String[] args = new String[]{"-rungencmd", cmd};
        CommandResult cmdResult = new CommandResult();
        queryCmd[0] = new VerificationCommand(m_localHostName, args, envPath, (NativeResult)cmdResult);
        Trace.out((String)("about to submit query cmd : " + cmd));
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])queryCmd, 0, rs);
        Result resultCmd = queryCmd[0].getResult();
        String output = null;
        if (resultCmd.getStatus() == 1) {
            output = queryCmd[0].getOutput();
        } else {
            String[] outputArr = cmdResult.getOutputString();
            String tmpStr = VerificationUtil.strArr2String(outputArr, LSEP);
            output = VerificationUtil.fetchVerificationValue(tmpStr);
        }
        if (output == null || output.length() == 0) {
            Trace.out((String)"Error retreiving output of crsctl/cvunetquery command");
            errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{cmdError, m_localHostName});
            errorDesc = new ErrorDescription(errMsg);
            result.addErrorDescription(errorDesc);
            result.setStatus(2);
            return null;
        }
        if (output.indexOf(CRSTXT_SUC) == -1) {
            errMsg = null;
            errMsg = VerificationUtil.getCRSErrorMessage(output);
            if (!VerificationUtil.isStringGood(errMsg)) {
                errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{cmd, m_localHostName, output});
            }
            errorDesc = new ErrorDescription(errMsg);
            result.addErrorDescription(errorDesc);
            result.setStatus(3);
            return null;
        }
        String[] resultQuery = VerificationUtil.fetchTextByTagsRepeat(output, TAG_ARG_START, TAG_ARG_END);
        if (isIPv4) {
            listIPs = Arrays.asList(resultQuery[0].split(" "));
        } else {
            if (resultQuery[0] == null) {
                result.setStatus(3);
                return null;
            }
            listIPs = new ArrayList<String>();
            for (String strIp : VerificationUtil.string2strArr(resultQuery[0], " ")) {
                listIPs.add(strIp.replaceAll("[\\[\\]]", ""));
            }
        }
        result.setStatus(1);
        return listIPs;
    }

    public static String getCRSErrorMessage(String output) {
        Object[] argArr = null;
        String crsErrMsg = null;
        if (VerificationUtil.isStringGood(output)) {
            if (output.indexOf(ERRTXT_10035) != -1 || output.indexOf(ERRTXT_10048) != -1) {
                int beginIndex = output.indexOf(TXT_MSG_NUM_START) + TXT_MSG_NUM_START.length();
                String msgNumStr = output.substring(beginIndex, beginIndex + 5).trim();
                argArr = VerificationUtil.fetchTextByTagsRepeat(output, TAG_ARG_START, TAG_ARG_END);
                crsErrMsg = s_gMsgBundle.getMessage(msgNumStr, true, argArr);
            } else if (output.indexOf(ERRTXT_10038) != -1) {
                crsErrMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"Invalid IP address"});
            } else if (output.indexOf(ERRTXT_10047) != -1) {
                crsErrMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"Invalid query type"});
            }
        }
        return crsErrMsg;
    }

    public static boolean isSolarisGlobalZone(String[] nodeList, ResultSet resultSet) {
        String[] globalZoneNodes = sVerificationUtil.filterSolarisZoneNodes(nodeList, true, resultSet);
        return Arrays.asList(globalZoneNodes).containsAll(Arrays.asList(nodeList));
    }

    public static String[] getSolarisNonGlobalZoneNodes(String[] nodeList, ResultSet resultSet) {
        return sVerificationUtil.filterSolarisZoneNodes(nodeList, false, resultSet);
    }

    public static boolean isSolarisKernelZone(String[] nodeList, ResultSet resultSet) {
        return sVerificationUtil.isSolarisKernelZone(nodeList, resultSet);
    }

    public static String[] filterLeafNodeList(String[] nodeList) {
        HashSet<String> nodeListToReturn = new HashSet<String>();
        try {
            NodeManager nodeMgr = NodeManagerFactory.getInstance().getNodeManager();
            if (nodeMgr.isBigCluster()) {
                Trace.out((String)"Checking for LEAF nodes");
                String[] leafNodes = nodeMgr.getConfiguredRimNodes(nodeList);
                if (leafNodes != null) {
                    for (String leaf : leafNodes) {
                        nodeListToReturn.add(leaf);
                    }
                }
            }
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("IGNORED : NODEMANAGEREXCEPTION: " + nmEx.getMessage()));
        }
        return nodeListToReturn.toArray(new String[0]);
    }

    public static String[] filterHubNodeList(String[] nodeList) {
        HashSet<String> nodeListForNodeAdd = new HashSet<String>();
        String[] returnNodeList = nodeListForNodeAdd.toArray(new String[0]);
        Trace.out((String)("nodeList: " + VerificationUtil.strArr2List(nodeList)));
        try {
            NodeManager nodeMgr = NodeManagerFactory.getInstance().getNodeManager();
            if (nodeMgr.isBigCluster()) {
                Trace.out((String)"Checking for HUB nodes");
                String[] hubNodes = nodeMgr.getConfiguredHubNodes(nodeList);
                if (hubNodes != null) {
                    for (String hub : hubNodes) {
                        nodeListForNodeAdd.add(hub);
                    }
                }
                Trace.out((int)1, (String)("Configured HUB nodes: " + ((Object)nodeListForNodeAdd).toString()));
                returnNodeList = nodeListForNodeAdd.toArray(new String[0]);
                Trace.out((String)"Checking for NEW HUB nodes");
                String[] newHubNodes = nodeMgr.getNewConfiguredHubNodes(nodeList);
                if (newHubNodes != null) {
                    for (String newHub : newHubNodes) {
                        nodeListForNodeAdd.add(newHub);
                    }
                }
            } else {
                return VerificationUtil.addLocalNodeToNodeList(nodeList);
            }
            Trace.out((int)1, (String)("Configured HUB, and NEWHUB nodes: " + ((Object)nodeListForNodeAdd).toString()));
            returnNodeList = nodeListForNodeAdd.toArray(new String[0]);
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("IGNORED : NODEMANAGEREXCEPTION: " + nmEx.getMessage()));
        }
        return returnNodeList;
    }

    public static String[] addLocalNodeToNodeList(String[] nodeList) {
        String localNode = VerificationUtil.getLocalNode();
        HashSet<String> nodeListForNodeAdd = new HashSet<String>();
        if (VerificationUtil.isStringGood(localNode)) {
            nodeListForNodeAdd.add(localNode);
        }
        if (nodeList != null) {
            for (String nodeToAdd : nodeList) {
                nodeListForNodeAdd.add(nodeToAdd);
            }
        }
        return nodeListForNodeAdd.toArray(new String[0]);
    }

    public static String[] filterCRSConfiguredNodes(String[] nodeList) {
        HashSet<String> nodesWithCRSConfigured = new HashSet<String>();
        ClusterwareInfo ci = new ClusterwareInfo();
        if (nodeList != null) {
            for (String nodeToAdd : nodeList) {
                try {
                    if (!ci.isCRSConfiguredOnNode(nodeToAdd)) continue;
                    nodesWithCRSConfigured.add(nodeToAdd);
                }
                catch (InstallException e) {
                    Trace.out((String)("Caught InstallException, Error is " + e.getMessage()));
                }
            }
        }
        return nodesWithCRSConfigured.toArray(new String[0]);
    }

    public static void logNetworkInterfaces(Set<NetworkInfo> networks) {
        if (!NetworkUtility.isNetworksSetGood(networks)) {
            Trace.out((String)"Invalid cluster networks");
            return;
        }
        for (NetworkInfo network : networks) {
            String networkType;
            String subnetId;
            String networkName = network.getInterfaceName();
            if (!VerificationUtil.isStringGood(networkName)) {
                networkName = "*";
            }
            if (!VerificationUtil.isStringGood(subnetId = network.getSubnetAsString())) {
                subnetId = "*";
            }
            if (!VerificationUtil.isStringGood(networkType = network.getNetworkTypeAsString())) {
                networkType = "UNKNWON";
            }
            Trace.out((String)("'\"" + networkName + "\"" + ":" + subnetId + ":" + networkType + "'"));
        }
    }

    public static void getUserGroups(String[] nodeList, String username, Hashtable<String, String> primaryGroupMap, Hashtable<String, List<String>> groupMap, ResultSet getGroupResultSet) {
        GlobalExecution globalExec = new GlobalExecution();
        Trace.out((String)"about to run command to get groups");
        globalExec.getUserGroups(nodeList, username, getGroupResultSet);
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        boolean isUnixSystem = nativeSys.isUnixSystem();
        Hashtable ht = getGroupResultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                Trace.out((String)("get groups successful on node " + node));
                String primaryGroup = (String)result.getResultInfoSet().get(0);
                String[] groupArray = (String[])result.getResultInfoSet().get(1);
                List<String> groupList = Arrays.asList(groupArray);
                Trace.out((String)("adding " + primaryGroup + " as primary group"));
                if (isUnixSystem) {
                    primaryGroupMap.put(node, primaryGroup);
                }
                Trace.out((String)("adding " + VerificationUtil.strArr2String(groupArray, ",") + " as user's groups"));
                groupMap.put(node, groupList);
                continue;
            }
            if (result.getStatus() == 3) {
                Trace.out((String)("user " + username + "doesn't exit on the node " + node));
                errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7537", true, (Object[])new String[]{username, node}), result));
                getGroupResultSet.addErrorDescription(node, errDesc);
                continue;
            }
            Trace.out((String)("couldn't determine " + username + "'s group on node " + node));
            errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_gMsgBundle.getMessage("7505", true, (Object[])new String[]{username, node}), result));
            getGroupResultSet.addErrorDescription(node, errDesc);
        }
    }

    public static String getClusterType() {
        String clusterType = "";
        try {
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            clusterType = clustInfo.getClusterType();
            Trace.out((String)("clusterType[" + clusterType + "]"));
            return clusterType;
        }
        catch (InstallException ie) {
            Trace.out((String)"Caught InstallException");
            VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
            return clusterType;
        }
    }

    public static String getOracleBase() {
        String oracleBase = null;
        String orabaseExe = new SystemFactory().CreateSystem().getExeName("orabase");
        String orabasePath = VerificationUtil.getCVHome() + "bin" + FSEP + orabaseExe;
        Trace.out((String)"looking for ORACLE_BASE");
        String[] output = null;
        String[] cmd = new String[]{orabasePath};
        RuntimeExec rt = new RuntimeExec(cmd, null, null);
        rt.runCommand();
        String[] error = rt.getError();
        output = rt.getOutput();
        if (rt.getExitValue() == 0 && (error == null || error.length == 0) && output != null && output.length == 1) {
            oracleBase = output[0];
        }
        return oracleBase;
    }

    public static boolean isSubsetPath(String path1, String path2) {
        String p2;
        String p1 = path1.endsWith(FSEP) ? path1.substring(0, path1.lastIndexOf(FSEP)) : path1;
        if (p1.equals(p2 = path2.endsWith(FSEP) ? path2.substring(0, path2.lastIndexOf(FSEP)) : path2)) {
            return false;
        }
        if (!p2.startsWith(p1)) {
            return false;
        }
        return p1.lastIndexOf(FSEP) != p2.lastIndexOf(FSEP);
    }

    public static List<String> filterLinuxContainerNodes(String[] nodeList, ResultSet resultSet) {
        return sVerificationUtil.filterLinuxContainerNodes(nodeList, resultSet);
    }

    public static boolean isVirtualEnvironment() {
        if (!m_isVirtualEnvChecked) {
            m_isVirtualEnv = sVerificationUtil.isVirtualEnvironment();
            m_isVirtualEnvChecked = true;
        }
        return m_isVirtualEnv;
    }

    public static String getDefaultInventoryConfigFilePointer() {
        return sVerificationUtil.getInventoryConfigFilePointer();
    }

    public static boolean isOPC() {
        try {
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            boolean isOPCHost = clustInfo.isOPCHost();
            Trace.out((String)("Running on OPC?: " + isOPCHost));
            return isOPCHost;
        }
        catch (InstallException e) {
            Trace.out((String)("Install exception while trying to determine if OPC: " + e.getMessage()));
            return false;
        }
    }

    public static boolean isODAEnv() {
        boolean isODAEnv = sVerificationUtil.isODASystem();
        Trace.out((String)("is ODA environment ?: " + isODAEnv));
        return isODAEnv;
    }

    public static boolean isODALiteEnv() {
        ClusterwareInfo clusterInfo = new ClusterwareInfo();
        boolean isODALiteEnv = clusterInfo.isODALiteEnv_lightweight();
        Trace.out((String)("is ODA Lite environment ?: " + isODALiteEnv));
        return isODALiteEnv;
    }

    public static boolean isODASingleIPEnv() {
        ClusterwareInfo clusterInfo = new ClusterwareInfo();
        boolean isODASingleIPEnv = clusterInfo.isODASingleIPEnv_lightweight();
        Trace.out((String)("is ODA Single IP environment ?: " + isODASingleIPEnv));
        return isODASingleIPEnv;
    }

    public static String getLongestExistingParentPath(String[] nodeList, String path, boolean isWritableToBeChecked) {
        String parentPath = "";
        int pathLength = 10000;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet pathRsltSet = new ResultSet();
        HashMap<String, String> nodePath = new HashMap<String, String>();
        boolean cmdResult = false;
        boolean anyFailure = false;
        cmdResult = globalExec.getLongestValidPath(nodeList, path, isWritableToBeChecked, pathRsltSet);
        if (cmdResult) {
            Hashtable ht = pathRsltSet.getResultTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result pathResult = (Result)ht.get(node);
                if (pathResult.getStatus() == 1) {
                    String longestPath = (String)pathResult.getResultInfoSet().firstElement();
                    nodePath.put(node, longestPath);
                    Trace.out((String)("Longest valid path on node " + node + " is " + longestPath));
                    continue;
                }
                Trace.out((String)("failed to retrieve the longest valid path on node " + node));
                anyFailure = true;
            }
            if (!anyFailure) {
                for (String validPath : nodePath.values()) {
                    if (validPath.length() >= pathLength) continue;
                    pathLength = validPath.length();
                    parentPath = validPath;
                }
                Trace.out((String)("Longest existing parent path is " + parentPath));
            } else {
                Trace.out((String)"Failure occurred on atleast one node while retrieving longest existing parent path ");
            }
            return parentPath;
        }
        Trace.out((String)("Failed to get the longest valid path from the given path " + path));
        return parentPath;
    }

    public static ErrorDescription nlsTagsToErrorDescription(String nlsMsg, boolean displayFac) {
        ErrorDescription errDesc;
        Trace.out((String)("nlsMsg: '" + nlsMsg + "'"));
        String PRVG_STR = "PRVG";
        String CMD_OUTPUT_STR = "2034";
        String facility = VerificationUtil.fetchTextByTags(nlsMsg, "<FACILITY>", "</FACILITY>");
        String idStr = VerificationUtil.fetchTextByTags(nlsMsg, "<ID>", "</ID>");
        String msgData = VerificationUtil.fetchTextByTags(nlsMsg, "<MSG_DATA>", "</MSG_DATA>");
        Object[] data = null;
        if (msgData != null) {
            data = VerificationUtil.fetchTextByTagsRepeat(msgData, "<DATA>", "</DATA>");
        }
        String errMsg = nlsMsg;
        Trace.out((String)("facility=" + facility + "; idStr=" + idStr + "; data=" + VerificationUtil.strArr2String((String[])data)));
        if (facility != null && idStr != null) {
            MessageBundle msgBundle = VerificationUtil.getMessageBundle(facility);
            if (msgBundle != null) {
                errMsg = data != null && data.length >= 1 ? msgBundle.getMessage(idStr, displayFac, data) : msgBundle.getMessage(idStr, displayFac);
                if (PRVG_STR.equalsIgnoreCase(facility) && CMD_OUTPUT_STR.equalsIgnoreCase(idStr) && data != null && data.length > 3) {
                    for (int i = 3; i < data.length; ++i) {
                        errMsg = errMsg + LSEP + (String)data[i];
                    }
                }
                if (displayFac) {
                    String cause = msgBundle.getCause(idStr, false);
                    String action = msgBundle.getAction(idStr, false);
                    Trace.out((String)("errMsg=" + errMsg + LSEP + "cause=" + cause + LSEP + "action=" + action));
                    errDesc = new ErrorDescription(errMsg, cause, action);
                } else {
                    errDesc = new ErrorDescription(errMsg);
                }
            } else {
                Trace.out((String)("Couldn't get message bundle for facility: '" + facility + "'"));
                errMsg = s_msgBundle.getMessage("0015", false, (Object[])new String[]{facility});
                String cause = msgBundle.getCause("0015", false);
                String action = msgBundle.getAction("0015", false);
                errDesc = new ErrorDescription(errMsg, cause, action);
            }
        } else {
            errDesc = new ErrorDescription(nlsMsg);
        }
        return errDesc;
    }

    public static synchronized void clearCache() {
        Trace.out((String)"Clearing cached network details on all the nodes");
        NetworkDataDiscovery.clearCache();
    }

    public static boolean isPostW2K12() {
        if (VerificationUtil.isPlatformWindows() && !m_winVersionChecked) {
            String curVer = System.getProperty("os.version");
            if (VerificationUtil.isStringGood(curVer) && Float.parseFloat(curVer) >= 6.2f) {
                Trace.out((String)"Current windows version is post W2k12 release");
                m_isPostW2K12 = true;
            }
            m_winVersionChecked = true;
        }
        return m_isPostW2K12;
    }

    public static String getCurrentDateAndTimeString() {
        return VerificationUtil.getDateAndTimeString(Calendar.getInstance());
    }

    public static String getDateAndTimeString(Calendar instance) {
        if (instance != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss:SSS");
            return formatter.format(instance.getTime());
        }
        return null;
    }

    public static String getElapsedTime(Calendar begin, Calendar end) {
        StringBuffer buffer = new StringBuffer();
        if (begin != null && end != null) {
            long diff = end.getTimeInMillis() - begin.getTimeInMillis();
            long days = TimeUnit.MILLISECONDS.toDays(diff);
            long hours = TimeUnit.MILLISECONDS.toHours(diff);
            long minutes = TimeUnit.MILLISECONDS.toMinutes(diff) % TimeUnit.HOURS.toMinutes(1L);
            long seconds = TimeUnit.MILLISECONDS.toSeconds(diff) % TimeUnit.MINUTES.toSeconds(1L);
            long milliseconds = diff - (days * 86400000L + hours * 3600000L + minutes * 60000L + seconds * 1000L);
            if (days > 0L) {
                buffer.append(days + " Days");
            }
            if (hours > 0L) {
                buffer.append((buffer.toString().isEmpty() ? "" : " ") + hours + " Hours");
            }
            if (minutes > 0L) {
                buffer.append((buffer.toString().isEmpty() ? "" : " ") + minutes + " Minutes");
            }
            if (seconds > 0L) {
                buffer.append((buffer.toString().isEmpty() ? "" : " ") + seconds + " Seconds");
            }
            if (milliseconds > 0L) {
                buffer.append((buffer.toString().isEmpty() ? "" : " ") + milliseconds + " Milliseconds");
            }
        }
        return buffer.toString();
    }

    public static int getDefaultPingMaxTimeout() {
        return VDMUtil.getDefaultPingTimeOut();
    }

    public static List<String> checkSharedFileSystemPath(String pathName, String[] nodeList) throws VerificationException, InvalidPathException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(pathName);
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        Result result = new Result(m_localNode);
        String crsHome = VerificationUtil.getCRSHome(m_localNode, result);
        try {
            return clustInfo.checkSharedFileSystemPath(pathName, m_localNode, nodeList, crsHome);
        }
        catch (InvalidNodeListException inle) {
            Trace.out((String)("Caught InvalidNodeListException : error is " + inle.getMessage()));
            throw new VerificationException(inle);
        }
        catch (SharedDeviceException sde) {
            Trace.out((String)("Caught SharedDeviceException : error is " + sde.getMessage()));
            throw new VerificationException(sde);
        }
        catch (InstallException ie) {
            String errMsg = ie.getMessage();
            Trace.out((String)("Caught InstallException : error is " + errMsg));
            NativeSystem nativeSys = new SystemFactory().CreateSystem();
            String activeVersion = VerificationUtil.getCRSActiveVersion();
            if (!nativeSys.isUnixSystem() && activeVersion != null && activeVersion.startsWith("11.2.0.2")) {
                Trace.out((String)"Windows NT 11.2.0.2, checking exception message");
                if (errMsg.indexOf("CLSU-00100") != -1 && errMsg.indexOf("CLSU-00103") != -1 && errMsg.indexOf("CLSU-00101") != -1 && errMsg.indexOf("ACFS-00513") != -1) {
                    Trace.out((String)"ignoring ie");
                    return new ArrayList<String>();
                }
            }
            throw new VerificationException(ie);
        }
    }

    public static ResultSet verifyFrameworkSetup(String[] nodeList) throws VerificationException {
        String destLoc;
        ResultSet resultSet = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Collection<String> nodesToCheckDestLoc = VerificationUtil.getFrameworkSetupNotCheckedNodes(nodeList, succNodes, resultSet);
        if (nodesToCheckDestLoc.isEmpty()) {
            return resultSet;
        }
        String[] nodesToBeChecked = nodesToCheckDestLoc.toArray(new String[0]);
        String[] equivNodes = VerificationUtil.isLocalNodeOperation() ? nodesToBeChecked : VerificationUtil.getUserEquivalentNodes(nodesToBeChecked, resultSet);
        if (equivNodes != null && equivNodes.length > 1 && VerificationUtil.isStringGood(destLoc = VerificationUtil.getDestLoc())) {
            try {
                List<String> destLocSharedNode = VerificationUtil.checkSharedFileSystemPath(destLoc, equivNodes);
                if (destLocSharedNode.size() > 0) {
                    throw new VerificationException(s_gMsgBundle.getMessage("1560", true, (Object[])new String[]{destLoc, VerificationUtil.strList2List(destLocSharedNode)}));
                }
            }
            catch (InvalidPathException ipe) {
                Trace.out((String)("Caught InvalidPathException, Error is " + ipe.getMessage()));
                throw new VerificationException(ipe);
            }
        }
        if (equivNodes != null) {
            VerificationUtil.checkDestLoc(equivNodes, resultSet, succNodes, failNodes, true);
        }
        m_nodesWithFrameworkSetup.addAll(succNodes);
        return resultSet;
    }

    public static Collection<String> getNodesWithFrameworkSetup() {
        return m_nodesWithFrameworkSetup;
    }

    public static Collection<String> getFrameworkSetupNotCheckedNodes(String[] nodeList, Collection<String> nodesWithFrameworkSetup, ResultSet resultSet) {
        HashSet<String> nodesForFrameworkSetup = new HashSet<String>();
        nodesWithFrameworkSetup.clear();
        if (resultSet == null) {
            resultSet = new ResultSet();
        }
        if (nodeList == null || nodeList.length == 0) {
            return nodesForFrameworkSetup;
        }
        VerificationUtil.traceAndLog("Input nodelist: " + VerificationUtil.strArr2List(nodeList));
        if (m_nodesWithFrameworkSetup.isEmpty()) {
            VerificationUtil.traceAndLog("Framework setup cache is empty..perform setup check on all the nodes");
            Collections.addAll(nodesForFrameworkSetup, nodeList);
            return nodesForFrameworkSetup;
        }
        VerificationUtil.traceAndLog("Previously cached nodes " + VerificationUtil.strCollection2String(m_nodesWithFrameworkSetup));
        if (m_nodesWithFrameworkSetup.containsAll(Arrays.asList(nodeList))) {
            VerificationUtil.traceAndLog("Input nodelist: " + VerificationUtil.strArr2List(nodeList) + " is already " + "checked for framework setup successfully and is cached..");
            nodesWithFrameworkSetup.addAll(Arrays.asList(nodeList));
            resultSet.addResult(nodeList, 1);
            return nodesForFrameworkSetup;
        }
        for (String node : nodeList) {
            if (!m_nodesWithFrameworkSetup.contains(node)) {
                nodesForFrameworkSetup.add(node);
                continue;
            }
            nodesWithFrameworkSetup.add(node);
        }
        if (!nodesWithFrameworkSetup.isEmpty()) {
            resultSet.addResult(nodesWithFrameworkSetup, 1);
        }
        return nodesForFrameworkSetup;
    }

    public static void resetFrameworkSetupCache() {
        VerificationUtil.traceAndLog("Clearing the framework setup cache.");
        m_nodesWithFrameworkSetup.clear();
    }

    public static boolean isHAIPSupported() {
        return sVerificationUtil.isHAIPSupported();
    }

    static {
        s_preReqXmlRepos = Collections.synchronizedMap(new HashMap());
        s_genericPreReqXmlFile = null;
        s_cvuLogFile = null;
        m_crsHomeChecked = false;
        m_isODASystemChecked = false;
        s_releaseVersionMap = Collections.synchronizedMap(new HashMap());
        s_secVariable = new HashSet<String>(Arrays.asList("DB_PWD", VerificationAPIConstants.VAR_HOME_USER_PASSWORD));
        m_adminGroups = null;
        m_getAdminGroups = false;
        m_getRACGroups = false;
        m_groupExceptionReported = false;
        m_asmAdminGroup = null;
        m_asmOperGroup = null;
        m_asmDbaGroup = null;
        m_osAsmGroup = null;
        m_osOperGroup = null;
        m_osDbaGroup = null;
        m_osBackupDBAGroup = null;
        m_osDgDBAGroup = null;
        m_osKmDBAGroup = null;
        m_osRACDBAGroup = null;
        m_groupPrivilegesMap = new HashMap<String, Set<String>>();
        m_localNodeShellLimits = null;
        m_localNodeUmask = null;
        m_cvuSysPropRead = false;
        PASSWORD_VAR_NAME_PATTERN = Pattern.compile(".*pwd.*|.*password.*|.*passwd.*", 2);
        m_isLocalNodeCRSConfigured = null;
        m_isLocalNodeHAConfigured = null;
        m_isPostW2K12 = false;
        m_winVersionChecked = false;
        m_isVirtualEnvChecked = false;
        m_isVirtualEnv = false;
        m_nodesWithFrameworkSetup = new HashSet();
        m_localHostInitialized = false;
        m_localNodeInitialized = false;
    }

    private static class APIExecInfo {
        private String m_slosCategory;
        private String m_apiName;
        private String m_errorNum;
        private String m_otherInfo;
        private String m_errTxtInEnglish;
        private String m_errTxtInCurrLocale;

        APIExecInfo(String slosCategory, String apiName, String errorNum, String otherInfo, String errTxtInEnglish, String errTxtInCurrLocale) {
            this.m_slosCategory = slosCategory;
            this.m_apiName = apiName;
            this.m_errorNum = errorNum;
            this.m_otherInfo = otherInfo;
            this.m_errTxtInEnglish = errTxtInEnglish;
            this.m_errTxtInCurrLocale = errTxtInCurrLocale;
        }

        String getSlosCategory() {
            return this.m_slosCategory;
        }

        String getApiName() {
            return this.m_apiName;
        }

        String getErrorNum() {
            return this.m_errorNum;
        }

        String getOtherInfo() {
            return this.m_otherInfo;
        }

        String getErrTxtInEnglish() {
            return this.m_errTxtInEnglish;
        }

        String getErrTxtInCurrLocale() {
            return this.m_errTxtInCurrLocale;
        }
    }

    private static class CmdExecInfo {
        private String m_cmd;
        private String m_output;
        private int m_exitVal;

        CmdExecInfo(String cmd, String output, int exitVal) {
            this.m_cmd = cmd;
            this.m_output = output;
            this.m_exitVal = exitVal;
            Trace.out((String)(VerificationConstants.LSEP + "m_cmd=" + this.m_cmd + VerificationConstants.LSEP + "m_output=" + this.m_output + VerificationConstants.LSEP + "m_exitVal=" + this.m_exitVal));
        }

        String getCmd() {
            return this.m_cmd;
        }

        String getOutput() {
            return this.m_output;
        }

        int getExitVal() {
            return this.m_exitVal;
        }
    }
}

