/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RemoteExecFileList {
    private List<FilePath> m_listOfFiles = null;
    private static String m_localNodeName = null;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public RemoteExecFileList(List<FilePath> completeListOfFiles) {
        this.m_listOfFiles = completeListOfFiles;
    }

    public void addFile(FilePath filePath) {
        this.m_listOfFiles.add(filePath);
    }

    public void copyFiles(String destLocation) throws VerificationException, InvalidPathException, ClusterException {
        this.copyFiles("localnode", destLocation);
    }

    private static String getLocalNodeName() throws VerificationException {
        if (!VerificationUtil.isStringGood(m_localNodeName)) {
            try {
                m_localNodeName = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                m_localNodeName = VerificationUtil.getLocalNode();
            }
        }
        return m_localNodeName;
    }

    public void copyFiles(String node, String destLocation) throws VerificationException, InvalidPathException, ClusterException {
        RemoteExecFileList.assertNode(node);
        boolean isLocalExecution = "localnode".equals(node.trim()) ? true : RemoteExecFileList.getLocalNodeName().equals(node);
        boolean destLocExists = true;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Trace.out((String)"Verify if destLoc exists & is writable");
        try {
            destLocExists = nativeSystem.pathExists(isLocalExecution ? "localnode" : node, destLocation, 4);
        }
        catch (RemoteDirException rse) {
            destLocExists = false;
            Trace.out((String)("Exception while checking for existance of dir " + node + ":" + destLocation));
            Trace.out((Exception)((Object)rse));
            throw rse;
        }
        if (!destLocExists) {
            Trace.out((String)("DestLoc doesn't exist, trying to create " + node + ":" + destLocation));
            RemoteExecFileList.createDirectoryOnNode(node, destLocation, isLocalExecution);
        }
        for (FilePath path : this.m_listOfFiles) {
            this.createSubDirectories(node, path, destLocation, isLocalExecution);
            if (path.isDirectoryPath()) continue;
            this.copyFileToNode(node, path, destLocation, isLocalExecution);
        }
    }

    private void createSubDirectories(String node, FilePath path, String destLocation, boolean isLocalExecution) throws ClusterException, VerificationException {
        Trace.out((String)"ENTRY - Creating required sub directories");
        String dirToCreate = destLocation.endsWith(VerificationConstants.FILE_SEPARATOR) ? destLocation : destLocation + VerificationConstants.FILE_SEPARATOR;
        for (String dirName : path.getSubDirectoryList()) {
            dirToCreate = dirToCreate + dirName + VerificationConstants.FILE_SEPARATOR;
            Trace.out((String)("Creating Directory " + dirToCreate));
            RemoteExecFileList.createDirectoryOnNode(node, dirToCreate, isLocalExecution);
        }
    }

    private void copyFileToNode(String node, FilePath path, String destLocPath, boolean isLocalExecution) throws ClusterException, InvalidPathException, VerificationException {
        if (path.isDirectoryPath()) {
            return;
        }
        String destPath = destLocPath.endsWith(VerificationConstants.FILE_SEPARATOR) ? destLocPath : destLocPath + VerificationConstants.FILE_SEPARATOR;
        destPath = destPath + path.getDestinationPath();
        Trace.out((String)("Copying file " + path.getSourcePath() + " to node " + (isLocalExecution ? RemoteExecFileList.getLocalNodeName() : node) + " at path " + destPath));
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String copyResult = nativeSystem.copyFile("localnode", path.getSourcePath(), isLocalExecution ? "localnode" : node, destPath);
        Trace.out((String)("copyResult= " + copyResult));
        CommandResult cmdResult = new CommandResult(copyResult);
        boolean fileCopied = cmdResult.getStatus();
        if (!fileCopied) {
            if (nativeSystem.pathExists(isLocalExecution ? "localnode" : node, destPath, 2)) {
                Trace.out((String)("File " + destPath + " already exists on node " + (isLocalExecution ? RemoteExecFileList.getLocalNodeName() : node + " and does not have write permissions and hence ignoring the copy errors")));
            } else {
                Trace.out((String)("Failed to copy from " + path.getSourcePath() + " to " + destPath + " on " + (isLocalExecution ? RemoteExecFileList.getLocalNodeName() : node)));
                String errMsg = s_msgBundle.getMessage("1108", true, (Object[])new String[]{path.getSourcePath(), RemoteExecFileList.getLocalNodeName(), destPath, isLocalExecution ? RemoteExecFileList.getLocalNodeName() : node, cmdResult.getErrorString()});
                throw new ClusterException(errMsg);
            }
        }
    }

    public static void removeDirectory(String directoryPath) throws ClusterException, VerificationException {
        RemoteExecFileList.removeDirectoryOnNode("localnode", directoryPath, true);
    }

    public static void removeDirectoryOnNode(String node, String directoryPath, boolean isLocalExecution) throws ClusterException, VerificationException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String retStr = nativeSystem.removeDirRecurse(isLocalExecution ? "localnode" : node, directoryPath);
        CommandResult cmdResult = new CommandResult(retStr);
        boolean rmdirSucc = cmdResult.getStatus();
        if (!rmdirSucc) {
            Trace.out((String)("Unable to remove directory on " + node + ":" + directoryPath));
            Trace.out((String)("retStr=" + retStr));
            String errMsg = s_msgBundle.getMessage("1111", true, (Object[])new String[]{directoryPath, isLocalExecution ? RemoteExecFileList.getLocalNodeName() : node, cmdResult.getErrorString()});
            throw new ClusterException(errMsg);
        }
    }

    public static void createDirectory(String directoryPath) throws ClusterException, VerificationException {
        RemoteExecFileList.createDirectoryOnNode("localnode", directoryPath, true);
    }

    public static void createDirectoryOnNode(String node, String directoryPath, boolean isLocalExecution) throws ClusterException, VerificationException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String retStr = nativeSystem.createDirRecurse(isLocalExecution ? "localnode" : node, directoryPath);
        CommandResult cmdResult = new CommandResult(retStr);
        boolean mkdirSucc = cmdResult.getStatus();
        if (!mkdirSucc) {
            Trace.out((String)("Unable to create directory " + node + ":" + directoryPath));
            Trace.out((String)("retStr=" + retStr));
            String errMsg = s_msgBundle.getMessage("1110", true, (Object[])new String[]{directoryPath, isLocalExecution ? RemoteExecFileList.getLocalNodeName() : node, cmdResult.getErrorString()});
            throw new ClusterException(errMsg);
        }
    }

    private static final void assertNode(String node) throws VerificationException {
        if (node == null || node.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7514", false));
        }
    }

    private static final void assertPath(String path, boolean isDirPath, boolean checkExists) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7518", false, (Object[])new String[]{path}));
        }
        if (checkExists && !file.exists()) {
            throw new InvalidPathException(s_msgBundle.getMessage("0029", false, (Object[])new String[]{path}));
        }
        if (isDirPath && !file.isDirectory()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7509", false, (Object[])new String[]{path}));
        }
    }

    private static final void assertPath(String path, boolean isDirPath) throws InvalidPathException {
        RemoteExecFileList.assertPath(path, isDirPath, false);
    }

    public static class FilePath {
        private String m_DestPath = null;
        private String m_srcPath = null;
        private boolean m_isDir = false;
        private List<String> m_ListOfSubDirs = new ArrayList<String>();

        public FilePath(String srcPath, String destPath, boolean isDirPath) throws InvalidPathException {
            RemoteExecFileList.assertPath(srcPath, false, !isDirPath);
            this.m_DestPath = destPath;
            this.m_srcPath = srcPath;
            while (this.m_DestPath.startsWith(VerificationConstants.FILE_SEPARATOR)) {
                this.m_DestPath = this.m_DestPath.substring(1);
            }
            String[] dirNames = this.m_DestPath.split(VerificationConstants.FILE_SEPARATOR);
            for (int index = dirNames.length - 1; index >= 0; --index) {
                String dir = dirNames[index];
                if (!VerificationUtil.isStringGood(dir) || index == dirNames.length - 1 && !isDirPath) continue;
                this.m_ListOfSubDirs.add(dir);
            }
        }

        public FilePath(String path, int dirDepthToRetain, boolean isDirPath) throws InvalidPathException {
            RemoteExecFileList.assertPath(path, false, !isDirPath);
            this.m_srcPath = path;
            File file = new File(this.m_srcPath);
            this.m_DestPath = file.getName();
            this.m_isDir = isDirPath;
            ArrayList<String> dirList = new ArrayList<String>();
            Trace.out((int)5, (String)("Input path " + this.m_srcPath));
            if (isDirPath) {
                dirList.add(this.m_DestPath);
            }
            for (int i = 0; i < dirDepthToRetain; ++i) {
                String parentDirName;
                String parentDir = file.getParent();
                if (!VerificationUtil.isStringGood(parentDir) || !VerificationUtil.isStringGood(parentDirName = new File(parentDir).getName())) continue;
                dirList.add(parentDirName);
                this.m_DestPath = parentDirName + VerificationConstants.FILE_SEPARATOR + this.m_DestPath;
            }
            for (int index = dirList.size() - 1; index >= 0; --index) {
                this.m_ListOfSubDirs.add((String)dirList.get(index));
            }
            Trace.out((int)5, (String)("Processed and resultant destination path being added is = " + this.m_DestPath));
        }

        public String getSourcePath() {
            return this.m_srcPath;
        }

        public List<String> getSubDirectoryList() {
            return this.m_ListOfSubDirs;
        }

        public String getDestinationPath() {
            return this.m_DestPath;
        }

        public boolean isDirectoryPath() {
            return this.m_isDir;
        }
    }
}

