/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDGData;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageDataParser;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperExec;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class ASMDiskGroupsUtil
implements CVUHelperConstants {
    private String m_kfodLocation = null;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private String CHECK_RUNNING_HELPER_ARG = "-checkASMRunning";
    private String GET_DISKCOUNT_HELPER_ARG = "-getDiskGroupCount";
    private final String KFOD_ERR_TXT = "KFOD-";
    private static Hashtable<String, Hashtable<String, List<String>>> m_htdg = new Hashtable();
    NativeSystem m_nativeSystem = new SystemFactory().CreateSystem();
    boolean m_isUnix = this.m_nativeSystem.isUnixSystem();
    GlobalVerificationContext m_gCtx = GlobalVerificationContext.getInstance();

    public void checkASMRunning(String[] nodeNameArr, List<String> runningNodeList, List<String> failedNodeList) throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        String[] args = new String[]{this.CHECK_RUNNING_HELPER_ARG, VerificationUtil.strArr2String(nodeNameArr, ",")};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1006", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1006", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        String[] output = helperExec.getOutput();
        String[] asmRunningArr = null;
        String[] errorArray = null;
        String[] warnArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                warnArray = CVUHelperUtil.fetchWarning(output);
                if (warnArray == null || warnArray.length == 0) {
                    Trace.out((String)"all failed");
                    errorArray = CVUHelperUtil.fetchError(output);
                    String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                    throw new ASMDiskGroupsUtilException(errMsg);
                }
            } else {
                if (status == 1) {
                    Trace.out((String)"some warning nodes");
                    warnArray = CVUHelperUtil.fetchWarning(output);
                }
                Trace.out((String)"fetching successful nodes");
                asmRunningArr = CVUHelperUtil.fetchOutput(output);
            }
        } else {
            Trace.out((String)"cvuhelper failed to produce output");
            String errMsg = s_gMsgBundle.getMessage("1006", true, (Object[])new String[]{helperExec.getCommandString()});
            String errStr = helperExec.getErrorString();
            if (errStr != null && errStr.length() != 0) {
                errMsg = errMsg + LSEP + helperExec.getErrorString();
            }
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        if (warnArray != null && warnArray.length > 0) {
            for (String warnStr : warnArray) {
                String warnNode = VerificationUtil.fetchTextByTags(warnStr, "<ASM_FAIL_NODE>", "</ASM_FAIL_NODE>");
                failedNodeList.add(warnNode);
                Trace.out((String)("failed node " + warnNode + " added"));
            }
        }
        if (asmRunningArr != null && asmRunningArr.length > 0) {
            for (String runStr : asmRunningArr) {
                String runNode = VerificationUtil.fetchTextByTags(runStr, "<ASM_SUCC_NODE>", "</ASM_SUCC_NODE>");
                Trace.out((String)("running node is " + runNode));
                runningNodeList.add(runNode);
            }
        }
        Trace.out((int)2, (String)"Exit");
    }

    public List<String> getASMInstanceRunningNodes(String[] nodeList, ResultSet asmRsltSet) {
        ArrayList<String> runningNodeList = new ArrayList<String>();
        String message = null;
        try {
            ArrayList<String> failedNodeList = new ArrayList<String>();
            this.checkASMRunning(nodeList, runningNodeList, failedNodeList);
            if (runningNodeList.size() > 0) {
                Trace.out((String)("ASM instance was found configured and running on nodes " + runningNodeList));
                VerificationLogData.log("ASM instance was found configured and running on nodes " + runningNodeList);
                asmRsltSet.setStatus(1);
            } else {
                Trace.out((String)"ASM instance was not found configured on any of the cluster nodes, Its still a success case as no errors encountered in determining the status of asm");
                VerificationLogData.log("ASM instance was not found configured on any of the cluster nodes, Its still a success case as no errors encountered in determining the status of asm");
                asmRsltSet.setStatus(1);
            }
        }
        catch (ASMDiskGroupsUtilException ace) {
            Trace.out((String)("Caught ASMDiskGroupsUtilException : " + ace.getMessage()));
            VerificationLogData.logError("Caught ASMDiskGroupsUtilException : " + ace.getMessage());
            message = s_gMsgBundle.getMessage("4562", true, (Object[])new String[]{ace.getMessage()});
            asmRsltSet.addErrorDescription(new ErrorDescription(message));
            asmRsltSet.setStatus(2);
        }
        return runningNodeList;
    }

    public int getDiskGroupCount() throws ASMDiskGroupsUtilException {
        Trace.out((int)2, (String)"Entry");
        String[] args = new String[]{this.GET_DISKCOUNT_HELPER_ARG};
        String[] env = null;
        CVUHelperExec helperExec = null;
        try {
            helperExec = CVUHelperUtil.runCVUHelper(args, env);
        }
        catch (CVUHelperException e) {
            Trace.out((String)"cvuhelper couldn't be executed");
            String errMsg = s_gMsgBundle.getMessage("1007", true, (Object[])new String[]{"cvuhelper"}) + LSEP + e.getMessage();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        if (helperExec.getExitValue() == 2) {
            Trace.out((String)"cvuhelper failed to execute");
            String errMsg = s_gMsgBundle.getMessage("1007", true, (Object[])new String[]{helperExec.getCommandString()}) + LSEP + helperExec.getErrorString();
            throw new ASMDiskGroupsUtilException(errMsg);
        }
        String[] output = helperExec.getOutput();
        String[] errorArray = null;
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out((String)outputStr);
            int status = CVUHelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out((String)"disk group count couldn't be fetched");
                errorArray = CVUHelperUtil.fetchError(output);
                String errMsg = VerificationUtil.strArr2String(errorArray, LSEP);
                throw new ASMDiskGroupsUtilException(errMsg);
            }
            Trace.out((String)"disk group count got");
            String dgCountStr = VerificationUtil.fetchTextByTags(outputStr, null, "<ASMDG_COUNT>", "</ASMDG_COUNT>");
            if (dgCountStr != null && dgCountStr.length() > 0) {
                return Integer.parseInt(dgCountStr);
            }
            return 0;
        }
        Trace.out((String)"cvuhelper failed to produce output");
        String errMsg = s_gMsgBundle.getMessage("1007", true, (Object[])new String[]{helperExec.getCommandString()});
        String errStr = helperExec.getErrorString();
        if (errStr != null && errStr.length() != 0) {
            errMsg = errMsg + LSEP + helperExec.getErrorString();
        }
        throw new ASMDiskGroupsUtilException(errMsg);
    }

    public boolean getDiskGroups(String[] nodeList, ResultSet dgResultSet, Hashtable<String, List<ASMDiskGroup>> htdg) throws ASMDiskGroupsUtilException {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList)));
        int nodeCount = nodeList.length;
        VerificationCommand[] getDGListCmdArray = new VerificationCommand[nodeCount];
        String[] env = null;
        String clusterwareHome = null;
        if (VerificationUtil.isCRSConfigured()) {
            clusterwareHome = VerificationUtil.getCRSHome();
        } else if (VerificationUtil.isHAConfigured()) {
            clusterwareHome = VerificationUtil.getHAHome();
        }
        Trace.out((String)"DiskGroup query using kfod...");
        if (!VerificationUtil.isStringGood(this.m_kfodLocation)) {
            try {
                this.m_kfodLocation = this.getKFODLocationForDG();
                if (!VerificationUtil.isStringGood(this.m_kfodLocation)) {
                    return false;
                }
            }
            catch (VerificationException e) {
                Trace.out((String)("VERIFICATIONEXCEPTION: " + e.getMessage()));
                VerificationLogData.logError(e.getMessage());
                String errMsg = e.getMessage();
                ReportUtil.printError(errMsg);
                dgResultSet.addResult(nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                dgResultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = null;
            arg = this.m_isUnix && VerificationUtil.isStringGood(clusterwareHome) ? new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true", "-cv_oh", clusterwareHome} : new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true"};
            getDGListCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
            Trace.out((String)("Building command array entry for: " + nodeList[j] + "|" + VerificationUtil.strArr2String(arg, LSEP) + "|" + VerificationUtil.strArr2String(env, LSEP)));
        }
        Trace.out((String)"Submitting commands...");
        new GlobalHandler().submit((Command[])getDGListCmdArray, 0, dgResultSet);
        if (!dgResultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5131", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            dgResultSet.addErrorDescription(nodeList, errorDesc);
            dgResultSet.addResult(nodeList, 2);
            dgResultSet.setStatus();
            Trace.out((String)"disk group retrieval failed on all nodes");
            VerificationLogData.logError("disk group retrieval failed on all nodes");
            return false;
        }
        Trace.out((String)"Checking command results...");
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand getDGListCmd = getDGListCmdArray[nodeIndex];
            Result result = getDGListCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = getDGListCmd.getNode();
            String output = this.getKFODvalidOutput(getDGListCmd, dgResultSet);
            if (!VerificationUtil.isStringGood(output)) continue;
            ArrayList<ASMDiskGroup> dgl = new ArrayList<ASMDiskGroup>();
            boolean isOK = this.parseDGListOutput(node, output, dgl);
            Trace.out((String)("Result of parseDGListOutput(): " + isOK));
            if (isOK) {
                for (ASMDiskGroup dg : dgl) {
                    Trace.out((String)("Adding this disk group for node '" + node + "' :" + LSEP + dg.toString()));
                }
                htdg.put(node, dgl);
                continue;
            }
            dgResultSet.addResult(node, 3);
            ErrorDescription error = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}));
            dgResultSet.addErrorDescription(node, error);
            VerificationLogData.logError(output);
        }
        return true;
    }

    public boolean getDiskGroups(String[] nodeList, ResultSet dgResultSet, HashMap<String, List<ASMDGData>> nodeDGListMap) {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        int nodeCount = nodeList.length;
        VerificationCommand[] getDGListCmdArray = new VerificationCommand[nodeCount];
        String[] env = null;
        String clusterwareHome = null;
        if (this.m_gCtx.isCRSConfigured()) {
            clusterwareHome = VerificationUtil.getCRSHome();
        } else if (this.m_gCtx.isHAConfigured()) {
            clusterwareHome = VerificationUtil.getHAHome();
        }
        VerificationUtil.traceAndLog("DiskGroup query using kfod...");
        if (!VerificationUtil.isStringGood(this.m_kfodLocation)) {
            try {
                this.m_kfodLocation = this.getKFODLocationForDG();
                if (!VerificationUtil.isStringGood(this.m_kfodLocation)) {
                    return false;
                }
            }
            catch (VerificationException e) {
                Trace.out((String)("VERIFICATIONEXCEPTION: " + e.getMessage()));
                VerificationLogData.logError(e.getMessage());
                String errMsg = e.getMessage();
                dgResultSet.addResult(nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                dgResultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = null;
            arg = this.m_isUnix && VerificationUtil.isStringGood(clusterwareHome) ? new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true", "-cv_oh", clusterwareHome} : new String[]{"-runexe", this.m_kfodLocation, "op=GROUPS", "nohdr=true"};
            getDGListCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
            VerificationUtil.traceAndLog("Building command array entry for: " + nodeList[j] + "|" + VerificationUtil.strArr2String(arg, LSEP) + "|" + VerificationUtil.strArr2String(env, LSEP));
        }
        VerificationUtil.traceAndLog("Submitting kfod commands for disk group retrieval...");
        ResultSet locRS = new ResultSet();
        new GlobalHandler().submit((Command[])getDGListCmdArray, 0, locRS);
        if (!locRS.anySuccess()) {
            VerificationUtil.traceAndLog("disk group retrieval failed on all nodes");
            VerificationLogData.logError("disk group retrieval failed on all nodes");
            dgResultSet.addResult(nodeList, 2);
            String message = s_msgBundle.getMessage("5131", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            dgResultSet.addErrorDescription(errorDesc);
            for (VerificationError vErr : locRS.getGlobalAndNodeErrorList()) {
                dgResultSet.addErrorDescription((ErrorDescription)vErr);
            }
            return false;
        }
        VerificationUtil.traceAndLog("Checking command results...");
        StorageDataParser sdParser = new StorageDataParser(new StorageCheckContext(true));
        dgResultSet.addResult(nodeList, 1);
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand getDGListCmd = getDGListCmdArray[nodeIndex];
            String node = nodeList[nodeIndex];
            Result result = getDGListCmd.getResult();
            VerificationUtil.traceAndLog("Status='%s'", Result.resultStatusString(result.getStatus()));
            if (result.getStatus() == 1) {
                String output = this.getKFODvalidOutput(getDGListCmd, dgResultSet);
                if (!VerificationUtil.isStringGood(output)) continue;
                ArrayList<ASMDGData> dgDataList = new ArrayList<ASMDGData>();
                String[] dgout = output.split("\\n");
                if (dgout.length < 1) {
                    VerificationUtil.traceAndLog("Output DG List is empty");
                    continue;
                }
                for (int i = 0; i < dgout.length; ++i) {
                    VerificationUtil.traceAndLog("DGList: dg[" + i + "]=" + dgout[i]);
                    ASMDGData dgData = null;
                    Result rslt = new Result(node);
                    dgData = sdParser.parseKfodOutputForDG(dgout[i], rslt);
                    if (rslt.getStatus() == 1) {
                        if (dgData == null) continue;
                        VerificationUtil.traceAndLog("Adding the diskgroup with following details:" + LSEP + dgData.toString());
                        dgDataList.add(dgData);
                        continue;
                    }
                    VerificationUtil.traceAndLog("Parsing failed; No action");
                }
                if (dgDataList.size() == 0) continue;
                nodeDGListMap.put(node, dgDataList);
                continue;
            }
            VerificationUtil.traceAndLog("Failure in execution of kfod command on node '%s'", node);
            dgResultSet.addResult(node, 2);
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}));
            dgResultSet.addErrorDescription(node, errDesc);
        }
        return dgResultSet.getStatus() == 1;
    }

    /*
     * Unable to fully structure code
     */
    public boolean getDiskGroupsDiskMap(String[] nodeList, ResultSet dgResultSet, Hashtable<String, Hashtable<String, List<String>>> htdg) throws ASMDiskGroupsUtilException {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList)));
        clusterwareHome = null;
        activeVersion = null;
        env = null;
        newNodeList = null;
        if (ASMDiskGroupsUtil.m_htdg.isEmpty()) ** GOTO lbl24
        nodeListForRetrieval = new ArrayList<String>();
        for (String node : nodeList) {
            if (ASMDiskGroupsUtil.m_htdg.containsKey(node)) {
                Trace.out((String)("The Disk group information is already retrieved on the node " + node));
                htdg.put(node, ASMDiskGroupsUtil.m_htdg.get(node));
                dgResultSet.addResult(node, 1);
                continue;
            }
            Trace.out((String)("The Disk group information is not yet retrieved on the node " + node));
            nodeListForRetrieval.add(node);
        }
        if (!nodeListForRetrieval.isEmpty()) {
            newNodeList = nodeListForRetrieval.toArray(new String[0]);
        } else {
            Trace.out((String)("Returning... As the Disk group information is already retrieved on all the nodes " + VerificationUtil.strArr2String(nodeList)));
            return true;
lbl24:
            // 1 sources

            newNodeList = nodeList;
        }
        nodeCount = newNodeList.length;
        getDGListCmdArray = new VerificationCommand[nodeCount];
        Trace.out((String)"DiskGroup query using kfod...");
        nodewiseDiskGroupDisksTable = new Hashtable<Object, Hashtable<K, V>>();
        if (!VerificationUtil.isStringGood(this.m_kfodLocation)) {
            try {
                this.m_kfodLocation = this.getKFODLocationForDG();
                if (!VerificationUtil.isStringGood(this.m_kfodLocation)) {
                    return false;
                }
            }
            catch (VerificationException e) {
                Trace.out((String)("VERIFICATIONEXCEPTION: " + e.getMessage()));
                VerificationLogData.logError(e.getMessage());
                errMsg = e.getMessage();
                ReportUtil.printError(errMsg);
                dgResultSet.addResult(newNodeList, 2);
                errDesc = new ErrorDescription(errMsg);
                dgResultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        for (j = 0; j < nodeCount; ++j) {
            arg = null;
            arg = this.m_isUnix != false && VerificationUtil.isStringGood(clusterwareHome) != false ? new String[]{"-runexe", this.m_kfodLocation, "nohdr=true", "op=DISKS", "disks=all", "dscvgroup=TRUE", "-cv_oh", clusterwareHome} : new String[]{"-runexe", this.m_kfodLocation, "nohdr=true", "op=DISKS", "disks=all", "dscvgroup=TRUE"};
            getDGListCmdArray[j] = new VerificationCommand(newNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])getDGListCmdArray, 0, dgResultSet);
        if (!dgResultSet.anySuccess()) {
            message = ASMDiskGroupsUtil.s_msgBundle.getMessage("5131", true);
            errorDesc = new ErrorDescription(message);
            dgResultSet.addErrorDescription(newNodeList, errorDesc);
            VerificationLogData.logError("disk group retrieval failed on all nodes");
            return false;
        }
        for (nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            getDGListCmd = getDGListCmdArray[nodeIndex];
            result = getDGListCmd.getResult();
            if (result.getStatus() != 1) continue;
            node = getDGListCmd.getNode();
            output = this.getKFODvalidOutput(getDGListCmd, dgResultSet);
            if (!VerificationUtil.isStringGood(output)) continue;
            dgdmap = new Hashtable<String, List<String>>();
            isOK = this.parseDiskGroupDiskMap(node, output, dgdmap);
            Trace.out((String)("Result of parseDiskGroupDiskMap(): " + isOK));
            if (!isOK) {
                dgResultSet.addResult(node, 3);
                error = new ErrorDescription(ASMDiskGroupsUtil.s_msgBundle.getMessage("5155", true, (Object[])new String[]{node}));
                dgResultSet.addErrorDescription(node, error);
                VerificationLogData.logError(output);
                continue;
            }
            nodewiseDiskGroupDisksTable.put(node, dgdmap);
        }
        isKfodListAFDLabelForDiskGroup = false;
        for (String node : nodewiseDiskGroupDisksTable.keySet()) {
            for (String diskGroup : ((Hashtable)nodewiseDiskGroupDisksTable.get(node)).keySet()) {
                VerificationUtil.traceAndLog("On Node (" + node + ") KFOD lists disks (" + ((Hashtable)nodewiseDiskGroupDisksTable.get(node)).get(diskGroup) + ") for diskgroup (" + diskGroup + ")");
                for (String disk : (List)((Hashtable)nodewiseDiskGroupDisksTable.get(node)).get(diskGroup)) {
                    if (!disk.trim().startsWith("AFD:")) continue;
                    VerificationUtil.traceAndLog("KFOD lists AFD label (" + disk + ") as disk for diskgroup (" + diskGroup + ")");
                    isKfodListAFDLabelForDiskGroup = true;
                }
            }
        }
        if (VerificationUtil.isCRSConfigured()) {
            clusterwareHome = VerificationUtil.getCRSHome();
            activeVersion = VerificationUtil.getCRSActiveVersionObj();
        } else if (VerificationUtil.isHAConfigured()) {
            clusterwareHome = VerificationUtil.getHAHome();
            activeVersion = VerificationUtil.getSIHAReleaseVersionObj();
        }
        if (VerificationUtil.isStringGood(clusterwareHome) && activeVersion != null && !Version.isPre12102((Version)activeVersion) && StorageUtil.isAFDSupported()) {
            Trace.out((String)"The current active version of CRS/HA home is 12.1.0.2 or further, Checking if AFD is used for managing ASM ddevices.");
            afdChkRsltSet = new ResultSet();
            if (StorageUtil.isASMFilterDriverConfigured(newNodeList, clusterwareHome, activeVersion, afdChkRsltSet)) {
                nodewiseAFDLabelDisksTable = StorageUtil.getAFDDiskList(newNodeList, clusterwareHome, activeVersion, dgResultSet);
                for (String node : nodewiseAFDLabelDisksTable.keySet()) {
                    Trace.out((String)("Adding the information for node:" + node));
                    for (String label : nodewiseAFDLabelDisksTable.get(node).keySet()) {
                        diskPathForLabel = nodewiseAFDLabelDisksTable.get(node).get(label);
                        VerificationUtil.traceAndLog("AFD LABEL (" + label + ") belongs to disk path (" + diskPathForLabel + ")");
                        if (isKfodListAFDLabelForDiskGroup && nodewiseDiskGroupDisksTable.containsKey(node)) {
                            for (String diskGroup : ((Hashtable)nodewiseDiskGroupDisksTable.get(node)).keySet()) {
                                listOfDisksForGroup = (List)((Hashtable)nodewiseDiskGroupDisksTable.get(node)).get(diskGroup);
                                for (String disk : (List)((Hashtable)nodewiseDiskGroupDisksTable.get(node)).get(diskGroup)) {
                                    v0 = labelToCompare = label.startsWith("AFD:") != false ? label : "AFD:" + label;
                                    if (!disk.startsWith("AFD:") || !disk.equalsIgnoreCase(labelToCompare)) continue;
                                    VerificationUtil.traceAndLog("Replacing the AFD label (" + label + ") with actual disk path (" + diskPathForLabel + ") for ASM disk group ( " + diskGroup + ")");
                                    newListOfDisksForGroup = new ArrayList<String>();
                                    for (String d : listOfDisksForGroup) {
                                        if (d.equals(disk)) {
                                            newListOfDisksForGroup.add(diskPathForLabel);
                                            continue;
                                        }
                                        newListOfDisksForGroup.add(d);
                                    }
                                    ((Hashtable)nodewiseDiskGroupDisksTable.get(node)).put(diskGroup, newListOfDisksForGroup);
                                }
                            }
                            continue;
                        }
                        diskLabelDiskListTable = new Hashtable<String, ArrayList<E>>();
                        diskList = new ArrayList<String>();
                        diskList.add(diskPathForLabel);
                        diskLabelDiskListTable.put(label, diskList);
                        nodewiseDiskGroupDisksTable.put(node, diskLabelDiskListTable);
                    }
                }
            }
        }
        if (!nodewiseDiskGroupDisksTable.isEmpty()) {
            for (String node : nodewiseDiskGroupDisksTable.keySet()) {
                for (String diskGroup : ((Hashtable)nodewiseDiskGroupDisksTable.get(node)).keySet()) {
                    VerificationUtil.traceAndLog("On Node (" + node + ") the diskgroup (" + diskGroup + ") belongs to disks (" + ((Hashtable)nodewiseDiskGroupDisksTable.get(node)).get(diskGroup) + ")");
                }
                htdg.put(node, (Hashtable<String, List<String>>)nodewiseDiskGroupDisksTable.get(node));
                ASMDiskGroupsUtil.m_htdg.put(node, (Hashtable<String, List<String>>)nodewiseDiskGroupDisksTable.get(node));
            }
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    public List<String> getDiskListForDiskGroup(String diskGroup, ResultSet dgRsltSet) throws ASMDiskGroupsUtilException {
        String localNode = VerificationUtil.getLocalNode();
        return this.getDiskListForDiskGroup(new String[]{localNode}, diskGroup, dgRsltSet).get(localNode);
    }

    public Hashtable<String, List<String>> getDiskListForDiskGroup(String[] nodeList, String diskGroup, ResultSet dgRsltSet) throws ASMDiskGroupsUtilException {
        Hashtable<String, List<String>> nodeDiskListTable = new Hashtable<String, List<String>>();
        Hashtable<String, Hashtable<String, List<String>>> htdg = new Hashtable<String, Hashtable<String, List<String>>>();
        if (this.getDiskGroupsDiskMap(nodeList, dgRsltSet, htdg)) {
            for (String node : htdg.keySet()) {
                if (!htdg.get(node).containsKey(diskGroup)) continue;
                nodeDiskListTable.put(node, htdg.get(node).get(diskGroup));
            }
        }
        return nodeDiskListTable;
    }

    private boolean parseDGListOutput(String node, String output, List<ASMDiskGroup> dgl) {
        Trace.out((int)2, (String)"Entry");
        String[] dgout = output.split("\\n");
        if (dgout.length < 1) {
            Trace.out((String)"Output DG List is empty");
            return false;
        }
        for (int i = 0; i < dgout.length; ++i) {
            Trace.out((String)("DGList: dg[" + i + "]=" + dgout[i]));
            ASMDiskGroup dg = null;
            dg = ASMDiskGroup.parseInput(node, dgout[i]);
            if (dg == null) continue;
            Trace.out((String)("Adding the diskgroup with following details:" + LSEP + dg.toString()));
            dgl.add(dg);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    private boolean parseDiskGroupDiskMap(String node, String output, Hashtable<String, List<String>> dgdMap) {
        Trace.out((int)2, (String)"Entry");
        String[] dgout = output.split("\\n");
        if (dgout.length < 1) {
            Trace.out((String)"Output List is empty");
            return false;
        }
        for (String outputLine : dgout) {
            String[] values;
            Trace.out((String)("DiskGroupDiskMap: outputLine=" + outputLine));
            String dgName = null;
            String disk = null;
            if (outputLine.contains("AFD:") || outputLine.contains("o/") || outputLine.contains("ORCL:") || outputLine.contains("\\\\.\\ORCL")) {
                values = outputLine.trim().split("\\s+");
                if (values.length < 3) continue;
                dgName = values[2];
                disk = values[1];
            } else {
                values = outputLine.trim().split("[ ]+");
                if (values.length < 5) continue;
                dgName = values[2];
                disk = values[1];
            }
            if (!VerificationUtil.isStringGood(dgName) || !VerificationUtil.isStringGood(disk)) continue;
            List<String> diskList = dgdMap.get(dgName);
            if (diskList == null) {
                diskList = new ArrayList<String>();
                dgdMap.put(dgName, diskList);
            }
            dgdMap.get(dgName).add(disk);
        }
        Trace.out((int)2, (String)"Exit");
        return true;
    }

    private String getKFODvalidOutput(VerificationCommand cmd, ResultSet resultSet) {
        boolean cmdExecError = true;
        Result result = cmd.getResult();
        Vector resultInfoset = result.getResultInfoSet();
        String exectaskOutput = cmd.getExectaskOutput();
        Trace.out((String)("exectaskOutput=" + exectaskOutput));
        if (exectaskOutput != null && VerificationUtil.fetchVerificationResult(exectaskOutput).equals("0")) {
            cmdExecError = false;
        }
        String node = cmd.getNode();
        String output = cmd.getOutput();
        Trace.out((String)("cmdExecError=" + cmdExecError + "; kfod output on node " + node + "= >" + output + "<"));
        if (cmdExecError || !VerificationUtil.isStringGood(output) || VerificationUtil.isStringGood(output) && output.startsWith("KFOD-")) {
            Trace.out((String)"Encountered error in kfod command execution");
            resultSet.addResult(node, 3);
            String errMsg = s_msgBundle.getMessage("5155", true, (Object[])new String[]{node});
            if (VerificationUtil.isStringGood(output)) {
                errMsg = errMsg + LSEP + output;
            }
            ErrorDescription error = new ErrorDescription(errMsg);
            resultSet.addErrorDescription(node, error);
            VerificationLogData.logError("kfod failure " + output);
            return null;
        }
        return output;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getKFODLocationForDG() throws VerificationException {
        String kfodLoc;
        block8: {
            String clusterwareHome = null;
            kfodLoc = null;
            Version curVer = null;
            Result result = new Result(VerificationUtil.getLocalNode());
            Trace.out((String)"ENTRY");
            if (VerificationUtil.isHAConfigured()) {
                curVer = VerificationUtil.getSIHAReleaseVersionObj();
                clusterwareHome = VerificationUtil.getHAHome();
            } else if (VerificationUtil.isCRSConfigured()) {
                curVer = VerificationUtil.getCRSActiveVersionObj();
                clusterwareHome = VerificationUtil.getCRSHome();
            }
            Trace.out((String)("Clusterware home is : " + clusterwareHome + " CRS version " + curVer));
            if (curVer != null && Version.isPre112((Version)curVer)) {
                clusterwareHome = CVUHelperUtil.getASMhome(result);
                Trace.out((String)("Using ASM home " + clusterwareHome));
            }
            if (!VerificationUtil.isStringGood(clusterwareHome)) {
                String configOption = CVUVariables.getValue(CVUVariableConstants.POST_SW_INSTALL_API_MODE);
                if (configOption != null && configOption.equalsIgnoreCase("true")) {
                    String oHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                    if (!VerificationUtil.isStringGood(oHome)) {
                        Trace.out((String)"ORACLE_HOME varaible does not contain valid home.");
                        throw new VerificationException(s_msgBundle.getMessage("5461", true, (Object[])new String[]{"ORACLE_HOME"}));
                    }
                    String kfodHome = oHome + FSEP + "inventory" + FSEP + "Scripts" + FSEP + "ext";
                    kfodLoc = this.m_isUnix ? (!VerificationUtil.isBinaryExistsInsideHome(kfodHome, "kfod") ? kfodHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "kfod.bin" : kfodHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + this.m_nativeSystem.getExeName("kfod")) : kfodHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + this.m_nativeSystem.getExeName("kfod");
                    break block8;
                } else {
                    Trace.out((String)"VAR_POST_SW_INSTALL_API_MODE not set to 'true'");
                    return null;
                }
            }
            kfodLoc = clusterwareHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + this.m_nativeSystem.getExeName("kfod");
        }
        Trace.out((String)("Returning KFOD Location as: '" + kfodLoc + "'"));
        return kfodLoc;
    }

    public List<String> getASMQuorumGroupDisks() throws CmdToolUtilException {
        ArrayList<String> quorumDiskList = new ArrayList<String>();
        String clusterwareHome = VerificationUtil.getConfiguredCRSOrHAHome();
        ASMCMDUtil asmcmd = null;
        List diskCmdOutputLines = null;
        asmcmd = new ASMCMDUtil(clusterwareHome);
        diskCmdOutputLines = asmcmd.getASMDisks();
        for (String line : diskCmdOutputLines) {
            VerificationUtil.traceAndLog("lsdsk output line : " + line);
            if (line.startsWith("ASMCMD-")) continue;
            String[] fieldsArr = line.split("[\\s]+");
            Trace.out((String)("Fileds length = " + fieldsArr.length));
            if (fieldsArr.length < 9) {
                Trace.out((String)"lsdsk output not in correct format");
                continue;
            }
            int failgroupTypeField = fieldsArr.length - 4;
            if (!"QUORUM".equalsIgnoreCase(fieldsArr[failgroupTypeField])) continue;
            quorumDiskList.add(fieldsArr[fieldsArr.length - 1]);
        }
        return quorumDiskList;
    }
}

