/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sStorageUtil
implements StorageConstants {
    private static String m_localHost = null;
    private static boolean RAW_ENABLED;
    private static int[] s_nonDiscoverableTypes;
    protected static MessageBundle s_msgBundle;
    protected static MessageBundle s_gMsgBundle;

    public boolean isTypeValid(int type) {
        return type > 0;
    }

    public static int[] getDiscoveryTypes() {
        return sStorageUtil.getDiscoveryTypes(OracleFileType.RAC_DATA_FILES, "12.2", false);
    }

    public static int[] getDiscoveryTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        Trace.out((String)("fileType=" + fileType.name() + "; release=" + release + "; considerASMStorage=" + considerASMStorage + "; RAW_ENABLED=" + RAW_ENABLED));
        Object discoveryTypes = null;
        ArrayList<Integer> discoveryTypesList = new ArrayList<Integer>();
        int[] supportedTypes = sStorageUtil.getSupportedFileTypes(fileType, release, considerASMStorage);
        Trace.out((String)("s_nonDiscoverableTypes=" + StorageUtil.getTypesListByStr(s_nonDiscoverableTypes)));
        for (int supportedType : supportedTypes) {
            boolean isDiscoverable = true;
            for (int nonDiscoverableType : s_nonDiscoverableTypes) {
                if (supportedType != nonDiscoverableType) continue;
                Trace.out((String)("Removing type " + StorageUtil.getTypeStr(supportedType) + " from list of discoverable types"));
                isDiscoverable = false;
                break;
            }
            if (!isDiscoverable) continue;
            discoveryTypesList.add(new Integer(supportedType));
        }
        if (considerASMStorage && RAW_ENABLED && !VerificationUtil.isVersionPre(release, "12") && (fileType == OracleFileType.RAC_OCR_VDISK || fileType == OracleFileType.RAC_DATA_FILES)) {
            Trace.out((String)"TYPE_DISK is being added to discovery list, if not there.");
            if (!discoveryTypesList.contains(new Integer(1))) {
                discoveryTypesList.add(new Integer(1));
            }
        }
        int[] discoveryTypesArr = new int[discoveryTypesList.size()];
        int i = 0;
        for (Integer discoveryType : discoveryTypesList) {
            discoveryTypesArr[i++] = discoveryType;
        }
        Trace.out((String)("Returning discovery types=" + StorageUtil.getTypesListByStr(discoveryTypesArr)));
        return discoveryTypesArr;
    }

    public static int[] getSupportedFileTypes(OracleFileType fileType, String release, boolean considerASMStorage) {
        Trace.out((String)("fileType=" + fileType.name() + "; release=" + release + "; considerASMStorage=" + considerASMStorage));
        int[] supportedFileTypes = new int[]{};
        boolean bc = false;
        try {
            bc = NodeManagerFactory.getInstance().getNodeManager().isBigCluster();
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((String)"Ignored exception: %s: %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
        }
        switch (fileType) {
            case ASM: {
                return new int[]{1};
            }
            case RAC_OCR_VDISK: {
                if (VerificationUtil.isVersionPre(release, "11.2")) {
                    supportedFileTypes = new int[]{1, 7};
                    break;
                }
                if (VerificationUtil.isVersionPre(release, "12")) {
                    supportedFileTypes = new int[]{1, 13, 7};
                    break;
                }
                if (!bc) {
                    supportedFileTypes = new int[]{13};
                    break;
                }
                supportedFileTypes = new int[]{13};
                break;
            }
            case RAC_SOFTWARE: 
            case SI_SOFTWARE: {
                if (VerificationUtil.isVersionPre(release, "11.2")) {
                    supportedFileTypes = new int[]{7, 5};
                    break;
                }
                if (VerificationUtil.isVersionPre(release, "12")) {
                    supportedFileTypes = new int[]{7, 14, 5};
                    break;
                }
                supportedFileTypes = new int[]{14, 5};
                break;
            }
            case RAC_DATA_FILES: {
                supportedFileTypes = VerificationUtil.isVersionPre(release, "11.2") ? new int[]{1, 13, 7} : (VerificationUtil.isVersionPre(release, "12") ? new int[]{1, 13, 7} : new int[]{13, 14});
            }
        }
        Trace.out((String)("Supported storage types for '" + fileType.name() + "' in release '" + release + "' =" + StorageUtil.getTypesListByStr(supportedFileTypes)));
        return supportedFileTypes;
    }

    public static String getTypeStr(int type) {
        return StorageUtil.getTypeStr(type);
    }

    public static StorageType getTypeEnum(int type) {
        return StorageUtil.getTypeEnum(type);
    }

    public static int getTypeByStr(String str) throws StorageException {
        return StorageUtil.getTypeByStr(str);
    }

    protected static String getLocalHost() throws StorageException {
        if (null == m_localHost) {
            try {
                m_localHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new StorageException("7007", e);
            }
        }
        return m_localHost;
    }

    public static int getNumDiskPartitions(StorageInfo stInfo) {
        if (stInfo.getType() == 1) {
            return ((sDisk)stInfo).getNumPartitions();
        }
        return -1;
    }

    public static Result processASMStamp(String stamp) {
        String node = VerificationUtil.getLocalHostName();
        Result result = new Result(node);
        ErrorDescription errDesc = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet stampDevResSet = new ResultSet();
        String winGlobalRootToken = "\\\\?\\GLOBALROOT";
        if (!VerificationUtil.isStringGood(stamp)) {
            errDesc = new ErrorDescription(s_gMsgBundle.getMessage("10530", false, (Object[])new String[]{"stamp"}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return result;
        }
        String windeviceRootToken = "\\\\.\\";
        if (stamp.startsWith(windeviceRootToken)) {
            Trace.out((String)("The Stamp name " + stamp + " contains windows device root token prefix"));
            stamp = stamp.substring(windeviceRootToken.length());
        }
        globalExec.checkAsmStamp(new String[]{node}, stamp, stampDevResSet);
        Result sdResult = (Result)stampDevResSet.getResultTable().get(node);
        String devicePath = null;
        if (sdResult.getStatus() == 1) {
            devicePath = (String)sdResult.getResultInfoSet().elementAt(0);
            if (VerificationUtil.isStringGood(devicePath)) {
                devicePath = devicePath.trim();
                result.setStatus(1);
            }
        } else {
            errDesc = sdResult.getStatus() == 3 ? new ErrorDescription(s_gMsgBundle.getMessage("10520", true, (Object[])new String[]{stamp, node}), s_gMsgBundle, "10520") : new ErrorDescription(s_gMsgBundle.getMessage("10521", true, (Object[])new String[]{stamp, node}), s_gMsgBundle, "10521");
            result.addErrorDescription(errDesc);
            result.setStatus(sdResult.getStatus());
        }
        if (VerificationUtil.isStringGood(devicePath)) {
            if (devicePath.toUpperCase().startsWith(winGlobalRootToken)) {
                Trace.out((String)"The resolved device path contains Global root prefix, truncating the global root prefix");
                devicePath = devicePath.substring(winGlobalRootToken.length());
            }
            result.setActualValue(devicePath);
            result.setHasResultValues(true);
            Trace.out((String)("Resoved stamp " + stamp + " to " + devicePath + " returning SUCCESS"));
        }
        return result;
    }

    static {
        s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
        s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
        RAW_ENABLED = StorageUtil.isRawDiscoveryEnabled();
        s_nonDiscoverableTypes = RAW_ENABLED ? new int[]{5} : new int[]{5, 1};
    }
}

