/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.storage.NFSInfo;
import oracle.ops.verification.framework.storage.SharedStrategy;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class NFSSharedStrategy
extends SharedStrategy {
    private MessageBundle m_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private StringBuffer m_msgXmlChecks;
    private String m_mountOpts;
    private List<String> m_unsupportedMountOpts = new ArrayList<String>();

    @Override
    public void findShared(Vector stList, Vector superSet) throws StorageException, MultiNodeException {
        Vector<NFSInfo> okPaths = new Vector<NFSInfo>();
        Trace.out((String)"Checking for NFS Shared storage.. ");
        Object[] nfspath = new String[3];
        MultiNodeException mne = new MultiNodeException();
        boolean nfspath_failure = false;
        Iterator iter = stList.iterator();
        while (iter.hasNext()) {
            this.m_msgXmlChecks = new StringBuffer();
            this.m_unsupportedMountOpts.clear();
            NFSInfo nfsInfo = (NFSInfo)iter.next();
            nfspath[0] = nfsInfo.getServer();
            nfspath[1] = nfsInfo.getPathOnServer();
            nfspath[2] = nfsInfo.getMountPoint();
            Trace.out((String)("Checking nfs options on: " + nfsInfo.getServer() + ":" + nfsInfo.getPathOnServer() + "mounted on:" + nfsInfo.getMountPoint()));
            this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7022", false, nfspath));
            this.m_mountOpts = nfsInfo.getMountOpts();
            if (this.matchesXmlConstraints(this.m_oracleFileType)) {
                okPaths.add(nfsInfo);
            } else {
                Trace.out((String)("This NFSInfo didn't qualify " + nfsInfo));
                if (this.m_checkPath) {
                    nfspath_failure = true;
                    mne.addThrowable(nfsInfo.getNode(), new StorageException("7036", nfsInfo.getNode(), (Object[])new String[]{VDMUtil.getNFSOptionsRegExp(this.m_oracleFileType, false), this.m_mountOpts}, new Throwable(this.m_msgXmlChecks.toString())));
                    if (!this.m_unsupportedMountOpts.isEmpty()) {
                        mne.addThrowable(nfsInfo.getNode(), new StorageException("0361", nfsInfo.getNode(), new String[]{VerificationUtil.strCollection2String(this.m_unsupportedMountOpts), nfsInfo.getServer(), nfsInfo.getPathOnServer(), nfsInfo.getMountPoint()}, new Throwable(this.m_msgXmlChecks.toString()), true, "Prvg"));
                    }
                }
            }
            this.m_mountOpts = null;
        }
        super.findShared(okPaths, superSet);
        if (nfspath_failure) {
            throw mne;
        }
    }

    private boolean matchesXmlConstraints(OracleFileType fileType) {
        String xmlOptions = VDMUtil.getNFSOptionsRegExp(fileType);
        String[] xmlOptionsArray = xmlOptions.split(",");
        for (int i = 0; i < xmlOptionsArray.length; ++i) {
            this.m_msgXmlChecks = new StringBuffer();
            if (!this.validateConstraints(xmlOptionsArray[i])) {
                Trace.out((String)("XML options check message: " + this.m_msgXmlChecks));
                return false;
            }
            this.m_msgXmlChecks = null;
        }
        Trace.out((String)("XML options check message: " + this.m_msgXmlChecks));
        return true;
    }

    private boolean validateConstraints(String xmlOptionsStr) {
        Trace.out((String)("Validating constraint from xml:  " + xmlOptionsStr));
        String[] condsArray = new String[2];
        if (xmlOptionsStr.indexOf("|") != -1) {
            Trace.out((String)"Found an OR constraint..");
            condsArray = xmlOptionsStr.split("\\|", 2);
            boolean lvalue = this.validateConstraints(condsArray[0]);
            if (lvalue) {
                return true;
            }
            this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7024", false));
            boolean rvalue = this.validateConstraints(condsArray[1]);
            return rvalue;
        }
        if (xmlOptionsStr.indexOf("&") != -1) {
            Trace.out((String)"Found an AND constraint..");
            condsArray = xmlOptionsStr.split("\\&", 2);
            boolean lvalue = this.validateConstraints(condsArray[0]);
            if (!lvalue) {
                return false;
            }
            this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7024", false));
            boolean rvalue = this.validateConstraints(condsArray[1]);
            return rvalue;
        }
        boolean retvalue = this.validateOptionValue(xmlOptionsStr);
        if (retvalue) {
            this.m_msgXmlChecks.append("\n");
        }
        return retvalue;
    }

    private boolean validateOptionValue(String xmlOption) {
        Object xmlOptionValue = null;
        Object nfsOptionValue = null;
        int comparisonResult = 0;
        boolean validateAbsence = false;
        if (VerificationUtil.isStringGood(xmlOption) && xmlOption.trim().startsWith("!")) {
            validateAbsence = true;
            xmlOption = xmlOption.substring(xmlOption.indexOf("!") + 1);
            Trace.out((String)("Validating the absence of option (" + xmlOption + ")"));
        }
        this.m_msgBundle = VerificationUtil.getMessageBundle("Prvf");
        String optionKey = this.extractOptionKey(xmlOption);
        Object[] nfsoption = new String[]{optionKey};
        this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7023", false, nfsoption));
        String[] mntOptionsArray = this.m_mountOpts.split(",");
        boolean found = false;
        for (String mntOptionStr : mntOptionsArray) {
            if (!this.extractOptionKey(mntOptionStr).equals(optionKey)) continue;
            found = true;
            nfsOptionValue = this.extractOptionValue(mntOptionStr, optionKey, "=");
            break;
        }
        if (!found) {
            this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            return validateAbsence;
        }
        if (xmlOption.indexOf("<=") != -1) {
            optionKey = xmlOption.split("<=")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, "<=");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult <= 0) {
                    this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7033", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7030", false, nfsoption));
            }
        } else if (xmlOption.indexOf(">=") != -1) {
            optionKey = xmlOption.split(">=")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, ">=");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult >= 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7031", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7032", false, nfsoption));
            }
        } else if (xmlOption.indexOf("<") != -1) {
            optionKey = xmlOption.split("<")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, "<");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult < 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7032", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7031", false, nfsoption));
            }
        } else if (xmlOption.indexOf(">") != -1) {
            optionKey = xmlOption.split(">")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, ">");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult > 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7030", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7033", false, nfsoption));
            }
        } else if (xmlOption.indexOf("=") != -1) {
            optionKey = xmlOption.split("=")[0].trim();
            xmlOptionValue = this.extractOptionValue(xmlOption, optionKey, "=");
            nfsoption[0] = optionKey;
            if (nfsOptionValue == null || xmlOptionValue == null) {
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            } else {
                comparisonResult = !(nfsOptionValue instanceof Integer) || !(xmlOptionValue instanceof Integer) ? nfsOptionValue.toString().compareTo(xmlOptionValue.toString()) : ((Integer)nfsOptionValue).compareTo((Integer)xmlOptionValue);
                if (comparisonResult == 0) {
                    nfsoption[0] = optionKey;
                    this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7028", false, nfsoption));
                    return true;
                }
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7029", false, nfsoption));
            }
        } else {
            optionKey = xmlOption;
            Trace.out((String)("Checking for XML option key: " + optionKey + ", nfs options = " + this.m_mountOpts));
            if (-1 != this.m_mountOpts.indexOf(optionKey)) {
                this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7026", false, nfsoption));
                if (validateAbsence) {
                    this.m_unsupportedMountOpts.add(optionKey);
                }
                return !validateAbsence;
            }
            this.m_msgXmlChecks.append(this.m_msgBundle.getMessage("7027", false, nfsoption));
            return validateAbsence;
        }
        return false;
    }

    private String extractOptionKey(String xmlOption) {
        String optionKey = xmlOption.split("<=|>=|<|>|=", 2)[0].trim();
        Trace.out((String)("Verify Option key: XML option = " + xmlOption + ", key = " + optionKey));
        return optionKey;
    }

    private Object extractOptionValue(String mntOpts, String optionKey, String condition) {
        try {
            if (-1 == mntOpts.indexOf(optionKey)) {
                return null;
            }
            Object optValue = null;
            int startIndex = mntOpts.indexOf(optionKey);
            if (startIndex == -1) {
                return null;
            }
            int endIndex = mntOpts.indexOf(44, startIndex);
            if (endIndex == -1) {
                endIndex = mntOpts.length();
            }
            String optionsString = new String(mntOpts.substring(startIndex, endIndex));
            String[] optParts = optionsString.split(condition, 2);
            try {
                optValue = new Integer(optParts[1].trim());
            }
            catch (NumberFormatException e) {
                optValue = optParts[1].trim();
            }
            Trace.out((String)("Found nfs option, value: option =" + optionKey + ",nfs value = " + optValue));
            return optValue;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
    }
}

