/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageInfo;

public class FSInfo
extends StorageInfo
implements StorageConstants {
    private String m_fsname;
    private int m_fstype;
    private double m_fsbsize;
    private double m_fsblocks;
    private double m_fsbfree;
    private double m_fsbavail;
    private double m_fsfiles;
    private double m_fsfree;
    private int m_fsaccess;

    public FSInfo(String node, String path) {
        super(path, node, 5);
        this.m_fsname = path;
    }

    public FSInfo(String node, String path, int fstype, double fsbsize, double fsblocks, double fsbfree, double fsbavail, double fsfiles, double fsfree, int fsaccess) {
        this(node, 5, path, fstype, fsbsize, fsblocks, fsbfree, fsbavail, fsfiles, fsfree, fsaccess);
    }

    public FSInfo(String node, int type, String path, int fstype, double fsbsize, double fsblocks, double fsbfree, double fsbavail, double fsfiles, double fsfree, int fsaccess) {
        super(path, node, type);
        this.m_fsname = path;
        this.m_fstype = fstype;
        this.m_fsbsize = fsbsize;
        this.m_fsblocks = fsblocks;
        this.m_fsbfree = fsbfree;
        this.m_fsbavail = fsbavail;
        this.m_fsfiles = fsfiles;
        this.m_fsfree = fsfree;
        this.m_fsaccess = fsaccess;
        this.setFree(new StorageSize(this.m_fsbavail / 1024.0 * this.m_fsbsize, StorageUnit.KBYTE));
        this.setAccess(fsaccess);
    }

    public String getFSname() {
        return this.m_fsname;
    }

    public int getFStype() {
        return this.m_fstype;
    }

    public double getFSbsize() {
        return this.m_fsbsize;
    }

    public double getFSblocks() {
        return this.m_fsblocks;
    }

    public double getFSbfree() {
        return this.m_fsbfree;
    }

    public double getFSbavail() {
        return this.m_fsbavail;
    }

    public double getFSfiles() {
        return this.m_fsfiles;
    }

    public double getFSfree() {
        return this.m_fsfree;
    }

    public int getFSaccess() {
        return this.m_fsaccess;
    }

    @Override
    public StorageSize getSize() {
        return new StorageSize(this.m_fsblocks / 1024.0 * this.m_fsbsize, StorageUnit.KBYTE);
    }
}

