/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.HashMap;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ASMDGData
extends StorageData
implements StorageConstants {
    private String m_ASMsid;
    private String m_redundancyType;

    public ASMDGData(String id) {
        super(id, StorageType.ASMDG);
        this.setEffectiveID(id);
        this.setSuppliedID(id);
        if (VerificationUtil.isStringGood(id)) {
            this.setStorageSignature(new StorageSignature(id));
        }
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkSignatures(nodeSDmap, rSet);
    }

    public String getASMsid() {
        return this.m_ASMsid;
    }

    public String getRedundancyType() {
        return this.m_redundancyType;
    }

    public void setASMsid(String asmsid) {
        this.m_ASMsid = asmsid;
    }

    public void setRedundancyType(String redundancyType) {
        this.m_redundancyType = redundancyType;
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "ASMsid=" + this.m_ASMsid + " | redundancyType=" + this.m_redundancyType;
    }
}

